/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.keymanager.config;

import com.ibm.keymanager.KMSDebug;
import com.ibm.keymanager.KeyManagerException;
import com.ibm.keymanager.config.Config;
import com.ibm.keymanager.logic.Logic;
import com.ibm.keymanager.util.SmudgedBytes;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class ConfigImpl
extends Config {
    private static final String WINCONFFILE;
    private static final String IXCONFFILE;
    private static KMSDebug debug;
    private static String className;
    private static ConfigImpl configInstance;
    private static Hashtable configInMemory;
    private static Properties p;
    private static FileInputStream fis;
    private static FileOutputStream fos;
    private static String configFile;
    private static final String[] z;

    public void init() throws KeyManagerException {
        debug = KMSDebug.getInstance();
        debug.entry(z[6], className, z[15]);
        String string = System.getProperty(z[14]);
        debug.trace(z[6], className, z[15], string);
        if (string.toUpperCase().indexOf(z[13]) != -1) {
            debug.trace(z[6], className, z[15], z[16]);
            ConfigImpl.load(WINCONFFILE);
        } else if (string.toUpperCase().indexOf("X") != -1) {
            debug.trace(z[6], className, z[15], string + z[11]);
            ConfigImpl.load(IXCONFFILE);
        } else {
            debug.trace(z[6], className, z[15], string + z[11]);
            ConfigImpl.load(IXCONFFILE);
        }
        debug.exit(z[6], className, z[15]);
    }

    public void init(String string) throws KeyManagerException {
        debug = KMSDebug.getInstance();
        debug.entry(z[6], className, z[15]);
        if (string != null) {
            ConfigImpl.load(string);
        } else {
            this.init();
        }
        debug.exit(z[6], className, z[15]);
    }

    public static void load(String string) throws KeyManagerException {
        debug.entry(z[6], className, z[12]);
        String string2 = null;
        if (string == null) {
            String string3 = System.getProperty(z[14]);
            if (string3.toUpperCase().indexOf(z[13]) != -1) {
                string2 = WINCONFFILE;
                debug.trace(z[6], className, z[15], z[16]);
            } else if (string3.toUpperCase().indexOf("X") != -1) {
                string2 = IXCONFFILE;
                debug.trace(z[6], className, z[15], string3 + z[11]);
            }
            configFile = string2;
        } else {
            configFile = string;
        }
        try {
            debug.trace(z[6], className, z[12], configFile);
            fis = new FileInputStream(configFile);
            p.clear();
            p.load(fis);
            fis.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new KeyManagerException(fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new KeyManagerException(iOException);
        }
        ConfigImpl.buildConfig(p);
        debug.exit(z[6], className, z[12]);
    }

    public void add(String string, Object object) throws KeyManagerException {
        debug.entry(z[6], className, z[17]);
        try {
            if (string.toLowerCase().indexOf(z[3]) == 0) {
                debug.trace(z[6], className, z[17], string + z[0] + object);
            }
            configInMemory.put(string, object);
        }
        catch (NullPointerException nullPointerException) {
            throw new KeyManagerException(nullPointerException);
        }
        debug.exit(z[6], className, z[17]);
    }

    public void delete(String string) throws KeyManagerException {
        debug.entry(z[6], className, z[10]);
        try {
            if (string.toLowerCase().indexOf(z[3]) == 0) {
                debug.trace(z[6], className, z[10], string);
            }
            configInMemory.remove(string);
        }
        catch (NullPointerException nullPointerException) {
            throw new KeyManagerException(nullPointerException);
        }
        debug.exit(z[6], className, z[10]);
    }

    public void replace(String string, Object object) throws KeyManagerException {
        debug.entry(z[6], className, z[26]);
        try {
            if (string.toLowerCase().indexOf(z[3]) == 0) {
                debug.trace(z[6], className, z[26], string + z[0] + object);
                debug.trace(z[6], className, z[26], string + z[25] + configInMemory.get(string));
            }
            configInMemory.remove(string);
            configInMemory.put(string, object);
        }
        catch (NullPointerException nullPointerException) {
            throw new KeyManagerException(nullPointerException);
        }
        debug.exit(z[6], className, z[26]);
    }

    public void reload() throws KeyManagerException {
        debug.entry(z[6], className, z[18]);
        try {
            debug.trace(z[6], className, z[18], configFile);
            fis = new FileInputStream(configFile);
            p.clear();
            p.load(fis);
            fis.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new KeyManagerException(fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new KeyManagerException(iOException);
        }
        configInMemory.clear();
        ConfigImpl.buildConfig(p);
        debug.exit(z[6], className, z[18]);
    }

    public Hashtable get() {
        debug.entry(z[6], className, z[7]);
        Hashtable hashtable = new Hashtable(configInMemory.size());
        Enumeration enumeration = configInMemory.keys();
        while (enumeration.hasMoreElements()) {
            Object k2 = enumeration.nextElement();
            hashtable.put(k2, configInMemory.get(k2));
        }
        debug.exit(z[6], className, z[7]);
        return hashtable;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object get(String string) throws KeyManagerException {
        debug.entry(z[6], className, z[7]);
        if (string == null) {
            return null;
        }
        Object var2_2 = null;
        try {
            if (string.equals(z[22])) {
                String string2 = (String)configInMemory.get(z[20]);
                if (string2 == null) {
                    return null;
                }
                byte[] byArray = Logic.hexStringToByteArray(string2);
                return SmudgedBytes.getClearTextPWstring(byArray);
            }
            if (string.equals(z[19])) {
                String string3 = (String)configInMemory.get(z[24]);
                if (string3 == null) {
                    return null;
                }
                byte[] byArray = Logic.hexStringToByteArray(string3);
                return SmudgedBytes.getClearTextPWstring(byArray);
            }
            if (string.equals(z[23])) {
                String string4 = (String)configInMemory.get(z[21]);
                if (string4 == null) {
                    return null;
                }
                byte[] byArray = Logic.hexStringToByteArray(string4);
                return SmudgedBytes.getClearTextPWstring(byArray);
            }
            var2_2 = configInMemory.get(string);
            if (string.toLowerCase().indexOf(z[3]) == -1) {
                debug.trace(z[6], className, z[7], string + z[0] + var2_2);
            }
        }
        catch (NullPointerException nullPointerException) {
            throw new KeyManagerException(nullPointerException);
        }
        debug.exit(z[6], className, z[7]);
        if (!(var2_2 instanceof String)) return var2_2;
        return ((String)var2_2).trim();
    }

    public void shutdown() throws KeyManagerException {
        debug.entry(z[6], className, z[8]);
        this.sync();
        debug.exit(z[6], className, z[8]);
    }

    public void sync() throws KeyManagerException {
        debug = KMSDebug.getInstance();
        debug.entry(z[6], className, z[31]);
        try {
            ConfigImpl.write();
        }
        catch (Exception exception) {
            throw new KeyManagerException(exception);
        }
        debug.exit(z[6], className, z[31]);
    }

    public void sync(Hashtable hashtable) throws KeyManagerException {
        debug.entry(z[6], className, z[31]);
        configInMemory.clear();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object k2 = enumeration.nextElement();
            configInMemory.put(k2, hashtable.get(k2));
        }
        try {
            ConfigImpl.write();
        }
        catch (Exception exception) {
            throw new KeyManagerException(exception.getMessage());
        }
        debug.exit(z[6], className, z[31]);
    }

    private static void buildConfig(Properties properties) {
        debug.entry(z[6], className, z[28]);
        Enumeration<?> enumeration = p.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = null;
            string2 = p.getProperty(string);
            int n2 = string2.toString().length();
            if (n2 >= 1) {
                if (string.toLowerCase().indexOf(z[3]) == 0) {
                    debug.trace(z[6], className, z[28], z[27] + string + z[30] + string2);
                }
                configInMemory.put(string, string2);
                continue;
            }
            if (configInMemory.get(string) != null) continue;
            if (string.toLowerCase().indexOf(z[3]) == 0) {
                debug.trace(z[6], className, z[28], z[29] + string);
            }
            configInMemory.put(string, p.getProperty(string));
        }
        debug.exit(z[6], className, z[28]);
    }

    private static void mergeConfig(Properties properties) {
        debug.entry(z[6], className, z[32]);
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = null;
            string2 = properties.getProperty(string);
            int n2 = string2.toString().length();
            if (n2 >= 1) {
                configInMemory.put(string, string2);
                if (string.toLowerCase().indexOf(z[3]) != 0) continue;
                debug.trace(z[6], className, z[32], z[27] + string + z[30] + string2);
                continue;
            }
            if (configInMemory.get(string) != null) continue;
            debug.trace(z[6], className, z[32], z[29] + string);
            configInMemory.put(string, p.getProperty(string));
        }
        debug.exit(z[6], className, z[32]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void write() throws Exception {
        String string = configFile;
        debug.entry(z[6], className, z[1]);
        String string2 = configFile;
        synchronized (string2) {
            File file;
            debug.trace(z[6], className, z[1], string);
            File file2 = new File(string);
            File file3 = new File(string + z[5]);
            if (!file3.exists()) {
                try {
                    file3.createNewFile();
                }
                catch (IOException iOException) {
                    file = file3.getAbsoluteFile().getParentFile();
                    if (!file.exists()) {
                        if (!file.mkdirs()) {
                            throw new KeyManagerException(z[4] + string + z[2]);
                        }
                    } else {
                        throw (KeyManagerException)new KeyManagerException().initCause(iOException);
                    }
                    try {
                        file3.createNewFile();
                    }
                    catch (IOException iOException2) {
                        throw (KeyManagerException)new KeyManagerException().initCause(iOException2);
                    }
                }
            }
            fos = new FileOutputStream(file3);
            Enumeration enumeration = configInMemory.keys();
            file = null;
            while (enumeration.hasMoreElements()) {
                file = enumeration.nextElement();
                String string3 = file + z[0] + configInMemory.get(file) + "\n";
                if (string3.toLowerCase().indexOf(z[3]) == 0) {
                    debug.trace(z[6], className, z[1], "" + string3);
                }
                if (configInMemory.get(file) == null) continue;
                fos.write(string3.getBytes());
                fos.flush();
            }
            fos.close();
            if (file2.exists()) {
                file2.delete();
            }
            file3.renameTo(file2);
        }
        debug.exit(z[6], className, z[1]);
    }

    public void write(String string) throws KeyManagerException {
        debug.entry(z[6], className, z[1]);
        try {
            String string2 = configFile;
            configFile = string;
            ConfigImpl.write();
            configFile = string2;
        }
        catch (Exception exception) {
            throw new KeyManagerException(exception);
        }
        debug.exit(z[6], className, z[1]);
    }

    public void merge(File file) throws KeyManagerException {
        Hashtable hashtable = new Hashtable(25);
        debug.entry(z[6], className, z[9]);
        if (file == null) {
            return;
        }
        try {
            p = new Properties();
            fis = new FileInputStream(file);
            p.load(fis);
            ConfigImpl.mergeConfig(p);
            fis.close();
        }
        catch (IOException iOException) {
            throw new KeyManagerException(iOException);
        }
        debug.exit(z[6], className, z[9]);
    }

    public void load(File file) throws KeyManagerException {
        debug.entry(z[6], className, z[12]);
        if (file == null) {
            return;
        }
        try {
            debug.trace(z[6], className, z[12], file.getName());
            p = new Properties();
            fis = new FileInputStream(file);
            p.load(fis);
            ConfigImpl.buildConfig(p);
            fis.close();
        }
        catch (IOException iOException) {
            throw new KeyManagerException(iOException);
        }
        debug.exit(z[6], className, z[12]);
    }

    public Enumeration list() {
        debug.entry(z[6], className, z[33]);
        debug.exit(z[6], className, z[33]);
        return configInMemory.keys();
    }

    static {
        String[] stringArray = new String[34];
        Object var0 = null;
        WINCONFFILE = ConfigImpl.z(ConfigImpl.z("{\u001dk($W@6\u0019;\u0018a-\u00143K\b\r:\u001b\u0017l!\u0001\u001bYI%\u001f3Jt!\n ]Uk33Aj%\u00167_B6;9VA-\u001fxHU+\b3JS-\u001d%"));
        var0 = null;
        IXCONFFILE = ConfigImpl.z(ConfigImpl.z("\u0017H4\fyQE)W\u001d]^\t\u00198Y@!\n\u0005]U2\u001d$\u0017l!\u0001\u001bYI%\u001f3Jd+\u00160Q@j\b$WW!\n\"QB7"));
        var0 = null;
        stringArray[0] = ConfigImpl.z(ConfigImpl.z("\u0018\u001ad"));
        var0 = null;
        stringArray[1] = ConfigImpl.z(ConfigImpl.z("OU-\f3"));
        var0 = null;
        stringArray[2] = ConfigImpl.z(ConfigImpl.z("\u0018D%\u0016vVH0X4]\u0007'\n3YS!\u001c"));
        var0 = null;
        stringArray[3] = ConfigImpl.z(ConfigImpl.z("HF7\u000b!WU "));
        var0 = null;
        stringArray[4] = ConfigImpl.z(ConfigImpl.z("{H*\u001e?_R6\u0019\"QH*X\u0010QK!X"));
        var0 = null;
        stringArray[5] = ConfigImpl.z(ConfigImpl.z("\u0016E%\u001b=MW"));
        var0 = null;
        stringArray[6] = ConfigImpl.z(ConfigImpl.z("[H*\u001e?_"));
        var0 = null;
        stringArray[7] = ConfigImpl.z(ConfigImpl.z("_B0"));
        var0 = null;
        stringArray[8] = ConfigImpl.z(ConfigImpl.z("KO1\f2WP*"));
        var0 = null;
        stringArray[9] = ConfigImpl.z(ConfigImpl.z("UB6\u001f3"));
        var0 = null;
        stringArray[10] = ConfigImpl.z(ConfigImpl.z("\\B(\u001d\"]"));
        var0 = null;
        stringArray[11] = ConfigImpl.z(ConfigImpl.z("\u0018n\u0010X\u001fk\u0006"));
        var0 = null;
        stringArray[12] = ConfigImpl.z(ConfigImpl.z("TH%\u001c"));
        var0 = null;
        stringArray[13] = ConfigImpl.z(ConfigImpl.z("on\n"));
        var0 = null;
        stringArray[14] = ConfigImpl.z(ConfigImpl.z("WTj\u00167UB"));
        var0 = null;
        stringArray[15] = ConfigImpl.z(ConfigImpl.z("QI-\f"));
        var0 = null;
        stringArray[16] = ConfigImpl.z(ConfigImpl.z("on\n<\u0019otd1\u0002\u0018n\u0017Y"));
        var0 = null;
        stringArray[17] = ConfigImpl.z(ConfigImpl.z("YC "));
        var0 = null;
        stringArray[18] = ConfigImpl.z(ConfigImpl.z("JB(\u00177\\"));
        var0 = null;
        stringArray[19] = ConfigImpl.z(ConfigImpl.z("yC)\u00118\u0016T7\u0014xSB=\u000b\"WU!V&YT7\u000f9JC"));
        var0 = null;
        stringArray[20] = ConfigImpl.z(ConfigImpl.z("[H*\u001e?_\t/\u001d/KS+\n3\u0016W%\u000b%OH6\u001cxWE\"\r%[F0\u001d2"));
        var0 = null;
        stringArray[21] = ConfigImpl.z(ConfigImpl.z("lU%\u0016%HH6\f\u001aQT0\u001d8]Uj\u000b%T\t/\u001d/KS+\n3\u0016W%\u000b%OH6\u001cxWE\"\r%[F0\u001d2"));
        var0 = null;
        stringArray[22] = ConfigImpl.z(ConfigImpl.z("[H*\u001e?_\t/\u001d/KS+\n3\u0016W%\u000b%OH6\u001c"));
        var0 = null;
        stringArray[23] = ConfigImpl.z(ConfigImpl.z("lU%\u0016%HH6\f\u001aQT0\u001d8]Uj\u000b%T\t/\u001d/KS+\n3\u0016W%\u000b%OH6\u001c"));
        var0 = null;
        stringArray[24] = ConfigImpl.z(ConfigImpl.z("yC)\u00118\u0016T7\u0014xSB=\u000b\"WU!V&YT7\u000f9JCj\u00174^R7\u001b7LB "));
        var0 = null;
        stringArray[25] = ConfigImpl.z(ConfigImpl.z("\u0018p\u0005+v"));
        var0 = null;
        stringArray[26] = ConfigImpl.z(ConfigImpl.z("JB4\u00147[B"));
        var0 = null;
        stringArray[27] = ConfigImpl.z(ConfigImpl.z("MW \u0019\"QI#X"));
        var0 = null;
        stringArray[28] = ConfigImpl.z(ConfigImpl.z("ZR-\u00142{H*\u001e?_"));
        var0 = null;
        stringArray[29] = ConfigImpl.z(ConfigImpl.z("nf\b-\u0013\u0018i\u00114\u001a\u0002\u0007"));
        var0 = null;
        stringArray[30] = ConfigImpl.z(ConfigImpl.z("\u0018S+X"));
        var0 = null;
        stringArray[31] = ConfigImpl.z(ConfigImpl.z("K^*\u001b"));
        var0 = null;
        stringArray[32] = ConfigImpl.z(ConfigImpl.z("UB6\u001f3{H*\u001e?_"));
        var0 = null;
        stringArray[33] = ConfigImpl.z(ConfigImpl.z("TN7\f"));
        z = stringArray;
        debug = null;
        var0 = null;
        className = ConfigImpl.z(ConfigImpl.z("[H)V?ZJj\u00133AJ%\u00161]Uj\u001b9VA-\u001fx{H*\u001e?_n)\b:"));
        configInstance = new ConfigImpl();
        configInMemory = new Hashtable(25);
        p = new Properties();
        fis = null;
        fos = null;
        configFile = null;
    }

    private static char[] z(String string) {
        char[] cArray;
        block1: {
            int n2;
            char[] cArray2 = string.toCharArray();
            char[] cArray3 = cArray2;
            char[] cArray4 = cArray2;
            do {
                int n3 = cArray3.length;
                cArray = cArray4;
                n2 = n3;
                if (n3 >= 2) break block1;
                cArray4 = cArray;
                cArray3 = cArray;
            } while (n2 == 0);
            cArray = cArray4;
            n2 = 0;
            cArray3[0] = (char)(cArray3[0] ^ 0x56);
        }
        return cArray;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    private static String z(char[] cArray) {
        char[] cArray2;
        block10: {
            int n2;
            int n3;
            char[] cArray3;
            int n4;
            block9: {
                n4 = 0;
                int n5 = cArray.length;
                cArray3 = cArray;
                n3 = n5;
                if (n5 <= 1) break block9;
                cArray2 = cArray3;
                n2 = n3;
                if (n3 <= n4) break block10;
            }
            do {
                char[] cArray4 = cArray3;
                char[] cArray5 = cArray3;
                int n6 = n4;
                while (true) {
                    int n7;
                    char c2 = cArray4[n6];
                    switch (n4 % 5) {
                        case 0: {
                            n7 = 56;
                            break;
                        }
                        case 1: {
                            n7 = 39;
                            break;
                        }
                        case 2: {
                            n7 = 68;
                            break;
                        }
                        case 3: {
                            n7 = 120;
                            break;
                        }
                        default: {
                            n7 = 86;
                        }
                    }
                    cArray4[n6] = (char)(c2 ^ n7);
                    ++n4;
                    cArray3 = cArray5;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray5 = cArray3;
                    n2 = n3;
                    n6 = n3;
                    cArray4 = cArray3;
                }
                cArray2 = cArray3;
                n2 = n3;
            } while (n3 > n4);
        }
        return new String(cArray2).intern();
    }
}

