/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import com.ibm.oti.util.Msg;
import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AccessController {
    private static native void initializeInternal();

    private AccessController() {
    }

    private static native Object[] getProtectionDomains(int var0);

    public static void checkPermission(Permission perm) throws AccessControlException {
        if (perm == null) {
            throw new NullPointerException();
        }
        if ((AccessControlContext.debugSetting() & 2) != 0) {
            new Exception("Stack trace").printStackTrace();
        }
        Object[] domains = AccessController.getProtectionDomains(1);
        AccessControlContext acc = (AccessControlContext)domains[0];
        ProtectionDomain[] pDomains = null;
        if (acc != null && acc.domainCombiner != null) {
            if ((AccessControlContext.debugSetting() & 1) != 0) {
                AccessControlContext.debugPrintAccess();
                System.err.println("AccessController invoking the Combiner");
            }
            pDomains = acc.domainCombiner.combine(AccessController.toArrayOfProtectionDomains(domains, null), acc.context);
        } else {
            pDomains = AccessController.toArrayOfProtectionDomains(domains, acc);
        }
        if ((AccessControlContext.debugSetting() & 4) != 0) {
            AccessControlContext.debugPrintAccess();
            if (pDomains == null || pDomains.length == 0) {
                System.err.println("domain (context is null)");
            } else {
                for (int i = 0; i < pDomains.length; ++i) {
                    System.err.println("domain " + i + " " + pDomains[i]);
                }
            }
        }
        int length = pDomains == null ? 0 : pDomains.length;
        for (int i = 0; i < length; ++i) {
            if (pDomains[i].implies(perm)) continue;
            if ((AccessControlContext.debugSetting() & 1) != 0) {
                AccessControlContext.debugPrintAccess();
                System.err.println("access denied " + perm);
            }
            if ((AccessControlContext.debugSetting() & 8) != 0) {
                new Exception("Stack trace").printStackTrace();
                System.err.println("domain that failed " + pDomains[i]);
            }
            throw new AccessControlException(Msg.getString("K002c", perm), perm);
        }
        if ((AccessControlContext.debugSetting() & 1) != 0) {
            AccessControlContext.debugPrintAccess();
            System.err.println("access allowed " + perm);
        }
    }

    private static void keepalive(AccessControlContext context) {
    }

    public static AccessControlContext getContext() {
        Object[] domains = AccessController.getProtectionDomains(1);
        AccessControlContext acc = (AccessControlContext)domains[0];
        ProtectionDomain[] pDomains = null;
        if (acc != null && acc.domainCombiner != null) {
            pDomains = acc.domainCombiner.combine(AccessController.toArrayOfProtectionDomains(domains, null), acc.context);
            if (pDomains.length == 0) {
                pDomains = null;
            }
            AccessControlContext result = new AccessControlContext(pDomains, false);
            result.domainCombiner = acc.domainCombiner;
            return result;
        }
        return new AccessControlContext(AccessController.toArrayOfProtectionDomains(domains, acc), false);
    }

    private static ProtectionDomain[] toArrayOfProtectionDomains(Object[] domains, AccessControlContext acc) {
        int len = 0;
        int size = domains.length - 1;
        int extra = 0;
        if (acc != null && acc.context != null) {
            extra = acc.context.length;
        }
        ProtectionDomain[] answer = new ProtectionDomain[size + extra];
        for (int i = 1; i <= size; ++i) {
            boolean found = false;
            answer[len] = (ProtectionDomain)domains[i];
            if (answer[len] == null) break;
            if (acc != null && acc.context != null) {
                for (int j = 0; j < acc.context.length; ++j) {
                    if (answer[len] != acc.context[j]) continue;
                    found = true;
                    break;
                }
            }
            if (found) continue;
            ++len;
        }
        if (len == 0 && acc != null) {
            return acc.context;
        }
        if (len + extra == 0) {
            return null;
        }
        if (len < size) {
            ProtectionDomain[] copy = new ProtectionDomain[len + extra];
            System.arraycopy((Object)answer, 0, (Object)copy, 0, len);
            answer = copy;
        }
        if (acc != null && acc.context != null) {
            System.arraycopy((Object)acc.context, 0, (Object)answer, len, acc.context.length);
        }
        return answer;
    }

    public static <T> T doPrivileged(PrivilegedAction<T> action) {
        return action.run();
    }

    public static <T> T doPrivileged(PrivilegedAction<T> action, AccessControlContext context) {
        T result = action.run();
        AccessController.keepalive(context);
        return result;
    }

    public static <T> T doPrivileged(PrivilegedExceptionAction<T> action) throws PrivilegedActionException {
        try {
            return action.run();
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new PrivilegedActionException(ex);
        }
    }

    public static <T> T doPrivileged(PrivilegedExceptionAction<T> action, AccessControlContext context) throws PrivilegedActionException {
        try {
            T result = action.run();
            AccessController.keepalive(context);
            return result;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new PrivilegedActionException(ex);
        }
    }

    public static <T> T doPrivilegedWithCombiner(PrivilegedAction<T> action) {
        AccessControlContext accWithCombiner = null;
        Object[] domains = AccessController.getProtectionDomains(1);
        AccessControlContext acc = (AccessControlContext)domains[0];
        if (acc != null && acc.domainCombiner != null) {
            accWithCombiner = new AccessControlContext(null, false);
            accWithCombiner.domainCombiner = acc.domainCombiner;
        }
        return AccessController.doPrivileged(action, accWithCombiner);
    }

    public static <T> T doPrivilegedWithCombiner(PrivilegedExceptionAction<T> action) throws PrivilegedActionException {
        AccessControlContext accWithCombiner = null;
        Object[] domains = AccessController.getProtectionDomains(1);
        AccessControlContext acc = (AccessControlContext)domains[0];
        if (acc != null && acc.domainCombiner != null) {
            accWithCombiner = new AccessControlContext(null, false);
            accWithCombiner.domainCombiner = acc.domainCombiner;
        }
        return AccessController.doPrivileged(action, accWithCombiner);
    }

    static {
        AccessController.initializeInternal();
    }
}

