/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Array {
    private Array() {
    }

    public static native Object get(Object var0, int var1) throws IllegalArgumentException, ArrayIndexOutOfBoundsException;

    public static native boolean getBoolean(Object var0, int var1) throws IllegalArgumentException, ArrayIndexOutOfBoundsException;

    public static native byte getByte(Object var0, int var1) throws IllegalArgumentException, ArrayIndexOutOfBoundsException;

    public static native char getChar(Object var0, int var1) throws IllegalArgumentException, ArrayIndexOutOfBoundsException;

    public static native double getDouble(Object var0, int var1) throws IllegalArgumentException, ArrayIndexOutOfBoundsException;

    public static native float getFloat(Object var0, int var1) throws IllegalArgumentException, ArrayIndexOutOfBoundsException;

    public static native int getInt(Object var0, int var1) throws IllegalArgumentException, ArrayIndexOutOfBoundsException;

    public static native int getLength(Object var0) throws IllegalArgumentException;

    public static native long getLong(Object var0, int var1) throws IllegalArgumentException, ArrayIndexOutOfBoundsException;

    public static native short getShort(Object var0, int var1) throws IllegalArgumentException, ArrayIndexOutOfBoundsException;

    private static native Object multiNewArrayImpl(Class var0, int var1, int[] var2);

    private static native Object newArrayImpl(Class var0, int var1);

    public static Object newInstance(Class<?> componentType, int ... dimensions) throws NegativeArraySizeException, IllegalArgumentException {
        if (componentType == null) {
            throw new NullPointerException();
        }
        int length = dimensions.length;
        if (length < 1) {
            throw new IllegalArgumentException();
        }
        int[] reversed = new int[length];
        for (int i = 0; i < length; ++i) {
            if (dimensions[i] < 0) {
                throw new NegativeArraySizeException();
            }
            reversed[length - i - 1] = dimensions[i];
        }
        return Array.multiNewArrayImpl(componentType, length, reversed);
    }

    public static Object newInstance(Class<?> componentType, int size) throws NegativeArraySizeException {
        if (componentType == null) {
            throw new NullPointerException();
        }
        if (size < 0) {
            throw new NegativeArraySizeException();
        }
        return Array.newArrayImpl(componentType, size);
    }

    public static void set(Object array, int index, Object value) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (value == null && array != null && array.getClass().getComponentType().isPrimitive()) {
            throw new IllegalArgumentException();
        }
        Array.setImpl(array, index, value);
    }

    private static native void setImpl(Object var0, int var1, Object var2) throws IllegalArgumentException, ArrayIndexOutOfBoundsException;

    public static native void setBoolean(Object var0, int var1, boolean var2) throws IllegalArgumentException, ArrayIndexOutOfBoundsException;

    public static native void setByte(Object var0, int var1, byte var2) throws IllegalArgumentException, ArrayIndexOutOfBoundsException;

    public static native void setChar(Object var0, int var1, char var2) throws IllegalArgumentException, ArrayIndexOutOfBoundsException;

    public static native void setDouble(Object var0, int var1, double var2) throws IllegalArgumentException, ArrayIndexOutOfBoundsException;

    public static native void setFloat(Object var0, int var1, float var2) throws IllegalArgumentException, ArrayIndexOutOfBoundsException;

    public static native void setInt(Object var0, int var1, int var2) throws IllegalArgumentException, ArrayIndexOutOfBoundsException;

    public static native void setLong(Object var0, int var1, long var2) throws IllegalArgumentException, ArrayIndexOutOfBoundsException;

    public static native void setShort(Object var0, int var1, short var2) throws IllegalArgumentException, ArrayIndexOutOfBoundsException;
}

