/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;

public class Throwable
implements Serializable {
    private static final long serialVersionUID = -3042686055658047285L;
    private String detailMessage;
    private transient Object walkback;
    private Throwable cause = this;
    private StackTraceElement[] stackTrace = null;

    public Throwable() {
        this.fillInStackTrace();
    }

    public Throwable(String detailMessage) {
        this();
        this.detailMessage = detailMessage;
    }

    public Throwable(String detailMessage, Throwable throwable) {
        this();
        this.detailMessage = detailMessage;
        this.cause = throwable;
    }

    public Throwable(Throwable throwable) {
        this();
        this.detailMessage = throwable == null ? null : throwable.toString();
        this.cause = throwable;
    }

    public native Throwable fillInStackTrace();

    public String getMessage() {
        return this.detailMessage;
    }

    public String getLocalizedMessage() {
        return this.getMessage();
    }

    public StackTraceElement[] getStackTrace() {
        return (StackTraceElement[])this.getInternalStackTrace().clone();
    }

    public void setStackTrace(StackTraceElement[] trace) {
        StackTraceElement[] newTrace = (StackTraceElement[])trace.clone();
        for (int i = 0; i < newTrace.length; ++i) {
            if (newTrace[i] != null) continue;
            throw new NullPointerException();
        }
        this.stackTrace = newTrace;
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    private static int countDuplicates(StackTraceElement[] currentStack, StackTraceElement[] parentStack) {
        StackTraceElement parentFrame;
        int duplicates = 0;
        int parentIndex = parentStack.length;
        int i = currentStack.length;
        while (--i >= 0 && --parentIndex >= 0 && (parentFrame = parentStack[parentIndex]).equals(currentStack[i])) {
            ++duplicates;
        }
        return duplicates;
    }

    private StackTraceElement[] getInternalStackTrace() {
        if (this.stackTrace == null) {
            this.stackTrace = J9VMInternals.getStackTrace(this, true);
        }
        return this.stackTrace;
    }

    public void printStackTrace(PrintStream err) {
        StackTraceElement[] stack = this.printStackTrace(err, null);
        for (Throwable throwable = this.getCause(); throwable != null && stack != null; throwable = throwable.getCause()) {
            stack = throwable.printStackTrace(err, stack);
        }
    }

    public void printStackTrace(PrintWriter err) {
        StackTraceElement[] stack = this.printStackTrace(err, null);
        for (Throwable throwable = this.getCause(); throwable != null && stack != null; throwable = throwable.getCause()) {
            stack = throwable.printStackTrace(err, stack);
        }
    }

    public String toString() {
        String msg = this.getLocalizedMessage();
        String name = this.getClass().getName();
        if (msg == null) {
            return name;
        }
        int length = name.length() + 2 + msg.length();
        StringBuilder buffer = new StringBuilder(length);
        return buffer.append(name).append(": ").append(msg).toString();
    }

    public synchronized Throwable initCause(Throwable throwable) {
        if (this.cause == this) {
            if (throwable != this) {
                this.cause = throwable;
                return this;
            }
            throw new IllegalArgumentException("Cause cannot be the receiver");
        }
        throw new IllegalStateException("Cause already initialized");
    }

    public Throwable getCause() {
        if (this.cause == this) {
            return null;
        }
        return this.cause;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        this.getInternalStackTrace();
        s.defaultWriteObject();
    }

    static void appendTo(Appendable buf, CharSequence s) {
        StackTraceElement.appendTo(buf, s);
    }

    static void appendTo(Appendable buf, int i) {
        StackTraceElement.appendTo(buf, i);
    }

    static void appendLnTo(Appendable buf) {
        if (buf instanceof PrintStream) {
            ((PrintStream)buf).println();
        } else if (buf instanceof PrintWriter) {
            ((PrintWriter)buf).println();
        } else {
            Throwable.appendTo(buf, "\n");
        }
    }

    private StackTraceElement[] printStackTrace(Appendable err, StackTraceElement[] parentStack) {
        StackTraceElement[] stack;
        if (err == null) {
            throw new NullPointerException();
        }
        boolean outOfMemory = this instanceof OutOfMemoryError;
        if (parentStack != null) {
            Throwable.appendTo(err, "Caused by: ");
        }
        if (!outOfMemory) {
            try {
                Throwable.appendTo(err, this.toString());
            }
            catch (OutOfMemoryError e) {
                outOfMemory = true;
            }
        }
        if (outOfMemory) {
            try {
                Throwable.appendTo(err, this.getClass().getName());
            }
            catch (OutOfMemoryError e) {
                outOfMemory = true;
                Throwable.appendTo(err, "java.lang.OutOfMemoryError(?)");
            }
            try {
                String message = this.getLocalizedMessage();
                if (message != null) {
                    Throwable.appendTo(err, ": ");
                    Throwable.appendTo(err, message);
                }
            }
            catch (OutOfMemoryError e) {
                outOfMemory = true;
            }
        }
        Throwable.appendLnTo(err);
        int duplicates = 0;
        try {
            stack = this.getInternalStackTrace();
            if (parentStack != null) {
                duplicates = Throwable.countDuplicates(stack, parentStack);
            }
        }
        catch (OutOfMemoryError e) {
            Throwable.appendTo(err, "\tat ?");
            Throwable.appendLnTo(err);
            return null;
        }
        for (int i = 0; i < stack.length - duplicates; ++i) {
            if (!outOfMemory) {
                try {
                    Throwable.appendTo(err, "\tat " + stack[i]);
                }
                catch (OutOfMemoryError e) {
                    outOfMemory = true;
                }
            }
            if (outOfMemory) {
                Throwable.appendTo(err, "\tat ");
                stack[i].appendTo(err);
            }
            Throwable.appendLnTo(err);
        }
        if (duplicates > 0) {
            if (!outOfMemory) {
                try {
                    Throwable.appendTo(err, "\t... " + duplicates + " more");
                }
                catch (OutOfMemoryError e) {
                    outOfMemory = true;
                }
            }
            if (outOfMemory) {
                Throwable.appendTo(err, "\t... ");
                Throwable.appendTo(err, duplicates);
                Throwable.appendTo(err, " more");
            }
            Throwable.appendLnTo(err);
        }
        return stack;
    }
}

