/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.ibm.jvm.io.ConsoleInputStream;
import com.ibm.jvm.io.ConsolePrintStream;
import com.ibm.misc.SystemIntialization;
import com.ibm.oti.util.Msg;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Console;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.channels.Channel;
import java.nio.channels.spi.SelectorProvider;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Map;
import java.util.Properties;
import java.util.PropertyPermission;
import sun.misc.SharedSecrets;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class System {
    public static final InputStream in;
    public static final PrintStream out;
    public static final PrintStream err;
    private static final Runtime RUNTIME;
    private static Properties systemProperties;
    private static SecurityManager security;
    private static final int NANO_RETURN = 0;
    private static final int NANO_DIVIDE = 1;
    private static final int NANO_INT_DIVIDE = 2;
    private static final int NANO_MULTIPLY = 3;
    private static final int NANO_INT_MULTIPLY = 4;
    private static final int nanoType;
    private static final double nanoAdjust;
    private static final long nanoIntAdjust;
    private static volatile Console console;
    private static volatile boolean consoleInitialized;
    private static final int InitLocale = 0;
    private static final int PlatformEncoding = 1;
    private static final int FileEncoding = 2;
    private static final int OSEncoding = 3;

    static void completeInitialization() {
        System.setIn(ConsoleInputStream.localize((InputStream)new BufferedInputStream(new FileInputStream(FileDescriptor.in))));
        Terminator.setup();
        Shutdown.add((Runnable)((Object)ApplicationShutdownHooks.hook()));
        SystemIntialization.lastChanceHook();
    }

    public static void setIn(InputStream newIn) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(RuntimePermission.permissionToSetIO);
        }
        System.setFieldImpl("in", newIn);
    }

    public static void setOut(PrintStream newOut) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(RuntimePermission.permissionToSetIO);
        }
        System.setFieldImpl("out", newOut);
    }

    public static void setErr(PrintStream newErr) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(RuntimePermission.permissionToSetIO);
        }
        System.setFieldImpl("err", newErr);
    }

    private System() {
    }

    public static native void arraycopy(Object var0, int var1, Object var2, int var3, int var4);

    private static void arraycopy(Object[] A1, int offset1, Object[] A2, int offset2, int length) {
        if (A1 == null || A2 == null) {
            throw new NullPointerException();
        }
        if (offset1 >= 0 && offset2 >= 0 && length >= 0 && length <= A1.length - offset1 && length <= A2.length - offset2) {
            if (A1 != A2 || offset1 > offset2 || offset1 + length <= offset2) {
                for (int i = 0; i < length; ++i) {
                    A2[offset2 + i] = A1[offset1 + i];
                }
            } else {
                for (int i = length - 1; i >= 0; --i) {
                    A2[offset2 + i] = A1[offset1 + i];
                }
            }
        } else {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    public static native long currentTimeMillis();

    private static void ensureProperties() {
        String key;
        String fileEncoding;
        systemProperties = new Properties();
        String platformEncoding = System.getEncoding(1);
        String osEncoding = null;
        String definedFileEncoding = System.getEncoding(2);
        String definedOSEncoding = System.getEncoding(3);
        if (definedFileEncoding != null) {
            fileEncoding = definedFileEncoding;
            if (definedOSEncoding == null) {
                osEncoding = platformEncoding;
            }
        } else {
            fileEncoding = platformEncoding;
        }
        if (osEncoding == null) {
            osEncoding = definedOSEncoding;
        }
        if (osEncoding != null) {
            systemProperties.put("os.encoding", osEncoding);
        }
        systemProperties.put("ibm.system.encoding", platformEncoding);
        systemProperties.put("sun.jnu.encoding", platformEncoding);
        systemProperties.put("file.encoding", fileEncoding);
        systemProperties.put("java.version", "1.6.0");
        systemProperties.put("java.specification.version", "1.6");
        systemProperties.put("java.specification.vendor", "Sun Microsystems Inc.");
        systemProperties.put("java.specification.name", "Java Platform API Specification");
        systemProperties.put("com.ibm.oti.configuration", "scar");
        String[] list = System.getPropertyList();
        for (int i = 0; i < list.length && (key = list[i]) != null; i += 2) {
            systemProperties.put(key, list[i + 1]);
        }
        systemProperties.put("com.ibm.oti.jcl.build", "20080613_1526");
    }

    public static void exit(int code) {
        RUNTIME.exit(code);
    }

    public static void gc() {
        RUNTIME.gc();
    }

    public static String getenv(String var) {
        if (var == null) {
            throw new NullPointerException();
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(new RuntimePermission("getenv." + var));
        }
        return ProcessEnvironment.getenv(var);
    }

    public static Properties getProperties() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPropertiesAccess();
        }
        return systemProperties;
    }

    static Properties internalGetProperties() {
        return systemProperties;
    }

    public static String getProperty(String prop) {
        return System.getProperty(prop, null);
    }

    public static String getProperty(String prop, String defaultValue) {
        if (prop.length() == 0) {
            throw new IllegalArgumentException();
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPropertyAccess(prop);
        }
        String result = systemProperties.getProperty(prop, defaultValue);
        return result;
    }

    public static String setProperty(String prop, String value) {
        if (prop.length() == 0) {
            throw new IllegalArgumentException();
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(new PropertyPermission(prop, "write"));
        }
        return (String)systemProperties.setProperty(prop, value);
    }

    private static native String[] getPropertyList();

    private static native String getEncoding(int var0);

    public static SecurityManager getSecurityManager() {
        return security;
    }

    public static native int identityHashCode(Object var0);

    public static void load(String pathName) {
        SecurityManager smngr = System.getSecurityManager();
        if (smngr != null) {
            smngr.checkLink(pathName);
        }
        ClassLoader.loadLibraryWithPath(pathName, ClassLoader.callerClassLoader(), null);
    }

    public static void loadLibrary(String libName) {
        ClassLoader.loadLibraryWithClassLoader(libName, ClassLoader.callerClassLoader());
    }

    public static void runFinalization() {
        RUNTIME.runFinalization();
    }

    @Deprecated
    public static void runFinalizersOnExit(boolean flag) {
        Runtime.runFinalizersOnExit((boolean)flag);
    }

    public static void setProperties(Properties p) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPropertiesAccess();
        }
        if (p == null) {
            System.ensureProperties();
        } else {
            systemProperties = p;
        }
    }

    public static void setSecurityManager(final SecurityManager s) {
        final SecurityManager currentSecurity = security;
        if (s != null) {
            try {
                s.checkPackageAccess("java.lang");
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        ProtectionDomain newDomain;
                        ProtectionDomain oldDomain = currentSecurity == null ? System.class.getPDImpl() : currentSecurity.getClass().getPDImpl();
                        if (oldDomain != (newDomain = s.getClass().getPDImpl())) {
                            Msg.getString("K002c");
                            newDomain.implies(new AllPermission());
                        }
                        return null;
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (currentSecurity != null) {
            currentSecurity.checkPermission(RuntimePermission.permissionToSetSecurityManager);
        }
        security = s;
    }

    public static native String mapLibraryName(String var0);

    private static native void setFieldImpl(String var0, Object var1);

    static Class getCallerClass() {
        return Class.getStackClass(2);
    }

    public static Channel inheritedChannel() throws IOException {
        return SelectorProvider.provider().inheritedChannel();
    }

    private static native long hiresFrequencyImpl();

    private static native long hiresClockImpl();

    public static long nanoTime() {
        long hiresClock = System.hiresClockImpl();
        switch (nanoType) {
            case 1: {
                return (long)((double)hiresClock / nanoAdjust);
            }
            case 2: {
                return hiresClock / nanoIntAdjust;
            }
            case 3: {
                return (long)((double)hiresClock * nanoAdjust);
            }
            case 4: {
                return hiresClock * nanoIntAdjust;
            }
        }
        return hiresClock;
    }

    public static String clearProperty(String prop) {
        if (prop.length() == 0) {
            throw new IllegalArgumentException();
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(new PropertyPermission(prop, "write"));
        }
        return (String)systemProperties.remove(prop);
    }

    public static Map<String, String> getenv() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(new RuntimePermission("getenv.*"));
        }
        return ProcessEnvironment.getenv();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Console console() {
        if (consoleInitialized) {
            return console;
        }
        Class<System> clazz = System.class;
        synchronized (System.class) {
            if (consoleInitialized) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return console;
            }
            console = SharedSecrets.getJavaIOAccess().console();
            consoleInitialized = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return console;
        }
    }

    static {
        RUNTIME = Runtime.getRuntime();
        console = null;
        consoleInitialized = false;
        long hiresFrequency = System.hiresFrequencyImpl();
        if (hiresFrequency == 1000000000L) {
            nanoType = 0;
            nanoAdjust = 0.0;
            nanoIntAdjust = 0L;
        } else if (hiresFrequency < 1000000000L) {
            nanoAdjust = 1.0E9 / (double)hiresFrequency;
            if (Math.floor(nanoAdjust) == nanoAdjust) {
                nanoType = 4;
                nanoIntAdjust = (long)nanoAdjust;
            } else {
                nanoType = 3;
                nanoIntAdjust = 0L;
            }
        } else {
            nanoAdjust = (double)hiresFrequency / 1.0E9;
            if (Math.floor(nanoAdjust) == nanoAdjust) {
                nanoType = 1;
                nanoIntAdjust = (long)nanoAdjust;
            } else {
                nanoType = 1;
                nanoIntAdjust = 0L;
            }
        }
        System.ensureProperties();
        StringCoding.encode((char[])new char[1], (int)0, (int)1);
        err = ConsolePrintStream.localize((OutputStream)new BufferedOutputStream(new FileOutputStream(FileDescriptor.err)), (boolean)true);
        out = ConsolePrintStream.localize((OutputStream)new BufferedOutputStream(new FileOutputStream(FileDescriptor.out)), (boolean)true);
        in = null;
        SystemIntialization.firstChanceHook();
    }
}

