/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.IOException;
import java.io.Serializable;

public final class StackTraceElement
implements Serializable {
    private static final long serialVersionUID = 6992337162326171013L;
    String declaringClass;
    String methodName;
    String fileName;
    int lineNumber;
    private static final String[] digits = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};

    public StackTraceElement(String cls, String method, String file, int line) {
        if (cls == null || method == null) {
            throw new NullPointerException();
        }
        this.declaringClass = cls;
        this.methodName = method;
        this.fileName = file;
        this.lineNumber = line;
    }

    private StackTraceElement() {
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StackTraceElement)) {
            return false;
        }
        StackTraceElement castObj = (StackTraceElement)obj;
        if (this.methodName == null || castObj.methodName == null) {
            return false;
        }
        if (!this.getMethodName().equals(castObj.getMethodName())) {
            return false;
        }
        if (!this.getClassName().equals(castObj.getClassName())) {
            return false;
        }
        String localFileName = this.getFileName();
        if (localFileName == null ? castObj.getFileName() != null : !localFileName.equals(castObj.getFileName())) {
            return false;
        }
        return this.getLineNumber() == castObj.getLineNumber();
    }

    public String getClassName() {
        return this.declaringClass == null ? "<unknown class>" : this.declaringClass;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getMethodName() {
        return this.methodName == null ? "<unknown method>" : this.methodName;
    }

    public int hashCode() {
        if (this.methodName == null) {
            return 0;
        }
        return this.methodName.hashCode() ^ this.declaringClass.hashCode();
    }

    public boolean isNativeMethod() {
        return this.lineNumber == -2;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(80);
        this.appendTo(buf);
        return buf.toString();
    }

    void appendTo(Appendable buf) {
        StackTraceElement.appendTo(buf, this.getClassName());
        StackTraceElement.appendTo(buf, ".");
        StackTraceElement.appendTo(buf, this.getMethodName());
        if (this.isNativeMethod()) {
            StackTraceElement.appendTo(buf, "(Native Method)");
        } else {
            String fileName = this.getFileName();
            if (fileName == null) {
                StackTraceElement.appendTo(buf, "(Unknown Source)");
            } else {
                int lineNumber = this.getLineNumber();
                StackTraceElement.appendTo(buf, "(");
                StackTraceElement.appendTo(buf, fileName);
                if (lineNumber >= 0) {
                    StackTraceElement.appendTo(buf, ":");
                    StackTraceElement.appendTo(buf, lineNumber);
                }
                StackTraceElement.appendTo(buf, ")");
            }
        }
    }

    static void appendTo(Appendable buf, CharSequence s) {
        try {
            buf.append(s);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static void appendTo(Appendable buf, int number) {
        int i;
        int j = 1;
        for (i = number; i >= 10; i /= 10) {
            j *= 10;
        }
        StackTraceElement.appendTo(buf, digits[i]);
        while (j >= 10) {
            i = (number -= j * i) / (j /= 10);
            StackTraceElement.appendTo(buf, digits[i]);
        }
    }
}

