/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

class J9VMInternals {
    private static final int UNINITIALIZED = 0;
    private static final int INITIALIZED = 1;
    private static final int FAILED = 2;
    private static final int UNVERIFIED = 3;
    private static final int UNPREPARED = 4;
    private static final int STATUS_MASK = 255;
    private static Map exceptions;
    private static boolean initialized;

    J9VMInternals() {
    }

    private static void completeInitialization() {
        initialized = true;
        exceptions = new WeakHashMap();
        ClassLoader.completeInitialization();
        Thread.currentThread().completeInitialization();
    }

    private static native void sendClassPrepareEvent(Class var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void verify(Class clazz) {
        block24: while (true) {
            switch (J9VMInternals.getInitStatus(clazz)) {
                case 0: 
                case 1: 
                case 2: 
                case 4: {
                    return;
                }
                case 3: {
                    Class clazz2 = clazz;
                    synchronized (clazz2) {
                        if (J9VMInternals.getInitStatus(clazz) != 3) {
                            continue block24;
                        }
                        J9VMInternals.setInitThread(clazz);
                    }
                    Class superclass = J9VMInternals.getSuperclass(clazz);
                    boolean succeeded = false;
                    try {
                        if (superclass != null) {
                            J9VMInternals.verify(superclass);
                        }
                        J9VMInternals.verifyImpl(clazz);
                        succeeded = true;
                    }
                    finally {
                        if (!succeeded) {
                            J9VMInternals.setInitStatus(clazz, 3);
                        }
                    }
                    Class clazz3 = clazz;
                    synchronized (clazz3) {
                        if (J9VMInternals.getInitThread(clazz) && (J9VMInternals.getInitStatus(clazz) & 0xFF) == 3) {
                            J9VMInternals.setInitStatus(clazz, 4);
                        }
                    }
                    return;
                }
            }
            Class superclass = clazz;
            synchronized (superclass) {
                int status = J9VMInternals.getInitStatus(clazz);
                if ((status & 0xFFFFFF00) == 0) {
                    continue;
                }
                if ((status & 0xFF) != 3) {
                    return;
                }
                if (!J9VMInternals.getInitThread(clazz)) {
                    try {
                        clazz.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    continue;
                }
            }
            boolean succeeded = false;
            try {
                J9VMInternals.verifyImpl(clazz);
                succeeded = true;
            }
            finally {
                if (!succeeded) {
                    J9VMInternals.setInitStatus(clazz, 3);
                }
            }
            Class clazz4 = clazz;
            synchronized (clazz4) {
                if (J9VMInternals.getInitThread(clazz) && (J9VMInternals.getInitStatus(clazz) & 0xFF) == 3) {
                    J9VMInternals.setInitStatus(clazz, 4);
                }
            }
        }
    }

    private static native void verifyImpl(Class var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initialize(Class clazz) throws Throwable {
        block32: while (true) {
            Object object;
            switch (J9VMInternals.getInitStatus(clazz)) {
                case 1: {
                    return;
                }
                case 3: {
                    J9VMInternals.verify(clazz);
                    continue block32;
                }
                case 4: {
                    J9VMInternals.prepare(clazz);
                    continue block32;
                }
                case 2: {
                    NoClassDefFoundError notFound = new NoClassDefFoundError(clazz.getName() + " (initialization failure)");
                    if (exceptions != null) {
                        object = exceptions;
                        synchronized (object) {
                            Throwable reason;
                            WeakReference weakReason = (WeakReference)exceptions.get(clazz);
                            if (weakReason != null && (reason = (Throwable)weakReason.get()) != null) {
                                reason = J9VMInternals.copyThrowable(reason);
                                notFound.initCause(reason);
                            }
                        }
                    }
                    throw notFound;
                }
                case 0: {
                    Class weakReason = clazz;
                    synchronized (weakReason) {
                        if (J9VMInternals.getInitStatus(clazz) != 0) {
                            continue block32;
                        }
                        J9VMInternals.setInitThread(clazz);
                    }
                    Class superclass = J9VMInternals.getSuperclass(clazz);
                    if (superclass != null) {
                        try {
                            J9VMInternals.initialize(superclass);
                        }
                        catch (Error err) {
                            J9VMInternals.setInitStatus(clazz, 2);
                            if (initialized) {
                                if (exceptions == null) {
                                    exceptions = new WeakHashMap();
                                }
                                Map reason = exceptions;
                                synchronized (reason) {
                                    Throwable cause = err;
                                    if (err instanceof ExceptionInInitializerError) {
                                        cause = ((ExceptionInInitializerError)err).getException();
                                    }
                                    exceptions.put(clazz, new WeakReference<Throwable>(J9VMInternals.copyThrowable(cause)));
                                }
                            }
                            throw err;
                        }
                    }
                    try {
                        J9VMInternals.initializeImpl(clazz);
                    }
                    catch (Error err) {
                        J9VMInternals.setInitStatus(clazz, 2);
                        if (initialized) {
                            if (exceptions == null) {
                                exceptions = new WeakHashMap();
                            }
                            Map reason = exceptions;
                            synchronized (reason) {
                                exceptions.put(clazz, new WeakReference<Throwable>(J9VMInternals.copyThrowable(err)));
                            }
                        }
                        throw err;
                    }
                    catch (Throwable t) {
                        J9VMInternals.setInitStatus(clazz, 2);
                        if (initialized) {
                            if (exceptions == null) {
                                exceptions = new WeakHashMap();
                            }
                            Map reason = exceptions;
                            synchronized (reason) {
                                exceptions.put(clazz, new WeakReference<Throwable>(J9VMInternals.copyThrowable(t)));
                            }
                        }
                        throw new ExceptionInInitializerError(t);
                    }
                    J9VMInternals.setInitStatus(clazz, 1);
                    return;
                }
            }
            object = clazz;
            synchronized (object) {
                int status = J9VMInternals.getInitStatus(clazz);
                if ((status & 0xFFFFFF00) == 0) {
                    continue;
                }
                if ((status & 0xFF) == 0) {
                    if (J9VMInternals.getInitThread(clazz)) {
                        return;
                    }
                    try {
                        clazz.wait();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    continue;
                }
            }
            J9VMInternals.verify(clazz);
        }
    }

    private static native Throwable newInstance(Class var0, Class var1);

    private static Throwable cloneThrowable(final Throwable throwable) {
        return (Throwable)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Throwable clone;
                try {
                    Class cls = throwable.getClass();
                    clone = J9VMInternals.newInstance(cls, Object.class);
                    while (cls != null) {
                        Field[] fields = cls.getDeclaredFields();
                        for (int i = 0; i < fields.length; ++i) {
                            if (Modifier.isStatic(fields[i].getModifiers()) || cls == Throwable.class && fields[i].getName().equals("walkback")) continue;
                            fields[i].setAccessible(true);
                            Object value = cls == Throwable.class && fields[i].getName().equals("cause") ? clone : fields[i].get(throwable);
                            fields[i].set(clone, value);
                        }
                        cls = J9VMInternals.getSuperclass(cls);
                    }
                }
                catch (Throwable e) {
                    clone = new Throwable("Error cloning Throwable (" + e + "). The original exception was: " + throwable.toString());
                }
                return clone;
            }
        });
    }

    private static Throwable copyThrowable(Throwable throwable) {
        Throwable root = J9VMInternals.cloneThrowable(throwable);
        root.setStackTrace(throwable.getStackTrace());
        Throwable parent = root;
        HashMap<Throwable, Throwable> found = new HashMap<Throwable, Throwable>();
        found.put(throwable, throwable);
        for (Throwable cause = throwable.getCause(); cause != null && found.get(cause) == null; cause = cause.getCause()) {
            found.put(cause, cause);
            Throwable child = J9VMInternals.cloneThrowable(cause);
            child.setStackTrace(cause.getStackTrace());
            parent.initCause(child);
            parent = child;
        }
        return root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setInitStatus(Class clazz, int status) {
        Class clazz2 = clazz;
        synchronized (clazz2) {
            J9VMInternals.setInitStatusImpl(clazz, status);
            clazz.notifyAll();
        }
    }

    private static native int getInitStatus(Class var0);

    private static native void setInitStatusImpl(Class var0, int var1);

    private static native void initializeImpl(Class var0) throws Throwable;

    private static native boolean getInitThread(Class var0);

    private static native void setInitThread(Class var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void threadCleanup(Thread thread) {
        try {
            thread.threadGroup.remove(thread);
        }
        finally {
            thread.cleanup();
            Thread thread2 = thread;
            synchronized (thread2) {
                thread.notifyAll();
            }
        }
    }

    private static void checkPackageAccess(final Class clazz, ProtectionDomain pd) {
        SecurityManager sm;
        if (clazz != null && pd != null && (sm = System.getSecurityManager()) != null) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    sm.checkPackageAccess(clazz.getPackageName());
                    return null;
                }
            }, new AccessControlContext(new ProtectionDomain[]{pd}));
        }
    }

    private static void runFinalize(Object obj) {
        try {
            obj.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static native StackTraceElement[] getStackTrace(Throwable var0, boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void prepare(Class clazz) {
        block8: while (true) {
            switch (J9VMInternals.getInitStatus(clazz)) {
                case 0: 
                case 1: 
                case 2: {
                    return;
                }
                case 3: {
                    J9VMInternals.verify(clazz);
                    continue block8;
                }
                case 4: {
                    Class superclass = J9VMInternals.getSuperclass(clazz);
                    if (superclass != null) {
                        J9VMInternals.prepare(superclass);
                    }
                    Class[] interfaces = J9VMInternals.getInterfaces(clazz);
                    for (int i = 0; i < interfaces.length; ++i) {
                        J9VMInternals.prepare(interfaces[i]);
                    }
                    Class clazz2 = clazz;
                    synchronized (clazz2) {
                        if (J9VMInternals.getInitStatus(clazz) != 4) {
                            // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 5, 8, 10] lbl20 : MonitorExitStatement: MONITOREXIT : var3_3
                            continue block8;
                        }
                        J9VMInternals.setInitStatus(clazz, 0);
                    }
                    J9VMInternals.sendClassPrepareEvent(clazz);
                    return;
                }
            }
            break;
        }
    }

    static native Class getSuperclass(Class var0);

    static native Class[] getInterfaces(Class var0);

    static native ClassLoader getClassLoader(Class var0);

    static native Object newInstanceImpl(Class var0) throws IllegalAccessException, InstantiationException;

    static {
        initialized = false;
    }
}

