/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.ibm.oti.util.Msg;
import com.ibm.oti.util.Util;
import com.ibm.oti.vm.AbstractClassLoader;
import com.ibm.oti.vm.BootstrapClassLoader;
import com.ibm.oti.vm.VM;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.nio.ByteBuffer;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import sun.misc.Launcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClassLoader {
    static ClassLoader systemClassLoader;
    private static ClassLoader applicationClassLoader;
    private static boolean initSystemClassLoader;
    private static boolean reflectCacheEnabled;
    private static boolean reflectCacheAppOnly;
    private static boolean reflectCacheDebug;
    private long vmRef;
    ClassLoader parent;
    private static boolean checkAssertionOptions;
    private Object assertionLock = new AssertionLock();
    private boolean defaultAssertionStatus;
    private Map packageAssertionStatus;
    private Map classAssertionStatus;
    private Hashtable genericRepository;
    private Hashtable annotationCache;
    private Hashtable packages = new Hashtable();
    private Object lazyInitLock = new LazyInitLock();
    private Hashtable classSigners = null;
    private Hashtable packageSigners = new Hashtable();
    private static Certificate[] emptyCertificates;
    private ProtectionDomain defaultProtectionDomain;
    private static boolean allowArraySyntax;
    private final Hashtable methodCache;
    private final Hashtable fieldCache;
    private final Hashtable constructorCache;

    static final void initializeClassLoaders() {
        String propValue;
        if (systemClassLoader != null) {
            return;
        }
        String allowValue = System.getProperty("sun.lang.ClassLoader.allowArraySyntax");
        if (allowValue != null) {
            allowValue = allowValue.toLowerCase();
        }
        if ("true".equals(allowValue)) {
            allowArraySyntax = true;
        }
        if ((propValue = System.getProperty("reflect.cache")) != null) {
            propValue = propValue.toLowerCase();
        }
        if (!"false".equals(propValue)) {
            reflectCacheEnabled = true;
            if (propValue != null) {
                StringTokenizer tokenizer = new StringTokenizer(propValue, ",");
                while (tokenizer.hasMoreTokens()) {
                    String value = tokenizer.nextToken();
                    if ("boot".equals(value)) {
                        reflectCacheAppOnly = false;
                    }
                    if (!"debug".equals(value)) continue;
                    reflectCacheDebug = true;
                }
            }
        }
        ClassLoader sysTemp = null;
        String systemLoaderString = System.getProperty("systemClassLoader");
        if (null == systemLoaderString) {
            sysTemp = BootstrapClassLoader.singleton();
        } else {
            try {
                sysTemp = (ClassLoader)Class.forName(systemLoaderString, true, null).newInstance();
            }
            catch (Throwable x) {
                x.printStackTrace();
                System.exit(1);
            }
        }
        systemClassLoader = sysTemp;
        AbstractClassLoader.setBootstrapClassLoader(systemClassLoader);
        applicationClassLoader = systemClassLoader;
        applicationClassLoader = Launcher.getLauncher().getClassLoader();
        if (reflectCacheEnabled) {
            Class.initCacheIds();
        }
    }

    protected ClassLoader() {
        this(applicationClassLoader);
    }

    protected ClassLoader(ClassLoader parentLoader) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkCreateClassLoader();
        }
        if (reflectCacheEnabled) {
            this.methodCache = new Hashtable();
            this.fieldCache = new Hashtable();
            this.constructorCache = new Hashtable();
        } else {
            this.methodCache = null;
            this.fieldCache = null;
            this.constructorCache = null;
        }
        this.parent = parentLoader;
        if (systemClassLoader != null) {
            VM.initializeClassLoader(this, false);
        }
        this.initializeClassLoaderAssertStatus();
    }

    @Deprecated
    protected final Class<?> defineClass(byte[] classRep, int offset, int length) throws ClassFormatError {
        return this.defineClass(null, classRep, offset, length);
    }

    protected final Class<?> defineClass(String className, byte[] classRep, int offset, int length) throws ClassFormatError {
        return this.defineClass(className, classRep, offset, length, null);
    }

    private String checkClassName(String className) {
        int index = className.lastIndexOf(46);
        if (index >= 0) {
            String packageName = className.substring(0, index);
            if (className.startsWith("java.")) {
                throw new SecurityException(Msg.getString("K01d2", packageName, className));
            }
            return packageName;
        }
        return "";
    }

    protected final Class<?> defineClass(String className, byte[] classRep, int offset, int length, ProtectionDomain protectionDomain) throws ClassFormatError {
        CodeSource cs;
        Object[] certs = null;
        if (protectionDomain != null && (cs = protectionDomain.getCodeSource()) != null) {
            certs = cs.getCertificates();
        }
        if (className != null) {
            String packageName = this.checkClassName(className);
            this.checkPackageSigners(packageName, className, (Certificate[])certs);
        }
        if (offset < 0 || length < 0 || offset > classRep.length || length > classRep.length - offset) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (protectionDomain == null) {
            protectionDomain = this.getDefaultProtectionDomain();
        }
        ProtectionDomain pd = protectionDomain;
        Class answer = this.defineClassImpl(className, classRep, offset, length, pd);
        if (this.isVerboseImpl()) {
            URL url;
            CodeSource cs2;
            String location = "<unknown>";
            if (pd != null && (cs2 = pd.getCodeSource()) != null && (url = cs2.getLocation()) != null) {
                location = url.toString();
            }
            VM.dumpString("class load: " + answer.getName() + " from: " + location + "\n");
        }
        if (certs != null) {
            this.setSigners(answer, certs);
        }
        return answer;
    }

    private native boolean isVerboseImpl();

    private void checkPackageSigners(String packageName, String className, Certificate[] classCerts) {
        Certificate[] packageCerts = (Certificate[])this.packageSigners.get(packageName);
        if (packageCerts == null) {
            if (classCerts == null) {
                this.packageSigners.put(packageName, emptyCertificates);
            } else {
                this.packageSigners.put(packageName, classCerts);
            }
        } else {
            if (classCerts == null && packageCerts.length == 0 || classCerts == packageCerts) {
                return;
            }
            if (classCerts != null && classCerts.length == packageCerts.length) {
                boolean foundMatch = true;
                block0: for (int i = 0; i < classCerts.length; ++i) {
                    if (classCerts[i] == packageCerts[i] || classCerts[i].equals(packageCerts[i])) continue;
                    for (int j = 0; j < packageCerts.length; ++j) {
                        if (j != i && (classCerts[i] == packageCerts[j] || classCerts[i].equals(packageCerts[j]))) continue block0;
                    }
                    foundMatch = false;
                    break;
                }
                if (foundMatch) {
                    return;
                }
            }
            throw new SecurityException(Msg.getString("K01d1", className));
        }
    }

    private final ProtectionDomain getDefaultProtectionDomain() {
        if (this.defaultProtectionDomain == null) {
            CodeSource nullCodeSource = new CodeSource(null, (Certificate[])null);
            this.defaultProtectionDomain = new ProtectionDomain(nullCodeSource, null, this, null);
        }
        return this.defaultProtectionDomain;
    }

    private final native Class defineClassImpl(String var1, byte[] var2, int var3, int var4, Object var5);

    protected Class<?> findClass(String className) throws ClassNotFoundException {
        throw new ClassNotFoundException();
    }

    protected final Class<?> findLoadedClass(String className) {
        if (!allowArraySyntax && className != null && className.length() > 0 && className.charAt(0) == '[') {
            return null;
        }
        return this.findLoadedClassImpl(className);
    }

    private native Class findLoadedClassImpl(String var1);

    protected final Class<?> findSystemClass(String className) throws ClassNotFoundException {
        return applicationClassLoader.loadClass(className);
    }

    public final ClassLoader getParent() {
        ClassLoader callersClassLoader;
        SecurityManager security = System.getSecurityManager();
        if (security != null && (callersClassLoader = ClassLoader.callerClassLoader()) != null && callersClassLoader != this && !callersClassLoader.isAncestorOf(this)) {
            security.checkPermission(RuntimePermission.permissionToGetClassLoader);
        }
        return this.parent;
    }

    public URL getResource(String resName) {
        URL url;
        URL uRL = url = this.parent == null ? systemClassLoader.findResource(resName) : this.parent.getResource(resName);
        if (url != null) {
            return url;
        }
        return this.findResource(resName);
    }

    public Enumeration<URL> getResources(String resName) throws IOException {
        ClassLoader up = this;
        final Vector<Enumeration<URL>> resources = new Vector<Enumeration<URL>>();
        while (true) {
            Enumeration<URL> e;
            if ((e = up.findResources(resName)) != null && e.hasMoreElements()) {
                resources.addElement(e);
            }
            if (up == systemClassLoader) break;
            up = up.parent;
            if (up != null) continue;
            up = systemClassLoader;
        }
        return new Enumeration<URL>(){
            int index;
            {
                this.index = resources.size() - 1;
            }

            @Override
            public boolean hasMoreElements() {
                while (this.index >= 0) {
                    if (((Enumeration)resources.elementAt(this.index)).hasMoreElements()) {
                        return true;
                    }
                    --this.index;
                }
                return false;
            }

            @Override
            public URL nextElement() {
                while (this.index >= 0) {
                    Enumeration e = (Enumeration)resources.elementAt(this.index);
                    if (e.hasMoreElements()) {
                        return (URL)e.nextElement();
                    }
                    --this.index;
                }
                throw new NoSuchElementException();
            }
        };
    }

    public InputStream getResourceAsStream(String resName) {
        URL url = this.getResource(resName);
        try {
            if (url != null) {
                return url.openStream();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    static void completeInitialization() {
        initSystemClassLoader = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassLoader getSystemClassLoader() {
        ClassLoader callersClassLoader;
        SecurityManager security;
        if (initSystemClassLoader) {
            Class<ClassLoader> classLoaderClass;
            Class<ClassLoader> clazz = classLoaderClass = ClassLoader.class;
            synchronized (clazz) {
                if (initSystemClassLoader) {
                    initSystemClassLoader = false;
                    String userLoader = System.getProperty("java.system.class.loader");
                    if (userLoader != null) {
                        try {
                            Class<?> loaderClass = Class.forName(userLoader, true, applicationClassLoader);
                            Constructor<?> constructor = loaderClass.getConstructor(classLoaderClass);
                            applicationClassLoader = (ClassLoader)constructor.newInstance(applicationClassLoader);
                        }
                        catch (Throwable e) {
                            throw new Error(e);
                        }
                    }
                }
            }
        }
        if ((security = System.getSecurityManager()) != null && (callersClassLoader = ClassLoader.callerClassLoader()) != null && callersClassLoader != applicationClassLoader && !callersClassLoader.isAncestorOf(applicationClassLoader)) {
            security.checkPermission(RuntimePermission.permissionToGetClassLoader);
        }
        return applicationClassLoader;
    }

    public static URL getSystemResource(String resName) {
        return ClassLoader.getSystemClassLoader().getResource(resName);
    }

    public static Enumeration<URL> getSystemResources(String resName) throws IOException {
        return ClassLoader.getSystemClassLoader().getResources(resName);
    }

    public static InputStream getSystemResourceAsStream(String resName) {
        return ClassLoader.getSystemClassLoader().getResourceAsStream(resName);
    }

    public Class<?> loadClass(String className) throws ClassNotFoundException {
        return this.loadClass(className, false);
    }

    protected synchronized Class<?> loadClass(String className, boolean resolveClass) throws ClassNotFoundException {
        Class<?> loadedClass = this.findLoadedClass(className);
        if (loadedClass == null) {
            try {
                loadedClass = this.parent == null ? systemClassLoader.loadClass(className) : this.parent.loadClass(className, resolveClass);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            if (loadedClass == null) {
                loadedClass = this.findClass(className);
            }
        }
        if (resolveClass) {
            this.resolveClass(loadedClass);
        }
        return loadedClass;
    }

    protected final void resolveClass(Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException();
        }
        J9VMInternals.verify(clazz);
    }

    private void setParent(ClassLoader newParent) {
        this.parent = newParent;
    }

    final boolean isSystemClassLoader() {
        if (this == systemClassLoader) {
            return true;
        }
        ClassLoader cl = applicationClassLoader;
        while (cl != null) {
            if (this == cl) {
                return true;
            }
            cl = cl.parent;
        }
        return false;
    }

    final boolean isAncestorOf(ClassLoader child) {
        if (child == null) {
            return false;
        }
        if (this == systemClassLoader) {
            return true;
        }
        ClassLoader cl = child.parent;
        while (cl != null) {
            if (this == cl) {
                return true;
            }
            cl = cl.parent;
        }
        return false;
    }

    protected URL findResource(String resName) {
        return null;
    }

    protected Enumeration<URL> findResources(String resName) throws IOException {
        return new Vector().elements();
    }

    protected String findLibrary(String libName) {
        return null;
    }

    protected Package getPackage(String name) {
        if (this != systemClassLoader) {
            Package pkg;
            ClassLoader parent = this.parent;
            if (parent == null) {
                parent = systemClassLoader;
            }
            if ((pkg = parent.getPackage(name)) != null) {
                return pkg;
            }
        }
        return (Package)this.packages.get(name);
    }

    protected Package[] getPackages() {
        Package[] ancestorsPackages = null;
        if (this.parent == null) {
            if (this != systemClassLoader) {
                ancestorsPackages = systemClassLoader.getPackages();
            }
        } else {
            ancestorsPackages = this.parent.getPackages();
        }
        int resultSize = this.packages.size();
        if (ancestorsPackages != null) {
            resultSize += ancestorsPackages.length;
        }
        Package[] result = new Package[resultSize];
        Enumeration myPkgs = this.packages.elements();
        if (ancestorsPackages != null) {
            for (int i = 0; i < ancestorsPackages.length; ++i) {
                result[i] = ancestorsPackages[i];
            }
        }
        while (myPkgs.hasMoreElements()) {
            result[i++] = (Package)myPkgs.nextElement();
        }
        return result;
    }

    protected Package definePackage(String name, String specTitle, String specVersion, String specVendor, String implTitle, String implVersion, String implVendor, URL sealBase) throws IllegalArgumentException {
        Hashtable hashtable = this.packages;
        synchronized (hashtable) {
            if (this.getPackage(name) == null) {
                Package newPackage = new Package(name, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, sealBase, this);
                this.packages.put(name, newPackage);
                return newPackage;
            }
            throw new IllegalArgumentException(Msg.getString("K0053", name));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Object[] getSigners(Class c) {
        Object object = this.lazyInitLock;
        synchronized (object) {
            if (this.classSigners == null) {
                return null;
            }
        }
        try {
            Object result = this.classSigners.get(c);
            if (result != null) {
                return (Object[])result.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setSigners(Class<?> c, Object[] signers) {
        if (c.getClassLoaderImpl() == this) {
            if (signers == null) {
                Object object = this.lazyInitLock;
                synchronized (object) {
                    if (this.classSigners == null) {
                        return;
                    }
                }
                this.classSigners.remove(c);
            } else {
                Object object = this.lazyInitLock;
                synchronized (object) {
                    if (this.classSigners == null) {
                        this.classSigners = new Hashtable();
                    }
                }
                this.classSigners.put(c, signers);
            }
        } else {
            c.getClassLoaderImpl().setSigners(c, signers);
        }
    }

    static ClassLoader getCallerClassLoader() {
        ClassLoader loader = ClassLoader.getStackClassLoader(2);
        if (loader == systemClassLoader) {
            return null;
        }
        return loader;
    }

    static final native ClassLoader getStackClassLoader(int var0);

    static ClassLoader callerClassLoader() {
        ClassLoader loader = ClassLoader.getStackClassLoader(2);
        if (loader == systemClassLoader) {
            return null;
        }
        return loader;
    }

    static synchronized void loadLibraryWithClassLoader(String libName, ClassLoader loader) {
        String realLibName;
        SecurityManager smngr = System.getSecurityManager();
        if (smngr != null) {
            smngr.checkLink(libName);
        }
        if (loader != null && (realLibName = loader.findLibrary(libName)) != null) {
            ClassLoader.loadLibraryWithPath(realLibName, loader, null);
            return;
        }
        ClassLoader.loadLibraryWithPath(libName, loader, System.internalGetProperties().getProperty(loader == null ? "com.ibm.oti.vm.bootstrap.library.path" : "java.library.path"));
    }

    static void loadLibraryWithPath(String libName, ClassLoader loader, String libraryPath) {
        byte[] message = ClassLoader.loadLibraryWithPath(Util.getBytes(libName), loader, libraryPath == null ? null : Util.getBytes(libraryPath));
        if (message != null) {
            String error;
            try {
                error = Util.convertFromUTF8(message, 0, message.length);
            }
            catch (IOException e) {
                error = Util.toString(message);
            }
            throw new UnsatisfiedLinkError(libName + " (" + error + ")");
        }
    }

    private static native byte[] loadLibraryWithPath(byte[] var0, ClassLoader var1, byte[] var2);

    static void loadLibrary(Class caller, String name, boolean fullPath) {
        if (fullPath) {
            ClassLoader.loadLibraryWithPath(name, caller.getClassLoaderImpl(), null);
        } else {
            ClassLoader.loadLibraryWithClassLoader(name, caller.getClassLoaderImpl());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClassAssertionStatus(String cname, boolean enable) {
        Object object = this.assertionLock;
        synchronized (object) {
            if (this.classAssertionStatus == null) {
                this.classAssertionStatus = new HashMap();
            }
            this.classAssertionStatus.put(cname, enable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPackageAssertionStatus(String pname, boolean enable) {
        Object object = this.assertionLock;
        synchronized (object) {
            if (this.packageAssertionStatus == null) {
                this.packageAssertionStatus = new HashMap();
            }
            this.packageAssertionStatus.put(pname, enable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultAssertionStatus(boolean enable) {
        Object object = this.assertionLock;
        synchronized (object) {
            this.defaultAssertionStatus = enable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAssertionStatus() {
        Object object = this.assertionLock;
        synchronized (object) {
            this.defaultAssertionStatus = false;
            this.classAssertionStatus = null;
            this.packageAssertionStatus = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean getClassAssertionStatus(String cname) {
        Object object = this.assertionLock;
        synchronized (object) {
            int dlrIndex = -1;
            if (this.classAssertionStatus != null) {
                Boolean b = (Boolean)this.classAssertionStatus.get(cname);
                if (b != null) {
                    return b;
                }
                dlrIndex = cname.indexOf(36);
                if (dlrIndex > 0 && (b = (Boolean)this.classAssertionStatus.get(cname.substring(0, dlrIndex))) != null) {
                    return b;
                }
            }
            if ((dlrIndex = cname.lastIndexOf(46)) > 0) {
                return this.getPackageAssertionStatus(cname.substring(0, dlrIndex));
            }
            return this.getDefaultAssertionStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean getPackageAssertionStatus(String pname) {
        Object object = this.assertionLock;
        synchronized (object) {
            int prdIndex = -1;
            if (this.packageAssertionStatus != null) {
                Boolean b = (Boolean)this.packageAssertionStatus.get(pname);
                if (b != null) {
                    return b;
                }
                prdIndex = pname.lastIndexOf(46);
                if (prdIndex > 0) {
                    return this.getPackageAssertionStatus(pname.substring(0, prdIndex));
                }
            }
            return this.getDefaultAssertionStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean getDefaultAssertionStatus() {
        Object object = this.assertionLock;
        synchronized (object) {
            return this.defaultAssertionStatus;
        }
    }

    private void initializeClassLoaderAssertStatus() {
        boolean bootLoader;
        boolean bl = bootLoader = systemClassLoader == null;
        if (!bootLoader && !checkAssertionOptions) {
            return;
        }
        boolean foundAssertionOptions = false;
        String[] vmargs = VM.getVMArgs();
        for (int i = 0; i < vmargs.length; ++i) {
            boolean def;
            String vmargExtraInfo;
            String vmargOptions;
            if (!vmargs[i].startsWith("-e") && !vmargs[i].startsWith("-d")) continue;
            int indexColon = vmargs[i].indexOf(58);
            if (indexColon == -1) {
                vmargOptions = vmargs[i];
                vmargExtraInfo = null;
            } else {
                vmargOptions = vmargs[i].substring(0, indexColon);
                vmargExtraInfo = vmargs[i].substring(indexColon + 1);
            }
            if (vmargOptions.compareTo("-ea") == 0 || vmargOptions.compareTo("-enableassertions") == 0 || vmargOptions.compareTo("-da") == 0 || vmargOptions.compareTo("-disableassertions") == 0) {
                foundAssertionOptions = true;
                boolean bl2 = def = vmargOptions.charAt(1) == 'e';
                if (vmargExtraInfo == null) {
                    if (bootLoader) continue;
                    this.setDefaultAssertionStatus(def);
                    continue;
                }
                String str = vmargExtraInfo;
                int len = str.length();
                if (len > 3 && str.charAt(len - 1) == '.' && str.charAt(len - 2) == '.' && str.charAt(len - 3) == '.') {
                    str = str.substring(0, len - 3);
                    this.setPackageAssertionStatus(str, def);
                    continue;
                }
                this.setClassAssertionStatus(str, def);
                continue;
            }
            if (vmargOptions.compareTo("-esa") != 0 && vmargOptions.compareTo("-enablesystemassertions") != 0 && vmargOptions.compareTo("-dsa") != 0 && vmargOptions.compareTo("-disablesystemassertions") != 0 || !bootLoader) continue;
            def = vmargOptions.charAt(1) == 'e';
            this.setDefaultAssertionStatus(def);
        }
        if (bootLoader && foundAssertionOptions) {
            checkAssertionOptions = true;
        }
    }

    protected final Class<?> defineClass(String name, ByteBuffer buffer, ProtectionDomain domain) throws ClassFormatError {
        if (buffer.hasArray()) {
            return this.defineClass(name, buffer.array(), buffer.position(), buffer.limit() - buffer.position(), domain);
        }
        int size = buffer.limit() - buffer.position();
        byte[] bytes = new byte[size];
        buffer.get(bytes);
        return this.defineClass(name, bytes, 0, bytes.length, domain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Hashtable getGenericRepository() {
        Object object = this.lazyInitLock;
        synchronized (object) {
            if (this.genericRepository == null) {
                this.genericRepository = new Hashtable();
            }
        }
        return this.genericRepository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Hashtable getAnnotationCache() {
        Object object = this.lazyInitLock;
        synchronized (object) {
            if (this.annotationCache == null) {
                this.annotationCache = new Hashtable();
            }
        }
        return this.annotationCache;
    }

    static boolean isReflectCacheEnabled() {
        return reflectCacheEnabled;
    }

    static boolean isReflectCacheAppOnly() {
        return reflectCacheAppOnly;
    }

    static boolean isReflectCacheDebug() {
        return reflectCacheDebug;
    }

    final Hashtable getMethodCache() {
        return this.methodCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final CacheTable getMethodCache(Class cl) {
        Hashtable hashtable = this.methodCache;
        synchronized (hashtable) {
            CacheTable clCache = (CacheTable)this.methodCache.get(cl);
            if (clCache == null) {
                clCache = new CacheTable(this.methodCache, cl);
                this.methodCache.put(cl, clCache);
            }
            clCache.used();
            return clCache;
        }
    }

    final Hashtable getFieldCache() {
        return this.fieldCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final CacheTable getFieldCache(Class cl) {
        Hashtable hashtable = this.fieldCache;
        synchronized (hashtable) {
            CacheTable clCache = (CacheTable)this.fieldCache.get(cl);
            if (clCache == null) {
                clCache = new CacheTable(this.fieldCache, cl);
                this.fieldCache.put(cl, clCache);
            }
            clCache.used();
            return clCache;
        }
    }

    final Hashtable getConstructorCache() {
        return this.constructorCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final CacheTable getConstructorCache(Class cl) {
        Hashtable hashtable = this.constructorCache;
        synchronized (hashtable) {
            CacheTable clCache = (CacheTable)this.constructorCache.get(cl);
            if (clCache == null) {
                clCache = new CacheTable(this.constructorCache, cl);
                this.constructorCache.put(cl, clCache);
            }
            clCache.used();
            return clCache;
        }
    }

    static {
        initSystemClassLoader = false;
        reflectCacheEnabled = false;
        reflectCacheAppOnly = true;
        reflectCacheDebug = false;
        checkAssertionOptions = false;
        emptyCertificates = new Certificate[0];
        allowArraySyntax = false;
    }

    static class CacheTable
    extends Hashtable {
        Hashtable parent;
        Object key;
        int useCount;

        public CacheTable(Hashtable parent, Object key) {
            this.parent = parent;
            this.key = key;
        }

        public Object get(Object key) {
            SoftReference sf = (SoftReference)super.get(key);
            return sf != null ? sf.get() : null;
        }

        public Object getRef(Object key) {
            return super.get(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeEmpty() {
            Hashtable hashtable = this.parent;
            synchronized (hashtable) {
                CacheTable cacheTable = this;
                synchronized (cacheTable) {
                    if (this.isEmpty() && this.useCount == 0) {
                        if (ClassLoader.isReflectCacheDebug()) {
                            System.err.println("Removed reflect cache for: " + this.key);
                        }
                        this.parent.remove(this.key);
                    } else if (ClassLoader.isReflectCacheDebug()) {
                        System.err.println("Reflect cache size: " + this.size() + " and useCount: " + this.useCount + " for: " + this.key);
                    }
                }
            }
        }

        public synchronized void used() {
            ++this.useCount;
        }

        public synchronized void free() {
            --this.useCount;
        }
    }

    private static class LazyInitLock {
        private LazyInitLock() {
        }
    }

    private static class AssertionLock {
        private AssertionLock() {
        }
    }
}

