/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.vm;

import com.ibm.oti.util.Msg;
import com.ibm.oti.util.Util;
import com.ibm.oti.vm.JxeException;
import com.ibm.oti.vm.JxeMetaData;
import com.ibm.oti.vm.JxePermission;
import com.ibm.oti.vm.JxeResource;
import com.ibm.oti.vm.JxeResourceTable;
import com.ibm.oti.vm.JxeUtil;
import com.ibm.oti.vm.MemInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public final class Jxe {
    long romSegmentPointer;
    private boolean allocated;
    private String uuid;
    private long jxePointer;
    private Hashtable resTable;
    static final int DEFLATED = 8;
    static final int STORED = 0;

    public static Jxe fromInputStream(InputStream iStream, int length) throws JxeException, IOException {
        Jxe jxe;
        long malloc = Jxe.nativeMalloc(length + 7);
        if (0L == malloc) {
            throw new OutOfMemoryError(Msg.getString("K019a", length + 7));
        }
        int offset = (int)(malloc & 7L);
        long pointer = offset == 0 ? malloc : malloc + (long)(8 - offset);
        try {
            Jxe.copyStreamToMemory(iStream, length, pointer);
        }
        catch (IOException e) {
            Jxe.nativeFree(malloc);
            throw e;
        }
        try {
            jxe = new Jxe(malloc, true);
            JxeMetaData metaData = jxe.getJxeMetaData();
            JxeUtil.relocateJxeInPlace(pointer);
            jxe.uuid = metaData.getUuid();
        }
        catch (JxeException e) {
            Jxe.nativeFree(malloc);
            throw e;
        }
        JxeUtil.registerJxe(jxe);
        return jxe;
    }

    static void copyStreamToMemory(InputStream iStream, int size, long pointer) throws IOException {
        int chunk;
        byte[] buffer = new byte[size < 4096 ? size : 4096];
        for (int read = 0; read < size; read += chunk) {
            int left = size - read;
            chunk = iStream.read(buffer, 0, left <= buffer.length ? left : buffer.length);
            if (-1 == chunk) {
                throw new IOException(Msg.getString("K019b", read));
            }
            Jxe.nativeMemcpy(pointer + (long)read, buffer, 0, chunk);
        }
    }

    public static Jxe fromFile(File file) throws JxeException, IOException {
        if (!file.exists()) {
            throw new FileNotFoundException(file.getPath());
        }
        byte[] filename = Util.getBytes(file.getPath());
        long pointer = Jxe.nativeLoadJxeFromFileByteArray(filename);
        if (pointer == 0L) {
            throw new JxeException(Msg.getString("K01c5", file.getPath()));
        }
        Jxe jxe = new Jxe(pointer, false);
        JxeMetaData metaData = jxe.getJxeMetaData();
        jxe.uuid = metaData.getUuid();
        return jxe;
    }

    public static Jxe fromSharedLibrary(String name) throws JxeException {
        long pointer = Jxe.nativeLoadJxeFromSharedLibrary(Util.getBytes(name));
        if (pointer == 0L) {
            throw new JxeException(Msg.getString("K01c5", name));
        }
        Jxe jxe = new Jxe(pointer, false);
        JxeMetaData metaData = jxe.getJxeMetaData();
        jxe.uuid = metaData.getUuid();
        return jxe;
    }

    Jxe(long pointer, boolean allocated) {
        this.jxePointer = pointer;
        this.allocated = allocated;
    }

    public static Jxe fromPointer(long pointer) throws JxeException {
        JxeUtil.relocateJxeInPlace(pointer);
        return new Jxe(pointer, false);
    }

    long getJxePointer() {
        int offset;
        if (this.allocated && (offset = (int)(this.jxePointer & 7L)) != 0) {
            return this.jxePointer + (long)(8 - offset);
        }
        return this.jxePointer;
    }

    long getJxeAlloc() {
        return this.allocated ? this.jxePointer : 0L;
    }

    public JxeMetaData getJxeMetaData() {
        return new JxeMetaData(this);
    }

    public String[] getClassList() {
        return Jxe.nativeGetClassList(this.jxePointer);
    }

    public InputStream getResourceAsStream(String name) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new JxePermission(this.getUuid()));
        }
        return this.internalGetResourceAsStream(name);
    }

    InputStream internalGetResourceAsStream(String name) {
        if (this.jxePointer == 0L) {
            return null;
        }
        this.initializeResTable();
        while (true) {
            JxeResource entry;
            if (null != (entry = (JxeResource)this.resTable.get(name))) {
                MemInputStream stream = new MemInputStream(entry.getPointer(), entry.getSize(), this);
                if (entry.getMethod() != 0) {
                    return new InflaterInputStream(stream, new Inflater(true));
                }
                return stream;
            }
            if (!name.startsWith("/", 0)) {
                return null;
            }
            name = name.substring(1);
        }
    }

    public String getUuid() {
        if (this.uuid == null) {
            this.uuid = this.getJxeMetaData().getUuid();
        }
        return this.uuid;
    }

    private void free() {
        if (this.allocated && this.jxePointer != 0L && this.romSegmentPointer == 0L) {
            Jxe.nativeFree(this.jxePointer);
            this.jxePointer = 0L;
        }
    }

    public void finalize() {
        if (!JxeUtil.unregisterJxe(this)) {
            this.free();
        }
    }

    private void initializeResTable() {
        JxeResourceTable resources;
        if (null != this.resTable) {
            return;
        }
        try {
            resources = new JxeResourceTable(new MemInputStream(this.getJxePointer(), Integer.MAX_VALUE, null));
        }
        catch (IOException e) {
            this.resTable = new Hashtable(0);
            return;
        }
        this.resTable = resources.getTable();
    }

    private static native String[] nativeGetClassList(long var0);

    private static native long nativeLoadJxeFromFileByteArray(byte[] var0);

    private static native void nativeMemcpy(long var0, byte[] var2, int var3, int var4);

    private static native long nativeMalloc(int var0);

    private static native void nativeFree(long var0);

    private static native long nativeLoadJxeFromSharedLibrary(byte[] var0);
}

