/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.shared;

import com.ibm.oti.shared.CannotSetClasspathException;
import com.ibm.oti.shared.SharedClassAbstractHelper;
import com.ibm.oti.shared.SharedClassFilter;
import com.ibm.oti.shared.SharedClassURLClasspathHelper;
import java.net.URL;

public class SharedClassURLClasspathHelperImpl
extends SharedClassAbstractHelper
implements SharedClassURLClasspathHelper {
    private URL[] urls;
    private URL[] origurls;
    private boolean[] validated;
    private int urlCount;
    private int confirmedCount;

    SharedClassURLClasspathHelperImpl(ClassLoader loader, URL[] classpath, int id, boolean canFind, boolean canStore) {
        this.origurls = classpath;
        this.urls = new URL[classpath.length];
        this.urlCount = classpath.length;
        this.validated = new boolean[classpath.length];
        this.confirmedCount = 0;
        this.initialize(loader, id, canFind, canStore);
        this.initializeShareableClassloader(loader);
        this.initializeURLs();
    }

    private void initializeURLs() {
        for (int i = 0; i < this.urlCount; ++i) {
            this.urls[i] = this.convertJarURL(this.origurls[i]);
        }
    }

    private native int findSharedClassImpl2(int var1, String var2, String var3, ClassLoader var4, URL[] var5, boolean var6, boolean var7, int var8, int var9, byte[] var10);

    private native boolean storeSharedClassImpl2(int var1, String var2, ClassLoader var3, URL[] var4, int var5, int var6, Class var7, byte[] var8);

    private native void notifyClasspathChange(int var1);

    public byte[] findSharedClass(String className, SharedClassURLClasspathHelper.IndexHolder indexFoundAtHolder) {
        return this.findSharedClass(null, className, indexFoundAtHolder);
    }

    public synchronized byte[] findSharedClass(String partition, String className, SharedClassURLClasspathHelper.IndexHolder indexFoundAtHolder) {
        boolean doStore;
        boolean doFind;
        if (!this.canFind) {
            return null;
        }
        if (className == null) {
            this.printVerboseError("Cannot call findSharedClass with null class name. Returning null.");
            return null;
        }
        if (this.confirmedCount == 0) {
            this.printVerboseInfo("There are no confirmed elements in the classpath. Returning null.");
            return null;
        }
        SharedClassFilter theFilter = this.getSharingFilter();
        if (theFilter != null) {
            doFind = theFilter.acceptFind(className);
            doStore = nativeFlags[0] == 0 ? theFilter.acceptStore(className) : true;
        } else {
            doFind = true;
            doStore = true;
        }
        byte[] romClassCookie = new byte[this.ROMCLASS_COOKIE_SIZE];
        int indexFoundAt = this.findSharedClassImpl2(this.id, partition, className, this.getClassLoader(), this.urls, doFind, doStore, this.urlCount, this.confirmedCount, romClassCookie);
        if (indexFoundAt < 0) {
            return null;
        }
        if (indexFoundAtHolder != null) {
            indexFoundAtHolder.setIndex(indexFoundAt);
        }
        return romClassCookie;
    }

    public boolean storeSharedClass(Class clazz, int foundAtIndex) {
        return this.storeSharedClass(null, clazz, foundAtIndex);
    }

    public synchronized boolean storeSharedClass(String partition, Class clazz, int foundAtIndex) {
        ClassLoader actualLoader;
        if (!this.canStore) {
            return false;
        }
        if (clazz == null) {
            this.printVerboseError("Cannot call storeSharedClass with null Class. Returning false.");
            return false;
        }
        if (this.urlCount == 0) {
            this.printVerboseError("Classpath has zero elements. Cannot call storeSharedClass without classpath. Returning false.");
            return false;
        }
        if (foundAtIndex < 0) {
            this.printVerboseError("foundAtIndex cannot be <0 for storeSharedClass. Returning false.");
            return false;
        }
        if (foundAtIndex >= this.urlCount) {
            this.printVerboseError("foundAtIndex cannot be >= urls in classpath for storeSharedClass. Returning false.");
            return false;
        }
        if (!this.validated[foundAtIndex]) {
            if (!this.validateURL(this.urls[foundAtIndex], true)) {
                return false;
            }
            this.validated[foundAtIndex] = true;
        }
        if (!this.validateClassLoader(actualLoader = this.getClassLoader(), clazz)) {
            return false;
        }
        if (this.confirmedCount <= foundAtIndex) {
            this.confirmedCount = foundAtIndex + 1;
            this.printVerboseInfo("Number of confirmed entries is now " + this.confirmedCount);
        }
        return this.storeSharedClassImpl2(this.id, partition, actualLoader, this.urls, this.urlCount, foundAtIndex, clazz, nativeFlags);
    }

    private synchronized void growURLs(int toMinSize) {
        this.printVerboseInfo("Growing URL array to " + toMinSize);
        int newSize = (toMinSize + 1) * 2;
        URL[] newOrigUrls = new URL[newSize];
        URL[] newUrls = new URL[newSize];
        boolean[] newValidated = new boolean[newSize];
        System.arraycopy((Object)this.origurls, 0, (Object)newOrigUrls, 0, this.urlCount);
        System.arraycopy((Object)this.urls, 0, (Object)newUrls, 0, this.urlCount);
        System.arraycopy((Object)this.validated, 0, (Object)newValidated, 0, this.urlCount);
        this.origurls = newOrigUrls;
        this.urls = newUrls;
        this.validated = newValidated;
    }

    public synchronized void addClasspathEntry(URL cpe) {
        if (cpe == null) {
            this.printVerboseError("URL is null for addClasspathEntry.");
            return;
        }
        if (this.urls.length < this.urlCount + 1) {
            this.growURLs(this.urlCount + 1);
        }
        this.origurls[this.urlCount] = cpe;
        this.urls[this.urlCount] = this.convertJarURL(cpe);
        ++this.urlCount;
    }

    synchronized URL[] getClasspath() {
        URL[] correctLengthArray = new URL[this.urlCount];
        System.arraycopy((Object)this.origurls, 0, (Object)correctLengthArray, 0, this.urlCount);
        return correctLengthArray;
    }

    public synchronized void confirmAllEntries() {
        this.confirmedCount = this.urlCount;
    }

    public synchronized void setClasspath(URL[] newClasspath) throws CannotSetClasspathException {
        int i;
        boolean changeMade = false;
        if (newClasspath.length < this.confirmedCount) {
            throw new CannotSetClasspathException("New classpath cannot be shorter than confirmed elements of original");
        }
        for (i = 0; i < this.confirmedCount; ++i) {
            if (newClasspath[i].equals(this.origurls[i])) continue;
            throw new CannotSetClasspathException("Index " + i + " of newClasspath does not match confirmed original");
        }
        if (newClasspath.length > this.origurls.length) {
            this.growURLs(newClasspath.length);
        }
        for (i = this.confirmedCount; i < newClasspath.length; ++i) {
            if (newClasspath[i].equals(this.origurls[i])) continue;
            this.origurls[i] = newClasspath[i];
            this.urls[i] = this.convertJarURL(newClasspath[i]);
            changeMade = true;
        }
        if (this.urlCount != newClasspath.length) {
            this.urlCount = newClasspath.length;
            changeMade = true;
        }
        if (changeMade) {
            this.printVerboseInfo("setClasspath() updated classpath. Now urlCount=" + this.urlCount);
            this.notifyClasspathChange(this.id);
        }
    }

    String getHelperType() {
        return "SharedClassURLClasspathHelper";
    }
}

