/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.shared;

import com.ibm.oti.shared.SharedClassAbstractHelper;
import com.ibm.oti.shared.SharedClassFilter;
import com.ibm.oti.shared.SharedClassTokenHelper;

public class SharedClassTokenHelperImpl
extends SharedClassAbstractHelper
implements SharedClassTokenHelper {
    SharedClassTokenHelperImpl(ClassLoader loader, int id, boolean canFind, boolean canStore) {
        this.initialize(loader, id, canFind, canStore);
        this.initializeShareableClassloader(loader);
    }

    private native boolean findSharedClassImpl2(int var1, String var2, ClassLoader var3, String var4, boolean var5, boolean var6, byte[] var7);

    private native boolean storeSharedClassImpl2(int var1, ClassLoader var2, String var3, Class var4, byte[] var5);

    public synchronized byte[] findSharedClass(String token, String className) {
        boolean doStore;
        boolean doFind;
        if (!this.canFind) {
            return null;
        }
        if (token == null) {
            this.printVerboseError("Cannot call findSharedClass with null token. Returning null.");
            return null;
        }
        if (className == null) {
            this.printVerboseError("Cannot call findSharedClass with null class name. Returning null.");
            return null;
        }
        SharedClassFilter theFilter = this.getSharingFilter();
        if (theFilter != null) {
            doFind = theFilter.acceptFind(className);
            doStore = nativeFlags[0] == 0 ? theFilter.acceptStore(className) : true;
        } else {
            doFind = true;
            doStore = true;
        }
        byte[] romClassCookie = new byte[this.ROMCLASS_COOKIE_SIZE];
        boolean found = this.findSharedClassImpl2(this.id, className, this.getClassLoader(), token, doFind, doStore, romClassCookie);
        if (!found) {
            return null;
        }
        return romClassCookie;
    }

    public synchronized boolean storeSharedClass(String token, Class clazz) {
        if (!this.canStore) {
            return false;
        }
        if (token == null) {
            this.printVerboseError("Cannot call storeSharedClass with null token. Returning false.");
            return false;
        }
        if (clazz == null) {
            this.printVerboseError("Cannot call storeSharedClass with null Class. Returning false.");
            return false;
        }
        ClassLoader actualLoader = this.getClassLoader();
        if (!this.validateClassLoader(actualLoader, clazz)) {
            return false;
        }
        return this.storeSharedClassImpl2(this.id, actualLoader, token, clazz, nativeFlags);
    }

    String getHelperType() {
        return "SharedClassTokenHelper";
    }
}

