/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.shared;

import com.ibm.oti.shared.HelperAlreadyDefinedException;
import com.ibm.oti.shared.SharedAbstractHelperFactory;
import com.ibm.oti.shared.SharedClassFilter;
import com.ibm.oti.shared.SharedClassHelper;
import com.ibm.oti.shared.SharedClassHelperFactory;
import com.ibm.oti.shared.SharedClassTokenHelper;
import com.ibm.oti.shared.SharedClassTokenHelperImpl;
import com.ibm.oti.shared.SharedClassURLClasspathHelper;
import com.ibm.oti.shared.SharedClassURLClasspathHelperImpl;
import com.ibm.oti.shared.SharedClassURLHelper;
import com.ibm.oti.shared.SharedClassURLHelperImpl;
import com.ibm.oti.util.PriviAction;
import java.net.URL;
import java.security.AccessController;
import java.util.HashMap;

public class SharedClassHelperFactoryImpl
extends SharedAbstractHelperFactory
implements SharedClassHelperFactory {
    static HashMap helpers;
    private static SharedClassFilter globalSharingFilter;
    private static final String GLOBAL_SHARING_FILTER = "com.ibm.oti.shared.SharedClassGlobalFilterClass";

    private static SharedClassFilter getGlobalSharingFilter() {
        if (globalSharingFilter == null) {
            try {
                String className = (String)AccessController.doPrivileged(new PriviAction(GLOBAL_SHARING_FILTER));
                Class<?> filterClass = Class.forName(className);
                if (filterClass != null) {
                    globalSharingFilter = (SharedClassFilter)filterClass.newInstance();
                }
            }
            catch (Exception e) {
                return null;
            }
        }
        return globalSharingFilter;
    }

    public SharedClassHelper findHelperForClassLoader(ClassLoader loader) {
        return (SharedClassHelper)this.findSharedHelperForClassLoader(loader);
    }

    public SharedClassTokenHelper getTokenHelper(ClassLoader loader, SharedClassFilter filter) throws HelperAlreadyDefinedException {
        SharedClassTokenHelper helper = this.getTokenHelper(loader);
        if (helper != null) {
            helper.setSharingFilter(filter);
        }
        return helper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SharedClassTokenHelper getTokenHelper(ClassLoader loader) throws HelperAlreadyDefinedException {
        if (loader == null) {
            return null;
        }
        HashMap hashMap = helpers;
        synchronized (hashMap) {
            SharedClassHelper helper = this.findHelperForClassLoader(loader);
            if (helper != null) {
                if (helper instanceof SharedClassTokenHelper) {
                    return (SharedClassTokenHelper)helper;
                }
                throw new HelperAlreadyDefinedException("A different type of helper already exists for this classloader");
            }
            boolean canFind = this.canFind(loader);
            boolean canStore = this.canStore(loader);
            if (canFind || canStore) {
                SharedClassFilter filter;
                SharedClassTokenHelperImpl result = new SharedClassTokenHelperImpl(loader, this.getNewID(), canFind, canStore);
                if (result != null && (filter = SharedClassHelperFactoryImpl.getGlobalSharingFilter()) != null) {
                    result.setSharingFilter(filter);
                }
                this.addHelper(loader, result);
                return result;
            }
        }
        return null;
    }

    public SharedClassURLHelper getURLHelper(ClassLoader loader, SharedClassFilter filter) throws HelperAlreadyDefinedException {
        SharedClassURLHelper helper = this.getURLHelper(loader);
        if (helper != null) {
            helper.setSharingFilter(filter);
        }
        return helper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SharedClassURLHelper getURLHelper(ClassLoader loader) throws HelperAlreadyDefinedException {
        if (loader == null) {
            return null;
        }
        HashMap hashMap = helpers;
        synchronized (hashMap) {
            SharedClassHelper helper = this.findHelperForClassLoader(loader);
            if (helper != null) {
                if (helper instanceof SharedClassURLHelper) {
                    return (SharedClassURLHelper)helper;
                }
                throw new HelperAlreadyDefinedException("A different type of helper already exists for this classloader");
            }
            boolean canFind = this.canFind(loader);
            boolean canStore = this.canStore(loader);
            if (canFind || canStore) {
                SharedClassFilter filter;
                SharedClassURLHelperImpl result = new SharedClassURLHelperImpl(loader, this.getNewID(), canFind, canStore);
                if (result != null && (filter = SharedClassHelperFactoryImpl.getGlobalSharingFilter()) != null) {
                    result.setSharingFilter(filter);
                }
                this.addHelper(loader, result);
                return result;
            }
        }
        return null;
    }

    public SharedClassURLClasspathHelper getURLClasspathHelper(ClassLoader loader, URL[] classpath, SharedClassFilter filter) throws HelperAlreadyDefinedException {
        SharedClassURLClasspathHelper helper = this.getURLClasspathHelper(loader, classpath);
        if (helper != null) {
            helper.setSharingFilter(filter);
        }
        return helper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SharedClassURLClasspathHelper getURLClasspathHelper(ClassLoader loader, URL[] classpath) throws HelperAlreadyDefinedException {
        if (loader == null || classpath == null) {
            return null;
        }
        HashMap hashMap = helpers;
        synchronized (hashMap) {
            SharedClassHelper helper = this.findHelperForClassLoader(loader);
            SharedClassURLClasspathHelperImpl result = null;
            boolean found = true;
            if (helper != null) {
                if (helper instanceof SharedClassURLClasspathHelper) {
                    result = (SharedClassURLClasspathHelperImpl)helper;
                    URL[] testCP = result.getClasspath();
                    for (int j = 0; j < classpath.length; ++j) {
                        if (classpath[j].equals(testCP[j])) continue;
                        found = false;
                        break;
                    }
                    if (found) {
                        return result;
                    }
                    throw new HelperAlreadyDefinedException("A SharedClassURLClasspathHelper already exists for this classloader with a different classpath");
                }
                throw new HelperAlreadyDefinedException("A different type of helper already exists for this classloader");
            }
            boolean canFind = this.canFind(loader);
            boolean canStore = this.canStore(loader);
            if (canFind || canStore) {
                SharedClassFilter filter;
                result = new SharedClassURLClasspathHelperImpl(loader, classpath, this.getNewID(), canFind, canStore);
                if (result != null && (filter = SharedClassHelperFactoryImpl.getGlobalSharingFilter()) != null) {
                    result.setSharingFilter(filter);
                }
                this.addHelper(loader, result);
                return result;
            }
        }
        return null;
    }

    HashMap getHelperMap() {
        return helpers;
    }

    static {
        globalSharingFilter = null;
        helpers = new HashMap();
    }
}

