/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.shared;

import com.ibm.oti.shared.SharedAbstractHelper;
import com.ibm.oti.shared.SharedClassFilter;
import com.ibm.oti.shared.SharedClassHelper;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;

public abstract class SharedClassAbstractHelper
extends SharedAbstractHelper
implements SharedClassHelper {
    int ROMCLASS_COOKIE_SIZE = 0;
    private static final int URI_EXCEPTION = 1;
    private static final int FILE_EXIST = 2;
    private static final int FILE_NOT_EXIST = 3;
    private SharedClassFilter sharedClassFilter;
    static byte[] nativeFlags = new byte[1];
    static final int CACHE_FULL_FLAG = 0;

    public boolean isSharedClassCookie(byte[] classBytes) {
        return classBytes.length == this.ROMCLASS_COOKIE_SIZE;
    }

    private native int initializeShareableClassloaderImpl(ClassLoader var1);

    void initializeShareableClassloader(ClassLoader loader) {
        this.ROMCLASS_COOKIE_SIZE = this.initializeShareableClassloaderImpl(loader);
    }

    URL convertJarURL(URL url) {
        if (url == null) {
            return null;
        }
        if (!url.getProtocol().equals("jar")) {
            return url;
        }
        String jarPath = this.recursiveJarTrim(url.getPath());
        try {
            return new URL(jarPath);
        }
        catch (MalformedURLException e) {
            return url;
        }
    }

    private String recursiveJarTrim(String jarName) {
        int subStringEnd;
        if (jarName == null) {
            return null;
        }
        int lastIndexBang = jarName.lastIndexOf("!/");
        boolean startsWithJar = jarName.startsWith("jar:");
        int subStringStart = startsWithJar ? 4 : 0;
        int n = subStringEnd = lastIndexBang >= 0 ? lastIndexBang : jarName.length();
        if (!startsWithJar && lastIndexBang == -1) {
            return jarName;
        }
        return this.recursiveJarTrim(jarName.substring(subStringStart, subStringEnd));
    }

    boolean validateClassLoader(ClassLoader loader, Class clazz) {
        if (loader == null) {
            return false;
        }
        if (!loader.equals(clazz.getClassLoader())) {
            this.printVerboseError("ClassLoader of SharedClassHelper and ClassLoader of class " + clazz.getName() + " do not match.");
            return false;
        }
        return true;
    }

    boolean validateURL(URL url, boolean checkExists) {
        String protocol = url.getProtocol();
        if (!protocol.equals("file") && !protocol.equals("jar")) {
            this.printVerboseInfo("URL " + url + " does not have required file or jar protocol.");
            return false;
        }
        if (checkExists) {
            final URL urlToCheck = url;
            Integer fExists = (Integer)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    File f;
                    try {
                        f = new File(urlToCheck.toURI());
                    }
                    catch (URISyntaxException e) {
                        return new Integer(1);
                    }
                    catch (IllegalArgumentException e) {
                        f = new File(urlToCheck.getPath());
                    }
                    return new Integer(f.exists() ? 2 : 3);
                }
            });
            if (fExists == 3) {
                this.printVerboseError("URL resource " + url + " does not exist.");
                return false;
            }
            if (fExists == 1) {
                this.printVerboseError("URI could not be created from the URL " + url);
                return false;
            }
        }
        return true;
    }

    public synchronized void setSharingFilter(SharedClassFilter filter) {
        if (System.getSecurityManager() != null) {
            if (!this.checkReadPermission()) {
                this.printVerboseError("Read permission denied. Cannot set sharing filter.");
                return;
            }
            if (!this.checkWritePermission()) {
                this.printVerboseError("Write permission denied. Cannot set sharing filter.");
                return;
            }
        }
        this.sharedClassFilter = filter;
    }

    public synchronized SharedClassFilter getSharingFilter() {
        return this.sharedClassFilter;
    }

    static {
        SharedClassAbstractHelper.nativeFlags[0] = 0;
    }
}

