/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.shared;

import com.ibm.oti.shared.SharedClassPermission;
import com.ibm.oti.shared.SharedHelper;
import java.lang.ref.WeakReference;
import java.security.AccessControlException;
import java.util.HashMap;

public abstract class SharedAbstractHelperFactory {
    private static int idCount = 1;
    static Object monitor = new Monitor();

    boolean checkPermission(ClassLoader loader, String type) {
        boolean result = true;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                sm.checkPermission(new SharedClassPermission(loader, type));
            }
            catch (AccessControlException e) {
                result = false;
            }
        }
        return result;
    }

    boolean canFind(ClassLoader loader) {
        return this.checkPermission(loader, "read");
    }

    boolean canStore(ClassLoader loader) {
        return this.checkPermission(loader, "write");
    }

    String objectToString(Object o) {
        return o.getClass().getName() + Integer.toHexString(o.hashCode());
    }

    void addHelper(ClassLoader loader, SharedHelper helper) {
        String loaderString = this.objectToString(loader);
        HashMap helpers = this.getHelperMap();
        WeakReference listRef = (WeakReference)helpers.get(loaderString);
        HelperList listHead = listRef != null ? (HelperList)listRef.get() : null;
        HelperList list = listHead;
        if (list == null) {
            helpers.put(loaderString, new WeakReference<HelperList>(new HelperList(helper)));
        } else {
            HelperList tail = null;
            while (list != null) {
                if (list.getHelper() == null) {
                    list.setHelper(helper);
                    return;
                }
                tail = list;
                list = list.getNext();
            }
            tail.setNext(new HelperList(helper));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SharedHelper findSharedHelperForClassLoader(ClassLoader loader) {
        HashMap helpers;
        if (loader == null) {
            return null;
        }
        HashMap hashMap = helpers = this.getHelperMap();
        synchronized (hashMap) {
            HelperList listHead;
            String loaderString = this.objectToString(loader);
            WeakReference listRef = (WeakReference)helpers.get(loaderString);
            for (HelperList list = listHead = listRef != null ? (HelperList)listRef.get() : null; list != null; list = list.getNext()) {
                SharedHelper helper = list.getHelper();
                if (helper == null) continue;
                ClassLoader currentLoader = helper.getClassLoader();
                if (currentLoader == loader) {
                    return helper;
                }
                if (currentLoader != null) continue;
                list.setHelper(null);
            }
        }
        return null;
    }

    abstract HashMap getHelperMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNewID() {
        Object object = monitor;
        synchronized (object) {
            return idCount++;
        }
    }

    class HelperList {
        private WeakReference helperRef;
        private WeakReference nextRef;

        public HelperList(SharedHelper current) {
            this.helperRef = new WeakReference<SharedHelper>(current);
            this.nextRef = null;
        }

        SharedHelper getHelper() {
            if (this.helperRef != null) {
                return (SharedHelper)this.helperRef.get();
            }
            return null;
        }

        void setHelper(SharedHelper helper) {
            this.helperRef = helper != null ? new WeakReference<SharedHelper>(helper) : null;
        }

        HelperList getNext() {
            if (this.nextRef != null) {
                return (HelperList)this.nextRef.get();
            }
            return null;
        }

        void setNext(HelperList list) {
            this.nextRef = list != null ? new WeakReference<HelperList>(list) : null;
        }
    }

    private static class Monitor {
        private Monitor() {
        }
    }
}

