/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.reflect;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;

public class AnnotationHelper {
    public static final int ANNOTATION_TYPE_CLASS = 0;
    public static final int ANNOTATION_TYPE_FIELD = 1;
    public static final int ANNOTATION_TYPE_METHOD = 2;
    public static final int ANNOTATION_TYPE_PARAMETER = 3;
    public static final int ANNOTATION_TYPE_ANNOTATION = 4;
    public static final int ANNOTATION_PARM_SHIFT = 24;

    private static native long[] getAnnotationEntries(Class var0, int var1, Object var2);

    private static native String getAnnotationClassNameForEntry(long var0);

    private static native Object getReturnValueForEntry(Class var0, Class var1, Class var2, long var3, String var5);

    static native Object getDefaultReturnValueFromMethod(Class var0, Class var1, Object var2);

    public static Annotation getAnnotation(Class declaringClass, long value) {
        Annotation result = null;
        String className = AnnotationHelper.getAnnotationClassNameForEntry(value);
        try {
            Class<?> forProxy = Class.forName(className, true, declaringClass.getClassLoader());
            result = (Annotation)Proxy.newProxyInstance(forProxy.getClassLoader(), new Class[]{forProxy}, (InvocationHandler)new AnnotationInvocationHandler(declaringClass, forProxy, value));
        }
        catch (ClassNotFoundException e) {
            throw new TypeNotPresentException(className, e);
        }
        return result;
    }

    public static Annotation[] getDeclaredAnnotations(Class declaringClass, int type, AccessibleObject object) {
        long[] entries = AnnotationHelper.getAnnotationEntries(declaringClass, type, object);
        if (entries == null) {
            return new Annotation[0];
        }
        Annotation[] annArray = new Annotation[entries.length];
        for (int i = 0; i < entries.length; ++i) {
            annArray[i] = AnnotationHelper.getAnnotation(declaringClass, entries[i]);
        }
        return annArray;
    }

    private Enum getEnumForValue(Class clazz, String enumValue) {
        Enum[] values = (Enum[])clazz.getEnumConstants();
        for (int i = 0; i < values.length; ++i) {
            if (!values[i].name().equals(enumValue)) continue;
            return values[i];
        }
        return null;
    }

    private static Enum getEnumFromValue(Class clazz, String enumValue) {
        Enum[] values = (Enum[])clazz.getEnumConstants();
        for (int i = 0; i < values.length; ++i) {
            if (!values[i].name().equals(enumValue)) continue;
            return values[i];
        }
        return null;
    }

    static class AnnotationInvocationHandler
    implements InvocationHandler,
    Serializable {
        private static final long serialVersionUID = 3206093459760838691L;
        private long entry;
        private Class clazz;
        private Class annType;

        AnnotationInvocationHandler(Class declaringClass, Class a, long e) {
            this.entry = e;
            this.clazz = declaringClass;
            this.annType = a;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("toString")) {
                return this.objectToString();
            }
            if (method.getName().equals("annotationType")) {
                return this.annType;
            }
            if (method.getName().equals("equals")) {
                return this.compare(args) ? Boolean.TRUE : Boolean.FALSE;
            }
            if (method.getName().equals("hashCode")) {
                return new Integer(this.getHashValue());
            }
            return AnnotationHelper.getReturnValueForEntry(this.clazz, this.annType, method.getReturnType(), this.entry, method.getName());
        }

        private String objectToString() throws Throwable {
            Method[] methods = this.annType.getDeclaredMethods();
            StringBuilder output = new StringBuilder(methods.length * 48);
            output.append('@').append(this.annType.getCanonicalName()).append('(');
            for (int i = 0; i < methods.length; ++i) {
                output.append(methods[i].getName()).append('=');
                Object result = AnnotationHelper.getReturnValueForEntry(this.clazz, this.annType, methods[i].getReturnType(), this.entry, methods[i].getName());
                if (result.getClass().isArray()) {
                    output.append(this.getArrayValue(result));
                } else {
                    output.append(result);
                }
                if (i == methods.length - 1) continue;
                output.append(", ");
            }
            output.append(')');
            return output.toString();
        }

        private boolean compare(Object[] args) throws Throwable {
            if (args.length != 1) {
                return false;
            }
            if (!(args[0] instanceof Annotation)) {
                return false;
            }
            Class<? extends Annotation> annType2 = ((Annotation)args[0]).annotationType();
            if (!this.annType.equals(annType2)) {
                return false;
            }
            Method[] m = this.annType.getDeclaredMethods();
            for (int i = 0; i < m.length; ++i) {
                Object result1 = AnnotationHelper.getReturnValueForEntry(this.clazz, this.annType, m[i].getReturnType(), this.entry, m[i].getName());
                m[i].setAccessible(true);
                Object result2 = m[i].invoke(args[0], new Object[0]);
                if (result1 == null || result2 == null) {
                    if (result1 == result2) continue;
                    return false;
                }
                if (result1.getClass().isArray() && result2.getClass().isArray()) {
                    if (result1 instanceof boolean[] && result2 instanceof boolean[]) {
                        if (Arrays.equals((boolean[])result1, (boolean[])result2)) continue;
                        return false;
                    }
                    if (result1 instanceof char[] && result2 instanceof char[]) {
                        if (Arrays.equals((char[])result1, (char[])result2)) continue;
                        return false;
                    }
                    if (result1 instanceof byte[] && result2 instanceof byte[]) {
                        if (Arrays.equals((byte[])result1, (byte[])result2)) continue;
                        return false;
                    }
                    if (result1 instanceof short[] && result2 instanceof short[]) {
                        if (Arrays.equals((short[])result1, (short[])result2)) continue;
                        return false;
                    }
                    if (result1 instanceof int[] && result2 instanceof int[]) {
                        if (Arrays.equals((int[])result1, (int[])result2)) continue;
                        return false;
                    }
                    if (result1 instanceof float[] && result2 instanceof float[]) {
                        if (Arrays.equals((float[])result1, (float[])result2)) continue;
                        return false;
                    }
                    if (result1 instanceof double[] && result2 instanceof double[]) {
                        if (Arrays.equals((double[])result1, (double[])result2)) continue;
                        return false;
                    }
                    if (result1 instanceof long[] && result2 instanceof long[]) {
                        if (Arrays.equals((long[])result1, (long[])result2)) continue;
                        return false;
                    }
                    if (result1 instanceof Object[] && result2 instanceof Object[]) {
                        if (Arrays.equals((Object[])result1, (Object[])result2)) continue;
                        return false;
                    }
                    return false;
                }
                if (result1.equals(result2)) continue;
                return false;
            }
            return true;
        }

        private int getHashValue() throws Throwable {
            Method[] m = this.annType.getDeclaredMethods();
            int hashCode = 0;
            for (int i = 0; i < m.length; ++i) {
                int tempHashCode = m[i].getName().hashCode() * 127;
                Object result = AnnotationHelper.getReturnValueForEntry(this.clazz, this.annType, m[i].getReturnType(), this.entry, m[i].getName());
                if (result == null) {
                    tempHashCode = 0;
                } else if (result.getClass().isArray()) {
                    if (result instanceof boolean[]) {
                        tempHashCode ^= Arrays.hashCode((boolean[])result);
                    } else if (result instanceof char[]) {
                        tempHashCode ^= Arrays.hashCode((char[])result);
                    } else if (result instanceof byte[]) {
                        tempHashCode ^= Arrays.hashCode((byte[])result);
                    } else if (result instanceof short[]) {
                        tempHashCode ^= Arrays.hashCode((short[])result);
                    } else if (result instanceof int[]) {
                        tempHashCode ^= Arrays.hashCode((int[])result);
                    } else if (result instanceof float[]) {
                        tempHashCode ^= Arrays.hashCode((float[])result);
                    } else if (result instanceof double[]) {
                        tempHashCode ^= Arrays.hashCode((double[])result);
                    } else if (result instanceof long[]) {
                        tempHashCode ^= Arrays.hashCode((long[])result);
                    } else if (result instanceof Object[]) {
                        tempHashCode ^= Arrays.hashCode((Object[])result);
                    }
                } else {
                    tempHashCode ^= result.hashCode();
                }
                hashCode += tempHashCode;
            }
            return hashCode;
        }

        private String getArrayValue(Object obj) {
            if (obj instanceof boolean[]) {
                return this.getBooleanArrayData((boolean[])obj);
            }
            if (obj instanceof char[]) {
                return this.getCharArrayData((char[])obj);
            }
            if (obj instanceof byte[]) {
                return this.getByteArrayData((byte[])obj);
            }
            if (obj instanceof char[]) {
                return this.getCharArrayData((char[])obj);
            }
            if (obj instanceof short[]) {
                return this.getShortArrayData((short[])obj);
            }
            if (obj instanceof int[]) {
                return this.getIntArrayData((int[])obj);
            }
            if (obj instanceof float[]) {
                return this.getFloatArrayData((float[])obj);
            }
            if (obj instanceof double[]) {
                return this.getDoubleArrayData((double[])obj);
            }
            if (obj instanceof long[]) {
                return this.getLongArrayData((long[])obj);
            }
            return this.getObjectArrayData((Object[])obj);
        }

        private String getObjectArrayData(Object[] objects) {
            StringBuilder output = new StringBuilder(objects.length * 20);
            output.append('[');
            for (int i = 0; i < objects.length; ++i) {
                output.append(objects[i]);
                if (i >= objects.length - 1) continue;
                output.append(',');
            }
            output.append(']');
            return output.toString();
        }

        private String getBooleanArrayData(boolean[] objects) {
            StringBuilder output = new StringBuilder(2 + objects.length * 6);
            output.append('[');
            for (int i = 0; i < objects.length; ++i) {
                output.append(objects[i]);
                if (i >= objects.length - 1) continue;
                output.append(',');
            }
            output.append(']');
            return output.toString();
        }

        private String getCharArrayData(char[] objects) {
            StringBuilder output = new StringBuilder(2 + objects.length * 4);
            output.append('[');
            for (int i = 0; i < objects.length; ++i) {
                output.append(objects[i]);
                if (i >= objects.length - 1) continue;
                output.append(',');
            }
            output.append(']');
            return output.toString();
        }

        private String getByteArrayData(byte[] objects) {
            StringBuilder output = new StringBuilder(2 + objects.length * 4);
            output.append('[');
            for (int i = 0; i < objects.length; ++i) {
                output.append(objects[i]);
                if (i >= objects.length - 1) continue;
                output.append(',');
            }
            output.append(']');
            return output.toString();
        }

        private String getShortArrayData(short[] objects) {
            StringBuilder output = new StringBuilder(objects.length * 6);
            output.append('[');
            for (int i = 0; i < objects.length; ++i) {
                output.append(objects[i]);
                if (i >= objects.length - 1) continue;
                output.append(',');
            }
            output.append(']');
            return output.toString();
        }

        private String getIntArrayData(int[] objects) {
            StringBuilder output = new StringBuilder(objects.length * 12);
            output.append('[');
            for (int i = 0; i < objects.length; ++i) {
                output.append(objects[i]);
                if (i >= objects.length - 1) continue;
                output.append(',');
            }
            output.append(']');
            return output.toString();
        }

        private String getFloatArrayData(float[] objects) {
            StringBuilder output = new StringBuilder(objects.length * 15);
            output.append('[');
            for (int i = 0; i < objects.length; ++i) {
                output.append(objects[i]);
                if (i >= objects.length - 1) continue;
                output.append(',');
            }
            output.append(']');
            return output.toString();
        }

        private String getDoubleArrayData(double[] objects) {
            StringBuilder output = new StringBuilder(objects.length * 20);
            output.append('[');
            for (int i = 0; i < objects.length; ++i) {
                output.append(objects[i]);
                if (i >= objects.length - 1) continue;
                output.append(',');
            }
            output.append(']');
            return output.toString();
        }

        private String getLongArrayData(long[] objects) {
            StringBuilder output = new StringBuilder(objects.length * 20);
            output.append('[');
            for (int i = 0; i < objects.length; ++i) {
                output.append(objects[i]);
                if (i >= objects.length - 1) continue;
                output.append(',');
            }
            output.append(']');
            return output.toString();
        }
    }
}

