/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.format;

import com.ibm.jvm.format.InvalidSpannedRecordException;
import com.ibm.jvm.format.TraceFile;
import com.ibm.jvm.format.TraceRecord;
import com.ibm.jvm.format.Util;
import java.io.IOException;

public final class TraceRecordExternal
extends TraceRecord {
    protected byte[] spannedEntrySoFar;
    protected byte[] spanEntry;
    private int spannedEntrySizeSoFar = 0;

    protected TraceRecordExternal(TraceFile traceFile, int start) throws IOException {
        super(traceFile, start);
    }

    protected void prime() throws IOException {
        this.buffer = new byte[this.bufferSize - this.headerSize + this.spannedEntrySizeSoFar];
        byte longEntryID = 0;
        int longEntryLength = 0;
        int entry = (int)(this.nextEntry - (long)this.headerSize + (long)this.spannedEntrySizeSoFar);
        if (this.spannedEntrySizeSoFar > 0) {
            System.arraycopy((Object)this.spannedEntrySoFar, 0, (Object)this.buffer, 0, this.spannedEntrySizeSoFar);
        }
        this.traceFile.seek(this.start + this.headerSize);
        this.traceFile.read(this.buffer, this.spannedEntrySizeSoFar, this.bufferSize - this.headerSize);
        Util.Debug.println(" ");
        Util.Debug.println("TraceRecord: reading buffer size=:        " + this.bufferSize);
        Util.Debug.println("TraceRecord: nextEntry        :           " + (int)this.nextEntry);
        if (this.nextEntry < 0L) {
            Util.Debug.println("TraceRecord: entry spans entire record");
            this.copySpannedEntryForNextRecord(this.buffer, 0, this.bufferSize - this.headerSize + this.spannedEntrySizeSoFar);
            return;
        }
        Util.Debug.println("TraceRecord: buffer[nextEntry]:           " + this.buffer[entry]);
        this.copySpannedEntryForNextRecord(this.buffer, entry, this.bufferSize - this.headerSize + this.spannedEntrySizeSoFar);
        int entryLength = Util.constructUnsignedByte(this.buffer, entry);
        while (entry != 0) {
            if ((entry -= entryLength) < 0) {
                Util.Debug.println("entry < 0 must be a partial entry in first record");
                Util.Debug.println("spannedEntrySizeSoFar " + this.spannedEntrySizeSoFar);
                if (this.spannedEntrySizeSoFar != 0) {
                    throw new InvalidSpannedRecordException("Invalid spanned trace record");
                }
                entry += entryLength;
                break;
            }
            if (entryLength == 8 && entry != 0 && this.buffer[entry + 3] == 0 && this.buffer[entry + 2] == 0 && this.buffer[entry + 1] == 0) {
                this.wrapTimes.push(this.upperWord);
                this.upperWord = Util.constructUnsignedLong(this.buffer, entry + 4, 4);
                Util.Debug.println("TraceBuffer: timewrap entry =" + entry + " upperWord=" + this.upperWord);
            }
            if (entryLength == 4 && this.buffer[entry + 2] == 0 && this.buffer[entry + 1] == 0) {
                Util.Debug.println("Entry with data length > 256");
                longEntryID = this.buffer[entry + 3];
                longEntryLength = Util.constructUnsignedByte(this.buffer, entry);
                if (entry - (longEntryLength + longEntryID * 256) < 0) {
                    Util.Debug.println("entry < 0 must be a partial entry in first record");
                    Util.Debug.println("spannedEntrySizeSoFar " + this.spannedEntrySizeSoFar);
                    if (this.spannedEntrySizeSoFar != 0) {
                        throw new InvalidSpannedRecordException("Invalid spanned trace record");
                    }
                    entry += entryLength;
                    break;
                }
                this.buffer[entry] = (byte)entryLength;
                this.longEntryTraceIDs.push(new Integer(Util.constructTraceID(this.buffer, (entry -= longEntryLength + longEntryID * 256) + 1)));
                this.buffer[entry + 1] = 0;
                this.buffer[entry + 2] = 0;
                this.buffer[entry + 3] = longEntryID;
                entryLength = longEntryLength;
            }
            if (entryLength == 0) {
                if (longEntryID == 0) {
                    Util.Debug.println("TraceRecord: Hit 0 length entry");
                    break;
                }
                Util.Debug.println("TraceRecord: 0 length entry (long record length is exact multiple of 256)");
            }
            int temp = Util.constructUnsignedByte(this.buffer, entry);
            this.buffer[entry] = (byte)entryLength;
            entryLength = temp;
        }
        if (this.buffer[entry] == 8 && this.buffer[entry + 1] == 0 && this.buffer[entry + 2] == 0 && this.buffer[entry + 3] == 0) {
            entry += 8;
            Util.Debug.println("TraceBuffer: ignoring time wrap at offset 0");
        }
        this.offset = entry;
        this.currentTimeStamp = this.upperWord.shiftLeft(32).or(Util.constructUnsignedLong(this.buffer, entry + 4, 4));
        Util.Debug.println("TraceRecord: oldest offset for thread " + this.threadID + " = " + this.offset + " timeStamp = " + this.currentTimeStamp);
    }

    protected int getNextEntry() throws IOException {
        int rc;
        if (this.notFormatted) {
            return 1;
        }
        this.notFormatted = true;
        do {
            if (this.nextEntry < 0L || (long)this.offset >= this.nextEntry - (long)this.headerSize + (long)this.spannedEntrySizeSoFar) {
                rc = 0;
                continue;
            }
            rc = this.processNextEntryHeader(this.buffer, this.offset);
            if (this.currentLength >= 256) {
                this.offset += 4;
            }
            this.offset += this.currentLength;
        } while (rc == 2);
        return rc;
    }

    protected final void spanStart(byte[] startofSpanEntry, int startofSpanEntrySize) {
        this.spannedEntrySoFar = startofSpanEntry;
        this.spannedEntrySizeSoFar = startofSpanEntrySize;
    }

    protected final void copySpannedEntryForNextRecord(byte[] buffer, int start, int end) {
        TraceRecordExternal nextTraceRecord = (TraceRecordExternal)this.getNextRecord();
        if (nextTraceRecord == null) {
            return;
        }
        byte[] startofSpanEntry = new byte[end - start];
        System.arraycopy((Object)buffer, start, (Object)startofSpanEntry, 0, end - start);
        nextTraceRecord.spanStart(startofSpanEntry, end - start);
        if (end - start < 8) {
            byte[] next9 = new byte[9];
            System.arraycopy((Object)buffer, start, (Object)next9, 0, end - start);
            System.arraycopy((Object)nextTraceRecord.nextEight, 0, (Object)next9, end - start, 9 - (end - start));
            if (next9[8] == 8 && next9[1] == 0 && next9[2] == 0 && next9[3] == 0) {
                this.upperWord = Util.constructUnsignedLong(next9, 4, 4);
                Util.Debug.println("TraceBuffer: spanned timewrap entry=" + start + " upperWord=" + this.upperWord);
            }
        }
    }
}

