/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.format;

import com.ibm.jvm.format.Message;
import com.ibm.jvm.format.MessageFile;
import com.ibm.jvm.format.TraceArgs;
import com.ibm.jvm.format.TraceFile;
import com.ibm.jvm.format.TraceFileHeader;
import com.ibm.jvm.format.TraceFormat;
import com.ibm.jvm.format.TraceThread;
import com.ibm.jvm.format.Util;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Hashtable;
import java.util.Stack;

public class TraceRecord
implements Comparable {
    protected static Hashtable indentLevels;
    protected static long lastThread;
    protected static final byte EVENT_TYPE = 0;
    protected static final byte EXCEPTION_TYPE = 1;
    protected static final byte ENTRY_TYPE = 2;
    protected static final byte ENTRY_EXCPT_TYPE = 3;
    protected static final byte EXIT_TYPE = 4;
    protected static final byte EXIT_EXCPT_TYPE = 5;
    protected static final byte MEM_TYPE = 6;
    protected static final byte MEM_EXCPT_TYPE = 7;
    protected static final byte DEBUG_TYPE = 8;
    protected static final byte DEBUG_EXCPT_TYPE = 9;
    protected static final byte PERF_TYPE = 10;
    protected static final byte PERF_EXCPT_TYPE = 11;
    protected static final byte ASSERT_TYPE = 12;
    protected static final byte APP_TYPE = 13;
    protected static final byte ERROR_TYPE = 14;
    protected static final String[] Chars;
    protected static final String[] types;
    protected static final StringBuffer BASE_INDENT;
    protected static final String TAB = " ";
    protected static final int TRACEID_OFFSET = 1;
    protected static final int TIMESTAMP_OFFSET = 4;
    protected byte[] buffer = null;
    protected byte[] nextEight = new byte[8];
    protected BigInteger timeStamp;
    protected BigInteger wrapTime;
    protected BigInteger writePlatform = BigInteger.ZERO;
    protected BigInteger writeSystem = BigInteger.ZERO;
    protected long threadID = 0L;
    protected long threadSyn1 = 0L;
    protected long threadSyn2 = 0L;
    protected String threadName;
    protected long nextEntry;
    private String padding;
    private boolean doIndent;
    private String threadIDString;
    protected boolean recordFinished = false;
    protected TraceThread traceThread = null;
    protected TraceFile traceFile;
    protected int bufferSize;
    protected int start;
    protected int offset;
    protected byte[] currentBuffer;
    protected int currentOffset;
    protected int currentTraceID;
    protected int currentLength;
    protected BigInteger currentTimeStamp;
    private Message currentMessage;
    private int currentType;
    private String currentComponent;
    protected BigInteger upperWord = BigInteger.ZERO;
    protected Stack wrapTimes = new Stack();
    protected Stack longEntryTraceIDs = new Stack();
    protected boolean notFormatted = false;
    private int lastErrorRecord = -1;
    protected int headerSize = 72;

    protected TraceRecord(TraceFile traceFile, int start) throws IOException {
        traceFile.seek(start);
        this.timeStamp = traceFile.readBigInteger(8);
        this.wrapTime = traceFile.readBigInteger(8);
        this.writePlatform = traceFile.readBigInteger(8);
        this.writeSystem = traceFile.readBigInteger(8);
        this.threadID = traceFile.readL();
        if (TraceFileHeader.isUTE()) {
            this.threadSyn1 = traceFile.readL();
            this.threadSyn2 = traceFile.readL();
            this.headerSize = traceFile.readI();
            this.nextEntry = traceFile.readI();
            this.threadName = traceFile.readString(this.headerSize - 64);
        } else {
            this.threadName = traceFile.readString(28);
            this.nextEntry = traceFile.readI();
        }
        traceFile.read(this.nextEight, 0, 8);
        this.upperWord = this.timeStamp.shiftRight(32);
        this.wrapTimes.push(this.upperWord);
        this.threadIDString = Util.formatAsHexString(this.threadID);
        Util.Debug.println("reading timeStamp     " + this.timeStamp);
        Util.Debug.println("reading wrapTime      " + this.wrapTime);
        Util.Debug.println("reading writePlatform " + this.writePlatform);
        Util.Debug.println("reading writeSystem   " + this.writeSystem);
        this.bufferSize = traceFile.traceFileHeader.getBufferSize();
        this.traceFile = traceFile;
        this.start = start;
        this.currentTimeStamp = this.timeStamp;
        if (this.nextEntry >= 0L && (this.nextEntry < (long)this.headerSize || this.nextEntry > (long)this.bufferSize)) {
            Util.Debug.println("Invalid Buffer - nextEntry = " + this.nextEntry + ", headerSize = " + this.headerSize + ", bufferSize = " + this.bufferSize);
            ++TraceFormat.invalidBuffers;
            return;
        }
        if (this.writePlatform.compareTo(TraceFormat.lastWritePlatform) > 0) {
            Util.Debug.println("updating lastWritePlatform" + this.writePlatform);
            Util.Debug.println("updating lastWriteSystem  " + this.writeSystem);
            TraceFormat.lastWritePlatform = this.writePlatform;
            TraceFormat.lastWriteSystem = this.writeSystem;
        }
        if (this.wrapTime.compareTo(TraceFormat.first) < 0) {
            TraceFormat.first = this.wrapTime;
        }
        if (this.timeStamp.compareTo(TraceFormat.last) > 0) {
            TraceFormat.last = this.timeStamp;
        }
        this.padding = Integer.valueOf(Util.getProperty("POINTER_SIZE")) == 4 ? "00000000" : "0000000000000000";
        this.doIndent = TraceArgs.indent;
        Util.Debug.println("*********************************************************");
        Util.Debug.println("TraceBufferHeader: timeStamp : 0x" + this.timeStamp.toString(16));
        Util.Debug.println("TraceBufferHeader: threadID  : 0x" + Long.toString(this.threadID, 16));
        Util.Debug.println("TraceBufferHeader: threadName: " + this.threadName + "\n");
        Util.Debug.println("TraceBufferHeader: nextEntry : " + this.nextEntry);
        Util.Debug.println("*********************************************************");
        boolean foundThreadID = false;
        Util.Debug.println("Processing Record Header");
        foundThreadID = false;
        if (!Util.findThreadID(new Long(this.threadID))) {
            return;
        }
        for (TraceThread this.traceThread : TraceFormat.threads) {
            if (this.threadID != this.traceThread.threadID || !this.threadName.equals(this.traceThread.threadName)) continue;
            foundThreadID = true;
            Util.Debug.println("Found existing threadID " + this.threadID);
            break;
        }
        if (!foundThreadID) {
            this.traceThread = new TraceThread(this.threadID, this.threadName);
            TraceFormat.threads.addElement(this.traceThread);
        }
        this.traceThread.addElement(this);
    }

    protected static final void initStatics() {
        indentLevels = null;
        lastThread = 0L;
    }

    protected final BigInteger getCurrentTimeStamp() {
        return this.currentTimeStamp;
    }

    protected final TraceRecord getNextRecord() {
        int next = this.traceThread.indexOf(this) + 1;
        if (next >= this.traceThread.size()) {
            return null;
        }
        BigInteger thisTimeStamp = ((TraceRecord)this.traceThread.elementAt((int)(next - 1))).timeStamp;
        BigInteger nextTimeStamp = ((TraceRecord)this.traceThread.elementAt((int)next)).timeStamp;
        if (thisTimeStamp.equals(nextTimeStamp)) {
            if (this.lastErrorRecord != next) {
                this.lastErrorRecord = next;
                TraceFormat.outStream.println("\nWARNING: duplicate trace record discarded (record " + (next + 1) + " for thread " + Util.formatAsHexString(this.threadID) + ")");
                --TraceFormat.expectedRecords;
            }
            if (next + 1 >= this.traceThread.size()) {
                return null;
            }
            return (TraceRecord)this.traceThread.elementAt(next + 1);
        }
        return (TraceRecord)this.traceThread.elementAt(next);
    }

    protected final int processNextEntryHeader(byte[] entry, int start) throws IOException {
        this.currentLength = Util.constructUnsignedByte(entry, start);
        this.currentTraceID = Util.constructTraceID(entry, start + 1);
        if (this.currentTraceID == 0) {
            if (this.currentLength == 8) {
                this.upperWord = (BigInteger)this.wrapTimes.pop();
                Util.Debug.println("TraceRecord: timewrap new upperWord=" + this.upperWord);
            }
            return 2;
        }
        if (this.currentTraceID == 256 && this.currentLength == 8) {
            this.currentTimeStamp = this.wrapTime;
            Util.Debug.println("TraceRecord: lost records");
        } else {
            this.currentTimeStamp = this.upperWord.shiftLeft(32).or(Util.constructUnsignedLong(entry, start + 4, 4));
        }
        if (this.currentTraceID < 256) {
            Util.Debug.println("processing long record: start                   " + start);
            Util.Debug.println("processing long record: previous currentLength  " + this.currentLength);
            Util.Debug.println("processing long record: previous currentTraceID " + this.currentTraceID);
            this.currentLength += this.currentTraceID * 256;
            this.currentTraceID = (Integer)this.longEntryTraceIDs.pop();
            Util.Debug.println("processing long record: currentLength           " + this.currentLength);
            Util.Debug.println("processing long record: currentTraceID          " + this.currentTraceID);
        }
        if ((this.currentMessage = MessageFile.getMessageFromID(this.currentTraceID)) == null) {
            if (TraceFormat.messageFile != null) {
                TraceFormat.messageFile.addMessage("ApplicationTrace");
            }
            if (this.currentLength == 8) {
                Util.Debug.println("TraceRecord: Adding unrecognized event message format for tracepoint: " + this.currentTraceID);
                TraceFormat.messageFile.addMessage(Util.formatAsHexString(this.currentTraceID) + " 1 01 1 N ApplicationTraceEntry \"Unrecognized tracepoint\"");
                this.currentMessage = MessageFile.getMessageFromID(this.currentTraceID);
            } else {
                switch (entry[start + 10]) {
                    case 62: {
                        Util.Debug.println("TraceRecord: Adding entry message format for tracepoint: " + this.currentTraceID);
                        TraceFormat.messageFile.addMessage(Util.formatAsHexString(this.currentTraceID) + " 2 01 1 N ApplicationTraceEntry \"%s\"");
                        this.currentMessage = MessageFile.getMessageFromID(this.currentTraceID);
                        break;
                    }
                    case 60: {
                        int exception = entry[start + 8] == 42 ? 1 : 0;
                        Util.Debug.println("TraceRecord: Adding exit message format for tracepoint: " + this.currentTraceID);
                        TraceFormat.messageFile.addMessage(Util.formatAsHexString(this.currentTraceID) + TAB + (exception + 4) + " 01 1 N ApplicationTraceExit \"%s\"");
                        this.currentMessage = MessageFile.getMessageFromID(this.currentTraceID);
                        break;
                    }
                    case 45: {
                        Util.Debug.println("TraceRecord: Adding event message format for tracepoint: " + this.currentTraceID);
                        TraceFormat.messageFile.addMessage(Util.formatAsHexString(this.currentTraceID) + " 0 01 1 N ApplicationTraceEvent \"%s\"");
                        this.currentMessage = MessageFile.getMessageFromID(this.currentTraceID);
                        break;
                    }
                    case 42: {
                        Util.Debug.println("TraceRecord: Adding exception message format for tracepoint: " + this.currentTraceID);
                        TraceFormat.messageFile.addMessage(Util.formatAsHexString(this.currentTraceID) + " 1 00 0 N ApplicationTraceException \"%s\"");
                        this.currentMessage = MessageFile.getMessageFromID(this.currentTraceID);
                        break;
                    }
                    default: {
                        Util.Debug.println("TraceRecord: message is null ");
                        Util.Debug.println("TraceRecord: currentTraceID  " + this.currentTraceID);
                        Util.Debug.println("TraceRecord: currentLength   " + this.currentLength);
                        Util.Debug.println("TraceRecord: notFormatted    " + this.notFormatted);
                        Util.Debug.println("TraceRecord: start           " + start);
                        Util.printDump(entry, start + this.currentLength);
                        TraceFormat.outStream.println(TAB);
                        TraceFormat.outStream.println("*** Invalid trace entry TraceID=" + Util.formatAsHexString(this.currentTraceID) + " found in Trace Buffer");
                        return 0;
                    }
                }
            }
        }
        this.currentType = this.currentMessage.getType();
        this.currentComponent = this.currentMessage.getComponent();
        this.currentBuffer = entry;
        this.currentOffset = start;
        if (this.currentLength == 0) {
            Util.Debug.println("TraceRecord: currentLength 0 start=" + start);
            Util.printDump(entry, 16);
            TraceFormat.outStream.println("Internal Error");
            throw new IOException();
        }
        if (!Util.findComponentAndType(this.currentComponent.toLowerCase(), types[this.currentType].toLowerCase())) {
            return 2;
        }
        return 1;
    }

    protected final String formatCurrentEntry() throws IOException {
        String entryData;
        boolean threadSwitch = this.threadID != lastThread;
        lastThread = this.threadID;
        StringBuffer indent = TraceRecord.getIndent(this.threadIDString, this.doIndent);
        StringBuffer sBuffer = new StringBuffer(Util.getFormattedTime(this.currentTimeStamp));
        try {
            entryData = this.currentTraceID == 256 ? this.currentMessage.getMessage(this.currentBuffer, this.currentOffset + 4, this.currentOffset + 8) : this.currentMessage.getMessage(this.currentBuffer, this.currentOffset + 8, this.currentOffset + this.currentLength);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            entryData = "*** Invalid data in Trace Entry ***";
        }
        sBuffer.ensureCapacity(100);
        String stringId = Util.formatAsHexString(this.currentTraceID);
        stringId = "        ".substring(stringId.length()) + stringId;
        if ((double)TraceFormat.verMod >= 1.1) {
            sBuffer.append(threadSwitch ? "*" : TAB).append(this.padding.substring(this.threadIDString.length()) + this.threadIDString).append(TAB).append(stringId).append((this.currentType & 1) == 1 ? "*" : TAB).append(types[this.currentType]);
        } else {
            sBuffer.append(threadSwitch ? "*" : TAB).append(this.padding.substring(this.threadIDString.length()) + this.threadIDString).append(TAB).append(stringId).append(this.currentType == 1 ? Chars[this.currentType] : TAB).append(types[this.currentType]);
        }
        if (this.doIndent && (this.currentType == 4 || this.currentType == 5)) {
            indent.delete(0, TAB.length());
            TraceRecord.setIndent(this.threadIDString, indent);
        }
        sBuffer.append(BASE_INDENT.toString()).append(this.doIndent ? indent.toString() : "").append(Chars[this.currentType]).append(TAB).append(entryData);
        if (this.doIndent && (this.currentType == 2 || this.currentType == 3)) {
            indent.append(TAB);
            TraceRecord.setIndent(this.threadIDString, indent);
        }
        this.notFormatted = false;
        return sBuffer.toString();
    }

    protected final void release() {
        this.buffer = null;
        this.currentBuffer = null;
    }

    public final int compareTo(Object other) {
        return this.currentTimeStamp.compareTo(((TraceRecord)other).getCurrentTimeStamp());
    }

    protected static final StringBuffer getIndent(String threadID, boolean doIndent) {
        StringBuffer sb;
        if (!doIndent) {
            return BASE_INDENT;
        }
        if (indentLevels == null) {
            indentLevels = new Hashtable();
        }
        return (sb = (StringBuffer)indentLevels.get(threadID)) == null ? new StringBuffer() : sb;
    }

    protected static final void setIndent(String threadID, StringBuffer buffer) {
        if (indentLevels == null) {
            indentLevels = new Hashtable();
        }
        indentLevels.remove(threadID);
        indentLevels.put(threadID, buffer);
    }

    protected void prime() throws IOException {
    }

    protected int getNextEntry() throws IOException {
        return 0;
    }

    static {
        Chars = new String[]{"-", ">", ">", "<", "<", TAB, TAB, TAB, TAB, TAB, TAB, "*", TAB, "E"};
        types = new String[]{"Event     ", "Exception ", "Entry     ", "Entry     ", "Exit      ", "Exit      ", "Mem       ", "Mem       ", "Debug     ", "Debug     ", "Perf      ", "Perf      ", "Assert    ", "AppTrace  ", "ERROR     "};
        BASE_INDENT = new StringBuffer();
    }
}

