/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.format;

import com.ibm.jvm.format.TraceFileHeader;
import com.ibm.jvm.format.Util;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigInteger;

public final class TraceFile
extends RandomAccessFile {
    private boolean bigendian = true;
    protected TraceFileHeader traceFileHeader;
    private String filespec;

    public TraceFile(String filespec, String mode) throws Exception {
        super(filespec, mode);
        this.filespec = filespec;
        this.traceFileHeader = new TraceFileHeader(this);
    }

    protected final int readI() throws IOException {
        int temp = this.readInt();
        return this.bigendian ? temp : Util.convertEndian(temp);
    }

    protected final long readL() throws IOException {
        long temp = this.readLong();
        long temp1 = temp >>> 56 | temp << 56 | temp >> 40 & 0xFF00L | temp >> 24 & 0xFF0000L | temp >> 8 & 0xFF000000L | temp << 8 & 0xFF00000000L | temp << 24 & 0xFF0000000000L | temp << 40 & 0xFF000000000000L;
        return this.bigendian ? temp : temp1;
    }

    protected final BigInteger readBigInteger(int size) throws IOException {
        byte[] bytes = new byte[size];
        this.read(bytes);
        if (!this.bigendian) {
            TraceFile.reverseByteOrder(bytes);
        }
        return new BigInteger(1, bytes);
    }

    private static final void reverseByteOrder(byte[] data) {
        for (int i = 0; i < data.length / 2; ++i) {
            byte temp = data[i];
            data[i] = data[data.length - 1 - i];
            data[data.length - 1 - i] = temp;
        }
    }

    protected final long readULong() throws IOException {
        long temp = this.readLong();
        long temp1 = temp >>> 56 | temp << 56 | temp >> 40 & 0xFF00L | temp >> 24 & 0xFF0000L | temp >> 8 & 0xFF000000L | temp << 8 & 0xFF00000000L | temp << 24 & 0xFF0000000000L | temp << 40 & 0xFF000000000000L;
        return this.bigendian ? temp : temp1;
    }

    protected final String readString(int Length) throws IOException {
        int endOfString;
        byte[] buffer = new byte[Length];
        this.read(buffer, 0, Length);
        for (endOfString = 0; endOfString < Length && buffer[endOfString] != 0; ++endOfString) {
        }
        return new String(buffer, 0, endOfString, "8859_1");
    }

    protected final void setBigEndian(boolean endian) {
        this.bigendian = endian;
    }

    protected final String formatFileName() {
        return this.traceFileHeader.formatFileName();
    }

    protected final String getVMLevel() {
        return this.traceFileHeader.getVMLevel();
    }

    protected final String getNextFormatFileName(String previous) {
        return this.traceFileHeader.getNextFormatFileName(previous);
    }

    public final String toString() {
        return this.filespec;
    }

    public final TraceFileHeader getHeader() {
        return this.traceFileHeader;
    }
}

