/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import org.apache.harmony.logging.internal.nls.Messages;

public class StreamHandler
extends Handler {
    private OutputStream os;
    private Writer writer;
    private boolean writerNotInitialized;

    public StreamHandler() {
        this.initProperties("INFO", null, "java.util.logging.SimpleFormatter", null);
        this.os = null;
        this.writer = null;
        this.writerNotInitialized = true;
    }

    StreamHandler(OutputStream outputStream) {
        this();
        this.os = outputStream;
    }

    StreamHandler(String string, String string2, String string3, String string4) {
        this.initProperties(string, string2, string3, string4);
        this.os = null;
        this.writer = null;
        this.writerNotInitialized = true;
    }

    public StreamHandler(OutputStream outputStream, Formatter formatter) {
        this();
        if (outputStream == null) {
            throw new NullPointerException(Messages.getString("logging.2"));
        }
        if (formatter == null) {
            throw new NullPointerException(Messages.getString("logging.3"));
        }
        this.os = outputStream;
        this.internalSetFormatter(formatter);
    }

    private void initializeWritter() {
        this.writerNotInitialized = false;
        if (null == this.getEncoding()) {
            this.writer = new OutputStreamWriter(this.os);
        } else {
            try {
                this.writer = new OutputStreamWriter(this.os, this.getEncoding());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        this.write(this.getFormatter().getHead(this));
    }

    private void write(String string) {
        try {
            this.writer.write(string);
        }
        catch (Exception exception) {
            this.getErrorManager().error(Messages.getString("logging.14"), exception, 1);
        }
    }

    void internalSetOutputStream(OutputStream outputStream) {
        this.os = outputStream;
    }

    protected void setOutputStream(OutputStream outputStream) {
        if (null == outputStream) {
            throw new NullPointerException();
        }
        LogManager.getLogManager().checkAccess();
        this.close(true);
        this.writer = null;
        this.os = outputStream;
        this.writerNotInitialized = true;
    }

    @Override
    public void setEncoding(String string) throws SecurityException, UnsupportedEncodingException {
        this.flush();
        super.setEncoding(string);
        if (null != this.writer) {
            if (null == this.getEncoding()) {
                this.writer = new OutputStreamWriter(this.os);
            } else {
                try {
                    this.writer = new OutputStreamWriter(this.os, this.getEncoding());
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new AssertionError((Object)unsupportedEncodingException);
                }
            }
        }
    }

    void close(boolean bl) {
        if (null != this.os) {
            if (this.writerNotInitialized) {
                this.initializeWritter();
            }
            this.write(this.getFormatter().getTail(this));
            try {
                this.writer.flush();
                if (bl) {
                    this.writer.close();
                    this.writer = null;
                    this.os = null;
                }
            }
            catch (Exception exception) {
                this.getErrorManager().error(Messages.getString("logging.15"), exception, 3);
            }
        }
    }

    @Override
    public void close() {
        LogManager.getLogManager().checkAccess();
        this.close(true);
    }

    @Override
    public void flush() {
        if (null != this.os) {
            try {
                if (null != this.writer) {
                    this.writer.flush();
                } else {
                    this.os.flush();
                }
            }
            catch (Exception exception) {
                this.getErrorManager().error(Messages.getString("logging.16"), exception, 2);
            }
        }
    }

    @Override
    public synchronized void publish(LogRecord logRecord) {
        block5: {
            try {
                if (!this.isLoggable(logRecord)) break block5;
                if (this.writerNotInitialized) {
                    this.initializeWritter();
                }
                String string = null;
                try {
                    string = this.getFormatter().format(logRecord);
                }
                catch (Exception exception) {
                    this.getErrorManager().error(Messages.getString("logging.17"), exception, 5);
                }
                this.write(string);
            }
            catch (Exception exception) {
                this.getErrorManager().error(Messages.getString("logging.18"), exception, 0);
            }
        }
    }

    @Override
    public boolean isLoggable(LogRecord logRecord) {
        if (null == logRecord) {
            return false;
        }
        return null != this.os && super.isLoggable(logRecord);
    }
}

