/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;
import org.apache.harmony.logging.internal.nls.Messages;

public class SocketHandler
extends StreamHandler {
    private static final String DEFAULT_LEVEL = "ALL";
    private static final String DEFAULT_FORMATTER = "java.util.logging.XMLFormatter";
    private Socket socket;

    public SocketHandler() throws IOException {
        super(DEFAULT_LEVEL, null, DEFAULT_FORMATTER, null);
        this.initSocket(LogManager.getLogManager().getProperty("java.util.logging.SocketHandler.host"), LogManager.getLogManager().getProperty("java.util.logging.SocketHandler.port"));
    }

    public SocketHandler(String string, int n) throws IOException {
        super(DEFAULT_LEVEL, null, DEFAULT_FORMATTER, null);
        this.initSocket(string, String.valueOf(n));
    }

    private void initSocket(String string, String string2) throws IOException {
        if (null == string || "".equals(string)) {
            throw new IllegalArgumentException(Messages.getString("logging.C"));
        }
        int n = 0;
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(Messages.getString("logging.D"));
        }
        if (n <= 0) {
            throw new IllegalArgumentException(Messages.getString("logging.D"));
        }
        try {
            this.socket = new Socket(string, n);
        }
        catch (IOException iOException) {
            this.getErrorManager().error(Messages.getString("logging.E"), iOException, 4);
            throw iOException;
        }
        super.internalSetOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
    }

    @Override
    public void close() {
        try {
            super.close();
            if (null != this.socket) {
                this.socket.close();
                this.socket = null;
            }
        }
        catch (Exception exception) {
            this.getErrorManager().error(Messages.getString("logging.F"), exception, 3);
        }
    }

    @Override
    public void publish(LogRecord logRecord) {
        super.publish(logRecord);
        super.flush();
    }
}

