/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.LoggingMXBean;
import java.util.logging.LoggingPermission;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.apache.harmony.logging.internal.nls.Messages;

public class LogManager {
    private static final String lineSeparator = LogManager.getPrivilegedSystemProperty("line.separator");
    private static final LoggingPermission perm = new LoggingPermission("control", null);
    static LogManager manager;
    public static final String LOGGING_MXBEAN_NAME = "java.util.logging:type=Logging";
    private Hashtable<String, Logger> loggers = new Hashtable();
    private Properties props = new Properties();
    private PropertyChangeSupport listeners = new PropertyChangeSupport(this);

    public static LoggingMXBean getLoggingMXBean() {
        try {
            final ObjectName objectName = new ObjectName(LOGGING_MXBEAN_NAME);
            Set set = AccessController.doPrivileged(new PrivilegedAction<Set>(){

                @Override
                public Set run() {
                    MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
                    return mBeanServer.queryMBeans(objectName, null);
                }
            });
            if (set.size() != 1) {
                throw new AssertionError((Object)Messages.getString("logging.21"));
            }
            Iterator iterator = set.iterator();
            ObjectInstance objectInstance = (ObjectInstance)iterator.next();
            String string = objectInstance.getClassName();
            Class<?> clazz = Class.forName(string);
            final Method method = clazz.getDeclaredMethod("getInstance", new Class[0]);
            AccessController.doPrivileged(new PrivilegedAction<Set>(){

                @Override
                public Set run() {
                    method.setAccessible(true);
                    return null;
                }
            });
            LoggingMXBean loggingMXBean = (LoggingMXBean)method.invoke(null, new Object[0]);
            return loggingMXBean;
        }
        catch (Exception exception) {
            throw new AssertionError((Object)Messages.getString("logging.22"));
        }
    }

    protected LogManager() {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                try {
                    Runtime.getRuntime().addShutdownHook(new Thread(){

                        @Override
                        public void run() {
                            LogManager.this.reset();
                        }
                    });
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    static String getSystemLineSeparator() {
        return lineSeparator;
    }

    public void checkAccess() {
        if (null != System.getSecurityManager()) {
            System.getSecurityManager().checkPermission(perm);
        }
    }

    public synchronized boolean addLogger(Logger logger) {
        String string = logger.getName();
        if (null != this.loggers.get(string)) {
            return false;
        }
        this.addToFamilyTree(logger, string);
        this.loggers.put(string, logger);
        logger.setManager(this);
        return true;
    }

    private void addToFamilyTree(Logger logger, String string) {
        String string2;
        int n;
        Logger logger2 = null;
        String string3 = string;
        while ((n = string3.lastIndexOf(46)) != -1) {
            logger2 = this.loggers.get(string3 = string3.substring(0, n));
            if (logger2 != null) {
                logger.internalSetParent(logger2);
                break;
            }
            if (this.getProperty(string3 + ".level") == null && this.getProperty(string3 + ".handlers") == null) continue;
            logger2 = Logger.getLogger(string3);
            logger.internalSetParent(logger2);
            break;
        }
        if (logger2 == null && null != (logger2 = this.loggers.get(""))) {
            logger.internalSetParent(logger2);
        }
        boolean bl = string.length() == 0;
        final Logger logger3 = logger;
        String string4 = string2 = bl ? "" : string + '.';
        if (logger2 == null) {
            final Collection<Logger> collection = this.loggers.values();
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    for (Logger logger : collection) {
                        if (null != logger.getParent() || !logger.getName().startsWith(string2)) continue;
                        logger.setParent(logger3);
                    }
                    return null;
                }
            });
        } else {
            final List<Logger> list = logger2.childs;
            final Logger logger4 = logger2;
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    LinkedList<Logger> linkedList = new LinkedList<Logger>();
                    for (Logger logger : list) {
                        String string = logger.getName();
                        if (string == null || !string.startsWith(string2)) continue;
                        logger.setParent(logger3);
                        linkedList.add(logger);
                    }
                    logger4.childs.removeAll(linkedList);
                    return null;
                }
            });
        }
    }

    public synchronized Logger getLogger(String string) {
        return this.loggers.get(string);
    }

    public synchronized Enumeration<String> getLoggerNames() {
        return this.loggers.keys();
    }

    public static LogManager getLogManager() {
        return manager;
    }

    public String getProperty(String string) {
        return this.props.getProperty(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readConfiguration() throws IOException {
        this.checkAccess();
        String string = System.getProperty("java.util.logging.config.class");
        if (null == string || null == LogManager.getInstanceByClass(string)) {
            String string2 = System.getProperty("java.util.logging.config.file");
            if (null == string2) {
                string2 = System.getProperty("java.home") + File.separator + "lib" + File.separator + "logging.properties";
            }
            InputStream inputStream = null;
            try {
                inputStream = new BufferedInputStream(new FileInputStream(string2));
                this.readConfigurationImpl(inputStream);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    static String getPrivilegedSystemProperty(final String string) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(string);
            }
        });
    }

    static Object getInstanceByClass(String string) {
        try {
            Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass(string);
            return clazz.newInstance();
        }
        catch (Exception exception) {
            try {
                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(string);
                return clazz.newInstance();
            }
            catch (Exception exception2) {
                System.err.println(Messages.getString("logging.20", string));
                System.err.println(exception2);
                return null;
            }
        }
    }

    private synchronized void readConfigurationImpl(InputStream inputStream) throws IOException {
        Object object;
        Object object2;
        this.reset();
        this.props.load(inputStream);
        String string = this.props.getProperty("config");
        if (null != string) {
            object2 = new StringTokenizer(string, " ");
            while (((StringTokenizer)object2).hasMoreTokens()) {
                object = ((StringTokenizer)object2).nextToken();
                LogManager.getInstanceByClass((String)object);
            }
        }
        object2 = this.loggers.values();
        object = object2.iterator();
        while (object.hasNext()) {
            Logger logger = object.next();
            String string2 = this.props.getProperty(logger.getName() + ".level");
            if (null == string2) continue;
            logger.setLevel(Level.parse(string2));
        }
        this.listeners.firePropertyChange(null, null, null);
    }

    public void readConfiguration(InputStream inputStream) throws IOException {
        this.checkAccess();
        this.readConfigurationImpl(inputStream);
    }

    public void reset() {
        Object object;
        this.checkAccess();
        this.props = new Properties();
        Enumeration<String> enumeration = this.getLoggerNames();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            Logger logger = this.getLogger((String)object);
            if (logger == null) continue;
            logger.reset();
        }
        object = this.loggers.get("");
        if (null != object) {
            ((Logger)object).setLevel(Level.INFO);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException();
        }
        this.checkAccess();
        this.listeners.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.checkAccess();
        this.listeners.removePropertyChangeListener(propertyChangeListener);
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                String string = System.getProperty("java.util.logging.manager");
                if (null != string) {
                    manager = (LogManager)LogManager.getInstanceByClass(string);
                }
                if (null == manager) {
                    manager = new LogManager();
                }
                try {
                    manager.readConfiguration();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                Logger logger = new Logger("", null);
                logger.setLevel(Level.INFO);
                Logger.global.setParent(logger);
                manager.addLogger(logger);
                manager.addLogger(Logger.global);
                return null;
            }
        });
    }
}

