/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.harmony.kernel.vm.VM;
import org.apache.harmony.logging.internal.nls.Messages;

public class Level
implements Serializable {
    private static final long serialVersionUID = -8176160795706313070L;
    private static final List<Level> levels = new ArrayList<Level>(9);
    public static final Level OFF = new Level("OFF", Integer.MAX_VALUE);
    public static final Level SEVERE = new Level("SEVERE", 1000);
    public static final Level WARNING = new Level("WARNING", 900);
    public static final Level INFO = new Level("INFO", 800);
    public static final Level CONFIG = new Level("CONFIG", 700);
    public static final Level FINE = new Level("FINE", 500);
    public static final Level FINER = new Level("FINER", 400);
    public static final Level FINEST = new Level("FINEST", 300);
    public static final Level ALL = new Level("ALL", Integer.MIN_VALUE);
    private final String name;
    private final int value;
    private final String resourceBundleName;
    private transient ResourceBundle rb;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Level parse(String string) throws IllegalArgumentException {
        boolean bl;
        int n;
        if (string == null) {
            throw new NullPointerException(Messages.getString("logging.1C"));
        }
        try {
            n = Integer.parseInt(string);
            bl = true;
        }
        catch (NumberFormatException numberFormatException) {
            n = 0;
            bl = false;
        }
        List<Level> list = levels;
        synchronized (list) {
            for (Level level : levels) {
                if (!string.equals(level.getName())) continue;
                return level;
            }
            if (bl) {
                for (Level level : levels) {
                    if (n != level.intValue()) continue;
                    return level;
                }
            }
        }
        if (!bl) {
            throw new IllegalArgumentException(Messages.getString("logging.1D", string));
        }
        return new Level(string, n);
    }

    protected Level(String string, int n) {
        this(string, n, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Level(String string, int n, String string2) {
        if (string == null) {
            throw new NullPointerException(Messages.getString("logging.1C"));
        }
        this.name = string;
        this.value = n;
        this.resourceBundleName = string2;
        if (string2 != null) {
            try {
                this.rb = ResourceBundle.getBundle(string2, Locale.getDefault(), VM.callerClassLoader());
            }
            catch (MissingResourceException missingResourceException) {
                this.rb = null;
            }
        }
        List<Level> list = levels;
        synchronized (list) {
            levels.add(this);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getResourceBundleName() {
        return this.resourceBundleName;
    }

    public final int intValue() {
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object readResolve() {
        List<Level> list = levels;
        synchronized (list) {
            for (Level level : levels) {
                if (this.value != level.value || !this.name.equals(level.name)) continue;
                if (this.resourceBundleName == level.resourceBundleName) {
                    return level;
                }
                if (this.resourceBundleName == null || !this.resourceBundleName.equals(level.resourceBundleName)) continue;
                return level;
            }
            levels.add(this);
            return this;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.resourceBundleName != null) {
            try {
                this.rb = ResourceBundle.getBundle(this.resourceBundleName);
            }
            catch (MissingResourceException missingResourceException) {
                this.rb = null;
            }
        }
    }

    public String getLocalizedName() {
        if (this.rb == null) {
            return this.name;
        }
        try {
            return this.rb.getString(this.name);
        }
        catch (MissingResourceException missingResourceException) {
            return this.name;
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Level)) {
            return false;
        }
        return ((Level)object).intValue() == this.value;
    }

    public int hashCode() {
        return this.value;
    }

    public final String toString() {
        return this.name;
    }
}

