/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcp.channel.impl;

import com.ibm.nws.ejs.ras.Tr;
import com.ibm.nws.ejs.ras.TraceComponent;
import com.ibm.ws.tcp.channel.impl.TCPBaseRequestContext;
import com.ibm.ws.tcp.channel.impl.TCPChannel;
import com.ibm.ws.tcp.channel.impl.TCPChannelConfiguration;
import com.ibm.ws.tcp.channel.impl.TCPConnLink;
import com.ibm.ws.tcp.channel.impl.TCPReadRequestContextImpl;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.security.AccessController;
import java.security.PrivilegedAction;

public abstract class SocketIOChannel {
    private static final TraceComponent tc = Tr.register(SocketIOChannel.class, "TCPChannel", "com.ibm.ws.tcp.channel.resources.tcpchannelmessages");
    protected Socket socket;
    protected SocketChannel channel = null;
    private OutputStream output = null;
    private InputStream input = null;
    protected boolean closed = false;
    protected boolean processClose = true;
    protected TCPChannel tcpChannel = null;
    protected TCPChannelConfiguration cc = null;
    protected boolean checkCancel = false;
    protected boolean blockingChannel = false;
    protected static final int ATTEMPT_COMPLETE = 1;
    protected static final int ATTEMPT_NOT_COMPLETE = 0;
    protected static final int ATTEMPT_FAILED_IO_LESS_THAN_ZERO = -1;

    protected SocketIOChannel(Socket socket, TCPChannel tCPChannel) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "SocketIOChannel");
        }
        this.socket = socket;
        this.tcpChannel = tCPChannel;
        this.cc = this.tcpChannel.getConfig();
        this.tcpChannel.incrementConnectionCount();
        if (this.cc.getBlockingChannel() == 0) {
            this.channel = socket.getChannel();
            this.blockingChannel = false;
        } else {
            this.blockingChannel = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "SocketIOChannel");
        }
    }

    protected void initStreams() throws IOException {
        this.output = this.socket.getOutputStream();
        this.input = this.socket.getInputStream();
    }

    protected boolean connect(InetSocketAddress inetSocketAddress) throws IOException {
        if (!this.blockingChannel) {
            this.channel.configureBlocking(false);
        }
        StartPrivilegedThread startPrivilegedThread = new StartPrivilegedThread(this.channel, inetSocketAddress);
        ConnectReturn connectReturn = (ConnectReturn)AccessController.doPrivileged(startPrivilegedThread);
        if (connectReturn.ioe != null) {
            throw connectReturn.ioe;
        }
        return connectReturn.isConnected;
    }

    protected int writeStream(ByteBuffer[] byteBufferArray, int n) throws IOException {
        int n2 = -1;
        int n3 = -1;
        int n4 = 0;
        boolean bl = true;
        boolean bl2 = true;
        int n5 = 0;
        int n6 = 256;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0x100000;
        for (int i = 0; i < byteBufferArray.length; ++i) {
            bl2 = byteBufferArray[i].hasArray();
            n5 = byteBufferArray[i].remaining();
            if ((bl && !bl2 || bl2 && n5 <= n6) && n4 + n5 < n9) {
                if (n4 == 0) {
                    n2 = i;
                }
                n3 = i;
                n4 += n5;
                if (bl2) {
                    bl = false;
                }
                if (i != byteBufferArray.length - 1) continue;
                n7 = this.writeGroup(byteBufferArray, n2, n3, n4, bl);
                n8 += n7;
                n4 = 0;
                bl = true;
                continue;
            }
            if (n4 > 0) {
                n7 = this.writeGroup(byteBufferArray, n2, n3, n4, bl);
                n8 += n7;
                n4 = 0;
                bl = true;
            }
            if (i == byteBufferArray.length - 1 || bl2 && n5 > n6 || n5 >= n9) {
                n7 = this.writeGroup(byteBufferArray, i, i, n5, !bl2);
                n8 += n7;
                continue;
            }
            n2 = i;
            n3 = i;
            n4 = n5;
            if (!bl2) continue;
            bl = false;
        }
        return n8;
    }

    protected int writeGroup(ByteBuffer[] byteBufferArray, int n, int n2, int n3, boolean bl) throws IOException {
        int n4;
        int n5;
        byte[] byArray = null;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        if (n == n2) {
            return this.writeStream(byteBufferArray[n], n3);
        }
        byArray = new byte[n3];
        for (n5 = n; n5 <= n2; ++n5) {
            n8 = byteBufferArray[n5].remaining();
            if (n7 + n8 > n3) {
                n8 = n3 - n7;
            }
            n6 = byteBufferArray[n5].position();
            if (byteBufferArray[n5].hasArray()) {
                n4 = n6 + byteBufferArray[n5].arrayOffset();
                System.arraycopy((Object)byteBufferArray[n5].array(), n4, (Object)byArray, n7, n8);
            } else {
                byteBufferArray[n5].get(byArray, n7, n8);
            }
            byteBufferArray[n5].position(n6);
            n7 += n8;
        }
        n5 = this.writeStream(byArray, 0, n3);
        for (n4 = n; n4 <= n2; ++n4) {
            byteBufferArray[n4].position(byteBufferArray[n4].limit());
        }
        return n5;
    }

    protected int writeStream(ByteBuffer byteBuffer, int n) throws IOException {
        byte[] byArray = null;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        n2 = byteBuffer.position();
        n4 = byteBuffer.limit();
        int n5 = n4 - n2;
        if (byteBuffer.hasArray()) {
            byArray = byteBuffer.array();
            n3 = byteBuffer.arrayOffset() + n2;
        } else {
            byArray = new byte[n5];
            byteBuffer.get(byArray, 0, n5);
            byteBuffer.position(n2);
            n3 = 0;
        }
        int n6 = this.writeStream(byArray, n3, n5);
        byteBuffer.position(n4);
        return n6;
    }

    protected int writeStream(byte[] byArray, int n, int n2) throws IOException {
        if (this.output == null) {
            throw new IOException("no output stream found for this socket");
        }
        this.output.write(byArray, n, n2);
        return n2;
    }

    protected int readStream(ByteBuffer[] byteBufferArray, int n) throws IOException {
        int n2 = -1;
        int n3 = -1;
        int n4 = 0;
        boolean bl = true;
        boolean bl2 = true;
        int n5 = 0;
        int n6 = 256;
        int n7 = n;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0x100000;
        if (n == 0 && (n = this.input.available()) == 0) {
            return 0;
        }
        for (int i = 0; i < byteBufferArray.length && n7 > 0; ++i) {
            bl2 = byteBufferArray[i].hasArray();
            n5 = byteBufferArray[i].remaining();
            if ((bl && !bl2 || bl2 && n5 <= n6) && n4 + n5 < n11) {
                if (n4 == 0) {
                    n2 = i;
                }
                n3 = i;
                n4 += n5;
                if (bl2) {
                    bl = false;
                }
                if (i != byteBufferArray.length - 1 && n4 + n9 < n) continue;
                n10 = n7 < n4 ? n7 : n4;
                n8 = this.readGroup(byteBufferArray, n2, n3, n10, n4, bl);
                n7 -= n8;
                n9 += n8;
                n4 = 0;
                bl = true;
                continue;
            }
            if (n4 > 0) {
                n10 = n7 < n4 ? n7 : n4;
                n8 = this.readGroup(byteBufferArray, n2, n3, n10, n4, bl);
                n7 -= n8;
                n9 += n8;
                n4 = 0;
                bl = true;
            }
            if (i == byteBufferArray.length - 1 || n5 + n9 >= n || bl2 && n5 > n6 || n5 > n11) {
                n10 = n7 < n5 ? n7 : n5;
                n8 = this.readGroup(byteBufferArray, i, i, n10, n5, !bl2);
                n7 -= n8;
                n9 += n8;
                continue;
            }
            n2 = i;
            n3 = i;
            n4 = n5;
            if (!bl2) continue;
            bl = false;
        }
        return n9;
    }

    protected int readGroup(ByteBuffer[] byteBufferArray, int n, int n2, int n3, int n4, boolean bl) throws IOException {
        byte[] byArray = null;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        if (n == n2) {
            return this.readStream(byteBufferArray[n], n3);
        }
        byArray = new byte[n4];
        n7 = this.readStream(byArray, 0, n3, n4);
        for (int i = n; i <= n2; ++i) {
            n6 = byteBufferArray[i].remaining();
            if (n5 + n6 > n7) {
                n6 = n7 - n5;
            }
            if (byteBufferArray[i].hasArray()) {
                int n8 = byteBufferArray[i].position() + byteBufferArray[i].arrayOffset();
                System.arraycopy((Object)byArray, n5, (Object)byteBufferArray[i].array(), n8, n6);
            } else {
                byteBufferArray[i].put(byArray, n5, n6);
            }
            if ((n5 += n6) == n7) break;
        }
        return n7;
    }

    protected int readStream(ByteBuffer byteBuffer, int n) throws IOException {
        int n2;
        byte[] byArray = null;
        int n3 = 0;
        boolean bl = true;
        int n4 = 0;
        if (n == 0 && this.input.available() == 0) {
            return 0;
        }
        n4 = byteBuffer.limit() - byteBuffer.position();
        if (byteBuffer.hasArray()) {
            byArray = byteBuffer.array();
            n3 = byteBuffer.position();
            n2 = byteBuffer.arrayOffset() + n3;
        } else {
            bl = false;
            n2 = 0;
            byArray = new byte[n4];
        }
        int n5 = this.readStream(byArray, n2, n, n4);
        if (bl) {
            byteBuffer.position(n3 + n5);
        } else {
            byteBuffer.put(byArray, 0, n5);
        }
        return n5;
    }

    protected int readStream(byte[] byArray, int n, int n2, int n3) throws IOException {
        int n4 = 0;
        int n5 = 0;
        if (this.input == null) {
            throw new IOException("no input stream found for this socket");
        }
        n5 = this.input.read(byArray, n, n3);
        if (n5 >= n2) {
            return n5;
        }
        n4 = n5;
        do {
            if (n4 != -1) continue;
            throw new IOException("End of input stream reached.");
        } while ((n5 += (n4 = this.input.read(byArray, n + n5, n3 - n5))) < n2);
        return n5;
    }

    protected int attemptReadFromSocket(TCPBaseRequestContext tCPBaseRequestContext, boolean bl) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "attemptReadFromSocket");
        }
        int n = 0;
        TCPReadRequestContextImpl tCPReadRequestContextImpl = (TCPReadRequestContextImpl)tCPBaseRequestContext;
        TCPConnLink tCPConnLink = tCPReadRequestContextImpl.getTCPConnLink();
        long l = 0L;
        if (tCPReadRequestContextImpl.getJITAllocateSize() > 0 && tCPReadRequestContextImpl.getBuffers() == null) {
            if (tCPConnLink.getConfig().getAllocateBuffersDirect() == 1) {
                tCPReadRequestContextImpl.setBuffer(tCPConnLink.getTCPChannel().getWsByteBufferManager().allocateDirect(tCPReadRequestContextImpl.getJITAllocateSize()));
            } else {
                tCPReadRequestContextImpl.setBuffer(tCPConnLink.getTCPChannel().getWsByteBufferManager().allocate(tCPReadRequestContextImpl.getJITAllocateSize()));
            }
            tCPReadRequestContextImpl.setJITAllocateAction(true);
        }
        WsByteBuffer[] wsByteBufferArray = tCPReadRequestContextImpl.getBuffers();
        l = tCPConnLink.getConfig().getBlockingChannel() == 0 ? this.attemptReadFromSocketUsingNIO(tCPReadRequestContextImpl, wsByteBufferArray) : (wsByteBufferArray.length == 1 ? (long)this.readStream(wsByteBufferArray[0].getWrappedByteBufferNonSafe(), (int)tCPReadRequestContextImpl.getIOAmount()) : (long)this.readStream(tCPReadRequestContextImpl.getByteBufferArray(), (int)tCPReadRequestContextImpl.getIOAmount()));
        tCPReadRequestContextImpl.setLastIOAmt(l);
        tCPReadRequestContextImpl.setIODoneAmount(tCPReadRequestContextImpl.getIODoneAmount() + l);
        if (tCPReadRequestContextImpl.getIODoneAmount() >= tCPReadRequestContextImpl.getIOAmount()) {
            n = 1;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "Read " + l + "(" + tCPReadRequestContextImpl.getIODoneAmount() + ")" + " bytes, " + tCPReadRequestContextImpl.getIOAmount() + " requested on local: " + this.getSocket().getLocalSocketAddress() + " remote: " + this.getSocket().getRemoteSocketAddress());
        }
        if (tCPReadRequestContextImpl.getLastIOAmt() < 0L) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled() && !tCPConnLink.getConfig().isInbound()) {
                Tr.event(tc, "Empty read on outbound.  Close connection. local: " + this.getSocket().getLocalSocketAddress() + " remote: " + this.getSocket().getRemoteSocketAddress());
            }
            if (tCPReadRequestContextImpl.getJITAllocateAction()) {
                tCPReadRequestContextImpl.getBuffer().release();
                tCPReadRequestContextImpl.setBuffer(null);
                tCPReadRequestContextImpl.setJITAllocateAction(false);
            }
            return -1;
        }
        if (n == 1) {
            tCPReadRequestContextImpl.setIOCompleteAmount(tCPReadRequestContextImpl.getIODoneAmount());
            tCPReadRequestContextImpl.setIODoneAmount(0L);
        } else if (n == 0 && !bl && tCPReadRequestContextImpl.getJITAllocateAction() && tCPReadRequestContextImpl.getLastIOAmt() == 0L) {
            tCPReadRequestContextImpl.getBuffer().release();
            tCPReadRequestContextImpl.setBuffers(null);
            tCPReadRequestContextImpl.setJITAllocateAction(true);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "attemptReadFromSocket");
        }
        return n;
    }

    protected long attemptReadFromSocketUsingNIO(TCPReadRequestContextImpl tCPReadRequestContextImpl, WsByteBuffer[] wsByteBufferArray) throws IOException {
        throw new IOException("attemptReadFromSocketUsingNIO not overridden");
    }

    protected int attemptWriteToSocket(TCPBaseRequestContext tCPBaseRequestContext) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "attemptWriteToSocket");
        }
        int n = 0;
        TCPConnLink tCPConnLink = tCPBaseRequestContext.getTCPConnLink();
        long l = 0L;
        WsByteBuffer[] wsByteBufferArray = tCPBaseRequestContext.getBuffers();
        if (tCPConnLink.getConfig().getBlockingChannel() == 0) {
            l = this.attemptWriteToSocketUsingNIO(tCPBaseRequestContext, wsByteBufferArray);
        } else if (wsByteBufferArray.length == 1) {
            int n2 = (int)tCPBaseRequestContext.getIOAmount();
            l = this.writeStream(wsByteBufferArray[0].getWrappedByteBufferNonSafe(), n2);
        } else {
            l = this.writeStream(tCPBaseRequestContext.getByteBufferArray(), (int)tCPBaseRequestContext.getIOAmount());
        }
        tCPBaseRequestContext.setLastIOAmt(l);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "Wrote " + l + " bytes, " + tCPBaseRequestContext.getIOAmount() + " requested on local: " + this.getSocket().getLocalSocketAddress() + " remote: " + this.getSocket().getRemoteSocketAddress());
        }
        if (l < 0L) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled() && !tCPConnLink.getConfig().isInbound()) {
                Tr.event(tc, "invalid value returned for bytes written.  Close connection. Local port: " + this.getSocket().getLocalPort());
            }
            return -1;
        }
        if (tCPBaseRequestContext.getIOAmount() == -1L) {
            ByteBuffer[] byteBufferArray = tCPBaseRequestContext.getByteBufferArray();
            n = 1;
            for (int i = 0; i < byteBufferArray.length && n == 1; ++i) {
                if (!byteBufferArray[i].hasRemaining()) continue;
                n = 0;
            }
            tCPBaseRequestContext.setIODoneAmount(tCPBaseRequestContext.getIODoneAmount() + l);
        } else {
            tCPBaseRequestContext.setIODoneAmount(tCPBaseRequestContext.getIODoneAmount() + l);
            if (tCPBaseRequestContext.getIODoneAmount() >= tCPBaseRequestContext.getIOAmount()) {
                n = 1;
            }
        }
        if (n == 1) {
            tCPBaseRequestContext.setIOCompleteAmount(tCPBaseRequestContext.getIODoneAmount());
            tCPBaseRequestContext.setIODoneAmount(0L);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "attemptWriteToSocket, returning " + n);
        }
        return n;
    }

    protected long attemptWriteToSocketUsingNIO(TCPBaseRequestContext tCPBaseRequestContext, WsByteBuffer[] wsByteBufferArray) throws IOException {
        throw new IOException("attemptWriteToSocketUsingNIO not overridden");
    }

    public void close() {
        if (this.blockingChannel) {
            this.closeRegularSocket();
        }
    }

    protected void closeRegularSocket() {
        block4: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "closeRegularSocket");
            }
            try {
                this.socket.close();
                this.output.close();
                this.input.close();
            }
            catch (IOException iOException) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "IOException while closing regular socket channel");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "closeRegularSocket");
        }
    }

    public Socket getSocket() {
        return this.socket;
    }

    protected SocketChannel getChannel() {
        return this.channel;
    }

    public void connectActions() throws IOException {
    }

    protected Object[] buildDumpList() {
        return null;
    }

    protected String getFFDCDumpData() {
        return new String("no Dump Data from SocketIOChannel");
    }

    class StartPrivilegedThread
    implements PrivilegedAction {
        SocketChannel ioSocket;
        InetSocketAddress address;

        public StartPrivilegedThread(SocketChannel socketChannel, InetSocketAddress inetSocketAddress) {
            this.ioSocket = socketChannel;
            this.address = inetSocketAddress;
        }

        public Object run() {
            ConnectReturn connectReturn = new ConnectReturn();
            try {
                connectReturn.isConnected = this.ioSocket.connect(this.address);
            }
            catch (IOException iOException) {
                connectReturn.ioe = iOException;
            }
            return connectReturn;
        }
    }

    public class ConnectReturn {
        public boolean isConnected = false;
        public IOException ioe = null;
    }
}

