/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.channel.framework.impl;

import com.ibm.nws.ejs.ras.Tr;
import com.ibm.nws.ejs.ras.TraceComponent;
import com.ibm.nws.ffdc.FFDCFilter;
import com.ibm.websphere.channel.framework.ChainData;
import com.ibm.websphere.channel.framework.ChainGroupData;
import com.ibm.ws.channel.framework.impl.ChainDataImpl;
import com.ibm.ws.channel.framework.impl.ChannelFrameworkImpl;
import com.ibm.wsspi.channel.framework.ChainEventListener;
import com.ibm.wsspi.channel.framework.exception.ChainException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ChainGroupDataImpl
implements ChainGroupData {
    private static final long serialVersionUID = 3062239582748589190L;
    private static final TraceComponent tc = Tr.register(ChainGroupDataImpl.class, "ChannelFramework", "com.ibm.ws.channel.resources.channelframeworkservice");
    private String name = null;
    private ChainData[] chainArray = null;
    private transient List chainEventListeners = null;
    private transient ChannelFrameworkImpl framework = null;

    public ChainGroupDataImpl(String string, ChainData[] chainDataArray, ChannelFrameworkImpl channelFrameworkImpl) {
        this.name = string;
        this.chainArray = chainDataArray;
        this.chainEventListeners = new ArrayList(0);
        this.framework = channelFrameworkImpl;
    }

    public String getName() {
        return this.name;
    }

    public ChainData[] getChains() {
        return this.chainArray;
    }

    public boolean containsChain(String string) {
        for (int i = 0; i < this.chainArray.length; ++i) {
            if (!string.equals(this.chainArray[i].getName())) continue;
            return true;
        }
        return false;
    }

    public void setChains(ChainData[] chainDataArray) {
        this.chainArray = chainDataArray;
    }

    public void addChain(ChainData chainData) throws ChainException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addChain");
        }
        if (this.containsChain(chainData.getName())) {
            ChainException chainException = new ChainException("Chain already exists: " + chainData.getName());
            FFDCFilter.processException(chainException, "com.ibm.ws.channel.framework.impl.ChannelFrameworkImpl.addChainToGroup", "116", this, new Object[]{chainData});
            throw chainException;
        }
        int n = this.chainArray.length;
        ChainData[] chainDataArray = new ChainData[n + 1];
        System.arraycopy((Object)this.chainArray, 0, (Object)chainDataArray, 0, this.chainArray.length);
        chainDataArray[n] = chainData;
        this.chainArray = chainDataArray;
        Iterator iterator = this.chainEventListeners.iterator();
        while (iterator.hasNext()) {
            ((ChainDataImpl)chainData).addChainEventListener((ChainEventListener)iterator.next());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addChain");
        }
    }

    public void removeChain(ChainData chainData) throws ChainException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeChain");
        }
        if (!this.containsChain(chainData.getName())) {
            ChainException chainException = new ChainException("Unable to find chain: " + chainData.getName());
            FFDCFilter.processException(chainException, "com.ibm.ws.channel.framework.impl.ChannelFrameworkImpl.addChainToGroup", "157", this, new Object[]{chainData, this.framework});
            throw chainException;
        }
        int n = this.chainArray.length;
        ChainData[] chainDataArray = new ChainData[n - 1];
        for (int i = 0; i < n; ++i) {
            if (chainData.getName().equals(this.chainArray[i].getName())) continue;
            chainDataArray[i] = this.chainArray[i];
        }
        this.chainArray = chainDataArray;
        Iterator iterator = this.chainEventListeners.iterator();
        while (iterator.hasNext()) {
            this.removeListenerFromChain((ChainEventListener)iterator.next(), chainData);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeChain");
        }
    }

    public void updateChain(ChainData chainData) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateChain");
        }
        for (int i = 0; i < this.chainArray.length; ++i) {
            if (!chainData.getName().equals(this.chainArray[i].getName())) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Updating chain " + chainData.getName() + " in group " + this.name);
            }
            this.chainArray[i] = chainData;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateChain");
        }
    }

    public int getNumChainEventListeners() {
        return this.chainEventListeners.size();
    }

    public List getChainEventListeners() {
        return this.chainEventListeners;
    }

    public boolean containsChainEventListener(ChainEventListener chainEventListener) {
        return this.chainEventListeners.contains(chainEventListener);
    }

    private void removeListenerFromChain(ChainEventListener chainEventListener, ChainData chainData) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeListenerFromChain");
        }
        ChainGroupData[] chainGroupDataArray = null;
        boolean bl = false;
        try {
            chainGroupDataArray = this.framework.getAllChainGroups(chainData.getName());
            bl = false;
            int n = 0;
            for (n = 0; n < chainGroupDataArray.length; ++n) {
                if (!((ChainGroupDataImpl)chainGroupDataArray[n]).containsChainEventListener(chainEventListener)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Removing listener from chain config, " + chainData.getName());
                }
                ((ChainDataImpl)chainData).removeChainEventListener(chainEventListener);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found chain " + chainData.getName() + " in another group, " + chainGroupDataArray[n].getName());
            }
        }
        catch (ChainException chainException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Chain not found in config: " + chainData.getName() + ", but will remove listener.");
            }
            ((ChainDataImpl)chainData).removeChainEventListener(chainEventListener);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeListenerFromChain");
        }
    }

    public final void addChainEventListener(ChainEventListener chainEventListener) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addChainEventListener");
        }
        if (null != chainEventListener && !this.chainEventListeners.contains(chainEventListener)) {
            this.chainEventListeners.add(chainEventListener);
            for (int i = 0; i < this.chainArray.length; ++i) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding listener to chain, " + this.chainArray[i].getName());
                }
                ((ChainDataImpl)this.chainArray[i]).addChainEventListener(chainEventListener);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Cannot add null chain listener");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addChainEventListener");
        }
    }

    public final void removeChainEventListener(ChainEventListener chainEventListener) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeChainEventListener");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "listener:" + chainEventListener);
            Tr.debug(tc, "numListeners:" + this.chainEventListeners.size());
            Tr.debug(tc, "list:" + this.chainEventListeners);
        }
        if (null != chainEventListener) {
            if (!this.chainEventListeners.remove(chainEventListener) && tc.isDebugEnabled()) {
                Tr.debug(tc, "Listener " + chainEventListener + " was not found in list monitored by group " + this.name);
            }
            for (int i = 0; i < this.chainArray.length; ++i) {
                this.removeListenerFromChain(chainEventListener, this.chainArray[i]);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Cannot remove null chain listener");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeChainEventListener");
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ChainGroupData:\r\n\tname = ");
        stringBuffer.append(this.name);
        stringBuffer.append("\r\n\tchainconfigs:");
        for (int i = 0; i < this.chainArray.length; ++i) {
            stringBuffer.append("\r\n\t\t");
            stringBuffer.append(this.chainArray[i].getName());
        }
        return stringBuffer.toString();
    }
}

