/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.luni.internal.process;

import com.ibm.jvm.io.LocalizedOutputStream;
import java.io.FileDescriptor;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

class ProcessOutputStream
extends OutputStream {
    private long handle;
    private FileDescriptor fd = new FileDescriptor();

    private static native void oneTimeInitialization();

    private native void closeImpl() throws IOException;

    private native void setFDImpl(FileDescriptor var1, long var2);

    private native void writeImpl(byte[] var1, int var2, int var3, long var4) throws IOException;

    protected ProcessOutputStream(long l) {
        this.setFDImpl(this.fd, l);
        this.handle = l;
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        ProcessOutputStream processOutputStream = this;
        synchronized (processOutputStream) {
            if (this.handle == -1L) {
                return;
            }
            this.closeImpl();
            this.handle = -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] byArray) throws IOException {
        ProcessOutputStream processOutputStream = this;
        synchronized (processOutputStream) {
            this.writeImpl(byArray, 0, byArray.length, this.handle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        ProcessOutputStream processOutputStream = this;
        synchronized (processOutputStream) {
            if (this.handle == -1L) {
                return;
            }
            this.writeImpl(byArray, n, n2, this.handle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)n};
        ProcessOutputStream processOutputStream = this;
        synchronized (processOutputStream) {
            this.writeImpl(byArray, 0, 1, this.handle);
        }
    }

    public boolean isInstanceOf(OutputStream outputStream) {
        if (outputStream instanceof ProcessOutputStream) {
            return true;
        }
        OutputStream outputStream2 = outputStream;
        while (outputStream2 instanceof FilterOutputStream) {
            outputStream2 = LocalizedOutputStream.unwrap((FilterOutputStream)((FilterOutputStream)outputStream));
            if (!(outputStream2 instanceof ProcessOutputStream)) continue;
            return true;
        }
        return false;
    }

    public String getDefaultEncodingName() {
        String string = System.getProperty("console.encoding");
        if (string == null || string.equals("")) {
            return "ibm.system.encoding";
        }
        return string;
    }

    static {
        ProcessOutputStream.oneTimeInitialization();
    }
}

