/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.luni.internal.process;

import com.ibm.jvm.io.LocalizedInputStream;
import java.io.FileDescriptor;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

class ProcessInputStream
extends InputStream {
    private long handle;
    private FileDescriptor fd = new FileDescriptor();

    private static native void oneTimeInitialization();

    private native int availableImpl() throws IOException;

    private native int readImpl(byte[] var1, int var2, int var3, long var4) throws IOException;

    private native void setFDImpl(FileDescriptor var1, long var2);

    private native void closeImpl() throws IOException;

    protected ProcessInputStream(long l) {
        this.setFDImpl(this.fd, l);
        this.handle = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int available() throws IOException {
        ProcessInputStream processInputStream = this;
        synchronized (processInputStream) {
            if (this.handle == -1L) {
                return -1;
            }
            return this.availableImpl();
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        ProcessInputStream processInputStream = this;
        synchronized (processInputStream) {
            if (this.handle == -1L) {
                return;
            }
            this.closeImpl();
            this.handle = -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        byte[] byArray = new byte[1];
        ProcessInputStream processInputStream = this;
        synchronized (processInputStream) {
            if (this.readImpl(byArray, 0, 1, this.handle) == -1) {
                return -1;
            }
        }
        return byArray[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] byArray) throws IOException {
        ProcessInputStream processInputStream = this;
        synchronized (processInputStream) {
            return this.readImpl(byArray, 0, byArray.length, this.handle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        ProcessInputStream processInputStream = this;
        synchronized (processInputStream) {
            if (this.handle == -1L) {
                return -1;
            }
            if (n2 < 0 || n2 > byArray.length || n < 0 || n > byArray.length || n2 + n > byArray.length) {
                throw new ArrayIndexOutOfBoundsException();
            }
            return this.readImpl(byArray, n, n2, this.handle);
        }
    }

    public boolean isInstanceOf(InputStream inputStream) {
        if (inputStream instanceof ProcessInputStream) {
            return true;
        }
        InputStream inputStream2 = inputStream;
        while (inputStream2 instanceof FilterInputStream) {
            inputStream2 = LocalizedInputStream.unwrap((FilterInputStream)((FilterInputStream)inputStream));
            if (!(inputStream2 instanceof ProcessInputStream)) continue;
            return true;
        }
        return false;
    }

    public String getDefaultEncodingName() {
        String string = System.getProperty("console.encoding");
        if (string == null || string.equals("")) {
            return "ibm.system.encoding";
        }
        return string;
    }

    static {
        ProcessInputStream.oneTimeInitialization();
    }
}

