/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class WeakHashMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V> {
    private static final int DEFAULT_SIZE = 16;
    private final ReferenceQueue<K> referenceQueue;
    int elementCount;
    Entry<K, V>[] elementData;
    private final int loadFactor;
    private int threshold;
    volatile int modCount;

    private static <K, V> Entry<K, V>[] newEntryArray(int n) {
        return new Entry[n];
    }

    public WeakHashMap() {
        this(16);
    }

    public WeakHashMap(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.elementCount = 0;
        this.elementData = WeakHashMap.newEntryArray(n == 0 ? 1 : n);
        this.loadFactor = 7500;
        this.computeMaxSize();
        this.referenceQueue = new ReferenceQueue();
    }

    public WeakHashMap(int n, float f) {
        if (n < 0 || !(f > 0.0f)) {
            throw new IllegalArgumentException();
        }
        this.elementCount = 0;
        this.elementData = WeakHashMap.newEntryArray(n == 0 ? 1 : n);
        this.loadFactor = (int)(f * 10000.0f);
        this.computeMaxSize();
        this.referenceQueue = new ReferenceQueue();
    }

    public WeakHashMap(Map<? extends K, ? extends V> map) {
        this(map.size() < 6 ? 11 : map.size() * 2);
        super.putAllImpl(map);
    }

    @Override
    public void clear() {
        if (this.elementCount > 0) {
            this.elementCount = 0;
            Arrays.fill(this.elementData, null);
            ++this.modCount;
            while (this.referenceQueue.poll() != null) {
            }
        }
    }

    private void computeMaxSize() {
        this.threshold = (int)((long)this.elementData.length * (long)this.loadFactor / 10000L);
    }

    @Override
    public boolean containsKey(Object object) {
        return this.getEntry(object) != null;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.poll();
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public int size() {
                return WeakHashMap.this.size();
            }

            @Override
            public void clear() {
                WeakHashMap.this.clear();
            }

            @Override
            public boolean remove(Object object) {
                if (this.contains(object)) {
                    WeakHashMap.this.remove(((Map.Entry)object).getKey());
                    return true;
                }
                return false;
            }

            @Override
            public boolean contains(Object object) {
                Object t;
                Entry entry;
                if (object instanceof Map.Entry && (entry = WeakHashMap.this.getEntry(((Map.Entry)object).getKey())) != null && ((t = entry.get()) != null || entry.isNull)) {
                    return object.equals(entry);
                }
                return false;
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new HashIterator(new Entry.Type<Map.Entry<K, V>, K, V>(){

                    @Override
                    public Map.Entry<K, V> get(Map.Entry<K, V> entry) {
                        return entry;
                    }
                });
            }
        };
    }

    @Override
    public Set<K> keySet() {
        this.poll();
        if (this.keySet == null) {
            this.keySet = new AbstractSet<K>(){

                @Override
                public boolean contains(Object object) {
                    return WeakHashMap.this.containsKey(object);
                }

                @Override
                public int size() {
                    return WeakHashMap.this.size();
                }

                @Override
                public void clear() {
                    WeakHashMap.this.clear();
                }

                @Override
                public boolean remove(Object object) {
                    if (WeakHashMap.this.containsKey(object)) {
                        WeakHashMap.this.remove(object);
                        return true;
                    }
                    return false;
                }

                @Override
                public Iterator<K> iterator() {
                    return new HashIterator(new Entry.Type<K, K, V>(){

                        @Override
                        public K get(Map.Entry<K, V> entry) {
                            return entry.getKey();
                        }
                    });
                }

                @Override
                public Object[] toArray() {
                    ArrayList arrayList = new ArrayList(this.size());
                    Iterator iterator = this.iterator();
                    while (iterator.hasNext()) {
                        arrayList.add(iterator.next());
                    }
                    return arrayList.toArray();
                }

                @Override
                public <T> T[] toArray(T[] TArray) {
                    ArrayList arrayList = new ArrayList(this.size());
                    Iterator iterator = this.iterator();
                    while (iterator.hasNext()) {
                        arrayList.add(iterator.next());
                    }
                    return arrayList.toArray(TArray);
                }
            };
        }
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        this.poll();
        if (this.valuesCollection == null) {
            this.valuesCollection = new AbstractCollection<V>(){

                @Override
                public int size() {
                    return WeakHashMap.this.size();
                }

                @Override
                public void clear() {
                    WeakHashMap.this.clear();
                }

                @Override
                public boolean contains(Object object) {
                    return WeakHashMap.this.containsValue(object);
                }

                @Override
                public Iterator<V> iterator() {
                    return new HashIterator(new Entry.Type<V, K, V>(){

                        @Override
                        public V get(Map.Entry<K, V> entry) {
                            return entry.getValue();
                        }
                    });
                }
            };
        }
        return this.valuesCollection;
    }

    @Override
    public V get(Object object) {
        this.poll();
        if (object != null) {
            int n = (object.hashCode() & Integer.MAX_VALUE) % this.elementData.length;
            Entry<K, V> entry = this.elementData[n];
            while (entry != null) {
                if (object.equals(entry.get())) {
                    return entry.value;
                }
                entry = entry.next;
            }
            return null;
        }
        Entry<K, V> entry = this.elementData[0];
        while (entry != null) {
            if (entry.isNull) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    Entry<K, V> getEntry(Object object) {
        this.poll();
        if (object != null) {
            int n = (object.hashCode() & Integer.MAX_VALUE) % this.elementData.length;
            Entry<K, V> entry = this.elementData[n];
            while (entry != null) {
                if (object.equals(entry.get())) {
                    return entry;
                }
                entry = entry.next;
            }
            return null;
        }
        Entry<K, V> entry = this.elementData[0];
        while (entry != null) {
            if (entry.isNull) {
                return entry;
            }
            entry = entry.next;
        }
        return null;
    }

    @Override
    public boolean containsValue(Object object) {
        this.poll();
        if (object != null) {
            int n = this.elementData.length;
            while (--n >= 0) {
                Entry<K, V> entry = this.elementData[n];
                while (entry != null) {
                    Object t = entry.get();
                    if ((t != null || entry.isNull) && object.equals(entry.value)) {
                        return true;
                    }
                    entry = entry.next;
                }
            }
        } else {
            int n = this.elementData.length;
            while (--n >= 0) {
                Entry<K, V> entry = this.elementData[n];
                while (entry != null) {
                    Object t = entry.get();
                    if ((t != null || entry.isNull) && entry.value == null) {
                        return true;
                    }
                    entry = entry.next;
                }
            }
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    void poll() {
        Entry entry;
        while ((entry = (Entry)this.referenceQueue.poll()) != null) {
            this.removeEntry(entry);
        }
    }

    void removeEntry(Entry<K, V> entry) {
        Entry<K, V> entry2 = null;
        int n = (entry.hash & Integer.MAX_VALUE) % this.elementData.length;
        Entry<K, V> entry3 = this.elementData[n];
        while (entry3 != null) {
            if (entry == entry3) {
                ++this.modCount;
                if (entry2 == null) {
                    this.elementData[n] = entry3.next;
                } else {
                    entry2.next = entry3.next;
                }
                --this.elementCount;
                break;
            }
            entry2 = entry3;
            entry3 = entry3.next;
        }
    }

    @Override
    public V put(K k, V v) {
        Entry<K, V> entry;
        this.poll();
        int n = 0;
        if (k != null) {
            n = (k.hashCode() & Integer.MAX_VALUE) % this.elementData.length;
            entry = this.elementData[n];
            while (entry != null && k != entry.get()) {
                entry = entry.next;
            }
        } else {
            entry = this.elementData[0];
            while (entry != null && !entry.isNull) {
                entry = entry.next;
            }
        }
        if (entry == null) {
            ++this.modCount;
            if (++this.elementCount > this.threshold) {
                this.rehash();
                n = k == null ? 0 : (k.hashCode() & Integer.MAX_VALUE) % this.elementData.length;
            }
            entry = new Entry<K, V>(k, v, this.referenceQueue);
            entry.next = this.elementData[n];
            this.elementData[n] = entry;
            return null;
        }
        Object v2 = entry.value;
        entry.value = v;
        return v2;
    }

    private void rehash() {
        int n = this.elementData.length << 1;
        if (n == 0) {
            n = 1;
        }
        Entry<K, V>[] entryArray = WeakHashMap.newEntryArray(n);
        for (int i = 0; i < this.elementData.length; ++i) {
            Entry<K, V> entry = this.elementData[i];
            while (entry != null) {
                int n2 = entry.isNull ? 0 : (entry.hash & Integer.MAX_VALUE) % n;
                Entry entry2 = entry.next;
                entry.next = entryArray[n2];
                entryArray[n2] = entry;
                entry = entry2;
            }
        }
        this.elementData = entryArray;
        this.computeMaxSize();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        this.putAllImpl(map);
    }

    @Override
    public V remove(Object object) {
        Entry<K, V> entry;
        this.poll();
        int n = 0;
        Entry<K, V> entry2 = null;
        if (object != null) {
            n = (object.hashCode() & Integer.MAX_VALUE) % this.elementData.length;
            entry = this.elementData[n];
            while (entry != null && !object.equals(entry.get())) {
                entry2 = entry;
                entry = entry.next;
            }
        } else {
            entry = this.elementData[0];
            while (entry != null && !entry.isNull) {
                entry2 = entry;
                entry = entry.next;
            }
        }
        if (entry != null) {
            ++this.modCount;
            if (entry2 == null) {
                this.elementData[n] = entry.next;
            } else {
                entry2.next = entry.next;
            }
            --this.elementCount;
            return entry.value;
        }
        return null;
    }

    @Override
    public int size() {
        this.poll();
        return this.elementCount;
    }

    private void putAllImpl(Map<? extends K, ? extends V> map) {
        if (map.entrySet() != null) {
            super.putAll(map);
        }
    }

    class HashIterator<R>
    implements Iterator<R> {
        private int position = 0;
        private int expectedModCount;
        private Entry<K, V> currentEntry;
        private Entry<K, V> nextEntry;
        private K nextKey;
        final Entry.Type<R, K, V> type;

        HashIterator(Entry.Type<R, K, V> type) {
            this.type = type;
            this.expectedModCount = WeakHashMap.this.modCount;
        }

        @Override
        public boolean hasNext() {
            if (this.nextEntry != null && (this.nextKey != null || this.nextEntry.isNull)) {
                return true;
            }
            while (true) {
                if (this.nextEntry == null) {
                    while (this.position < WeakHashMap.this.elementData.length && (this.nextEntry = WeakHashMap.this.elementData[this.position++]) == null) {
                    }
                    if (this.nextEntry == null) {
                        return false;
                    }
                }
                this.nextKey = this.nextEntry.get();
                if (this.nextKey != null || this.nextEntry.isNull) {
                    return true;
                }
                this.nextEntry = this.nextEntry.next;
            }
        }

        @Override
        public R next() {
            if (this.expectedModCount == WeakHashMap.this.modCount) {
                if (this.hasNext()) {
                    this.currentEntry = this.nextEntry;
                    this.nextEntry = this.currentEntry.next;
                    R r = this.type.get(this.currentEntry);
                    this.nextKey = null;
                    return r;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void remove() {
            if (this.expectedModCount != WeakHashMap.this.modCount) throw new ConcurrentModificationException();
            if (this.currentEntry == null) throw new IllegalStateException();
            WeakHashMap.this.removeEntry(this.currentEntry);
            this.currentEntry = null;
            ++this.expectedModCount;
        }
    }

    private static final class Entry<K, V>
    extends WeakReference<K>
    implements Map.Entry<K, V> {
        int hash;
        boolean isNull;
        V value;
        Entry<K, V> next;

        Entry(K k, V v, ReferenceQueue<K> referenceQueue) {
            super(k, referenceQueue);
            this.isNull = k == null;
            this.hash = this.isNull ? 0 : k.hashCode();
            this.value = v;
        }

        @Override
        public K getKey() {
            return (K)super.get();
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V v) {
            V v2 = this.value;
            this.value = v;
            return v2;
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object t = super.get();
            return (t == null ? t == entry.getKey() : t.equals(entry.getKey())) && (this.value == null ? this.value == entry.getValue() : this.value.equals(entry.getValue()));
        }

        @Override
        public int hashCode() {
            return this.hash + (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return super.get() + "=" + this.value;
        }

        static interface Type<R, K, V> {
            public R get(Map.Entry<K, V> var1);
        }
    }
}

