/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.RandomAccess;

public class Vector<E>
extends AbstractList<E>
implements List<E>,
RandomAccess,
Cloneable,
Serializable {
    private static final long serialVersionUID = -2767605614048989439L;
    protected int elementCount = 0;
    protected Object[] elementData;
    protected int capacityIncrement;
    private static final int DEFAULT_SIZE = 10;

    public Vector() {
        this(10, 0);
    }

    public Vector(int n) {
        this(n, 0);
    }

    public Vector(int n, int n2) {
        try {
            this.elementData = this.newElementArray(n);
        }
        catch (NegativeArraySizeException negativeArraySizeException) {
            throw new IllegalArgumentException();
        }
        this.capacityIncrement = n2;
    }

    public Vector(Collection<? extends E> collection) {
        this(collection.size(), 0);
        Iterator<E> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.elementData[this.elementCount++] = iterator.next();
        }
    }

    private E[] newElementArray(int n) {
        return new Object[n];
    }

    @Override
    public void add(int n, E e) {
        this.insertElementAt(e, n);
    }

    @Override
    public synchronized boolean add(E e) {
        if (this.elementCount == this.elementData.length) {
            this.growByOne();
        }
        this.elementData[this.elementCount++] = e;
        ++this.modCount;
        return true;
    }

    @Override
    public synchronized boolean addAll(int n, Collection<? extends E> collection) {
        if (0 <= n && n <= this.elementCount) {
            int n2;
            int n3 = collection.size();
            if (n3 == 0) {
                return false;
            }
            int n4 = n3 - (this.elementData.length - this.elementCount);
            if (n4 > 0) {
                this.growBy(n4);
            }
            if ((n2 = this.elementCount - n) > 0) {
                System.arraycopy(this.elementData, n, this.elementData, n + n3, n2);
            }
            Iterator<E> iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.elementData[n++] = iterator.next();
            }
            this.elementCount += n3;
            ++this.modCount;
            return true;
        }
        throw new ArrayIndexOutOfBoundsException(n);
    }

    @Override
    public synchronized boolean addAll(Collection<? extends E> collection) {
        return this.addAll(this.elementCount, collection);
    }

    public synchronized void addElement(E e) {
        if (this.elementCount == this.elementData.length) {
            this.growByOne();
        }
        this.elementData[this.elementCount++] = e;
        ++this.modCount;
    }

    public synchronized int capacity() {
        return this.elementData.length;
    }

    @Override
    public void clear() {
        this.removeAllElements();
    }

    public synchronized Object clone() {
        try {
            Vector vector = (Vector)super.clone();
            vector.elementData = (Object[])this.elementData.clone();
            return vector;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    @Override
    public boolean contains(Object object) {
        return this.indexOf(object, 0) != -1;
    }

    @Override
    public synchronized boolean containsAll(Collection<?> collection) {
        return super.containsAll(collection);
    }

    public synchronized void copyInto(Object[] objectArray) {
        System.arraycopy(this.elementData, 0, objectArray, 0, this.elementCount);
    }

    public synchronized E elementAt(int n) {
        if (n < this.elementCount) {
            return (E)this.elementData[n];
        }
        throw new ArrayIndexOutOfBoundsException(n);
    }

    public Enumeration<E> elements() {
        return new Enumeration<E>(){
            int pos = 0;

            @Override
            public boolean hasMoreElements() {
                return this.pos < Vector.this.elementCount;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public E nextElement() {
                Vector vector = Vector.this;
                synchronized (vector) {
                    if (this.pos < Vector.this.elementCount) {
                        return Vector.this.elementData[this.pos++];
                    }
                }
                throw new NoSuchElementException();
            }
        };
    }

    public synchronized void ensureCapacity(int n) {
        if (this.elementData.length < n) {
            int n2 = (this.capacityIncrement <= 0 ? this.elementData.length : this.capacityIncrement) + this.elementData.length;
            this.grow(n > n2 ? n : n2);
        }
    }

    @Override
    public synchronized boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof List) {
            List list = (List)object;
            if (list.size() != this.elementCount) {
                return false;
            }
            int n = 0;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object object2 = this.elementData[n++];
                Object e = iterator.next();
                if (object2 != null ? object2.equals(e) : e == null) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public synchronized E firstElement() {
        if (this.elementCount > 0) {
            return (E)this.elementData[0];
        }
        throw new NoSuchElementException();
    }

    @Override
    public E get(int n) {
        return this.elementAt(n);
    }

    private void grow(int n) {
        E[] EArray = this.newElementArray(n);
        assert (this.elementCount <= n);
        System.arraycopy(this.elementData, 0, EArray, 0, this.elementCount);
        this.elementData = EArray;
    }

    private void growByOne() {
        int n = 0;
        if (this.capacityIncrement <= 0) {
            n = this.elementData.length;
            if (n == 0) {
                n = 1;
            }
        } else {
            n = this.capacityIncrement;
        }
        E[] EArray = this.newElementArray(this.elementData.length + n);
        System.arraycopy(this.elementData, 0, EArray, 0, this.elementCount);
        this.elementData = EArray;
    }

    private void growBy(int n) {
        int n2 = 0;
        if (this.capacityIncrement <= 0) {
            n2 = this.elementData.length;
            if (n2 == 0) {
                n2 = n;
            }
            while (n2 < n) {
                n2 += n2;
            }
        } else {
            n2 = n / this.capacityIncrement * this.capacityIncrement;
            if (n2 < n) {
                n2 += this.capacityIncrement;
            }
        }
        E[] EArray = this.newElementArray(this.elementData.length + n2);
        System.arraycopy(this.elementData, 0, EArray, 0, this.elementCount);
        this.elementData = EArray;
    }

    @Override
    public synchronized int hashCode() {
        int n = 1;
        for (int i = 0; i < this.elementCount; ++i) {
            n = 31 * n + (this.elementData[i] == null ? 0 : this.elementData[i].hashCode());
        }
        return n;
    }

    @Override
    public int indexOf(Object object) {
        return this.indexOf(object, 0);
    }

    public synchronized int indexOf(Object object, int n) {
        if (object != null) {
            for (int i = n; i < this.elementCount; ++i) {
                if (!object.equals(this.elementData[i])) continue;
                return i;
            }
        } else {
            for (int i = n; i < this.elementCount; ++i) {
                if (this.elementData[i] != null) continue;
                return i;
            }
        }
        return -1;
    }

    public synchronized void insertElementAt(E e, int n) {
        if (0 <= n && n <= this.elementCount) {
            int n2;
            if (this.elementCount == this.elementData.length) {
                this.growByOne();
            }
            if ((n2 = this.elementCount - n) > 0) {
                System.arraycopy(this.elementData, n, this.elementData, n + 1, n2);
            }
            this.elementData[n] = e;
            ++this.elementCount;
            ++this.modCount;
        } else {
            throw new ArrayIndexOutOfBoundsException(n);
        }
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.elementCount == 0;
    }

    public synchronized E lastElement() {
        try {
            return (E)this.elementData[this.elementCount - 1];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public synchronized int lastIndexOf(Object object) {
        return this.lastIndexOf(object, this.elementCount - 1);
    }

    public synchronized int lastIndexOf(Object object, int n) {
        if (n < this.elementCount) {
            if (object != null) {
                for (int i = n; i >= 0; --i) {
                    if (!object.equals(this.elementData[i])) continue;
                    return i;
                }
            } else {
                for (int i = n; i >= 0; --i) {
                    if (this.elementData[i] != null) continue;
                    return i;
                }
            }
            return -1;
        }
        throw new ArrayIndexOutOfBoundsException(n);
    }

    @Override
    public synchronized E remove(int n) {
        if (n < this.elementCount) {
            Object object = this.elementData[n];
            --this.elementCount;
            int n2 = this.elementCount - n;
            if (n2 > 0) {
                System.arraycopy(this.elementData, n + 1, this.elementData, n, n2);
            }
            this.elementData[this.elementCount] = null;
            ++this.modCount;
            return (E)object;
        }
        throw new ArrayIndexOutOfBoundsException(n);
    }

    @Override
    public boolean remove(Object object) {
        return this.removeElement(object);
    }

    @Override
    public synchronized boolean removeAll(Collection<?> collection) {
        return super.removeAll(collection);
    }

    public synchronized void removeAllElements() {
        Arrays.fill(this.elementData, 0, this.elementCount, null);
        ++this.modCount;
        this.elementCount = 0;
    }

    public synchronized boolean removeElement(Object object) {
        int n = this.indexOf(object, 0);
        if (n == -1) {
            return false;
        }
        this.removeElementAt(n);
        return true;
    }

    public synchronized void removeElementAt(int n) {
        if (0 <= n && n < this.elementCount) {
            --this.elementCount;
            int n2 = this.elementCount - n;
            if (n2 > 0) {
                System.arraycopy(this.elementData, n + 1, this.elementData, n, n2);
            }
            this.elementData[this.elementCount] = null;
            ++this.modCount;
        } else {
            throw new ArrayIndexOutOfBoundsException(n);
        }
    }

    @Override
    protected void removeRange(int n, int n2) {
        if (n >= 0 && n <= n2 && n2 <= this.elementCount) {
            if (n == n2) {
                return;
            }
            if (n2 != this.elementCount) {
                System.arraycopy(this.elementData, n2, this.elementData, n, this.elementCount - n2);
                int n3 = this.elementCount - (n2 - n);
                Arrays.fill(this.elementData, n3, this.elementCount, null);
                this.elementCount = n3;
            } else {
                Arrays.fill(this.elementData, n, this.elementCount, null);
                this.elementCount = n;
            }
            ++this.modCount;
        } else {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public synchronized boolean retainAll(Collection<?> collection) {
        return super.retainAll(collection);
    }

    @Override
    public synchronized E set(int n, E e) {
        if (n < this.elementCount) {
            Object object = this.elementData[n];
            this.elementData[n] = e;
            return (E)object;
        }
        throw new ArrayIndexOutOfBoundsException(n);
    }

    public synchronized void setElementAt(E e, int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        this.elementData[n] = e;
    }

    public synchronized void setSize(int n) {
        if (n == this.elementCount) {
            return;
        }
        this.ensureCapacity(n);
        if (this.elementCount > n) {
            Arrays.fill(this.elementData, n, this.elementCount, null);
        }
        this.elementCount = n;
        ++this.modCount;
    }

    @Override
    public synchronized int size() {
        return this.elementCount;
    }

    @Override
    public synchronized List<E> subList(int n, int n2) {
        return new Collections.SynchronizedRandomAccessList(super.subList(n, n2), (Object)this);
    }

    @Override
    public synchronized Object[] toArray() {
        Object[] objectArray = new Object[this.elementCount];
        System.arraycopy(this.elementData, 0, objectArray, 0, this.elementCount);
        return objectArray;
    }

    @Override
    public synchronized <T> T[] toArray(T[] objectArray) {
        if (this.elementCount > objectArray.length) {
            Class<?> clazz = objectArray.getClass().getComponentType();
            objectArray = (Object[])Array.newInstance(clazz, this.elementCount);
        }
        System.arraycopy(this.elementData, 0, objectArray, 0, this.elementCount);
        if (this.elementCount < objectArray.length) {
            objectArray[this.elementCount] = null;
        }
        return objectArray;
    }

    @Override
    public synchronized String toString() {
        if (this.elementCount == 0) {
            return "[]";
        }
        int n = this.elementCount - 1;
        StringBuffer stringBuffer = new StringBuffer(this.elementCount * 16);
        stringBuffer.append('[');
        for (int i = 0; i < n; ++i) {
            if (this.elementData[i] == this) {
                stringBuffer.append("(this Collection)");
            } else {
                stringBuffer.append(this.elementData[i]);
            }
            stringBuffer.append(", ");
        }
        if (this.elementData[n] == this) {
            stringBuffer.append("(this Collection)");
        } else {
            stringBuffer.append(this.elementData[n]);
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public synchronized void trimToSize() {
        if (this.elementData.length != this.elementCount) {
            this.grow(this.elementCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Vector vector = null;
        Vector vector2 = this;
        synchronized (vector2) {
            try {
                vector = (Vector)super.clone();
                vector.elementData = (Object[])this.elementData.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
        }
        vector.writeObjectImpl(objectOutputStream);
    }

    private void writeObjectImpl(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }
}

