/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.SortedSet;
import java.util.TreeMap;

public class TreeSet<E>
extends AbstractSet<E>
implements NavigableSet<E>,
Cloneable,
Serializable {
    private static final long serialVersionUID = -2479143000061671589L;
    transient NavigableMap<E, E> backingMap;
    transient NavigableSet<E> descendingSet;

    TreeSet(NavigableMap<E, E> navigableMap) {
        this.backingMap = navigableMap;
    }

    public TreeSet() {
        this.backingMap = new TreeMap<E, E>();
    }

    public TreeSet(Collection<? extends E> collection) {
        this();
        this.addAll(collection);
    }

    public TreeSet(Comparator<? super E> comparator) {
        this.backingMap = new TreeMap<E, E>(comparator);
    }

    public TreeSet(SortedSet<E> sortedSet) {
        this(sortedSet.comparator());
        Iterator iterator = sortedSet.iterator();
        while (iterator.hasNext()) {
            this.add(iterator.next());
        }
    }

    @Override
    public boolean add(E e) {
        return this.backingMap.put(e, e) == null;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        return super.addAll(collection);
    }

    @Override
    public void clear() {
        this.backingMap.clear();
    }

    public Object clone() {
        try {
            TreeSet treeSet = (TreeSet)super.clone();
            treeSet.backingMap = this.backingMap instanceof TreeMap ? (NavigableMap<Object, Object>)((TreeMap)this.backingMap).clone() : new TreeMap<E, E>(this.backingMap);
            return treeSet;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.backingMap.comparator();
    }

    @Override
    public boolean contains(Object object) {
        return this.backingMap.containsKey(object);
    }

    @Override
    public boolean isEmpty() {
        return this.backingMap.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.backingMap.keySet().iterator();
    }

    @Override
    public Iterator<E> descendingIterator() {
        return this.descendingSet().iterator();
    }

    @Override
    public boolean remove(Object object) {
        return this.backingMap.remove(object) != null;
    }

    @Override
    public int size() {
        return this.backingMap.size();
    }

    @Override
    public E first() {
        return (E)this.backingMap.firstKey();
    }

    @Override
    public E last() {
        return (E)this.backingMap.lastKey();
    }

    @Override
    public E pollFirst() {
        Map.Entry<E, E> entry = this.backingMap.pollFirstEntry();
        return null == entry ? null : (E)entry.getKey();
    }

    @Override
    public E pollLast() {
        Map.Entry<E, E> entry = this.backingMap.pollLastEntry();
        return null == entry ? null : (E)entry.getKey();
    }

    @Override
    public E higher(E e) {
        return this.backingMap.higherKey(e);
    }

    @Override
    public E lower(E e) {
        return this.backingMap.lowerKey(e);
    }

    @Override
    public E ceiling(E e) {
        return this.backingMap.ceilingKey(e);
    }

    @Override
    public E floor(E e) {
        return this.backingMap.floorKey(e);
    }

    @Override
    public NavigableSet<E> descendingSet() {
        return null != this.descendingSet ? this.descendingSet : (this.descendingSet = new TreeSet<E>(this.backingMap.descendingMap()));
    }

    @Override
    public NavigableSet<E> subSet(E e, boolean bl, E e2, boolean bl2) {
        int n;
        Comparator comparator = this.backingMap.comparator();
        int n2 = n = comparator == null ? ((Comparable)e).compareTo(e2) : comparator.compare(e, e2);
        if (n <= 0) {
            return new TreeSet<E>(this.backingMap.subMap(e, bl, e2, bl2));
        }
        throw new IllegalArgumentException();
    }

    @Override
    public NavigableSet<E> headSet(E e, boolean bl) {
        Comparator comparator = this.backingMap.comparator();
        if (comparator == null) {
            ((Comparable)e).compareTo(e);
        } else {
            comparator.compare(e, e);
        }
        return new TreeSet<E>(this.backingMap.headMap(e, bl));
    }

    @Override
    public NavigableSet<E> tailSet(E e, boolean bl) {
        Comparator comparator = this.backingMap.comparator();
        if (comparator == null) {
            ((Comparable)e).compareTo(e);
        } else {
            comparator.compare(e, e);
        }
        return new TreeSet<E>(this.backingMap.tailMap(e, bl));
    }

    @Override
    public SortedSet<E> subSet(E e, E e2) {
        return this.subSet(e, true, e2, false);
    }

    @Override
    public SortedSet<E> headSet(E e) {
        return this.headSet(e, false);
    }

    @Override
    public SortedSet<E> tailSet(E e) {
        return this.tailSet(e, true);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.backingMap.comparator());
        int n = this.backingMap.size();
        objectOutputStream.writeInt(n);
        if (n > 0) {
            Iterator iterator = this.backingMap.keySet().iterator();
            while (iterator.hasNext()) {
                objectOutputStream.writeObject(iterator.next());
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        TreeMap<E, E> treeMap = new TreeMap<E, E>((Comparator)objectInputStream.readObject());
        int n = objectInputStream.readInt();
        if (n > 0) {
            Object object = objectInputStream.readObject();
            TreeMap.Entry<Object, Object> entry = new TreeMap.Entry<Object, Object>(object, object);
            treeMap.root = entry;
            treeMap.size = 1;
            for (int i = 1; i < n; ++i) {
                object = objectInputStream.readObject();
                TreeMap.Entry<Object, Object> entry2 = new TreeMap.Entry<Object, Object>(object, object);
                entry2.parent = entry;
                entry.right = entry2;
                ++treeMap.size;
                treeMap.balance(entry2);
                entry = entry2;
            }
        }
        this.backingMap = treeMap;
    }
}

