/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Arrays;
import java.util.Date;
import java.util.TimerTask;
import org.apache.harmony.luni.util.Msg;

public class Timer {
    private TimerImpl impl;
    private Object finalizer = new Object(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() {
            TimerImpl timerImpl = Timer.this.impl;
            synchronized (timerImpl) {
                Timer.this.impl.finished = true;
                Timer.this.impl.notifyAll();
            }
        }
    };

    public Timer(boolean bl) {
        this.impl = new TimerImpl(bl);
    }

    public Timer() {
        this.impl = new TimerImpl(false);
    }

    public Timer(String string, boolean bl) {
        this.impl = new TimerImpl(string, bl);
    }

    public Timer(String string) {
        this.impl = new TimerImpl(string, false);
    }

    public void cancel() {
        this.impl.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int purge() {
        int n;
        TimerImpl timerImpl = this.impl;
        synchronized (timerImpl) {
            n = this.impl.purge();
            this.impl.notifyAll();
        }
        return n;
    }

    public void schedule(TimerTask timerTask, Date date) {
        if (date.getTime() < 0L) {
            throw new IllegalArgumentException();
        }
        long l = date.getTime() - System.currentTimeMillis();
        this.scheduleImpl(timerTask, l < 0L ? 0L : l, -1L, false);
    }

    public void schedule(TimerTask timerTask, long l) {
        if (l < 0L) {
            throw new IllegalArgumentException();
        }
        this.scheduleImpl(timerTask, l, -1L, false);
    }

    public void schedule(TimerTask timerTask, long l, long l2) {
        if (l < 0L || l2 <= 0L) {
            throw new IllegalArgumentException();
        }
        this.scheduleImpl(timerTask, l, l2, false);
    }

    public void schedule(TimerTask timerTask, Date date, long l) {
        if (l <= 0L || date.getTime() < 0L) {
            throw new IllegalArgumentException();
        }
        long l2 = date.getTime() - System.currentTimeMillis();
        this.scheduleImpl(timerTask, l2 < 0L ? 0L : l2, l, false);
    }

    public void scheduleAtFixedRate(TimerTask timerTask, long l, long l2) {
        if (l < 0L || l2 <= 0L) {
            throw new IllegalArgumentException();
        }
        this.scheduleImpl(timerTask, l, l2, true);
    }

    public void scheduleAtFixedRate(TimerTask timerTask, Date date, long l) {
        if (l <= 0L || date.getTime() < 0L) {
            throw new IllegalArgumentException();
        }
        long l2 = date.getTime() - System.currentTimeMillis();
        this.scheduleImpl(timerTask, l2 < 0L ? 0L : l2, l, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleImpl(TimerTask timerTask, long l, long l2, boolean bl) {
        if (this.impl.cancelled) {
            throw new IllegalStateException(Msg.getString("K00f3"));
        }
        long l3 = l + System.currentTimeMillis();
        if (l3 < 0L) {
            throw new IllegalArgumentException(Msg.getString("K00f5"));
        }
        Object object = timerTask.lock;
        synchronized (object) {
            if (timerTask.isScheduled()) {
                throw new IllegalStateException(Msg.getString("K00f6"));
            }
            if (timerTask.cancelled) {
                throw new IllegalStateException(Msg.getString("K00f7"));
            }
            timerTask.when = l3;
            timerTask.period = l2;
            timerTask.fixedRate = bl;
        }
        object = this.impl;
        synchronized (object) {
            this.impl.insertTask(timerTask);
        }
    }

    private static final class TimerImpl
    extends Thread {
        private boolean cancelled;
        private boolean finished;
        private TimerHeap tasks = new TimerHeap();

        TimerImpl(boolean bl) {
            this.setDaemon(bl);
            this.start();
        }

        TimerImpl(String string, boolean bl) {
            this.setName(string);
            this.setDaemon(bl);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                TimerTask timerTask;
                TimerImpl timerImpl = this;
                synchronized (timerImpl) {
                    if (this.cancelled) {
                        return;
                    }
                    if (this.tasks.isEmpty()) {
                        if (this.finished) {
                            return;
                        }
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        continue;
                    }
                    long l = System.currentTimeMillis();
                    timerTask = this.tasks.minimum();
                    if (timerTask.cancelled) {
                        this.tasks.delete(0);
                        continue;
                    }
                    long l2 = timerTask.when - l;
                    if (l2 > 0L) {
                        try {
                            this.wait(l2);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        continue;
                    }
                    Object object = timerTask.lock;
                    synchronized (object) {
                        int n = 0;
                        if (this.tasks.minimum().when != timerTask.when) {
                            n = this.tasks.getTask(timerTask);
                        }
                        if (timerTask.cancelled) {
                            this.tasks.delete(this.tasks.getTask(timerTask));
                            continue;
                        }
                        timerTask.setScheduledTime(timerTask.when);
                        this.tasks.delete(n);
                        if (timerTask.period >= 0L) {
                            timerTask.when = timerTask.fixedRate ? (timerTask.when += timerTask.period) : System.currentTimeMillis() + timerTask.period;
                            this.insertTask(timerTask);
                        } else {
                            timerTask.when = 0L;
                        }
                    }
                }
                try {
                    timerTask.run();
                }
                catch (Exception exception) {
                }
            }
        }

        private void insertTask(TimerTask timerTask) {
            this.tasks.insert(timerTask);
            this.notifyAll();
        }

        public synchronized void cancel() {
            this.cancelled = true;
            this.tasks.reset();
            this.notify();
        }

        public int purge() {
            if (this.tasks.isEmpty()) {
                return 0;
            }
            this.tasks.deletedCancelledNumber = 0;
            this.tasks.deleteIfCancelled();
            return this.tasks.deletedCancelledNumber;
        }

        public static final class TimerHeap {
            private int DEFAULT_HEAP_SIZE = 256;
            private TimerTask[] timers = new TimerTask[this.DEFAULT_HEAP_SIZE];
            private int size = 0;
            private int deletedCancelledNumber = 0;

            public TimerTask minimum() {
                return this.timers[0];
            }

            public boolean isEmpty() {
                return this.size == 0;
            }

            public void insert(TimerTask timerTask) {
                if (this.timers.length == this.size) {
                    this.timers = Arrays.copyOf(this.timers, this.size * 2);
                }
                this.timers[this.size++] = timerTask;
                this.upHeap();
            }

            public void delete(int n) {
                if (n >= 0 && n < this.size) {
                    this.timers[n] = this.timers[--this.size];
                    this.timers[this.size] = null;
                    this.downHeap(n);
                }
            }

            private void upHeap() {
                int n = this.size - 1;
                int n2 = (n - 1) / 2;
                while (this.timers[n].when < this.timers[n2].when) {
                    TimerTask timerTask = this.timers[n];
                    this.timers[n] = this.timers[n2];
                    this.timers[n2] = timerTask;
                    n = n2;
                    n2 = (n - 1) / 2;
                }
            }

            private void downHeap(int n) {
                int n2 = n;
                int n3 = 2 * n2 + 1;
                while (n3 < this.size && this.size > 0) {
                    if (n3 + 1 < this.size && this.timers[n3 + 1].when < this.timers[n3].when) {
                        ++n3;
                    }
                    if (this.timers[n2].when < this.timers[n3].when) break;
                    TimerTask timerTask = this.timers[n2];
                    this.timers[n2] = this.timers[n3];
                    this.timers[n3] = timerTask;
                    n2 = n3;
                    n3 = 2 * n2 + 1;
                }
            }

            public void reset() {
                this.timers = new TimerTask[this.DEFAULT_HEAP_SIZE];
                this.size = 0;
            }

            public void adjustMinimum() {
                this.downHeap(0);
            }

            public void deleteIfCancelled() {
                for (int i = 0; i < this.size; ++i) {
                    if (!this.timers[i].cancelled) continue;
                    ++this.deletedCancelledNumber;
                    this.delete(i);
                    --i;
                }
            }

            private int getTask(TimerTask timerTask) {
                for (int i = 0; i < this.timers.length; ++i) {
                    if (this.timers[i] != timerTask) continue;
                    return i;
                }
                return -1;
            }
        }
    }
}

