/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.EmptyStackException;
import java.util.Vector;

public class Stack<E>
extends Vector<E> {
    private static final long serialVersionUID = 1224463164541339165L;

    public synchronized boolean empty() {
        return this.elementCount == 0;
    }

    public synchronized E peek() {
        try {
            return (E)this.elementData[this.elementCount - 1];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new EmptyStackException();
        }
    }

    public synchronized E pop() {
        if (this.elementCount == 0) {
            throw new EmptyStackException();
        }
        int n = --this.elementCount;
        Object object = this.elementData[n];
        this.elementData[n] = null;
        ++this.modCount;
        return (E)object;
    }

    public E push(E e) {
        this.addElement(e);
        return e;
    }

    public synchronized int search(Object object) {
        Object[] objectArray = this.elementData;
        int n = this.elementCount;
        if (object != null) {
            for (int i = n - 1; i >= 0; --i) {
                if (!object.equals(objectArray[i])) continue;
                return n - i;
            }
        } else {
            for (int i = n - 1; i >= 0; --i) {
                if (objectArray[i] != null) continue;
                return n - i;
            }
        }
        return -1;
    }
}

