/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.ServiceConfigurationError;
import java.util.Set;
import org.apache.harmony.luni.util.Msg;

public final class ServiceLoader<S>
implements Iterable<S> {
    private static final String META_INF_SERVICES = "META-INF/services/";
    private Set<URL> services;
    private Class<S> service;
    private ClassLoader loader;

    private ServiceLoader() {
    }

    public void reload() {
        ServiceLoader.internalLoad(this, this.service, this.loader);
    }

    @Override
    public Iterator<S> iterator() {
        return new ServiceIterator(this);
    }

    public static <S> ServiceLoader<S> load(Class<S> clazz, ClassLoader classLoader) {
        ServiceLoader<S> serviceLoader = new ServiceLoader<S>();
        serviceLoader.service = clazz;
        serviceLoader.loader = classLoader;
        serviceLoader.services = new HashSet<URL>();
        ServiceLoader.internalLoad(serviceLoader, clazz, classLoader);
        return serviceLoader;
    }

    private static void internalLoad(ServiceLoader<?> serviceLoader, Class<?> clazz, ClassLoader classLoader) {
        Enumeration<URL> enumeration = null;
        if (null == clazz) {
            serviceLoader.services.add(null);
            return;
        }
        try {
            enumeration = null == classLoader ? ClassLoader.getSystemResources(META_INF_SERVICES + clazz.getName()) : classLoader.getResources(META_INF_SERVICES + clazz.getName());
        }
        catch (IOException iOException) {
            return;
        }
        if (null != enumeration) {
            while (enumeration.hasMoreElements()) {
                URL uRL = enumeration.nextElement();
                serviceLoader.services.add(uRL);
            }
        }
    }

    public static <S> ServiceLoader<S> load(Class<S> clazz) {
        return ServiceLoader.load(clazz, Thread.currentThread().getContextClassLoader());
    }

    public static <S> ServiceLoader<S> loadInstalled(Class<S> clazz) {
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        if (null != classLoader) {
            while (null != classLoader.getParent()) {
                classLoader = classLoader.getParent();
            }
        }
        return ServiceLoader.load(clazz, classLoader);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("ServiceLoader of ");
        stringBuilder.append(this.service.getName());
        return stringBuilder.toString();
    }

    private class ServiceIterator
    implements Iterator<S> {
        private static final String SINGAL_SHARP = "#";
        private ClassLoader cl;
        private Class<S> service;
        private Set<URL> services;
        private BufferedReader reader = null;
        private boolean isRead = false;
        private Queue<String> que;

        public ServiceIterator(ServiceLoader<S> serviceLoader2) {
            this.cl = serviceLoader2.loader;
            this.service = serviceLoader2.service;
            this.services = serviceLoader2.services;
        }

        @Override
        public boolean hasNext() {
            if (!this.isRead) {
                this.readClass();
            }
            return null != this.que && !this.que.isEmpty();
        }

        @Override
        public S next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            String string = this.que.remove();
            try {
                Object s = null == this.cl ? this.service.cast(Class.forName(string).newInstance()) : this.service.cast(this.cl.loadClass(string).newInstance());
                return s;
            }
            catch (Exception exception) {
                throw new ServiceConfigurationError(Msg.getString("KB005", string), exception);
            }
        }

        private void readClass() {
            if (null == this.services) {
                this.isRead = true;
                return;
            }
            Iterator<URL> iterator = this.services.iterator();
            this.que = new LinkedList<String>();
            while (iterator.hasNext()) {
                URL uRL = iterator.next();
                if (null == uRL) {
                    throw new NullPointerException();
                }
                try {
                    String string;
                    this.reader = new BufferedReader(new InputStreamReader(uRL.openStream(), "UTF-8"));
                    while (null != (string = this.reader.readLine())) {
                        String[] stringArray = string.trim().split(SINGAL_SHARP);
                        if (0 == stringArray.length || (string = stringArray[0].trim()).startsWith(SINGAL_SHARP) || 0 == string.length()) continue;
                        char[] cArray = string.toCharArray();
                        for (int i = 0; i < cArray.length; ++i) {
                            if (Character.isJavaIdentifierPart(cArray[i]) || cArray[i] == '.') continue;
                            throw new ServiceConfigurationError(Msg.getString("KB006", cArray[i]));
                        }
                        if (this.que.contains(string)) continue;
                        this.que.add(string);
                    }
                }
                catch (Exception exception) {
                    throw new ServiceConfigurationError(Msg.getString("KB006", uRL), exception);
                }
            }
            this.isRead = true;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

