/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.harmony.kernel.vm.VM;
import org.apache.harmony.luni.util.Msg;

public abstract class ResourceBundle {
    private static final String UNDER_SCORE = "_";
    private static final String EMPTY_STRING = "";
    protected ResourceBundle parent;
    private Locale locale;
    private long lastLoadTime = 0L;
    private static final ResourceBundle MISSING = new MissingBundle();
    private static final ResourceBundle MISSINGBASE = new MissingBundle();
    private static final WeakHashMap<Object, Hashtable<String, ResourceBundle>> cache = new WeakHashMap();

    public static final ResourceBundle getBundle(String string) throws MissingResourceException {
        ClassLoader classLoader = VM.callerClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        return ResourceBundle.getBundleImpl(string, Locale.getDefault(), classLoader);
    }

    public static final ResourceBundle getBundle(String string, Locale locale) {
        ClassLoader classLoader = VM.callerClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        return ResourceBundle.getBundleImpl(string, locale, classLoader);
    }

    public static ResourceBundle getBundle(String string, Locale locale, ClassLoader classLoader) throws MissingResourceException {
        if (classLoader == null) {
            throw new NullPointerException();
        }
        if (string != null) {
            ResourceBundle resourceBundle;
            if (!locale.equals(Locale.getDefault()) && (resourceBundle = ResourceBundle.handleGetBundle(string, UNDER_SCORE + locale, false, classLoader)) != null) {
                return resourceBundle;
            }
            resourceBundle = ResourceBundle.handleGetBundle(string, UNDER_SCORE + Locale.getDefault(), true, classLoader);
            if (resourceBundle != null) {
                return resourceBundle;
            }
            throw new MissingResourceException(Msg.getString("KA029", string, locale), string + '_' + locale, EMPTY_STRING);
        }
        throw new NullPointerException();
    }

    public static final ResourceBundle getBundle(String string, Control control) {
        return ResourceBundle.getBundle(string, Locale.getDefault(), ResourceBundle.getLoader(), control);
    }

    public static final ResourceBundle getBundle(String string, Locale locale, Control control) {
        return ResourceBundle.getBundle(string, locale, ResourceBundle.getLoader(), control);
    }

    private static ClassLoader getLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                ClassLoader classLoader = this.getClass().getClassLoader();
                if (null == classLoader) {
                    classLoader = ClassLoader.getSystemClassLoader();
                }
                return classLoader;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResourceBundle getBundle(String string, Locale locale, ClassLoader classLoader, Control control) {
        ResourceBundle resourceBundle;
        Hashtable<String, ResourceBundle> hashtable;
        boolean bl = false;
        String string2 = control.toBundleName(string, locale);
        Object object = classLoader != null ? classLoader : "null";
        Object object2 = cache;
        synchronized (object2) {
            hashtable = cache.get(object);
            if (hashtable == null) {
                hashtable = new Hashtable();
                cache.put(object, hashtable);
            }
        }
        object2 = hashtable.get(string2);
        if (object2 != null) {
            long l = control.getTimeToLive(string, locale);
            if (l != -1L && (l == 0L || l == -2L || l + ((ResourceBundle)object2).lastLoadTime > System.currentTimeMillis())) {
                if (MISSING == object2) {
                    throw new MissingResourceException(Msg.getString("KA029", string2, locale), string2 + '_' + locale, EMPTY_STRING);
                }
                return object2;
            }
            bl = true;
        }
        if (null != (resourceBundle = ResourceBundle.processGetBundle(string, locale, classLoader, control, bl, (ResourceBundle)object2))) {
            hashtable.put(string2, resourceBundle);
            resourceBundle.lastLoadTime = System.currentTimeMillis();
            return resourceBundle;
        }
        hashtable.put(string2, MISSING);
        throw new MissingResourceException(Msg.getString("KA029", string2, locale), string2 + '_' + locale, EMPTY_STRING);
    }

    private static ResourceBundle processGetBundle(String string, Locale locale, ClassLoader classLoader, Control control, boolean bl, ResourceBundle resourceBundle) {
        List<Locale> list = control.getCandidateLocales(string, locale);
        if (null == list) {
            throw new IllegalArgumentException();
        }
        List<String> list2 = control.getFormats(string);
        ResourceBundle resourceBundle2 = null;
        ResourceBundle resourceBundle3 = null;
        ResourceBundle resourceBundle4 = null;
        Object object = list.iterator();
        block6: while (object.hasNext()) {
            Locale locale2 = object.next();
            for (String string2 : list2) {
                try {
                    if (bl) {
                        resourceBundle4 = control.newBundle(string, locale2, string2, classLoader, control.needsReload(string, locale2, string2, classLoader, resourceBundle, System.currentTimeMillis()));
                    } else {
                        try {
                            resourceBundle4 = control.newBundle(string, locale2, string2, classLoader, false);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {}
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (null != resourceBundle4) {
                    if (null != resourceBundle3) {
                        resourceBundle3.setParent(resourceBundle4);
                        resourceBundle3 = resourceBundle4;
                    } else if (null == resourceBundle2) {
                        resourceBundle3 = resourceBundle2 = resourceBundle4;
                    }
                }
                if (null == resourceBundle4) continue;
                continue block6;
            }
        }
        if ((null == resourceBundle2 || Locale.ROOT.equals(resourceBundle2.getLocale()) && (list.size() != 1 || !list.contains(Locale.ROOT))) && null != (object = control.getFallbackLocale(string, locale))) {
            resourceBundle2 = ResourceBundle.processGetBundle(string, (Locale)object, classLoader, control, bl, resourceBundle);
        }
        return resourceBundle2;
    }

    private static ResourceBundle getBundleImpl(String string, Locale locale, ClassLoader classLoader) throws MissingResourceException {
        if (string != null) {
            ResourceBundle resourceBundle;
            String string2;
            if (!locale.equals(Locale.getDefault())) {
                string2 = locale.toString();
                if (string2.length() > 0) {
                    string2 = UNDER_SCORE + string2;
                }
                if ((resourceBundle = ResourceBundle.handleGetBundle(string, string2, false, classLoader)) != null) {
                    return resourceBundle;
                }
            }
            if ((string2 = Locale.getDefault().toString()).length() > 0) {
                string2 = UNDER_SCORE + string2;
            }
            if ((resourceBundle = ResourceBundle.handleGetBundle(string, string2, true, classLoader)) != null) {
                return resourceBundle;
            }
            throw new MissingResourceException(Msg.getString("KA029", string, locale), string + '_' + locale, EMPTY_STRING);
        }
        throw new NullPointerException();
    }

    public abstract Enumeration<String> getKeys();

    public Locale getLocale() {
        return this.locale;
    }

    public final Object getObject(String string) {
        ResourceBundle resourceBundle;
        ResourceBundle resourceBundle2 = this;
        do {
            Object object;
            if ((object = resourceBundle2.handleGetObject(string)) != null) {
                return object;
            }
            resourceBundle = resourceBundle2;
        } while ((resourceBundle2 = resourceBundle2.parent) != null);
        throw new MissingResourceException(Msg.getString("KA029", resourceBundle.getClass().getName(), string), resourceBundle.getClass().getName(), string);
    }

    public final String getString(String string) {
        return (String)this.getObject(string);
    }

    public final String[] getStringArray(String string) {
        return (String[])this.getObject(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ResourceBundle handleGetBundle(String string, String string2, boolean bl, final ClassLoader classLoader) {
        Object object;
        Object object2;
        Hashtable<String, ResourceBundle> hashtable;
        ResourceBundle resourceBundle = null;
        String string3 = string + string2;
        Object object3 = classLoader != null ? classLoader : "null";
        Object object4 = cache;
        synchronized (object4) {
            hashtable = cache.get(object3);
            if (hashtable == null) {
                hashtable = new Hashtable();
                cache.put(object3, hashtable);
            }
        }
        object4 = hashtable.get(string3);
        if (object4 != null) {
            if (object4 == MISSINGBASE) {
                return null;
            }
            if (object4 == MISSING) {
                if (!bl) {
                    return null;
                }
                String string4 = ResourceBundle.strip(string2);
                if (string4 == null) {
                    return null;
                }
                return ResourceBundle.handleGetBundle(string, string4, bl, classLoader);
            }
            return object4;
        }
        try {
            object2 = Class.forName(string3, true, classLoader);
            if (ResourceBundle.class.isAssignableFrom((Class<?>)object2)) {
                resourceBundle = (ResourceBundle)((Class)object2).newInstance();
            }
        }
        catch (LinkageError linkageError) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (resourceBundle != null) {
            super.setLocale(string2);
        } else {
            object2 = string3.replace('.', '/');
            object = AccessController.doPrivileged(new PrivilegedAction<InputStream>((String)object2){
                final /* synthetic */ String val$fileName;
                {
                    this.val$fileName = string;
                }

                @Override
                public InputStream run() {
                    return classLoader == null ? ClassLoader.getSystemResourceAsStream(this.val$fileName + ".properties") : classLoader.getResourceAsStream(this.val$fileName + ".properties");
                }
            });
            if (object != null) {
                try {
                    try {
                        resourceBundle = new PropertyResourceBundle((InputStream)object);
                    }
                    finally {
                        ((InputStream)object).close();
                    }
                    resourceBundle.setLocale(string2);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        object2 = ResourceBundle.strip(string2);
        if (resourceBundle != null) {
            if (object2 != null && (object = ResourceBundle.handleGetBundle(string, (String)object2, true, classLoader)) != null) {
                resourceBundle.setParent((ResourceBundle)object);
            }
            hashtable.put(string3, resourceBundle);
            return resourceBundle;
        }
        if (object2 != null && (bl || ((String)object2).length() > 0) && (resourceBundle = ResourceBundle.handleGetBundle(string, (String)object2, bl, classLoader)) != null) {
            hashtable.put(string3, resourceBundle);
            return resourceBundle;
        }
        hashtable.put(string3, bl ? MISSINGBASE : MISSING);
        return null;
    }

    protected abstract Object handleGetObject(String var1);

    protected void setParent(ResourceBundle resourceBundle) {
        this.parent = resourceBundle;
    }

    private static String strip(String string) {
        int n = string.lastIndexOf(95);
        if (n != -1) {
            return string.substring(0, n);
        }
        return null;
    }

    private void setLocale(Locale locale) {
        this.locale = locale;
    }

    private void setLocale(String string) {
        String string2 = EMPTY_STRING;
        String string3 = EMPTY_STRING;
        String string4 = EMPTY_STRING;
        if (string.length() > 1) {
            int n = string.indexOf(95, 1);
            if (n == -1) {
                n = string.length();
            }
            string2 = string.substring(1, n);
            if (n + 1 < string.length()) {
                int n2 = n;
                if ((n = string.indexOf(95, n + 1)) == -1) {
                    n = string.length();
                }
                string3 = string.substring(n2 + 1, n);
                if (n + 1 < string.length()) {
                    string4 = string.substring(n + 1, string.length());
                }
            }
        }
        this.locale = new Locale(string2, string3, string4);
    }

    public static final void clearCache() {
        cache.remove(ClassLoader.getSystemClassLoader());
    }

    public static final void clearCache(ClassLoader classLoader) {
        if (null == classLoader) {
            throw new NullPointerException();
        }
        cache.remove(classLoader);
    }

    public boolean containsKey(String string) {
        if (null == string) {
            throw new NullPointerException();
        }
        return this.keySet().contains(string);
    }

    public Set<String> keySet() {
        HashSet<String> hashSet = new HashSet<String>();
        Enumeration<String> enumeration = this.getKeys();
        while (enumeration.hasMoreElements()) {
            hashSet.add(enumeration.nextElement());
        }
        return hashSet;
    }

    protected Set<String> handleKeySet() {
        Set<String> set = this.keySet();
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : set) {
            if (null == this.handleGetObject(string)) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    public static class Control {
        static List<String> listDefault = new ArrayList<String>();
        static List<String> listClass = new ArrayList<String>();
        static List<String> listProperties = new ArrayList<String>();
        static String JAVACLASS = "java.class";
        static String JAVAPROPERTIES = "java.properties";
        public static final List<String> FORMAT_DEFAULT;
        public static final List<String> FORMAT_CLASS;
        public static final List<String> FORMAT_PROPERTIES;
        public static final long TTL_DONT_CACHE = -1L;
        public static final long TTL_NO_EXPIRATION_CONTROL = -2L;
        private static final Control FORMAT_PROPERTIES_CONTROL;
        private static final Control FORMAT_CLASS_CONTROL;
        private static final Control FORMAT_DEFAULT_CONTROL;
        List<String> format;

        protected Control() {
            listClass = new ArrayList<String>();
            listClass.add(JAVACLASS);
            listClass.add(JAVAPROPERTIES);
            this.format = Collections.unmodifiableList(listClass);
        }

        public static final Control getControl(List<String> list) {
            switch (list.size()) {
                case 1: {
                    if (list.contains(JAVACLASS)) {
                        return FORMAT_CLASS_CONTROL;
                    }
                    if (!list.contains(JAVAPROPERTIES)) break;
                    return FORMAT_PROPERTIES_CONTROL;
                }
                case 2: {
                    if (!((Object)list).equals(FORMAT_DEFAULT)) break;
                    return FORMAT_DEFAULT_CONTROL;
                }
            }
            throw new IllegalArgumentException();
        }

        public static final Control getNoFallbackControl(List<String> list) {
            switch (list.size()) {
                case 1: {
                    if (list.contains(JAVACLASS)) {
                        return NoFallbackControl.NOFALLBACK_FORMAT_CLASS_CONTROL;
                    }
                    if (!list.contains(JAVAPROPERTIES)) break;
                    return NoFallbackControl.NOFALLBACK_FORMAT_PROPERTIES_CONTROL;
                }
                case 2: {
                    if (!((Object)list).equals(FORMAT_DEFAULT)) break;
                    return NoFallbackControl.NOFALLBACK_FORMAT_DEFAULT_CONTROL;
                }
            }
            throw new IllegalArgumentException();
        }

        public List<Locale> getCandidateLocales(String string, Locale locale) {
            if (null == string || null == locale) {
                throw new NullPointerException();
            }
            ArrayList<Locale> arrayList = new ArrayList<Locale>();
            String string2 = locale.getLanguage();
            String string3 = locale.getCountry();
            String string4 = locale.getVariant();
            if (!ResourceBundle.EMPTY_STRING.equals(string4)) {
                arrayList.add(new Locale(string2, string3, string4));
            }
            if (!ResourceBundle.EMPTY_STRING.equals(string3)) {
                arrayList.add(new Locale(string2, string3));
            }
            if (!ResourceBundle.EMPTY_STRING.equals(string2)) {
                arrayList.add(new Locale(string2));
            }
            arrayList.add(Locale.ROOT);
            return arrayList;
        }

        public List<String> getFormats(String string) {
            if (null == string) {
                throw new NullPointerException();
            }
            return this.format;
        }

        public Locale getFallbackLocale(String string, Locale locale) {
            if (null == string || null == locale) {
                throw new NullPointerException();
            }
            if (Locale.getDefault() != locale) {
                return Locale.getDefault();
            }
            return null;
        }

        public ResourceBundle newBundle(String string, Locale locale, String string2, ClassLoader classLoader, boolean bl) throws IllegalAccessException, InstantiationException, IOException {
            if (null == string2 || null == classLoader) {
                throw new NullPointerException();
            }
            InputStream inputStream = null;
            final String string3 = this.toBundleName(string, locale);
            final ClassLoader classLoader2 = classLoader;
            Class clazz = null;
            if (JAVACLASS == string2) {
                clazz = (Class)AccessController.doPrivileged(new PrivilegedAction<Class<?>>(){

                    @Override
                    public Class<?> run() {
                        try {
                            return classLoader2.loadClass(string3);
                        }
                        catch (Exception exception) {
                            return null;
                        }
                        catch (NoClassDefFoundError noClassDefFoundError) {
                            return null;
                        }
                    }
                });
                if (null == clazz) {
                    return null;
                }
                try {
                    ResourceBundle resourceBundle = (ResourceBundle)clazz.newInstance();
                    resourceBundle.setLocale(locale);
                    return resourceBundle;
                }
                catch (NullPointerException nullPointerException) {
                    return null;
                }
            }
            if (JAVAPROPERTIES == string2) {
                final String string4 = this.toResourceName(string3, "properties");
                if (bl) {
                    URL uRL = null;
                    try {
                        uRL = classLoader.getResource(string4);
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    if (null != uRL) {
                        URLConnection uRLConnection = uRL.openConnection();
                        uRLConnection.setUseCaches(false);
                        inputStream = uRLConnection.getInputStream();
                    }
                } else {
                    try {
                        inputStream = AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

                            @Override
                            public InputStream run() {
                                return classLoader2.getResourceAsStream(string4);
                            }
                        });
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
                if (inputStream != null) {
                    PropertyResourceBundle propertyResourceBundle;
                    try {
                        propertyResourceBundle = new PropertyResourceBundle(inputStream);
                        ((ResourceBundle)propertyResourceBundle).setLocale(locale);
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        return null;
                    }
                    return propertyResourceBundle;
                }
                return null;
            }
            throw new IllegalArgumentException();
        }

        public long getTimeToLive(String string, Locale locale) {
            if (null == string || null == locale) {
                throw new NullPointerException();
            }
            return -2L;
        }

        public boolean needsReload(String string, Locale locale, String string2, ClassLoader classLoader, ResourceBundle resourceBundle, long l) {
            String string3;
            long l2;
            String string4;
            URL uRL;
            if (null == resourceBundle) {
                throw new NullPointerException();
            }
            String string5 = this.toBundleName(string, locale);
            String string6 = string2;
            if (JAVACLASS == string2) {
                string6 = "class";
            }
            if (JAVAPROPERTIES == string2) {
                string6 = "properties";
            }
            return null != (uRL = classLoader.getResource(string4 = this.toResourceName(string5, string6))) && (l2 = new File(string3 = uRL.getFile()).lastModified()) > l;
        }

        public String toBundleName(String string, Locale locale) {
            if (null == string) {
                throw new NullPointerException();
            }
            StringBuilder stringBuilder = new StringBuilder();
            StringBuilder stringBuilder2 = new StringBuilder();
            stringBuilder.append(string);
            if (!locale.getLanguage().equals(ResourceBundle.EMPTY_STRING)) {
                stringBuilder.append(ResourceBundle.UNDER_SCORE);
                stringBuilder.append(locale.getLanguage());
            } else {
                stringBuilder2.append(ResourceBundle.UNDER_SCORE);
            }
            if (!locale.getCountry().equals(ResourceBundle.EMPTY_STRING)) {
                stringBuilder.append((CharSequence)stringBuilder2);
                stringBuilder.append(ResourceBundle.UNDER_SCORE);
                stringBuilder.append(locale.getCountry());
                stringBuilder2 = new StringBuilder();
            } else {
                stringBuilder2.append(ResourceBundle.UNDER_SCORE);
            }
            if (!locale.getVariant().equals(ResourceBundle.EMPTY_STRING)) {
                stringBuilder.append((CharSequence)stringBuilder2);
                stringBuilder.append(ResourceBundle.UNDER_SCORE);
                stringBuilder.append(locale.getVariant());
            }
            return stringBuilder.toString();
        }

        public final String toResourceName(String string, String string2) {
            if (null == string2) {
                throw new NullPointerException();
            }
            StringBuilder stringBuilder = new StringBuilder(string.replace('.', '/'));
            stringBuilder.append('.');
            stringBuilder.append(string2);
            return stringBuilder.toString();
        }

        static {
            listDefault.add(JAVACLASS);
            listDefault.add(JAVAPROPERTIES);
            listClass.add(JAVACLASS);
            listProperties.add(JAVAPROPERTIES);
            FORMAT_DEFAULT = Collections.unmodifiableList(listDefault);
            FORMAT_CLASS = Collections.unmodifiableList(listClass);
            FORMAT_PROPERTIES = Collections.unmodifiableList(listProperties);
            FORMAT_PROPERTIES_CONTROL = new SimpleControl(JAVAPROPERTIES);
            FORMAT_CLASS_CONTROL = new SimpleControl(JAVACLASS);
            FORMAT_DEFAULT_CONTROL = new Control();
        }
    }

    private static class SimpleControl
    extends Control {
        public SimpleControl(String string) {
            listClass = new ArrayList();
            listClass.add(string);
            this.format = Collections.unmodifiableList(listClass);
        }
    }

    private static class NoFallbackControl
    extends Control {
        static final Control NOFALLBACK_FORMAT_PROPERTIES_CONTROL = new NoFallbackControl(JAVAPROPERTIES);
        static final Control NOFALLBACK_FORMAT_CLASS_CONTROL = new NoFallbackControl(JAVACLASS);
        static final Control NOFALLBACK_FORMAT_DEFAULT_CONTROL = new NoFallbackControl(listDefault);

        public NoFallbackControl(String string) {
            listClass = new ArrayList();
            listClass.add(string);
            this.format = Collections.unmodifiableList(listClass);
        }

        public NoFallbackControl(List<String> list) {
            this.format = list;
        }

        @Override
        public Locale getFallbackLocale(String string, Locale locale) {
            if (null == string || null == locale) {
                throw new NullPointerException();
            }
            return null;
        }
    }

    static class MissingBundle
    extends ResourceBundle {
        MissingBundle() {
        }

        @Override
        public Enumeration<String> getKeys() {
            return null;
        }

        @Override
        public Object handleGetObject(String string) {
            return null;
        }
    }
}

