/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.PropertyPermission;

class PropertyPermissionCollection
extends PermissionCollection {
    private static final long serialVersionUID = 7015263904581634791L;
    Hashtable<String, Permission> permissions = new Hashtable(30);
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("permissions", Hashtable.class), new ObjectStreamField("all_allowed", Boolean.TYPE)};

    PropertyPermissionCollection() {
    }

    @Override
    public void add(Permission permission) {
        if (!this.isReadOnly()) {
            Permission permission2 = this.permissions.put(permission.getName(), permission);
            if (permission2 != null && !permission2.getActions().equals(permission.getActions())) {
                PropertyPermission propertyPermission = new PropertyPermission(permission.getName(), "read,write");
                this.permissions.put(permission.getName(), propertyPermission);
            }
        } else {
            throw new IllegalStateException();
        }
    }

    @Override
    public Enumeration<Permission> elements() {
        return this.permissions.elements();
    }

    @Override
    public boolean implies(Permission permission) {
        Enumeration<Permission> enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            if (!enumeration.nextElement().implies(permission)) continue;
            return true;
        }
        return permission.getActions().equals("read,write") && this.implies(new PropertyPermission(permission.getName(), "read")) && this.implies(new PropertyPermission(permission.getName(), "write"));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("permissions", this.permissions);
        putField.put("all_allowed", false);
        objectOutputStream.writeFields();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        this.permissions = (Hashtable)getField.get("permissions", null);
    }
}

