/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.security.AccessController;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.InvalidPropertiesFormatException;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.harmony.luni.util.PriviAction;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class Properties
extends Hashtable<Object, Object> {
    private static final long serialVersionUID = 4112578634029874840L;
    private transient DocumentBuilder builder = null;
    private static final String PROP_DTD_NAME = "http://java.sun.com/dtd/properties.dtd";
    private static final String PROP_DTD = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>    <!ELEMENT properties (comment?, entry*) >    <!ATTLIST properties version CDATA #FIXED \"1.0\" >    <!ELEMENT comment (#PCDATA) >    <!ELEMENT entry (#PCDATA) >    <!ATTLIST entry key CDATA #REQUIRED >";
    protected Properties defaults;
    private static final int NONE = 0;
    private static final int SLASH = 1;
    private static final int UNICODE = 2;
    private static final int CONTINUE = 3;
    private static final int KEY_DONE = 4;
    private static final int IGNORE = 5;
    private static String lineSeparator;

    public Properties() {
    }

    public Properties(Properties properties) {
        this.defaults = properties;
    }

    private void dumpString(StringBuilder stringBuilder, String string, boolean bl) {
        int n = 0;
        if (!bl && n < string.length() && string.charAt(n) == ' ') {
            stringBuilder.append("\\ ");
            ++n;
        }
        while (n < string.length()) {
            char c = string.charAt(n);
            switch (c) {
                case '\t': {
                    stringBuilder.append("\\t");
                    break;
                }
                case '\n': {
                    stringBuilder.append("\\n");
                    break;
                }
                case '\f': {
                    stringBuilder.append("\\f");
                    break;
                }
                case '\r': {
                    stringBuilder.append("\\r");
                    break;
                }
                default: {
                    if ("\\#!=:".indexOf(c) >= 0 || bl && c == ' ') {
                        stringBuilder.append('\\');
                    }
                    if (c >= ' ' && c <= '~') {
                        stringBuilder.append(c);
                        break;
                    }
                    String string2 = Integer.toHexString(c);
                    stringBuilder.append("\\u");
                    for (int i = 0; i < 4 - string2.length(); ++i) {
                        stringBuilder.append("0");
                    }
                    stringBuilder.append(string2);
                }
            }
            ++n;
        }
    }

    public String getProperty(String string) {
        String string2;
        Object v = super.get(string);
        String string3 = string2 = v instanceof String ? (String)v : null;
        if (string2 == null && this.defaults != null) {
            string2 = this.defaults.getProperty(string);
        }
        return string2;
    }

    public String getProperty(String string, String string2) {
        String string3;
        Object v = super.get(string);
        String string4 = string3 = v instanceof String ? (String)v : null;
        if (string3 == null && this.defaults != null) {
            string3 = this.defaults.getProperty(string);
        }
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    public void list(PrintStream printStream) {
        if (printStream == null) {
            throw new NullPointerException();
        }
        StringBuffer stringBuffer = new StringBuffer(80);
        Enumeration<?> enumeration = this.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            stringBuffer.append(string);
            stringBuffer.append('=');
            String string2 = (String)super.get(string);
            Properties properties = this.defaults;
            while (string2 == null) {
                string2 = (String)properties.get(string);
                properties = properties.defaults;
            }
            if (string2.length() > 40) {
                stringBuffer.append(string2.substring(0, 37));
                stringBuffer.append("...");
            } else {
                stringBuffer.append(string2);
            }
            printStream.println(stringBuffer.toString());
            stringBuffer.setLength(0);
        }
    }

    public void list(PrintWriter printWriter) {
        if (printWriter == null) {
            throw new NullPointerException();
        }
        StringBuffer stringBuffer = new StringBuffer(80);
        Enumeration<?> enumeration = this.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            stringBuffer.append(string);
            stringBuffer.append('=');
            String string2 = (String)super.get(string);
            Properties properties = this.defaults;
            while (string2 == null) {
                string2 = (String)properties.get(string);
                properties = properties.defaults;
            }
            if (string2.length() > 40) {
                stringBuffer.append(string2.substring(0, 37));
                stringBuffer.append("...");
            } else {
                stringBuffer.append(string2);
            }
            printWriter.println(stringBuffer.toString());
            stringBuffer.setLength(0);
        }
    }

    public synchronized void load(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new NullPointerException();
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        bufferedInputStream.mark(Integer.MAX_VALUE);
        boolean bl = this.isAscii(bufferedInputStream);
        bufferedInputStream.reset();
        if (bl) {
            this.load(new InputStreamReader((InputStream)bufferedInputStream, "ISO8859-1"));
        } else {
            this.load(new InputStreamReader(bufferedInputStream));
        }
    }

    private boolean isAscii(BufferedInputStream bufferedInputStream) throws IOException {
        byte by;
        while ((by = (byte)bufferedInputStream.read()) != -1) {
            if (by == 35 || by == 10 || by == 61) {
                return true;
            }
            if (by != 21) continue;
            return false;
        }
        return false;
    }

    public synchronized void load(Reader reader) throws IOException {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        char[] cArray = new char[40];
        int n4 = 0;
        int n5 = -1;
        boolean bl = true;
        char[] cArray2 = new char[256];
        int n6 = 0;
        int n7 = 0;
        block17: while (true) {
            Object object;
            if (n7 == n6) {
                n6 = reader.read(cArray2);
                if (n6 == -1) break;
                n7 = 0;
            }
            int n8 = cArray2[n7++];
            if (n4 == cArray.length) {
                object = new char[cArray.length * 2];
                System.arraycopy(cArray, 0, object, 0, n4);
                cArray = object;
            }
            if (n == 2) {
                int n9 = Character.digit((char)n8, 16);
                if (n9 >= 0) {
                    n2 = (n2 << 4) + n9;
                    if (++n3 < 4) {
                        continue;
                    }
                } else {
                    throw new IllegalArgumentException();
                }
                n = 0;
                cArray[n4++] = (char)n2;
                if (n8 != 10) continue;
            }
            if (n == 1) {
                n = 0;
                switch (n8) {
                    case 13: {
                        n = 3;
                        continue block17;
                    }
                    case 10: {
                        n = 5;
                        continue block17;
                    }
                    case 98: {
                        n8 = 8;
                        break;
                    }
                    case 102: {
                        n8 = 12;
                        break;
                    }
                    case 110: {
                        n8 = 10;
                        break;
                    }
                    case 114: {
                        n8 = 13;
                        break;
                    }
                    case 116: {
                        n8 = 9;
                        break;
                    }
                    case 117: {
                        n = 2;
                        n3 = 0;
                        n2 = 0;
                        continue block17;
                    }
                }
            } else {
                switch (n8) {
                    case 33: 
                    case 35: {
                        if (!bl) break;
                        do {
                            if (n7 != n6) continue;
                            n6 = reader.read(cArray2);
                            if (n6 == -1) {
                                n7 = -1;
                                continue block17;
                            }
                            n7 = 0;
                        } while ((n8 = cArray2[n7++]) != 13 && n8 != 10);
                        continue block17;
                    }
                    case 10: {
                        if (n == 3) {
                            n = 5;
                            continue block17;
                        }
                    }
                    case 13: {
                        n = 0;
                        bl = true;
                        if (n4 > 0) {
                            if (n5 == -1) {
                                n5 = n4;
                            }
                            object = new String(cArray, 0, n4);
                            this.put(((String)object).substring(0, n5), ((String)object).substring(n5));
                        }
                        n5 = -1;
                        n4 = 0;
                        continue block17;
                    }
                    case 92: {
                        if (n == 4) {
                            n5 = n4;
                        }
                        n = 1;
                        continue block17;
                    }
                    case 58: 
                    case 61: {
                        if (n5 != -1) break;
                        n = 0;
                        n5 = n4;
                        continue block17;
                    }
                }
                if (Character.isWhitespace((char)n8)) {
                    if (n == 3) {
                        n = 5;
                    }
                    if (n4 == 0 || n4 == n5 || n == 5) continue;
                    if (n5 == -1) {
                        n = 4;
                        continue;
                    }
                }
                if (n == 5 || n == 3) {
                    n = 0;
                }
            }
            bl = false;
            if (n == 4) {
                n5 = n4;
                n = 0;
            }
            cArray[n4++] = n8;
        }
        if (n5 == -1 && n4 > 0) {
            n5 = n4;
        }
        if (n5 >= 0) {
            String string = new String(cArray, 0, n4);
            this.put(string.substring(0, n5), string.substring(n5));
        }
    }

    public Enumeration<?> propertyNames() {
        if (this.defaults == null) {
            return this.keys();
        }
        Hashtable hashtable = new Hashtable(this.defaults.size() + this.size());
        Enumeration<Object> enumeration = this.defaults.propertyNames();
        while (enumeration.hasMoreElements()) {
            hashtable.put(enumeration.nextElement(), hashtable);
        }
        enumeration = this.keys();
        while (enumeration.hasMoreElements()) {
            hashtable.put(enumeration.nextElement(), hashtable);
        }
        return hashtable.keys();
    }

    public Set<String> stringPropertyNames() {
        HashSet<String> hashSet = new HashSet<String>();
        Enumeration<?> enumeration = this.propertyNames();
        while (enumeration.hasMoreElements()) {
            Object obj = enumeration.nextElement();
            if (!(obj instanceof String)) continue;
            Object v = this.get(obj);
            if (v == null) {
                v = this.defaults.get(obj);
            }
            if (!(v instanceof String)) continue;
            hashSet.add((String)obj);
        }
        return Collections.unmodifiableSet(hashSet);
    }

    @Deprecated
    public void save(OutputStream outputStream, String string) {
        try {
            this.store(outputStream, string);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Object setProperty(String string, String string2) {
        return this.put(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(OutputStream outputStream, String string) throws IOException {
        String string2 = new Date().toString();
        Properties properties = this;
        synchronized (properties) {
            if (lineSeparator == null) {
                lineSeparator = (String)AccessController.doPrivileged(new PriviAction("line.separator"));
            }
            StringBuilder stringBuilder = new StringBuilder(200);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "ISO8859_1");
            if (string != null) {
                outputStreamWriter.write("#");
                outputStreamWriter.write(string);
                outputStreamWriter.write(lineSeparator);
            }
            outputStreamWriter.write("#");
            outputStreamWriter.write(string2);
            outputStreamWriter.write(lineSeparator);
            for (Map.Entry entry : this.entrySet()) {
                String string3 = (String)entry.getKey();
                this.dumpString(stringBuilder, string3, true);
                stringBuilder.append('=');
                this.dumpString(stringBuilder, (String)entry.getValue(), false);
                stringBuilder.append(lineSeparator);
                outputStreamWriter.write(stringBuilder.toString());
                stringBuilder.setLength(0);
            }
            outputStreamWriter.flush();
        }
    }

    public synchronized void store(Writer writer, String string) throws IOException {
        if (lineSeparator == null) {
            lineSeparator = (String)AccessController.doPrivileged(new PriviAction("line.separator"));
        }
        StringBuilder stringBuilder = new StringBuilder(200);
        if (string != null) {
            writer.write("#");
            writer.write(string);
            writer.write(lineSeparator);
        }
        writer.write("#");
        writer.write(new Date().toString());
        writer.write(lineSeparator);
        for (Map.Entry entry : this.entrySet()) {
            String string2 = (String)entry.getKey();
            this.dumpString(stringBuilder, string2, true);
            stringBuilder.append('=');
            this.dumpString(stringBuilder, (String)entry.getValue(), false);
            stringBuilder.append(lineSeparator);
            writer.write(stringBuilder.toString());
            stringBuilder.setLength(0);
        }
        writer.flush();
    }

    public synchronized void loadFromXML(InputStream inputStream) throws IOException, InvalidPropertiesFormatException {
        Object object;
        if (inputStream == null) {
            throw new NullPointerException();
        }
        if (this.builder == null) {
            object = DocumentBuilderFactory.newInstance();
            ((DocumentBuilderFactory)object).setValidating(true);
            try {
                this.builder = ((DocumentBuilderFactory)object).newDocumentBuilder();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new Error(parserConfigurationException);
            }
            this.builder.setErrorHandler(new ErrorHandler(){

                @Override
                public void warning(SAXParseException sAXParseException) throws SAXException {
                    throw sAXParseException;
                }

                @Override
                public void error(SAXParseException sAXParseException) throws SAXException {
                    throw sAXParseException;
                }

                @Override
                public void fatalError(SAXParseException sAXParseException) throws SAXException {
                    throw sAXParseException;
                }
            });
            this.builder.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
                    if (string2.equals(Properties.PROP_DTD_NAME)) {
                        InputSource inputSource = new InputSource(new StringReader(Properties.PROP_DTD));
                        inputSource.setSystemId(Properties.PROP_DTD_NAME);
                        return inputSource;
                    }
                    throw new SAXException("Invalid DOCTYPE declaration: " + string2);
                }
            });
        }
        try {
            object = this.builder.parse(inputStream);
            NodeList nodeList = object.getElementsByTagName("entry");
            if (nodeList == null) {
                return;
            }
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Element element = (Element)nodeList.item(i);
                String string = element.getAttribute("key");
                String string2 = element.getTextContent();
                this.put(string, string2);
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (SAXException sAXException) {
            throw new InvalidPropertiesFormatException(sAXException);
        }
    }

    public void storeToXML(OutputStream outputStream, String string) throws IOException {
        this.storeToXML(outputStream, string, "UTF-8");
    }

    public synchronized void storeToXML(OutputStream outputStream, String string, String string2) throws IOException {
        String string3;
        if (outputStream == null || string2 == null) {
            throw new NullPointerException();
        }
        try {
            string3 = Charset.forName(string2).name();
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            string3 = "UTF-8";
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            string3 = "UTF-8";
        }
        PrintStream printStream = new PrintStream(outputStream, false, string3);
        printStream.print("<?xml version=\"1.0\" encoding=\"");
        printStream.print(string3);
        printStream.println("\"?>");
        printStream.print("<!DOCTYPE properties SYSTEM \"");
        printStream.print(PROP_DTD_NAME);
        printStream.println("\">");
        printStream.println("<properties>");
        if (string != null) {
            printStream.print("<comment>");
            printStream.print(this.substitutePredefinedEntries(string));
            printStream.println("</comment>");
        }
        for (Map.Entry entry : this.entrySet()) {
            String string4 = (String)entry.getKey();
            String string5 = (String)entry.getValue();
            printStream.print("<entry key=\"");
            printStream.print(this.substitutePredefinedEntries(string4));
            printStream.print("\">");
            printStream.print(this.substitutePredefinedEntries(string5));
            printStream.println("</entry>");
        }
        printStream.println("</properties>");
        printStream.flush();
    }

    private String substitutePredefinedEntries(String string) {
        return string.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("'", "&apos;").replaceAll("\"", "&quot;");
    }
}

