/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.NoSuchElementException;

final class MiniEnumSet<E extends Enum<E>>
extends EnumSet<E> {
    private static final int MAX_ELEMENTS = 64;
    private int size;
    private final E[] enums;
    private long bits;

    MiniEnumSet(Class<E> clazz) {
        super(clazz);
        this.enums = (Enum[])clazz.getEnumConstants();
    }

    @Override
    public Iterator<E> iterator() {
        return new MiniEnumSetIterator();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        this.bits = 0L;
        this.size = 0;
    }

    @Override
    public boolean add(E e) {
        if (!this.isValidType(((Enum)e).getDeclaringClass())) {
            throw new ClassCastException();
        }
        long l = 1L << ((Enum)e).ordinal();
        if ((this.bits & l) == l) {
            return false;
        }
        this.bits |= l;
        ++this.size;
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        if (0 == collection.size()) {
            return false;
        }
        if (collection instanceof EnumSet) {
            EnumSet enumSet = (EnumSet)collection;
            if (!this.isValidType(enumSet.elementClass)) {
                throw new ClassCastException();
            }
            MiniEnumSet miniEnumSet = (MiniEnumSet)enumSet;
            long l = this.bits;
            this.bits |= miniEnumSet.bits;
            this.size = Long.bitCount(this.bits);
            return l != this.bits;
        }
        return super.addAll(collection);
    }

    @Override
    public boolean contains(Object object) {
        if (null == object) {
            return false;
        }
        if (!this.isValidType(object.getClass())) {
            return false;
        }
        Enum enum_ = (Enum)object;
        int n = enum_.ordinal();
        return (this.bits & 1L << n) != 0L;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        if (collection.size() == 0) {
            return true;
        }
        if (collection instanceof MiniEnumSet) {
            MiniEnumSet miniEnumSet = (MiniEnumSet)collection;
            return this.isValidType(miniEnumSet.elementClass) && (this.bits & miniEnumSet.bits) == miniEnumSet.bits;
        }
        return !(collection instanceof EnumSet) && super.containsAll(collection);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        if (0 == collection.size()) {
            return false;
        }
        if (collection instanceof EnumSet) {
            long l;
            EnumSet enumSet = (EnumSet)collection;
            boolean bl = false;
            if (this.isValidType(enumSet.elementClass) && (l = this.bits & ((MiniEnumSet)enumSet).bits) != 0L) {
                this.bits -= l;
                this.size = Long.bitCount(this.bits);
                bl = true;
            }
            return bl;
        }
        return super.removeAll(collection);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        if (collection instanceof EnumSet) {
            EnumSet enumSet = (EnumSet)collection;
            if (!this.isValidType(enumSet.elementClass)) {
                this.clear();
                return true;
            }
            boolean bl = false;
            long l = this.bits;
            this.bits &= ((MiniEnumSet)enumSet).bits;
            if (l != this.bits) {
                this.size = Long.bitCount(this.bits);
                bl = true;
            }
            return bl;
        }
        return super.retainAll(collection);
    }

    @Override
    public boolean remove(Object object) {
        if (!this.contains(object)) {
            return false;
        }
        Enum enum_ = (Enum)object;
        int n = enum_.ordinal();
        this.bits -= 1L << n;
        --this.size;
        return true;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof EnumSet)) {
            return super.equals(object);
        }
        EnumSet enumSet = (EnumSet)object;
        if (!this.isValidType(enumSet.elementClass)) {
            return this.size == 0 && enumSet.size() == 0;
        }
        return this.bits == ((MiniEnumSet)enumSet).bits;
    }

    @Override
    void complement() {
        if (0 != this.enums.length) {
            this.bits ^= 0xFFFFFFFFFFFFFFFFL;
            this.bits &= -1L >>> 64 - this.enums.length;
            this.size = this.enums.length - this.size;
        }
    }

    @Override
    void setRange(E e, E e2) {
        int n = ((Enum)e2).ordinal() - ((Enum)e).ordinal() + 1;
        long l = -1L >>> 64 - n << ((Enum)e).ordinal();
        this.bits |= l;
        this.size = Long.bitCount(this.bits);
    }

    private class MiniEnumSetIterator
    implements Iterator<E> {
        private long unProcessedBits;
        private long currentElementMask;
        private boolean canProcess = true;

        private MiniEnumSetIterator() {
            this.unProcessedBits = MiniEnumSet.this.bits;
            if (0L == this.unProcessedBits) {
                this.canProcess = false;
            }
        }

        @Override
        public boolean hasNext() {
            return this.canProcess;
        }

        @Override
        public E next() {
            if (!this.canProcess) {
                throw new NoSuchElementException();
            }
            this.currentElementMask = this.unProcessedBits & -this.unProcessedBits;
            this.unProcessedBits -= this.currentElementMask;
            if (0L == this.unProcessedBits) {
                this.canProcess = false;
            }
            return MiniEnumSet.this.enums[Long.numberOfTrailingZeros(this.currentElementMask)];
        }

        @Override
        public void remove() {
            if (this.currentElementMask == 0L) {
                throw new IllegalStateException();
            }
            MiniEnumSet.this.bits &= this.currentElementMask ^ 0xFFFFFFFFFFFFFFFFL;
            MiniEnumSet.this.size = Long.bitCount(MiniEnumSet.this.bits);
            this.currentElementMask = 0L;
        }
    }
}

