/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HugeEnumSet;
import java.util.Iterator;
import java.util.MiniEnumSet;

public abstract class EnumSet<E extends Enum<E>>
extends AbstractSet<E>
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1009687484059888093L;
    final Class<E> elementClass;

    EnumSet(Class<E> clazz) {
        this.elementClass = clazz;
    }

    public static <E extends Enum<E>> EnumSet<E> noneOf(Class<E> clazz) {
        if (!clazz.isEnum()) {
            throw new ClassCastException();
        }
        if (((Enum[])clazz.getEnumConstants()).length <= 64) {
            return new MiniEnumSet<E>(clazz);
        }
        return new HugeEnumSet<E>(clazz);
    }

    public static <E extends Enum<E>> EnumSet<E> allOf(Class<E> clazz) {
        EnumSet<E> enumSet = EnumSet.noneOf(clazz);
        enumSet.complement();
        return enumSet;
    }

    public static <E extends Enum<E>> EnumSet<E> copyOf(EnumSet<E> enumSet) {
        EnumSet<E> enumSet2 = EnumSet.noneOf(enumSet.elementClass);
        enumSet2.addAll(enumSet);
        return enumSet2;
    }

    public static <E extends Enum<E>> EnumSet<E> copyOf(Collection<E> collection) {
        if (collection instanceof EnumSet) {
            return EnumSet.copyOf((EnumSet)collection);
        }
        if (0 == collection.size()) {
            throw new IllegalArgumentException();
        }
        Iterator<E> iterator = collection.iterator();
        Enum enum_ = (Enum)iterator.next();
        EnumSet<Enum> enumSet = EnumSet.noneOf(enum_.getDeclaringClass());
        enumSet.add(enum_);
        while (iterator.hasNext()) {
            enumSet.add((Enum)iterator.next());
        }
        return enumSet;
    }

    public static <E extends Enum<E>> EnumSet<E> complementOf(EnumSet<E> enumSet) {
        EnumSet<E> enumSet2 = EnumSet.noneOf(enumSet.elementClass);
        enumSet2.addAll(enumSet);
        enumSet2.complement();
        return enumSet2;
    }

    abstract void complement();

    public static <E extends Enum<E>> EnumSet<E> of(E e) {
        EnumSet<E> enumSet = EnumSet.noneOf(e.getDeclaringClass());
        enumSet.add(e);
        return enumSet;
    }

    public static <E extends Enum<E>> EnumSet<E> of(E e, E e2) {
        EnumSet<E> enumSet = EnumSet.of(e);
        enumSet.add(e2);
        return enumSet;
    }

    public static <E extends Enum<E>> EnumSet<E> of(E e, E e2, E e3) {
        EnumSet<E> enumSet = EnumSet.of(e, e2);
        enumSet.add(e3);
        return enumSet;
    }

    public static <E extends Enum<E>> EnumSet<E> of(E e, E e2, E e3, E e4) {
        EnumSet<E> enumSet = EnumSet.of(e, e2, e3);
        enumSet.add(e4);
        return enumSet;
    }

    public static <E extends Enum<E>> EnumSet<E> of(E e, E e2, E e3, E e4, E e5) {
        EnumSet<E> enumSet = EnumSet.of(e, e2, e3, e4);
        enumSet.add(e5);
        return enumSet;
    }

    public static <E extends Enum<E>> EnumSet<E> of(E e, E ... EArray) {
        EnumSet<E> enumSet = EnumSet.of(e);
        for (E e2 : EArray) {
            enumSet.add(e2);
        }
        return enumSet;
    }

    public static <E extends Enum<E>> EnumSet<E> range(E e, E e2) {
        if (e.compareTo(e2) > 0) {
            throw new IllegalArgumentException();
        }
        EnumSet<E> enumSet = EnumSet.noneOf(e.getDeclaringClass());
        enumSet.setRange(e, e2);
        return enumSet;
    }

    abstract void setRange(E var1, E var2);

    public EnumSet<E> clone() {
        try {
            Object object = super.clone();
            return (EnumSet)object;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    boolean isValidType(Class clazz) {
        return clazz == this.elementClass || clazz.getSuperclass() == this.elementClass;
    }

    Object writeReplace() {
        SerializationProxy serializationProxy = new SerializationProxy();
        SerializationProxy.access$102(serializationProxy, this.toArray(new Enum[0]));
        serializationProxy.elementType = this.elementClass;
        return serializationProxy;
    }

    private static class SerializationProxy<E extends Enum<E>>
    implements Serializable {
        private static final long serialVersionUID = 362491234563181265L;
        private Class<E> elementType;
        private E[] elements;

        private SerializationProxy() {
        }

        private Object readResolve() {
            EnumSet<E> enumSet = EnumSet.noneOf(this.elementType);
            for (E e : this.elements) {
                enumSet.add(e);
            }
            return enumSet;
        }

        static /* synthetic */ Enum[] access$102(SerializationProxy serializationProxy, Enum[] enumArray) {
            serializationProxy.elements = enumArray;
            return enumArray;
        }
    }
}

