/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.MapEntry;
import java.util.NoSuchElementException;
import java.util.Set;

public class EnumMap<K extends Enum<K>, V>
extends AbstractMap<K, V>
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 458661240069192865L;
    private Class<K> keyType;
    transient Enum[] keys;
    transient Object[] values;
    transient boolean[] hasMapping;
    private transient int mappingsCount;
    transient int enumSize;
    private transient EnumMapEntrySet<K, V> entrySet = null;

    public EnumMap(Class<K> clazz) {
        this.initialization(clazz);
    }

    public EnumMap(EnumMap<K, ? extends V> enumMap) {
        this.initialization(enumMap);
    }

    public EnumMap(Map<K, ? extends V> map) {
        if (map instanceof EnumMap) {
            this.initialization((EnumMap)map);
        } else {
            if (0 == map.size()) {
                throw new IllegalArgumentException();
            }
            Iterator<K> iterator = map.keySet().iterator();
            Enum enum_ = (Enum)iterator.next();
            Class<?> clazz = enum_.getClass();
            if (clazz.isEnum()) {
                this.initialization(clazz);
            } else {
                this.initialization(clazz.getSuperclass());
            }
            this.putAllImpl(map);
        }
    }

    @Override
    public void clear() {
        Arrays.fill(this.values, null);
        Arrays.fill(this.hasMapping, false);
        this.mappingsCount = 0;
    }

    @Override
    public EnumMap<K, V> clone() {
        try {
            EnumMap enumMap = (EnumMap)super.clone();
            enumMap.initialization(this);
            return enumMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    @Override
    public boolean containsKey(Object object) {
        if (this.isValidKeyType(object)) {
            int n = ((Enum)object).ordinal();
            return this.hasMapping[n];
        }
        return false;
    }

    @Override
    public boolean containsValue(Object object) {
        if (null == object) {
            for (int i = 0; i < this.enumSize; ++i) {
                if (!this.hasMapping[i] || null != this.values[i]) continue;
                return true;
            }
        } else {
            for (int i = 0; i < this.enumSize; ++i) {
                if (!this.hasMapping[i] || !object.equals(this.values[i])) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (null == this.entrySet) {
            this.entrySet = new EnumMapEntrySet(this);
        }
        return this.entrySet;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof EnumMap)) {
            return super.equals(object);
        }
        EnumMap enumMap = (EnumMap)object;
        if (this.keyType != enumMap.keyType || this.size() != enumMap.size()) {
            return false;
        }
        return Arrays.equals(this.hasMapping, enumMap.hasMapping) && Arrays.equals(this.values, enumMap.values);
    }

    @Override
    public V get(Object object) {
        if (!this.isValidKeyType(object)) {
            return null;
        }
        int n = ((Enum)object).ordinal();
        return (V)this.values[n];
    }

    @Override
    public Set<K> keySet() {
        if (null == this.keySet) {
            this.keySet = new EnumMapKeySet(this);
        }
        return this.keySet;
    }

    @Override
    public V put(K k, V v) {
        return this.putImpl(k, v);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        this.putAllImpl(map);
    }

    @Override
    public V remove(Object object) {
        if (!this.isValidKeyType(object)) {
            return null;
        }
        int n = ((Enum)object).ordinal();
        if (this.hasMapping[n]) {
            this.hasMapping[n] = false;
            --this.mappingsCount;
        }
        Object object2 = this.values[n];
        this.values[n] = null;
        return (V)object2;
    }

    @Override
    public int size() {
        return this.mappingsCount;
    }

    @Override
    public Collection<V> values() {
        if (null == this.valuesCollection) {
            this.valuesCollection = new EnumMapValueCollection(this);
        }
        return this.valuesCollection;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n;
        objectInputStream.defaultReadObject();
        this.initialization(this.keyType);
        for (int i = n = objectInputStream.readInt(); i > 0; --i) {
            Enum enum_ = (Enum)objectInputStream.readObject();
            Object object = objectInputStream.readObject();
            this.putImpl(enum_, object);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.mappingsCount);
        for (Map.Entry<K, V> entry : this.entrySet()) {
            objectOutputStream.writeObject(entry.getKey());
            objectOutputStream.writeObject(entry.getValue());
        }
    }

    private boolean isValidKeyType(Object object) {
        return null != object && this.keyType.isInstance(object);
    }

    private void initialization(EnumMap enumMap) {
        this.keyType = enumMap.keyType;
        this.keys = enumMap.keys;
        this.enumSize = enumMap.enumSize;
        this.values = (Object[])enumMap.values.clone();
        this.hasMapping = (boolean[])enumMap.hasMapping.clone();
        this.mappingsCount = enumMap.mappingsCount;
    }

    private void initialization(Class<K> clazz) {
        this.keyType = clazz;
        this.keys = (Enum[])this.keyType.getEnumConstants();
        this.enumSize = this.keys.length;
        this.values = new Object[this.enumSize];
        this.hasMapping = new boolean[this.enumSize];
    }

    private void putAllImpl(Map map) {
        for (Map.Entry entry : map.entrySet()) {
            this.putImpl((Enum)entry.getKey(), entry.getValue());
        }
    }

    private V putImpl(K k, V v) {
        if (null == k) {
            throw new NullPointerException();
        }
        if (!this.isValidKeyType(k)) {
            throw new ClassCastException();
        }
        int n = ((Enum)k).ordinal();
        if (!this.hasMapping[n]) {
            this.hasMapping[n] = true;
            ++this.mappingsCount;
        }
        Object object = this.values[n];
        this.values[n] = v;
        return (V)object;
    }

    private static class EnumMapEntrySet<KT extends Enum<KT>, VT>
    extends AbstractSet<Map.Entry<KT, VT>> {
        private final EnumMap<KT, VT> enumMap;

        EnumMapEntrySet(EnumMap<KT, VT> enumMap) {
            this.enumMap = enumMap;
        }

        @Override
        public void clear() {
            this.enumMap.clear();
        }

        @Override
        public boolean contains(Object object) {
            boolean bl = false;
            if (object instanceof Map.Entry) {
                Object k = ((Map.Entry)object).getKey();
                Object v = ((Map.Entry)object).getValue();
                if (this.enumMap.containsKey(k)) {
                    VT VT = this.enumMap.get(k);
                    bl = VT == null ? null == v : VT.equals(v);
                }
            }
            return bl;
        }

        @Override
        public Iterator<Map.Entry<KT, VT>> iterator() {
            return new EnumMapEntryIterator(new MapEntry.Type<Map.Entry<KT, VT>, KT, VT>(){

                @Override
                public Map.Entry<KT, VT> get(MapEntry<KT, VT> mapEntry) {
                    return mapEntry;
                }
            }, this.enumMap);
        }

        @Override
        public boolean remove(Object object) {
            if (this.contains(object)) {
                this.enumMap.remove(((Map.Entry)object).getKey());
                return true;
            }
            return false;
        }

        @Override
        public int size() {
            return this.enumMap.size();
        }

        @Override
        public Object[] toArray() {
            Object[] objectArray = new Object[this.enumMap.size()];
            return this.toArray(objectArray);
        }

        @Override
        public Object[] toArray(Object[] objectArray) {
            Object object;
            int n = this.enumMap.size();
            int n2 = 0;
            Object[] objectArray2 = objectArray;
            if (n > objectArray.length) {
                object = objectArray.getClass().getComponentType();
                objectArray2 = (Object[])Array.newInstance(object, n);
            }
            object = this.iterator();
            while (n2 < n) {
                Map.Entry entry = (Map.Entry)object.next();
                objectArray2[n2] = new MapEntry(entry.getKey(), entry.getValue());
                ++n2;
            }
            if (n2 < objectArray.length) {
                objectArray2[n2] = null;
            }
            return objectArray2;
        }
    }

    private static class EnumMapEntryIterator<E, KT extends Enum<KT>, VT>
    extends EnumMapIterator<E, KT, VT> {
        EnumMapEntryIterator(MapEntry.Type<E, KT, VT> type, EnumMap<KT, VT> enumMap) {
            super(type, enumMap);
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.prePosition = this.position++;
            return (E)this.type.get(new EnumMapEntry<Enum, Object>(this.enumMap.keys[this.prePosition], this.enumMap.values[this.prePosition], this.enumMap));
        }
    }

    private static class EnumMapValueCollection<KT extends Enum<KT>, VT>
    extends AbstractCollection<VT> {
        private final EnumMap<KT, VT> enumMap;

        EnumMapValueCollection(EnumMap<KT, VT> enumMap) {
            this.enumMap = enumMap;
        }

        @Override
        public void clear() {
            this.enumMap.clear();
        }

        @Override
        public boolean contains(Object object) {
            return this.enumMap.containsValue(object);
        }

        @Override
        public Iterator iterator() {
            return new EnumMapIterator(new MapEntry.Type<VT, KT, VT>(){

                @Override
                public VT get(MapEntry<KT, VT> mapEntry) {
                    return mapEntry.value;
                }
            }, this.enumMap);
        }

        @Override
        public boolean remove(Object object) {
            if (null == object) {
                for (int i = 0; i < this.enumMap.enumSize; ++i) {
                    if (!this.enumMap.hasMapping[i] || null != this.enumMap.values[i]) continue;
                    this.enumMap.remove(this.enumMap.keys[i]);
                    return true;
                }
            } else {
                for (int i = 0; i < this.enumMap.enumSize; ++i) {
                    if (!this.enumMap.hasMapping[i] || !object.equals(this.enumMap.values[i])) continue;
                    this.enumMap.remove(this.enumMap.keys[i]);
                    return true;
                }
            }
            return false;
        }

        @Override
        public int size() {
            return this.enumMap.size();
        }
    }

    private static class EnumMapKeySet<KT extends Enum<KT>, VT>
    extends AbstractSet<KT> {
        private final EnumMap<KT, VT> enumMap;

        EnumMapKeySet(EnumMap<KT, VT> enumMap) {
            this.enumMap = enumMap;
        }

        @Override
        public void clear() {
            this.enumMap.clear();
        }

        @Override
        public boolean contains(Object object) {
            return this.enumMap.containsKey(object);
        }

        @Override
        public Iterator iterator() {
            return new EnumMapIterator(new MapEntry.Type<KT, KT, VT>(){

                @Override
                public KT get(MapEntry<KT, VT> mapEntry) {
                    return (Enum)mapEntry.key;
                }
            }, this.enumMap);
        }

        @Override
        public boolean remove(Object object) {
            if (this.contains(object)) {
                this.enumMap.remove(object);
                return true;
            }
            return false;
        }

        @Override
        public int size() {
            return this.enumMap.size();
        }
    }

    private static class EnumMapIterator<E, KT extends Enum<KT>, VT>
    implements Iterator<E> {
        int position = 0;
        int prePosition = -1;
        final EnumMap<KT, VT> enumMap;
        final MapEntry.Type<E, KT, VT> type;

        EnumMapIterator(MapEntry.Type<E, KT, VT> type, EnumMap<KT, VT> enumMap) {
            this.enumMap = enumMap;
            this.type = type;
        }

        @Override
        public boolean hasNext() {
            int n = this.enumMap.enumSize;
            while (this.position < n && !this.enumMap.hasMapping[this.position]) {
                ++this.position;
            }
            return this.position != n;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.prePosition = this.position++;
            return this.type.get(new MapEntry<Enum, Object>(this.enumMap.keys[this.prePosition], this.enumMap.values[this.prePosition]));
        }

        @Override
        public void remove() {
            this.checkStatus();
            if (this.enumMap.hasMapping[this.prePosition]) {
                this.enumMap.remove(this.enumMap.keys[this.prePosition]);
            }
            this.prePosition = -1;
        }

        public String toString() {
            if (-1 == this.prePosition) {
                return super.toString();
            }
            return this.type.get(new MapEntry<Enum, Object>(this.enumMap.keys[this.prePosition], this.enumMap.values[this.prePosition])).toString();
        }

        private void checkStatus() {
            if (-1 == this.prePosition) {
                throw new IllegalStateException();
            }
        }
    }

    private static class EnumMapEntry<KT extends Enum<KT>, VT>
    extends MapEntry<KT, VT>
    implements Map.Entry<KT, VT> {
        private final EnumMap<KT, VT> enumMap;
        private final int ordinal;

        EnumMapEntry(KT KT, VT VT, EnumMap<KT, VT> enumMap) {
            super(KT, VT);
            this.enumMap = enumMap;
            this.ordinal = ((Enum)KT).ordinal();
        }

        @Override
        public boolean equals(Object object) {
            Map.Entry entry;
            Object k;
            if (!this.enumMap.hasMapping[this.ordinal]) {
                return false;
            }
            boolean bl = false;
            if (object instanceof Map.Entry && ((Enum)this.key).equals(k = (entry = (Map.Entry)object).getKey())) {
                Object v = entry.getValue();
                bl = this.enumMap.values[this.ordinal] == null ? null == v : this.enumMap.values[this.ordinal].equals(v);
            }
            return bl;
        }

        @Override
        public int hashCode() {
            return (this.enumMap.keys[this.ordinal] == null ? 0 : this.enumMap.keys[this.ordinal].hashCode()) ^ (this.enumMap.values[this.ordinal] == null ? 0 : this.enumMap.values[this.ordinal].hashCode());
        }

        @Override
        public KT getKey() {
            this.checkEntryStatus();
            return (KT)this.enumMap.keys[this.ordinal];
        }

        @Override
        public VT getValue() {
            this.checkEntryStatus();
            return (VT)this.enumMap.values[this.ordinal];
        }

        @Override
        public VT setValue(VT VT) {
            this.checkEntryStatus();
            return this.enumMap.put((KT)this.enumMap.keys[this.ordinal], VT);
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(this.enumMap.keys[this.ordinal].toString());
            stringBuilder.append("=");
            stringBuilder.append(this.enumMap.values[this.ordinal].toString());
            return stringBuilder.toString();
        }

        private void checkEntryStatus() {
            if (!this.enumMap.hasMapping[this.ordinal]) {
                throw new IllegalStateException();
            }
        }
    }
}

