/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractQueue;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Random;
import java.util.RandomAccess;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import org.apache.harmony.luni.internal.nls.Messages;

public class Collections {
    public static final List EMPTY_LIST = new EmptyList();
    public static final Set EMPTY_SET = new EmptySet();
    public static final Map EMPTY_MAP = new EmptyMap();

    private Collections() {
    }

    public static <T> int binarySearch(List<? extends Comparable<? super T>> list, T t) {
        if (list == null) {
            throw new NullPointerException();
        }
        if (list.isEmpty()) {
            return -1;
        }
        if (!(list instanceof RandomAccess)) {
            ListIterator<Comparable<T>> listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                int n = -listIterator.next().compareTo(t);
                if (n > 0) continue;
                if (n == 0) {
                    return listIterator.previousIndex();
                }
                return -listIterator.previousIndex() - 1;
            }
            return -list.size() - 1;
        }
        int n = 0;
        int n2 = list.size();
        int n3 = n2 - 1;
        int n4 = -1;
        while (n <= n3) {
            n2 = n + n3 >> 1;
            n4 = -list.get(n2).compareTo(t);
            if (n4 > 0) {
                n = n2 + 1;
                continue;
            }
            if (n4 == 0) {
                return n2;
            }
            n3 = n2 - 1;
        }
        return -n2 - (n4 < 0 ? 1 : 2);
    }

    public static <T> int binarySearch(List<? extends T> list, T t, Comparator<? super T> comparator) {
        if (comparator == null) {
            return Collections.binarySearch(list, t);
        }
        if (!(list instanceof RandomAccess)) {
            ListIterator<T> listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                int n = -comparator.compare(listIterator.next(), t);
                if (n > 0) continue;
                if (n == 0) {
                    return listIterator.previousIndex();
                }
                return -listIterator.previousIndex() - 1;
            }
            return -list.size() - 1;
        }
        int n = 0;
        int n2 = list.size();
        int n3 = n2 - 1;
        int n4 = -1;
        while (n <= n3) {
            n2 = n + n3 >> 1;
            n4 = -comparator.compare(list.get(n2), t);
            if (n4 > 0) {
                n = n2 + 1;
                continue;
            }
            if (n4 == 0) {
                return n2;
            }
            n3 = n2 - 1;
        }
        return -n2 - (n4 < 0 ? 1 : 2);
    }

    public static <T> void copy(List<? super T> list, List<? extends T> list2) {
        if (list.size() < list2.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Iterator<T> iterator = list2.iterator();
        ListIterator<T> listIterator = list.listIterator();
        while (iterator.hasNext()) {
            try {
                listIterator.next();
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new ArrayIndexOutOfBoundsException();
            }
            listIterator.set(iterator.next());
        }
    }

    public static <T> Enumeration<T> enumeration(Collection<T> collection) {
        final Collection<T> collection2 = collection;
        return new Enumeration<T>(){
            Iterator<T> it;
            {
                this.it = collection2.iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.it.hasNext();
            }

            @Override
            public T nextElement() {
                return this.it.next();
            }
        };
    }

    public static <T> void fill(List<? super T> list, T t) {
        ListIterator<T> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            listIterator.next();
            listIterator.set(t);
        }
    }

    public static <T> T max(Collection<? extends T> collection) {
        Iterator<T> iterator = collection.iterator();
        T t = iterator.next();
        while (iterator.hasNext()) {
            T t2 = iterator.next();
            if (((Comparable)t).compareTo(t2) >= 0) continue;
            t = t2;
        }
        return t;
    }

    public static <T> T max(Collection<? extends T> collection, Comparator<? super T> comparator) {
        Iterator<T> iterator = collection.iterator();
        T t = iterator.next();
        while (iterator.hasNext()) {
            T t2 = iterator.next();
            if (comparator.compare(t, t2) >= 0) continue;
            t = t2;
        }
        return t;
    }

    public static <T> T min(Collection<? extends T> collection) {
        Iterator<T> iterator = collection.iterator();
        T t = iterator.next();
        while (iterator.hasNext()) {
            T t2 = iterator.next();
            if (((Comparable)t).compareTo(t2) <= 0) continue;
            t = t2;
        }
        return t;
    }

    public static <T> T min(Collection<? extends T> collection, Comparator<? super T> comparator) {
        Iterator<T> iterator = collection.iterator();
        T t = iterator.next();
        while (iterator.hasNext()) {
            T t2 = iterator.next();
            if (comparator.compare(t, t2) <= 0) continue;
            t = t2;
        }
        return t;
    }

    public static <T> List<T> nCopies(int n, T t) {
        return new CopiesList<T>(n, t);
    }

    public static void reverse(List<?> list) {
        int n = list.size();
        ListIterator<?> listIterator = list.listIterator();
        ListIterator<?> listIterator2 = list.listIterator(n);
        for (int i = 0; i < n / 2; ++i) {
            Object obj = listIterator.next();
            Object obj2 = listIterator2.previous();
            listIterator.set(obj2);
            listIterator2.set(obj);
        }
    }

    public static <T> Comparator<T> reverseOrder() {
        return new ReverseComparator();
    }

    public static <T> Comparator<T> reverseOrder(Comparator<T> comparator) {
        if (comparator == null) {
            return Collections.reverseOrder();
        }
        return new ReverseComparatorWithComparator<T>(comparator);
    }

    public static void shuffle(List<?> list) {
        Collections.shuffle(list, new Random());
    }

    public static void shuffle(List<?> list, Random random) {
        if (!(list instanceof RandomAccess)) {
            int n;
            Object[] objectArray = list.toArray();
            for (n = objectArray.length - 1; n > 0; --n) {
                int n2 = random.nextInt(n + 1);
                if (n2 < 0) {
                    n2 = -n2;
                }
                Object object = objectArray[n];
                objectArray[n] = objectArray[n2];
                objectArray[n2] = object;
            }
            n = 0;
            ListIterator<?> listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                listIterator.next();
                listIterator.set(objectArray[n++]);
            }
        } else {
            List<?> list2 = list;
            for (int i = list2.size() - 1; i > 0; --i) {
                int n = random.nextInt(i + 1);
                if (n < 0) {
                    n = -n;
                }
                list2.set(n, list2.set(i, list2.get(n)));
            }
        }
    }

    public static <E> Set<E> singleton(E e) {
        return new SingletonSet<E>(e);
    }

    public static <E> List<E> singletonList(E e) {
        return new SingletonList<E>(e);
    }

    public static <K, V> Map<K, V> singletonMap(K k, V v) {
        return new SingletonMap<K, V>(k, v);
    }

    public static <T extends Comparable<? super T>> void sort(List<T> list) {
        Object[] objectArray = list.toArray();
        Arrays.sort(objectArray);
        int n = 0;
        ListIterator<T> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            listIterator.next();
            listIterator.set((Comparable)objectArray[n++]);
        }
    }

    public static <T> void sort(List<T> list, Comparator<? super T> comparator) {
        Object[] objectArray = list.toArray(new Object[list.size()]);
        Arrays.sort(objectArray, comparator);
        int n = 0;
        ListIterator<T> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            listIterator.next();
            listIterator.set(objectArray[n++]);
        }
    }

    public static void swap(List<?> list, int n, int n2) {
        if (list == null) {
            throw new NullPointerException();
        }
        if (n == n2) {
            return;
        }
        List<?> list2 = list;
        list2.set(n2, list2.set(n, list2.get(n2)));
    }

    public static <T> boolean replaceAll(List<T> list, T t, T t2) {
        int n;
        boolean bl = false;
        while ((n = list.indexOf(t)) > -1) {
            bl = true;
            list.set(n, t2);
        }
        return bl;
    }

    public static void rotate(List<?> list, int n) {
        List<?> list2 = list;
        int n2 = list2.size();
        if (n2 == 0) {
            return;
        }
        int n3 = n > 0 ? n % n2 : n2 - n % n2 * -1;
        if (n3 == 0 || n3 == n2) {
            return;
        }
        if (list2 instanceof RandomAccess) {
            Object obj = list2.get(0);
            int n4 = 0;
            int n5 = 0;
            for (int i = 0; i < n2; ++i) {
                n4 = (n4 + n3) % n2;
                obj = list2.set(n4, obj);
                if (n4 != n5) continue;
                n4 = ++n5;
                obj = list2.get(n5);
            }
        } else {
            int n6 = (n2 - n3) % n2;
            List<?> list3 = list2.subList(0, n6);
            List<?> list4 = list2.subList(n6, n2);
            Collections.reverse(list3);
            Collections.reverse(list4);
            Collections.reverse(list2);
        }
    }

    public static int indexOfSubList(List<?> list, List<?> list2) {
        int n = list.size();
        int n2 = list2.size();
        if (n2 > n) {
            return -1;
        }
        if (n2 == 0) {
            return 0;
        }
        Object obj = list2.get(0);
        int n3 = list.indexOf(obj);
        if (n3 == -1) {
            return -1;
        }
        while (n3 < n && n - n3 >= n2) {
            ListIterator<?> listIterator = list.listIterator(n3);
            if (obj == null ? listIterator.next() == null : obj.equals(listIterator.next())) {
                ListIterator<?> listIterator2 = list2.listIterator(1);
                boolean bl = false;
                while (listIterator2.hasNext()) {
                    Object obj2 = listIterator2.next();
                    if (!listIterator.hasNext()) {
                        return -1;
                    }
                    if (!(obj2 == null ? listIterator.next() != null : !obj2.equals(listIterator.next()))) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    return n3;
                }
            }
            ++n3;
        }
        return -1;
    }

    public static int lastIndexOfSubList(List<?> list, List<?> list2) {
        int n;
        int n2 = list2.size();
        if (n2 > (n = list.size())) {
            return -1;
        }
        if (n2 == 0) {
            return n;
        }
        Object obj = list2.get(n2 - 1);
        for (int i = list.lastIndexOf(obj); i > -1 && i + 1 >= n2; --i) {
            ListIterator<?> listIterator = list.listIterator(i + 1);
            if (!(obj == null ? listIterator.previous() == null : obj.equals(listIterator.previous()))) continue;
            ListIterator<?> listIterator2 = list2.listIterator(n2 - 1);
            boolean bl = false;
            while (listIterator2.hasPrevious()) {
                Object obj2 = listIterator2.previous();
                if (!listIterator.hasPrevious()) {
                    return -1;
                }
                if (!(obj2 == null ? listIterator.previous() != null : !obj2.equals(listIterator.previous()))) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return listIterator.nextIndex();
        }
        return -1;
    }

    public static <T> ArrayList<T> list(Enumeration<T> enumeration) {
        ArrayList<T> arrayList = new ArrayList<T>();
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        return arrayList;
    }

    public static <T> Collection<T> synchronizedCollection(Collection<T> collection) {
        if (collection == null) {
            throw new NullPointerException();
        }
        return new SynchronizedCollection<T>(collection);
    }

    public static <T> List<T> synchronizedList(List<T> list) {
        if (list == null) {
            throw new NullPointerException();
        }
        if (list instanceof RandomAccess) {
            return new SynchronizedRandomAccessList<T>(list);
        }
        return new SynchronizedList<T>(list);
    }

    public static <K, V> Map<K, V> synchronizedMap(Map<K, V> map) {
        if (map == null) {
            throw new NullPointerException();
        }
        return new SynchronizedMap<K, V>(map);
    }

    public static <E> Set<E> synchronizedSet(Set<E> set) {
        if (set == null) {
            throw new NullPointerException();
        }
        return new SynchronizedSet<E>(set);
    }

    public static <K, V> SortedMap<K, V> synchronizedSortedMap(SortedMap<K, V> sortedMap) {
        if (sortedMap == null) {
            throw new NullPointerException();
        }
        return new SynchronizedSortedMap<K, V>(sortedMap);
    }

    public static <E> SortedSet<E> synchronizedSortedSet(SortedSet<E> sortedSet) {
        if (sortedSet == null) {
            throw new NullPointerException();
        }
        return new SynchronizedSortedSet<E>(sortedSet);
    }

    public static <E> Collection<E> unmodifiableCollection(Collection<? extends E> collection) {
        if (collection == null) {
            throw new NullPointerException();
        }
        return new UnmodifiableCollection<E>(collection);
    }

    public static <E> List<E> unmodifiableList(List<? extends E> list) {
        if (list == null) {
            throw new NullPointerException();
        }
        if (list instanceof RandomAccess) {
            return new UnmodifiableRandomAccessList<E>(list);
        }
        return new UnmodifiableList<E>(list);
    }

    public static <K, V> Map<K, V> unmodifiableMap(Map<? extends K, ? extends V> map) {
        if (map == null) {
            throw new NullPointerException();
        }
        return new UnmodifiableMap<K, V>(map);
    }

    public static <E> Set<E> unmodifiableSet(Set<? extends E> set) {
        if (set == null) {
            throw new NullPointerException();
        }
        return new UnmodifiableSet<E>(set);
    }

    public static <K, V> SortedMap<K, V> unmodifiableSortedMap(SortedMap<K, ? extends V> sortedMap) {
        if (sortedMap == null) {
            throw new NullPointerException();
        }
        return new UnmodifiableSortedMap<K, V>(sortedMap);
    }

    public static <E> SortedSet<E> unmodifiableSortedSet(SortedSet<E> sortedSet) {
        if (sortedSet == null) {
            throw new NullPointerException();
        }
        return new UnmodifiableSortedSet<E>(sortedSet);
    }

    public static int frequency(Collection<?> collection, Object object) {
        if (collection == null) {
            throw new NullPointerException();
        }
        if (collection.isEmpty()) {
            return 0;
        }
        int n = 0;
        for (Object obj : collection) {
            if (!(object == null ? obj == null : object.equals(obj))) continue;
            ++n;
        }
        return n;
    }

    public static final <T> List<T> emptyList() {
        return EMPTY_LIST;
    }

    public static final <T> Set<T> emptySet() {
        return EMPTY_SET;
    }

    public static final <K, V> Map<K, V> emptyMap() {
        return EMPTY_MAP;
    }

    public static <E> Collection<E> checkedCollection(Collection<E> collection, Class<E> clazz) {
        return new CheckedCollection<E>(collection, clazz);
    }

    public static <K, V> Map<K, V> checkedMap(Map<K, V> map, Class<K> clazz, Class<V> clazz2) {
        return new CheckedMap(map, clazz, clazz2);
    }

    public static <E> List<E> checkedList(List<E> list, Class<E> clazz) {
        if (list instanceof RandomAccess) {
            return new CheckedRandomAccessList<E>(list, clazz);
        }
        return new CheckedList<E>(list, clazz);
    }

    public static <E> Set<E> checkedSet(Set<E> set, Class<E> clazz) {
        return new CheckedSet<E>(set, clazz);
    }

    public static <K, V> SortedMap<K, V> checkedSortedMap(SortedMap<K, V> sortedMap, Class<K> clazz, Class<V> clazz2) {
        return new CheckedSortedMap<K, V>(sortedMap, clazz, clazz2);
    }

    public static <E> SortedSet<E> checkedSortedSet(SortedSet<E> sortedSet, Class<E> clazz) {
        return new CheckedSortedSet<E>(sortedSet, clazz);
    }

    public static <T> boolean addAll(Collection<? super T> collection, T ... TArray) {
        boolean bl = false;
        for (int i = 0; i < TArray.length; ++i) {
            bl |= collection.add(TArray[i]);
        }
        return bl;
    }

    public static boolean disjoint(Collection<?> collection, Collection<?> collection2) {
        Object object;
        if (collection instanceof Set && !(collection2 instanceof Set) || collection2.size() > collection.size()) {
            object = collection;
            collection = collection2;
            collection2 = object;
        }
        object = collection.iterator();
        while (object.hasNext()) {
            if (!collection2.contains(object.next())) continue;
            return false;
        }
        return true;
    }

    static <E> E checkType(E e, Class<E> clazz) {
        if (!clazz.isInstance(e)) {
            throw new ClassCastException(Messages.getString("luni.05", e.getClass(), clazz));
        }
        return e;
    }

    public static <E> Set<E> newSetFromMap(Map<E, Boolean> map) {
        if (map.isEmpty()) {
            return new SetFromMap<E>(map);
        }
        throw new IllegalArgumentException();
    }

    public static <T> Queue<T> asLifoQueue(Deque<T> deque) {
        return new AsLIFOQueue<T>(deque);
    }

    private static class CheckedSortedMap<K, V>
    extends CheckedMap<K, V>
    implements SortedMap<K, V> {
        private static final long serialVersionUID = 1599671320688067438L;
        SortedMap<K, V> sm;

        CheckedSortedMap(SortedMap<K, V> sortedMap, Class<K> clazz, Class<V> clazz2) {
            super(sortedMap, clazz, clazz2);
            this.sm = sortedMap;
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.sm.comparator();
        }

        @Override
        public SortedMap<K, V> subMap(K k, K k2) {
            return new CheckedSortedMap<K, V>(this.sm.subMap(k, k2), this.keyType, this.valueType);
        }

        @Override
        public SortedMap<K, V> headMap(K k) {
            return new CheckedSortedMap<K, V>(this.sm.headMap(k), this.keyType, this.valueType);
        }

        @Override
        public SortedMap<K, V> tailMap(K k) {
            return new CheckedSortedMap<K, V>(this.sm.tailMap(k), this.keyType, this.valueType);
        }

        @Override
        public K firstKey() {
            return this.sm.firstKey();
        }

        @Override
        public K lastKey() {
            return this.sm.lastKey();
        }
    }

    private static class CheckedSortedSet<E>
    extends CheckedSet<E>
    implements SortedSet<E> {
        private static final long serialVersionUID = 1599911165492914959L;
        private SortedSet<E> ss;

        public CheckedSortedSet(SortedSet<E> sortedSet, Class<E> clazz) {
            super(sortedSet, clazz);
            this.ss = sortedSet;
        }

        @Override
        public Comparator<? super E> comparator() {
            return this.ss.comparator();
        }

        @Override
        public SortedSet<E> subSet(E e, E e2) {
            return new CheckedSortedSet<E>(this.ss.subSet(e, e2), this.type);
        }

        @Override
        public SortedSet<E> headSet(E e) {
            return new CheckedSortedSet<E>(this.ss.headSet(e), this.type);
        }

        @Override
        public SortedSet<E> tailSet(E e) {
            return new CheckedSortedSet<E>(this.ss.tailSet(e), this.type);
        }

        @Override
        public E first() {
            return this.ss.first();
        }

        @Override
        public E last() {
            return this.ss.last();
        }
    }

    private static class CheckedMap<K, V>
    implements Map<K, V>,
    Serializable {
        private static final long serialVersionUID = 5742860141034234728L;
        Map<K, V> m;
        Class<K> keyType;
        Class<V> valueType;

        private CheckedMap(Map<K, V> map, Class<K> clazz, Class<V> clazz2) {
            if (map == null || clazz == null || clazz2 == null) {
                throw new NullPointerException();
            }
            this.m = map;
            this.keyType = clazz;
            this.valueType = clazz2;
        }

        @Override
        public int size() {
            return this.m.size();
        }

        @Override
        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        @Override
        public boolean containsKey(Object object) {
            return this.m.containsKey(object);
        }

        @Override
        public boolean containsValue(Object object) {
            return this.m.containsValue(object);
        }

        @Override
        public V get(Object object) {
            return this.m.get(object);
        }

        @Override
        public V put(K k, V v) {
            return this.m.put(Collections.checkType(k, this.keyType), Collections.checkType(v, this.valueType));
        }

        @Override
        public V remove(Object object) {
            return this.m.remove(object);
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> map) {
            int n;
            int n2 = map.size();
            if (n2 == 0) {
                return;
            }
            Map.Entry[] entryArray = new Map.Entry[n2];
            Iterator<Map.Entry<K, V>> iterator = map.entrySet().iterator();
            for (n = 0; n < n2; ++n) {
                Map.Entry<K, V> entry = iterator.next();
                Collections.checkType(entry.getKey(), this.keyType);
                Collections.checkType(entry.getValue(), this.valueType);
                entryArray[n] = entry;
            }
            for (n = 0; n < n2; ++n) {
                this.m.put(entryArray[n].getKey(), entryArray[n].getValue());
            }
        }

        @Override
        public void clear() {
            this.m.clear();
        }

        @Override
        public Set<K> keySet() {
            return this.m.keySet();
        }

        @Override
        public Collection<V> values() {
            return this.m.values();
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return new CheckedEntrySet<K, V>(this.m.entrySet(), this.valueType);
        }

        @Override
        public boolean equals(Object object) {
            return ((Object)this.m).equals(object);
        }

        @Override
        public int hashCode() {
            return ((Object)this.m).hashCode();
        }

        public String toString() {
            return this.m.toString();
        }

        private static class CheckedEntrySet<K, V>
        implements Set<Map.Entry<K, V>> {
            Set<Map.Entry<K, V>> s;
            Class<V> valueType;

            public CheckedEntrySet(Set<Map.Entry<K, V>> set, Class<V> clazz) {
                this.s = set;
                this.valueType = clazz;
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new CheckedEntryIterator<K, V>(this.s.iterator(), this.valueType);
            }

            @Override
            public Object[] toArray() {
                int n = this.size();
                Object[] objectArray = new Object[n];
                Iterator<Map.Entry<K, V>> iterator = this.iterator();
                for (int i = 0; i < n; ++i) {
                    objectArray[i] = iterator.next();
                }
                return objectArray;
            }

            @Override
            public <T> T[] toArray(T[] objectArray) {
                Object object;
                int n = this.size();
                if (objectArray.length < n) {
                    object = objectArray.getClass().getComponentType();
                    objectArray = (Object[])Array.newInstance(object, n);
                }
                object = this.iterator();
                for (int i = 0; i < n; ++i) {
                    objectArray[i] = object.next();
                }
                if (n < objectArray.length) {
                    objectArray[n] = null;
                }
                return objectArray;
            }

            @Override
            public boolean retainAll(Collection<?> collection) {
                return this.s.retainAll(collection);
            }

            @Override
            public boolean removeAll(Collection<?> collection) {
                return this.s.removeAll(collection);
            }

            @Override
            public boolean containsAll(Collection<?> collection) {
                return this.s.containsAll(collection);
            }

            @Override
            public boolean addAll(Collection<? extends Map.Entry<K, V>> collection) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object object) {
                return this.s.remove(object);
            }

            @Override
            public boolean contains(Object object) {
                return this.s.contains(object);
            }

            @Override
            public boolean add(Map.Entry<K, V> entry) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean isEmpty() {
                return this.s.isEmpty();
            }

            @Override
            public void clear() {
                this.s.clear();
            }

            @Override
            public int size() {
                return this.s.size();
            }

            @Override
            public int hashCode() {
                return ((Object)this.s).hashCode();
            }

            @Override
            public boolean equals(Object object) {
                return ((Object)this.s).equals(object);
            }

            private static class CheckedEntryIterator<K, V>
            implements Iterator<Map.Entry<K, V>> {
                Iterator<Map.Entry<K, V>> i;
                Class<V> valueType;

                public CheckedEntryIterator(Iterator<Map.Entry<K, V>> iterator, Class<V> clazz) {
                    this.i = iterator;
                    this.valueType = clazz;
                }

                @Override
                public boolean hasNext() {
                    return this.i.hasNext();
                }

                @Override
                public void remove() {
                    this.i.remove();
                }

                @Override
                public Map.Entry<K, V> next() {
                    return new CheckedEntry<K, V>(this.i.next(), this.valueType);
                }
            }
        }

        private static class CheckedEntry<K, V>
        implements Map.Entry<K, V> {
            Map.Entry<K, V> e;
            Class<V> valueType;

            public CheckedEntry(Map.Entry<K, V> entry, Class<V> clazz) {
                if (entry == null) {
                    throw new NullPointerException();
                }
                this.e = entry;
                this.valueType = clazz;
            }

            @Override
            public K getKey() {
                return this.e.getKey();
            }

            @Override
            public V getValue() {
                return this.e.getValue();
            }

            @Override
            public V setValue(V v) {
                return this.e.setValue(Collections.checkType(v, this.valueType));
            }

            @Override
            public boolean equals(Object object) {
                return ((Object)this.e).equals(object);
            }

            @Override
            public int hashCode() {
                return ((Object)this.e).hashCode();
            }
        }
    }

    private static class CheckedSet<E>
    extends CheckedCollection<E>
    implements Set<E> {
        private static final long serialVersionUID = 4694047833775013803L;

        public CheckedSet(Set<E> set, Class<E> clazz) {
            super(set, clazz);
        }

        @Override
        public boolean equals(Object object) {
            return ((Object)this.c).equals(object);
        }

        @Override
        public int hashCode() {
            return ((Object)this.c).hashCode();
        }
    }

    private static class CheckedRandomAccessList<E>
    extends CheckedList<E>
    implements RandomAccess {
        private static final long serialVersionUID = 1638200125423088369L;

        public CheckedRandomAccessList(List<E> list, Class<E> clazz) {
            super(list, clazz);
        }
    }

    private static class CheckedList<E>
    extends CheckedCollection<E>
    implements List<E> {
        private static final long serialVersionUID = 65247728283967356L;
        List<E> l;

        public CheckedList(List<E> list, Class<E> clazz) {
            super(list, clazz);
            this.l = list;
        }

        @Override
        public boolean addAll(int n, Collection<? extends E> collection) {
            int n2 = collection.size();
            if (n2 == 0) {
                return false;
            }
            Object[] objectArray = new Object[n2];
            Iterator<E> iterator = collection.iterator();
            for (int i = 0; i < n2; ++i) {
                objectArray[i] = Collections.checkType(iterator.next(), this.type);
            }
            return this.l.addAll(n, Arrays.asList(objectArray));
        }

        @Override
        public E get(int n) {
            return this.l.get(n);
        }

        @Override
        public E set(int n, E e) {
            return this.l.set(n, Collections.checkType(e, this.type));
        }

        @Override
        public void add(int n, E e) {
            this.l.add(n, Collections.checkType(e, this.type));
        }

        @Override
        public E remove(int n) {
            return this.l.remove(n);
        }

        @Override
        public int indexOf(Object object) {
            return this.l.indexOf(object);
        }

        @Override
        public int lastIndexOf(Object object) {
            return this.l.lastIndexOf(object);
        }

        @Override
        public ListIterator<E> listIterator() {
            return new CheckedListIterator<E>(this.l.listIterator(), this.type);
        }

        @Override
        public ListIterator<E> listIterator(int n) {
            return new CheckedListIterator<E>(this.l.listIterator(n), this.type);
        }

        @Override
        public List<E> subList(int n, int n2) {
            return Collections.checkedList(this.l.subList(n, n2), this.type);
        }

        @Override
        public boolean equals(Object object) {
            return ((Object)this.l).equals(object);
        }

        @Override
        public int hashCode() {
            return ((Object)this.l).hashCode();
        }
    }

    private static class CheckedListIterator<E>
    implements ListIterator<E> {
        private ListIterator<E> i;
        private Class<E> type;

        public CheckedListIterator(ListIterator<E> listIterator, Class<E> clazz) {
            this.i = listIterator;
            this.type = clazz;
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public E next() {
            return this.i.next();
        }

        @Override
        public void remove() {
            this.i.remove();
        }

        @Override
        public boolean hasPrevious() {
            return this.i.hasPrevious();
        }

        @Override
        public E previous() {
            return this.i.previous();
        }

        @Override
        public int nextIndex() {
            return this.i.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.i.previousIndex();
        }

        @Override
        public void set(E e) {
            this.i.set(Collections.checkType(e, this.type));
        }

        @Override
        public void add(E e) {
            this.i.add(Collections.checkType(e, this.type));
        }
    }

    private static class CheckedCollection<E>
    implements Collection<E>,
    Serializable {
        private static final long serialVersionUID = 1578914078182001775L;
        Collection<E> c;
        Class<E> type;

        public CheckedCollection(Collection<E> collection, Class<E> clazz) {
            if (collection == null || clazz == null) {
                throw new NullPointerException();
            }
            this.c = collection;
            this.type = clazz;
        }

        @Override
        public int size() {
            return this.c.size();
        }

        @Override
        public boolean isEmpty() {
            return this.c.isEmpty();
        }

        @Override
        public boolean contains(Object object) {
            return this.c.contains(object);
        }

        @Override
        public Iterator<E> iterator() {
            Iterator<E> iterator = this.c.iterator();
            if (iterator instanceof ListIterator) {
                iterator = new CheckedListIterator<E>((ListIterator)iterator, this.type);
            }
            return iterator;
        }

        @Override
        public Object[] toArray() {
            return this.c.toArray();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            return this.c.toArray(TArray);
        }

        @Override
        public boolean add(E e) {
            return this.c.add(Collections.checkType(e, this.type));
        }

        @Override
        public boolean remove(Object object) {
            return this.c.remove(object);
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            return this.c.containsAll(collection);
        }

        @Override
        public boolean addAll(Collection<? extends E> collection) {
            int n;
            int n2 = collection.size();
            if (n2 == 0) {
                return false;
            }
            Object[] objectArray = new Object[n2];
            Iterator<E> iterator = collection.iterator();
            for (n = 0; n < n2; ++n) {
                objectArray[n] = Collections.checkType(iterator.next(), this.type);
            }
            n = 0;
            for (int i = 0; i < n2; ++i) {
                n |= this.c.add(objectArray[i]);
            }
            return n != 0;
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            return this.c.removeAll(collection);
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            return this.c.retainAll(collection);
        }

        @Override
        public void clear() {
            this.c.clear();
        }

        public String toString() {
            return this.c.toString();
        }
    }

    private static class AsLIFOQueue<E>
    extends AbstractQueue<E>
    implements Serializable {
        private static final long serialVersionUID = 1802017725587941708L;
        private final Deque<E> q;

        AsLIFOQueue(Deque<E> deque) {
            this.q = deque;
        }

        @Override
        public Iterator<E> iterator() {
            return this.q.iterator();
        }

        @Override
        public int size() {
            return this.q.size();
        }

        @Override
        public boolean offer(E e) {
            return this.q.offerFirst(e);
        }

        @Override
        public E peek() {
            return this.q.peekFirst();
        }

        @Override
        public E poll() {
            return this.q.pollFirst();
        }

        @Override
        public boolean add(E e) {
            this.q.push(e);
            return true;
        }

        @Override
        public void clear() {
            this.q.clear();
        }

        @Override
        public E element() {
            return this.q.getFirst();
        }

        @Override
        public E remove() {
            return this.q.pop();
        }

        @Override
        public boolean contains(Object object) {
            return this.q.contains(object);
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            return this.q.containsAll(collection);
        }

        @Override
        public boolean isEmpty() {
            return this.q.isEmpty();
        }

        @Override
        public boolean remove(Object object) {
            return this.q.remove(object);
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            return this.q.removeAll(collection);
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            return this.q.retainAll(collection);
        }

        @Override
        public Object[] toArray() {
            return this.q.toArray();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            return this.q.toArray(TArray);
        }

        @Override
        public String toString() {
            return this.q.toString();
        }
    }

    private static class SetFromMap<E>
    extends AbstractSet<E>
    implements Serializable {
        private static final long serialVersionUID = 2454657854757543876L;
        private Map<E, Boolean> m;
        private transient Set<E> backingSet;

        SetFromMap(Map<E, Boolean> map) {
            this.m = map;
            this.backingSet = map.keySet();
        }

        @Override
        public boolean equals(Object object) {
            return ((Object)this.backingSet).equals(object);
        }

        @Override
        public int hashCode() {
            return ((Object)this.backingSet).hashCode();
        }

        @Override
        public boolean add(E e) {
            return this.m.put(e, Boolean.TRUE) == null;
        }

        @Override
        public void clear() {
            this.m.clear();
        }

        @Override
        public String toString() {
            return this.backingSet.toString();
        }

        @Override
        public boolean contains(Object object) {
            return this.backingSet.contains(object);
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            return this.backingSet.containsAll(collection);
        }

        @Override
        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        @Override
        public boolean remove(Object object) {
            return this.m.remove(object) != null;
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            return this.backingSet.retainAll(collection);
        }

        @Override
        public Object[] toArray() {
            return this.backingSet.toArray();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            return this.backingSet.toArray(TArray);
        }

        @Override
        public Iterator<E> iterator() {
            return this.backingSet.iterator();
        }

        @Override
        public int size() {
            return this.m.size();
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            this.backingSet = this.m.keySet();
        }
    }

    private static class UnmodifiableSortedSet<E>
    extends UnmodifiableSet<E>
    implements SortedSet<E> {
        private static final long serialVersionUID = -4929149591599911165L;
        private final SortedSet<E> ss;

        UnmodifiableSortedSet(SortedSet<E> sortedSet) {
            super(sortedSet);
            this.ss = sortedSet;
        }

        @Override
        public Comparator<? super E> comparator() {
            return this.ss.comparator();
        }

        @Override
        public E first() {
            return this.ss.first();
        }

        @Override
        public SortedSet<E> headSet(E e) {
            return new UnmodifiableSortedSet<E>(this.ss.headSet(e));
        }

        @Override
        public E last() {
            return this.ss.last();
        }

        @Override
        public SortedSet<E> subSet(E e, E e2) {
            return new UnmodifiableSortedSet<E>(this.ss.subSet(e, e2));
        }

        @Override
        public SortedSet<E> tailSet(E e) {
            return new UnmodifiableSortedSet<E>(this.ss.tailSet(e));
        }
    }

    private static class UnmodifiableSortedMap<K, V>
    extends UnmodifiableMap<K, V>
    implements SortedMap<K, V> {
        private static final long serialVersionUID = -8806743815996713206L;
        private final SortedMap<K, V> sm;

        UnmodifiableSortedMap(SortedMap<K, V> sortedMap) {
            super(sortedMap);
            this.sm = sortedMap;
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.sm.comparator();
        }

        @Override
        public K firstKey() {
            return this.sm.firstKey();
        }

        @Override
        public SortedMap<K, V> headMap(K k) {
            return new UnmodifiableSortedMap<K, V>(this.sm.headMap(k));
        }

        @Override
        public K lastKey() {
            return this.sm.lastKey();
        }

        @Override
        public SortedMap<K, V> subMap(K k, K k2) {
            return new UnmodifiableSortedMap<K, V>(this.sm.subMap(k, k2));
        }

        @Override
        public SortedMap<K, V> tailMap(K k) {
            return new UnmodifiableSortedMap<K, V>(this.sm.tailMap(k));
        }
    }

    private static class UnmodifiableSet<E>
    extends UnmodifiableCollection<E>
    implements Set<E> {
        private static final long serialVersionUID = -9215047833775013803L;

        UnmodifiableSet(Set<E> set) {
            super(set);
        }

        @Override
        public boolean equals(Object object) {
            return ((Object)this.c).equals(object);
        }

        @Override
        public int hashCode() {
            return ((Object)this.c).hashCode();
        }
    }

    private static class UnmodifiableMap<K, V>
    implements Map<K, V>,
    Serializable {
        private static final long serialVersionUID = -1034234728574286014L;
        private final Map<K, V> m;

        UnmodifiableMap(Map<K, V> map) {
            this.m = map;
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsKey(Object object) {
            return this.m.containsKey(object);
        }

        @Override
        public boolean containsValue(Object object) {
            return this.m.containsValue(object);
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return new UnmodifiableEntrySet<K, V>(this.m.entrySet());
        }

        @Override
        public boolean equals(Object object) {
            return ((Object)this.m).equals(object);
        }

        @Override
        public V get(Object object) {
            return this.m.get(object);
        }

        @Override
        public int hashCode() {
            return ((Object)this.m).hashCode();
        }

        @Override
        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        @Override
        public Set<K> keySet() {
            return new UnmodifiableSet<K>(this.m.keySet());
        }

        @Override
        public V put(K k, V v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> map) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V remove(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.m.size();
        }

        @Override
        public Collection<V> values() {
            return new UnmodifiableCollection<V>(this.m.values());
        }

        public String toString() {
            return this.m.toString();
        }

        private static class UnmodifiableEntrySet<K, V>
        extends UnmodifiableSet<Map.Entry<K, V>> {
            private static final long serialVersionUID = 7854390611657943733L;

            UnmodifiableEntrySet(Set<Map.Entry<K, V>> set) {
                super(set);
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new Iterator<Map.Entry<K, V>>(){
                    Iterator<Map.Entry<K, V>> iterator;
                    {
                        this.iterator = UnmodifiableEntrySet.this.c.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iterator.hasNext();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        return new UnmodifiableMapEntry(this.iterator.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public Object[] toArray() {
                int n = this.c.size();
                Object[] objectArray = new Object[n];
                Iterator<Map.Entry<K, V>> iterator = this.iterator();
                int n2 = n;
                while (--n2 >= 0) {
                    objectArray[n2] = iterator.next();
                }
                return objectArray;
            }

            @Override
            public <T> T[] toArray(T[] objectArray) {
                int n = this.c.size();
                int n2 = 0;
                Iterator<Map.Entry<K, V>> iterator = this.iterator();
                if (n > objectArray.length) {
                    Class<?> clazz = objectArray.getClass().getComponentType();
                    objectArray = (Object[])Array.newInstance(clazz, n);
                }
                while (n2 < n) {
                    objectArray[n2++] = iterator.next();
                }
                if (n2 < objectArray.length) {
                    objectArray[n2] = null;
                }
                return objectArray;
            }

            private static class UnmodifiableMapEntry<K, V>
            implements Map.Entry<K, V> {
                Map.Entry<K, V> mapEntry;

                UnmodifiableMapEntry(Map.Entry<K, V> entry) {
                    this.mapEntry = entry;
                }

                @Override
                public boolean equals(Object object) {
                    return ((Object)this.mapEntry).equals(object);
                }

                @Override
                public K getKey() {
                    return this.mapEntry.getKey();
                }

                @Override
                public V getValue() {
                    return this.mapEntry.getValue();
                }

                @Override
                public int hashCode() {
                    return ((Object)this.mapEntry).hashCode();
                }

                @Override
                public V setValue(V v) {
                    throw new UnsupportedOperationException();
                }

                public String toString() {
                    return this.mapEntry.toString();
                }
            }
        }
    }

    private static class UnmodifiableList<E>
    extends UnmodifiableCollection<E>
    implements List<E> {
        private static final long serialVersionUID = -283967356065247728L;
        final List<E> list;

        UnmodifiableList(List<E> list) {
            super(list);
            this.list = list;
        }

        @Override
        public void add(int n, E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(int n, Collection<? extends E> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object object) {
            return ((Object)this.list).equals(object);
        }

        @Override
        public E get(int n) {
            return this.list.get(n);
        }

        @Override
        public int hashCode() {
            return ((Object)this.list).hashCode();
        }

        @Override
        public int indexOf(Object object) {
            return this.list.indexOf(object);
        }

        @Override
        public int lastIndexOf(Object object) {
            return this.list.lastIndexOf(object);
        }

        @Override
        public ListIterator<E> listIterator() {
            return this.listIterator(0);
        }

        @Override
        public ListIterator<E> listIterator(final int n) {
            return new ListIterator<E>(){
                ListIterator<E> iterator;
                {
                    this.iterator = UnmodifiableList.this.list.listIterator(n);
                }

                @Override
                public void add(E e) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean hasNext() {
                    return this.iterator.hasNext();
                }

                @Override
                public boolean hasPrevious() {
                    return this.iterator.hasPrevious();
                }

                @Override
                public E next() {
                    return this.iterator.next();
                }

                @Override
                public int nextIndex() {
                    return this.iterator.nextIndex();
                }

                @Override
                public E previous() {
                    return this.iterator.previous();
                }

                @Override
                public int previousIndex() {
                    return this.iterator.previousIndex();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void set(E e) {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public E remove(int n) {
            throw new UnsupportedOperationException();
        }

        @Override
        public E set(int n, E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<E> subList(int n, int n2) {
            return new UnmodifiableList<E>(this.list.subList(n, n2));
        }

        private Object readResolve() {
            if (this.list instanceof RandomAccess) {
                return new UnmodifiableRandomAccessList<E>(this.list);
            }
            return this;
        }
    }

    private static class UnmodifiableRandomAccessList<E>
    extends UnmodifiableList<E>
    implements RandomAccess {
        private static final long serialVersionUID = -2542308836966382001L;

        UnmodifiableRandomAccessList(List<E> list) {
            super(list);
        }

        @Override
        public List<E> subList(int n, int n2) {
            return new UnmodifiableRandomAccessList(this.list.subList(n, n2));
        }

        private Object writeReplace() {
            return new UnmodifiableList(this.list);
        }
    }

    private static class UnmodifiableCollection<E>
    implements Collection<E>,
    Serializable {
        private static final long serialVersionUID = 1820017752578914078L;
        final Collection<E> c;

        UnmodifiableCollection(Collection<E> collection) {
            this.c = collection;
        }

        @Override
        public boolean add(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends E> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object object) {
            return this.c.contains(object);
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            return this.c.containsAll(collection);
        }

        @Override
        public boolean isEmpty() {
            return this.c.isEmpty();
        }

        @Override
        public Iterator<E> iterator() {
            return new Iterator<E>(){
                Iterator<E> iterator;
                {
                    this.iterator = UnmodifiableCollection.this.c.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.iterator.hasNext();
                }

                @Override
                public E next() {
                    return this.iterator.next();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public boolean remove(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.c.size();
        }

        @Override
        public Object[] toArray() {
            return this.c.toArray();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            return this.c.toArray(TArray);
        }

        public String toString() {
            return this.c.toString();
        }
    }

    static class SynchronizedSortedSet<E>
    extends SynchronizedSet<E>
    implements SortedSet<E> {
        private static final long serialVersionUID = 8695801310862127406L;
        private final SortedSet<E> ss;

        SynchronizedSortedSet(SortedSet<E> sortedSet) {
            super(sortedSet);
            this.ss = sortedSet;
        }

        SynchronizedSortedSet(SortedSet<E> sortedSet, Object object) {
            super(sortedSet, object);
            this.ss = sortedSet;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Comparator<? super E> comparator() {
            Object object = this.mutex;
            synchronized (object) {
                return this.ss.comparator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E first() {
            Object object = this.mutex;
            synchronized (object) {
                return this.ss.first();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedSet<E> headSet(E e) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedSortedSet<E>(this.ss.headSet(e), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E last() {
            Object object = this.mutex;
            synchronized (object) {
                return this.ss.last();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedSet<E> subSet(E e, E e2) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedSortedSet<E>(this.ss.subSet(e, e2), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedSet<E> tailSet(E e) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedSortedSet<E>(this.ss.tailSet(e), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            Object object = this.mutex;
            synchronized (object) {
                objectOutputStream.defaultWriteObject();
            }
        }
    }

    static class SynchronizedSortedMap<K, V>
    extends SynchronizedMap<K, V>
    implements SortedMap<K, V> {
        private static final long serialVersionUID = -8798146769416483793L;
        private final SortedMap<K, V> sm;

        SynchronizedSortedMap(SortedMap<K, V> sortedMap) {
            super(sortedMap);
            this.sm = sortedMap;
        }

        SynchronizedSortedMap(SortedMap<K, V> sortedMap, Object object) {
            super(sortedMap, object);
            this.sm = sortedMap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Comparator<? super K> comparator() {
            Object object = this.mutex;
            synchronized (object) {
                return this.sm.comparator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public K firstKey() {
            Object object = this.mutex;
            synchronized (object) {
                return this.sm.firstKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedMap<K, V> headMap(K k) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedSortedMap<K, V>(this.sm.headMap(k), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public K lastKey() {
            Object object = this.mutex;
            synchronized (object) {
                return this.sm.lastKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedMap<K, V> subMap(K k, K k2) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedSortedMap<K, V>(this.sm.subMap(k, k2), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedMap<K, V> tailMap(K k) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedSortedMap<K, V>(this.sm.tailMap(k), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            Object object = this.mutex;
            synchronized (object) {
                objectOutputStream.defaultWriteObject();
            }
        }
    }

    static class SynchronizedSet<E>
    extends SynchronizedCollection<E>
    implements Set<E> {
        private static final long serialVersionUID = 487447009682186044L;

        SynchronizedSet(Set<E> set) {
            super(set);
        }

        SynchronizedSet(Set<E> set, Object object) {
            super(set, object);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return ((Object)this.c).equals(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int hashCode() {
            Object object = this.mutex;
            synchronized (object) {
                return ((Object)this.c).hashCode();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            Object object = this.mutex;
            synchronized (object) {
                objectOutputStream.defaultWriteObject();
            }
        }
    }

    static class SynchronizedMap<K, V>
    implements Map<K, V>,
    Serializable {
        private static final long serialVersionUID = 1978198479659022715L;
        private final Map<K, V> m;
        final Object mutex;

        SynchronizedMap(Map<K, V> map) {
            this.m = map;
            this.mutex = this;
        }

        SynchronizedMap(Map<K, V> map, Object object) {
            this.m = map;
            this.mutex = object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.mutex;
            synchronized (object) {
                this.m.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsKey(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.m.containsKey(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsValue(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.m.containsValue(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedSet<Map.Entry<K, V>>(this.m.entrySet(), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return ((Object)this.m).equals(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V get(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.m.get(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int hashCode() {
            Object object = this.mutex;
            synchronized (object) {
                return ((Object)this.m).hashCode();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isEmpty() {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<K> keySet() {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedSet<K>(this.m.keySet(), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V put(K k, V v) {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.put(k, v);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void putAll(Map<? extends K, ? extends V> map) {
            Object object = this.mutex;
            synchronized (object) {
                this.m.putAll(map);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V remove(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.m.remove(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<V> values() {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedCollection<V>(this.m.values(), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.toString();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            Object object = this.mutex;
            synchronized (object) {
                objectOutputStream.defaultWriteObject();
            }
        }
    }

    static class SynchronizedList<E>
    extends SynchronizedCollection<E>
    implements List<E> {
        private static final long serialVersionUID = -7754090372962971524L;
        final List<E> list;

        SynchronizedList(List<E> list) {
            super(list);
            this.list = list;
        }

        SynchronizedList(List<E> list, Object object) {
            super(list, object);
            this.list = list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(int n, E e) {
            Object object = this.mutex;
            synchronized (object) {
                this.list.add(n, e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(int n, Collection<? extends E> collection) {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.addAll(n, collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return ((Object)this.list).equals(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E get(int n) {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.get(n);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int hashCode() {
            Object object = this.mutex;
            synchronized (object) {
                return ((Object)this.list).hashCode();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object object) {
            Object[] objectArray;
            int n;
            Object object2 = this.mutex;
            synchronized (object2) {
                n = this.list.size();
                objectArray = new Object[n];
                this.list.toArray(objectArray);
            }
            if (null != object) {
                for (int i = 0; i < n; ++i) {
                    if (!object.equals(objectArray[i])) continue;
                    return i;
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    if (null != objectArray[i]) continue;
                    return i;
                }
            }
            return -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int lastIndexOf(Object object) {
            Object[] objectArray;
            Object object2 = this.mutex;
            synchronized (object2) {
                int n = this.list.size();
                objectArray = new Object[n];
                this.list.toArray(objectArray);
            }
            if (null != object) {
                for (int i = n - 1; i >= 0; --i) {
                    if (!object.equals(objectArray[i])) continue;
                    return i;
                }
            } else {
                for (int i = n - 1; i >= 0; --i) {
                    if (null != objectArray[i]) continue;
                    return i;
                }
            }
            return -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ListIterator<E> listIterator() {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.listIterator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ListIterator<E> listIterator(int n) {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.listIterator(n);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E remove(int n) {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.remove(n);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E set(int n, E e) {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.set(n, e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<E> subList(int n, int n2) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedList<E>(this.list.subList(n, n2), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            Object object = this.mutex;
            synchronized (object) {
                objectOutputStream.defaultWriteObject();
            }
        }

        private Object readResolve() {
            if (this.list instanceof RandomAccess) {
                return new SynchronizedRandomAccessList<E>(this.list, this.mutex);
            }
            return this;
        }
    }

    static class SynchronizedRandomAccessList<E>
    extends SynchronizedList<E>
    implements RandomAccess {
        private static final long serialVersionUID = 1530674583602358482L;

        SynchronizedRandomAccessList(List<E> list) {
            super(list);
        }

        SynchronizedRandomAccessList(List<E> list, Object object) {
            super(list, object);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<E> subList(int n, int n2) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedRandomAccessList(this.list.subList(n, n2), this.mutex);
            }
        }

        private Object writeReplace() {
            return new SynchronizedList(this.list);
        }
    }

    static class SynchronizedCollection<E>
    implements Collection<E>,
    Serializable {
        private static final long serialVersionUID = 3053995032091335093L;
        final Collection<E> c;
        final Object mutex;

        SynchronizedCollection(Collection<E> collection) {
            this.c = collection;
            this.mutex = this;
        }

        SynchronizedCollection(Collection<E> collection, Object object) {
            this.c = collection;
            this.mutex = object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean add(E e) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.add(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(Collection<? extends E> collection) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.addAll(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.mutex;
            synchronized (object) {
                this.c.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.c.contains(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsAll(Collection<?> collection) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.containsAll(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isEmpty() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Iterator<E> iterator() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.iterator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.c.remove(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean removeAll(Collection<?> collection) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.removeAll(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean retainAll(Collection<?> collection) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.retainAll(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] toArray() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.toArray();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.toString();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T[] toArray(T[] TArray) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.toArray(TArray);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            Object object = this.mutex;
            synchronized (object) {
                objectOutputStream.defaultWriteObject();
            }
        }
    }

    private static final class SingletonMap<K, V>
    extends AbstractMap<K, V>
    implements Serializable {
        private static final long serialVersionUID = -6979724477215052911L;
        final K k;
        final V v;

        SingletonMap(K k, V v) {
            this.k = k;
            this.v = v;
        }

        @Override
        public boolean containsKey(Object object) {
            return this.k == null ? object == null : this.k.equals(object);
        }

        @Override
        public boolean containsValue(Object object) {
            return this.v == null ? object == null : this.v.equals(object);
        }

        @Override
        public V get(Object object) {
            if (this.containsKey(object)) {
                return this.v;
            }
            return null;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return new AbstractSet<Map.Entry<K, V>>(){

                @Override
                public boolean contains(Object object) {
                    if (object instanceof Map.Entry) {
                        Map.Entry entry = (Map.Entry)object;
                        return SingletonMap.this.containsKey(entry.getKey()) && SingletonMap.this.containsValue(entry.getValue());
                    }
                    return false;
                }

                @Override
                public int size() {
                    return 1;
                }

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    return new Iterator<Map.Entry<K, V>>(){
                        boolean hasNext = true;

                        @Override
                        public boolean hasNext() {
                            return this.hasNext;
                        }

                        @Override
                        public Map.Entry<K, V> next() {
                            if (this.hasNext) {
                                this.hasNext = false;
                                return new Map.Entry<K, V>(){

                                    @Override
                                    public boolean equals(Object object) {
                                        return this.contains(object);
                                    }

                                    @Override
                                    public K getKey() {
                                        return SingletonMap.this.k;
                                    }

                                    @Override
                                    public V getValue() {
                                        return SingletonMap.this.v;
                                    }

                                    @Override
                                    public int hashCode() {
                                        return (SingletonMap.this.k == null ? 0 : SingletonMap.this.k.hashCode()) ^ (SingletonMap.this.v == null ? 0 : SingletonMap.this.v.hashCode());
                                    }

                                    @Override
                                    public V setValue(V v) {
                                        throw new UnsupportedOperationException();
                                    }
                                };
                            }
                            throw new NoSuchElementException();
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }
            };
        }
    }

    private static final class SingletonList<E>
    extends AbstractList<E>
    implements Serializable {
        private static final long serialVersionUID = 3093736618740652951L;
        final E element;

        SingletonList(E e) {
            this.element = e;
        }

        @Override
        public boolean contains(Object object) {
            return this.element == null ? object == null : this.element.equals(object);
        }

        @Override
        public E get(int n) {
            if (n == 0) {
                return this.element;
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public int size() {
            return 1;
        }
    }

    private static final class SingletonSet<E>
    extends AbstractSet<E>
    implements Serializable {
        private static final long serialVersionUID = 3193687207550431679L;
        final E element;

        SingletonSet(E e) {
            this.element = e;
        }

        @Override
        public boolean contains(Object object) {
            return this.element == null ? object == null : this.element.equals(object);
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public Iterator<E> iterator() {
            return new Iterator<E>(){
                boolean hasNext = true;

                @Override
                public boolean hasNext() {
                    return this.hasNext;
                }

                @Override
                public E next() {
                    if (this.hasNext) {
                        this.hasNext = false;
                        return SingletonSet.this.element;
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    private static final class ReverseComparatorWithComparator<T>
    implements Comparator<T>,
    Serializable {
        private static final long serialVersionUID = 4374092139857L;
        private final Comparator<T> comparator;

        ReverseComparatorWithComparator(Comparator<T> comparator) {
            this.comparator = comparator;
        }

        @Override
        public int compare(T t, T t2) {
            return this.comparator.compare(t2, t);
        }
    }

    private static final class ReverseComparator<T>
    implements Comparator<T>,
    Serializable {
        private static final long serialVersionUID = 7207038068494060240L;

        private ReverseComparator() {
        }

        @Override
        public int compare(T t, T t2) {
            Comparable comparable = (Comparable)t2;
            return comparable.compareTo(t);
        }
    }

    private static final class EmptyMap
    extends AbstractMap
    implements Serializable {
        private static final long serialVersionUID = 6428348081105594320L;

        private EmptyMap() {
        }

        @Override
        public boolean containsKey(Object object) {
            return false;
        }

        @Override
        public boolean containsValue(Object object) {
            return false;
        }

        @Override
        public Set entrySet() {
            return EMPTY_SET;
        }

        @Override
        public Object get(Object object) {
            return null;
        }

        @Override
        public Set keySet() {
            return EMPTY_SET;
        }

        @Override
        public Collection values() {
            return EMPTY_LIST;
        }

        private Object readResolve() {
            return EMPTY_MAP;
        }
    }

    private static final class EmptySet
    extends AbstractSet
    implements Serializable {
        private static final long serialVersionUID = 1582296315990362920L;

        private EmptySet() {
        }

        @Override
        public boolean contains(Object object) {
            return false;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public Iterator iterator() {
            return new Iterator(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                public Object next() {
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        private Object readResolve() {
            return EMPTY_SET;
        }
    }

    private static final class EmptyList
    extends AbstractList
    implements RandomAccess,
    Serializable {
        private static final long serialVersionUID = 8842843931221139166L;

        private EmptyList() {
        }

        @Override
        public boolean contains(Object object) {
            return false;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public Object get(int n) {
            throw new IndexOutOfBoundsException();
        }

        private Object readResolve() {
            return EMPTY_LIST;
        }
    }

    private static final class CopiesList<E>
    extends AbstractList<E>
    implements Serializable {
        private static final long serialVersionUID = 2739099268398711800L;
        private final int n;
        private final E element;

        CopiesList(int n, E e) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            this.n = n;
            this.element = e;
        }

        @Override
        public boolean contains(Object object) {
            return this.element == null ? object == null : this.element.equals(object);
        }

        @Override
        public int size() {
            return this.n;
        }

        @Override
        public E get(int n) {
            if (0 <= n && n < this.n) {
                return this.element;
            }
            throw new IndexOutOfBoundsException();
        }
    }
}

