/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.apache.harmony.luni.util.Msg;

public class BitSet
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 7997698588986878753L;
    private static final int OFFSET = 6;
    private static final int ELM_SIZE = 64;
    private static final int RIGHT_BITS = 63;
    private static final long[] TWO_N_ARRAY = new long[]{1L, 2L, 4L, 8L, 16L, 32L, 64L, 128L, 256L, 512L, 1024L, 2048L, 4096L, 8192L, 16384L, 32768L, 65536L, 131072L, 262144L, 524288L, 0x100000L, 0x200000L, 0x400000L, 0x800000L, 0x1000000L, 0x2000000L, 0x4000000L, 0x8000000L, 0x10000000L, 0x20000000L, 0x40000000L, 0x80000000L, 0x100000000L, 0x200000000L, 0x400000000L, 0x800000000L, 0x1000000000L, 0x2000000000L, 0x4000000000L, 0x8000000000L, 0x10000000000L, 0x20000000000L, 0x40000000000L, 0x80000000000L, 0x100000000000L, 0x200000000000L, 0x400000000000L, 0x800000000000L, 0x1000000000000L, 0x2000000000000L, 0x4000000000000L, 0x8000000000000L, 0x10000000000000L, 0x20000000000000L, 0x40000000000000L, 0x80000000000000L, 0x100000000000000L, 0x200000000000000L, 0x400000000000000L, 0x800000000000000L, 0x1000000000000000L, 0x2000000000000000L, 0x4000000000000000L, Long.MIN_VALUE};
    private long[] bits;
    private transient boolean needClear;
    private transient int actualArrayLength;
    private transient boolean isLengthActual;

    public BitSet() {
        this.bits = new long[1];
        this.actualArrayLength = 0;
        this.isLengthActual = true;
    }

    public BitSet(int n) {
        if (n < 0) {
            throw new NegativeArraySizeException();
        }
        this.bits = new long[(n >> 6) + ((n & 0x3F) > 0 ? 1 : 0)];
        this.actualArrayLength = 0;
        this.isLengthActual = true;
    }

    private BitSet(long[] lArray, boolean bl, int n, boolean bl2) {
        this.bits = lArray;
        this.needClear = bl;
        this.actualArrayLength = n;
        this.isLengthActual = bl2;
    }

    public Object clone() {
        try {
            BitSet bitSet = (BitSet)super.clone();
            bitSet.bits = (long[])this.bits.clone();
            return bitSet;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof BitSet) {
            long[] lArray = ((BitSet)object).bits;
            int n = this.actualArrayLength;
            int n2 = ((BitSet)object).actualArrayLength;
            if (this.isLengthActual && ((BitSet)object).isLengthActual && n != n2) {
                return false;
            }
            if (n <= n2) {
                int n3;
                for (n3 = 0; n3 < n; ++n3) {
                    if (this.bits[n3] == lArray[n3]) continue;
                    return false;
                }
                for (n3 = n; n3 < n2; ++n3) {
                    if (lArray[n3] == 0L) continue;
                    return false;
                }
            } else {
                int n4;
                for (n4 = 0; n4 < n2; ++n4) {
                    if (this.bits[n4] == lArray[n4]) continue;
                    return false;
                }
                for (n4 = n2; n4 < n; ++n4) {
                    if (this.bits[n4] == 0L) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private final void growLength(int n) {
        long[] lArray = new long[Math.max(n, this.bits.length * 2)];
        System.arraycopy(this.bits, 0, lArray, 0, this.actualArrayLength);
        this.bits = lArray;
    }

    public int hashCode() {
        long l = 1234L;
        int n = this.actualArrayLength;
        for (int i = 0; i < n; ++i) {
            l ^= this.bits[i] * (long)(i + 1);
        }
        return (int)(l >> 32 ^ l);
    }

    public boolean get(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException(Msg.getString("K0006"));
        }
        int n2 = n >> 6;
        if (n2 < this.actualArrayLength) {
            return (this.bits[n2] & TWO_N_ARRAY[n & 0x3F]) != 0L;
        }
        return false;
    }

    public BitSet get(int n, int n2) {
        int n3;
        if (n < 0 || n2 < 0 || n2 < n) {
            throw new IndexOutOfBoundsException(Msg.getString("K0006"));
        }
        int n4 = this.actualArrayLength << 6;
        if (n >= n4 || n == n2) {
            return new BitSet(0);
        }
        if (n2 > n4) {
            n2 = n4;
        }
        int n5 = n >> 6;
        int n6 = n2 - 1 >> 6;
        long l = -1L << (n & 0x3F);
        long l2 = -1L >>> 64 - (n2 & 0x3F);
        if (n5 == n6) {
            long l3 = (this.bits[n5] & (l & l2)) >>> n % 64;
            if (l3 == 0L) {
                return new BitSet(0);
            }
            return new BitSet(new long[]{l3}, this.needClear, 1, true);
        }
        long[] lArray = new long[n6 - n5 + 1];
        lArray[0] = this.bits[n5] & l;
        lArray[lArray.length - 1] = this.bits[n6] & l2;
        for (n3 = 1; n3 < n6 - n5; ++n3) {
            lArray[n3] = this.bits[n5 + n3];
        }
        n3 = n & 0x3F;
        int n7 = lArray.length;
        if (n3 != 0) {
            for (int i = 0; i < lArray.length; ++i) {
                lArray[i] = lArray[i] >>> n3;
                if (i != lArray.length - 1) {
                    int n8 = i;
                    lArray[n8] = lArray[n8] | lArray[i + 1] << 64 - n3;
                }
                if (lArray[i] == 0L) continue;
                n7 = i + 1;
            }
        }
        return new BitSet(lArray, this.needClear, n7, lArray[n7 - 1] != 0L);
    }

    public void set(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException(Msg.getString("K0006"));
        }
        int n2 = (n >> 6) + 1;
        if (n2 > this.bits.length) {
            this.growLength(n2);
        }
        int n3 = n2 - 1;
        this.bits[n3] = this.bits[n3] | TWO_N_ARRAY[n & 0x3F];
        if (n2 > this.actualArrayLength) {
            this.actualArrayLength = n2;
            this.isLengthActual = true;
        }
        this.needClear();
    }

    public void set(int n, boolean bl) {
        if (bl) {
            this.set(n);
        } else {
            this.clear(n);
        }
    }

    public void set(int n, int n2) {
        if (n < 0 || n2 < 0 || n2 < n) {
            throw new IndexOutOfBoundsException(Msg.getString("K0006"));
        }
        if (n == n2) {
            return;
        }
        int n3 = (n2 - 1 >> 6) + 1;
        if (n3 > this.bits.length) {
            this.growLength(n3);
        }
        int n4 = n >> 6;
        int n5 = n2 - 1 >> 6;
        long l = -1L << (n & 0x3F);
        long l2 = -1L >>> 64 - (n2 & 0x3F);
        if (n4 == n5) {
            int n6 = n4;
            this.bits[n6] = this.bits[n6] | l & l2;
        } else {
            int n7 = n4;
            this.bits[n7] = this.bits[n7] | l;
            int n8 = n5;
            this.bits[n8] = this.bits[n8] | l2;
            int n9 = n4 + 1;
            while (n9 < n5) {
                int n10 = n9++;
                this.bits[n10] = this.bits[n10] | 0xFFFFFFFFFFFFFFFFL;
            }
        }
        if (n5 + 1 > this.actualArrayLength) {
            this.actualArrayLength = n5 + 1;
            this.isLengthActual = true;
        }
        this.needClear();
    }

    private void needClear() {
        this.needClear = true;
    }

    public void set(int n, int n2, boolean bl) {
        if (bl) {
            this.set(n, n2);
        } else {
            this.clear(n, n2);
        }
    }

    public void clear() {
        if (this.needClear) {
            for (int i = 0; i < this.bits.length; ++i) {
                this.bits[i] = 0L;
            }
            this.actualArrayLength = 0;
            this.isLengthActual = true;
            this.needClear = false;
        }
    }

    public void clear(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException(Msg.getString("K0006"));
        }
        if (!this.needClear) {
            return;
        }
        int n2 = n >> 6;
        if (n2 < this.actualArrayLength) {
            int n3 = n2;
            this.bits[n3] = this.bits[n3] & (TWO_N_ARRAY[n & 0x3F] ^ 0xFFFFFFFFFFFFFFFFL);
            if (this.bits[this.actualArrayLength - 1] == 0L) {
                this.isLengthActual = false;
            }
        }
    }

    public void clear(int n, int n2) {
        if (n < 0 || n2 < 0 || n2 < n) {
            throw new IndexOutOfBoundsException(Msg.getString("K0006"));
        }
        if (!this.needClear) {
            return;
        }
        int n3 = this.actualArrayLength << 6;
        if (n >= n3 || n == n2) {
            return;
        }
        if (n2 > n3) {
            n2 = n3;
        }
        int n4 = n >> 6;
        int n5 = n2 - 1 >> 6;
        long l = -1L << (n & 0x3F);
        long l2 = -1L >>> 64 - (n2 & 0x3F);
        if (n4 == n5) {
            int n6 = n4;
            this.bits[n6] = this.bits[n6] & (l & l2 ^ 0xFFFFFFFFFFFFFFFFL);
        } else {
            int n7 = n4;
            this.bits[n7] = this.bits[n7] & (l ^ 0xFFFFFFFFFFFFFFFFL);
            int n8 = n5;
            this.bits[n8] = this.bits[n8] & (l2 ^ 0xFFFFFFFFFFFFFFFFL);
            for (int i = n4 + 1; i < n5; ++i) {
                this.bits[i] = 0L;
            }
        }
        if (this.actualArrayLength > 0 && this.bits[this.actualArrayLength - 1] == 0L) {
            this.isLengthActual = false;
        }
    }

    public void flip(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException(Msg.getString("K0006"));
        }
        int n2 = (n >> 6) + 1;
        if (n2 > this.bits.length) {
            this.growLength(n2);
        }
        int n3 = n2 - 1;
        this.bits[n3] = this.bits[n3] ^ TWO_N_ARRAY[n & 0x3F];
        if (n2 > this.actualArrayLength) {
            this.actualArrayLength = n2;
        }
        this.isLengthActual = this.actualArrayLength <= 0 || this.bits[this.actualArrayLength - 1] != 0L;
        this.needClear();
    }

    public void flip(int n, int n2) {
        if (n < 0 || n2 < 0 || n2 < n) {
            throw new IndexOutOfBoundsException(Msg.getString("K0006"));
        }
        if (n == n2) {
            return;
        }
        int n3 = (n2 - 1 >> 6) + 1;
        if (n3 > this.bits.length) {
            this.growLength(n3);
        }
        int n4 = n >> 6;
        int n5 = n2 - 1 >> 6;
        long l = -1L << (n & 0x3F);
        long l2 = -1L >>> 64 - (n2 & 0x3F);
        if (n4 == n5) {
            int n6 = n4;
            this.bits[n6] = this.bits[n6] ^ l & l2;
        } else {
            int n7 = n4;
            this.bits[n7] = this.bits[n7] ^ l;
            int n8 = n5;
            this.bits[n8] = this.bits[n8] ^ l2;
            int n9 = n4 + 1;
            while (n9 < n5) {
                int n10 = n9++;
                this.bits[n10] = this.bits[n10] ^ 0xFFFFFFFFFFFFFFFFL;
            }
        }
        if (n3 > this.actualArrayLength) {
            this.actualArrayLength = n3;
        }
        this.isLengthActual = this.actualArrayLength <= 0 || this.bits[this.actualArrayLength - 1] != 0L;
        this.needClear();
    }

    public boolean intersects(BitSet bitSet) {
        long[] lArray = bitSet.bits;
        int n = this.actualArrayLength;
        int n2 = bitSet.actualArrayLength;
        if (n <= n2) {
            for (int i = 0; i < n; ++i) {
                if ((this.bits[i] & lArray[i]) == 0L) continue;
                return true;
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                if ((this.bits[i] & lArray[i]) == 0L) continue;
                return true;
            }
        }
        return false;
    }

    public void and(BitSet bitSet) {
        long[] lArray = bitSet.bits;
        if (!this.needClear) {
            return;
        }
        int n = this.actualArrayLength;
        int n2 = bitSet.actualArrayLength;
        if (n <= n2) {
            for (int i = 0; i < n; ++i) {
                int n3 = i;
                this.bits[n3] = this.bits[n3] & lArray[i];
            }
        } else {
            int n4;
            for (n4 = 0; n4 < n2; ++n4) {
                int n5 = n4;
                this.bits[n5] = this.bits[n5] & lArray[n4];
            }
            for (n4 = n2; n4 < n; ++n4) {
                this.bits[n4] = 0L;
            }
            this.actualArrayLength = n2;
        }
        this.isLengthActual = this.actualArrayLength <= 0 || this.bits[this.actualArrayLength - 1] != 0L;
    }

    public void andNot(BitSet bitSet) {
        long[] lArray = bitSet.bits;
        if (!this.needClear) {
            return;
        }
        int n = this.actualArrayLength < bitSet.actualArrayLength ? this.actualArrayLength : bitSet.actualArrayLength;
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            this.bits[n2] = this.bits[n2] & (lArray[i] ^ 0xFFFFFFFFFFFFFFFFL);
        }
        if (this.actualArrayLength < n) {
            this.actualArrayLength = n;
        }
        this.isLengthActual = this.actualArrayLength <= 0 || this.bits[this.actualArrayLength - 1] != 0L;
    }

    public void or(BitSet bitSet) {
        int n = bitSet.getActualArrayLength();
        if (n > this.bits.length) {
            long[] lArray = new long[n];
            System.arraycopy(bitSet.bits, 0, lArray, 0, bitSet.actualArrayLength);
            for (int i = 0; i < this.actualArrayLength; ++i) {
                int n2 = i;
                lArray[n2] = lArray[n2] | this.bits[i];
            }
            this.bits = lArray;
            this.actualArrayLength = n;
            this.isLengthActual = true;
        } else {
            long[] lArray = bitSet.bits;
            for (int i = 0; i < n; ++i) {
                int n3 = i;
                this.bits[n3] = this.bits[n3] | lArray[i];
            }
            if (n > this.actualArrayLength) {
                this.actualArrayLength = n;
                this.isLengthActual = true;
            }
        }
        this.needClear();
    }

    public void xor(BitSet bitSet) {
        int n = bitSet.getActualArrayLength();
        if (n > this.bits.length) {
            long[] lArray = new long[n];
            System.arraycopy(bitSet.bits, 0, lArray, 0, bitSet.actualArrayLength);
            for (int i = 0; i < this.actualArrayLength; ++i) {
                int n2 = i;
                lArray[n2] = lArray[n2] ^ this.bits[i];
            }
            this.bits = lArray;
            this.actualArrayLength = n;
            this.isLengthActual = this.actualArrayLength <= 0 || this.bits[this.actualArrayLength - 1] != 0L;
        } else {
            long[] lArray = bitSet.bits;
            for (int i = 0; i < n; ++i) {
                int n3 = i;
                this.bits[n3] = this.bits[n3] ^ lArray[i];
            }
            if (n > this.actualArrayLength) {
                this.actualArrayLength = n;
                this.isLengthActual = true;
            }
        }
        this.needClear();
    }

    public int size() {
        return this.bits.length << 6;
    }

    public int length() {
        int n;
        int n2;
        for (n2 = this.actualArrayLength - 1; n2 >= 0 && this.bits[n2] == 0L; --n2) {
        }
        this.actualArrayLength = n2 + 1;
        if (n2 == -1) {
            return 0;
        }
        long l = this.bits[n2];
        for (n = 63; (l & TWO_N_ARRAY[n]) == 0L && n > 0; --n) {
        }
        return (n2 << 6) + n + 1;
    }

    private final int getActualArrayLength() {
        int n;
        if (this.isLengthActual) {
            return this.actualArrayLength;
        }
        for (n = this.actualArrayLength - 1; n >= 0 && this.bits[n] == 0L; --n) {
        }
        this.actualArrayLength = n + 1;
        this.isLengthActual = true;
        return this.actualArrayLength;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.bits.length / 2);
        int n = 0;
        stringBuffer.append('{');
        boolean bl = false;
        for (int i = 0; i < this.bits.length; ++i) {
            if (this.bits[i] == 0L) {
                n += 64;
                continue;
            }
            for (int j = 0; j < 64; ++j) {
                if ((this.bits[i] & TWO_N_ARRAY[j]) != 0L) {
                    if (bl) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(n);
                    bl = true;
                }
                ++n;
            }
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    public int nextSetBit(int n) {
        int n2;
        if (n < 0) {
            throw new IndexOutOfBoundsException(Msg.getString("K0006"));
        }
        if (n >= this.actualArrayLength << 6) {
            return -1;
        }
        int n3 = n >> 6;
        if (this.bits[n3] != 0L) {
            for (n2 = n & 0x3F; n2 < 64; ++n2) {
                if ((this.bits[n3] & TWO_N_ARRAY[n2]) == 0L) continue;
                return (n3 << 6) + n2;
            }
        }
        ++n3;
        while (n3 < this.actualArrayLength && this.bits[n3] == 0L) {
            ++n3;
        }
        if (n3 == this.actualArrayLength) {
            return -1;
        }
        for (n2 = 0; n2 < 64; ++n2) {
            if ((this.bits[n3] & TWO_N_ARRAY[n2]) == 0L) continue;
            return (n3 << 6) + n2;
        }
        return -1;
    }

    public int nextClearBit(int n) {
        int n2;
        if (n < 0) {
            throw new IndexOutOfBoundsException(Msg.getString("K0006"));
        }
        int n3 = this.actualArrayLength;
        int n4 = n3 << 6;
        if (n >= n4) {
            return n;
        }
        int n5 = n >> 6;
        if (this.bits[n5] != -1L) {
            for (n2 = n % 64; n2 < 64; ++n2) {
                if ((this.bits[n5] & TWO_N_ARRAY[n2]) != 0L) continue;
                return n5 * 64 + n2;
            }
        }
        ++n5;
        while (n5 < n3 && this.bits[n5] == -1L) {
            ++n5;
        }
        if (n5 == n3) {
            return n4;
        }
        for (n2 = 0; n2 < 64; ++n2) {
            if ((this.bits[n5] & TWO_N_ARRAY[n2]) != 0L) continue;
            return (n5 << 6) + n2;
        }
        return n4;
    }

    public boolean isEmpty() {
        if (!this.needClear) {
            return true;
        }
        int n = this.bits.length;
        for (int i = 0; i < n; ++i) {
            if (this.bits[i] == 0L) continue;
            return false;
        }
        return true;
    }

    public int cardinality() {
        if (!this.needClear) {
            return 0;
        }
        int n = 0;
        int n2 = this.bits.length;
        for (int i = 0; i < n2; ++i) {
            n += this.pop(this.bits[i] & 0xFFFFFFFFL);
            n += this.pop(this.bits[i] >>> 32);
        }
        return n;
    }

    private final int pop(long l) {
        l -= l >>> 1 & 0x55555555L;
        l = (l & 0x33333333L) + (l >>> 2 & 0x33333333L);
        l = l + (l >>> 4) & 0xF0F0F0FL;
        l += l >>> 8;
        l += l >>> 16;
        return (int)l & 0x3F;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.isLengthActual = false;
        this.actualArrayLength = this.bits.length;
        this.needClear = this.getActualArrayLength() != 0;
    }
}

