/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.RandomAccess;

public class ArrayList<E>
extends AbstractList<E>
implements List<E>,
Cloneable,
Serializable,
RandomAccess {
    private static final long serialVersionUID = 8683452581122892189L;
    private transient int firstIndex;
    private transient int lastIndex;
    private transient E[] array;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("size", Integer.TYPE)};

    public ArrayList() {
        this(10);
    }

    public ArrayList(int n) {
        this.lastIndex = 0;
        this.firstIndex = 0;
        try {
            this.array = this.newElementArray(n);
        }
        catch (NegativeArraySizeException negativeArraySizeException) {
            throw new IllegalArgumentException();
        }
    }

    public ArrayList(Collection<? extends E> collection) {
        int n = collection.size();
        this.firstIndex = 0;
        this.array = this.newElementArray(n + n / 10);
        collection.toArray(this.array);
        this.lastIndex = n;
        this.modCount = 1;
    }

    private E[] newElementArray(int n) {
        return new Object[n];
    }

    @Override
    public void add(int n, E e) {
        int n2 = this.lastIndex - this.firstIndex;
        if (0 < n && n < n2) {
            if (this.firstIndex == 0 && this.lastIndex == this.array.length) {
                this.growForInsert(n, 1);
            } else if (n < n2 / 2 && this.firstIndex > 0 || this.lastIndex == this.array.length) {
                System.arraycopy(this.array, this.firstIndex, this.array, --this.firstIndex, n);
            } else {
                int n3 = n + this.firstIndex;
                System.arraycopy(this.array, n3, this.array, n3 + 1, n2 - n);
                ++this.lastIndex;
            }
            this.array[n + this.firstIndex] = e;
        } else if (n == 0) {
            if (this.firstIndex == 0) {
                this.growAtFront(1);
            }
            this.array[--this.firstIndex] = e;
        } else if (n == n2) {
            if (this.lastIndex == this.array.length) {
                this.growAtEnd(1);
            }
            this.array[this.lastIndex++] = e;
        } else {
            throw new IndexOutOfBoundsException();
        }
        ++this.modCount;
    }

    @Override
    public boolean add(E e) {
        if (this.lastIndex == this.array.length) {
            this.growAtEnd(1);
        }
        this.array[this.lastIndex++] = e;
        ++this.modCount;
        return true;
    }

    @Override
    public boolean addAll(int n, Collection<? extends E> collection) {
        int n2 = this.lastIndex - this.firstIndex;
        if (n < 0 || n > n2) {
            throw new IndexOutOfBoundsException();
        }
        int n3 = collection.size();
        if (0 < n && n < n2) {
            int n4;
            if (this.array.length - n2 < n3) {
                this.growForInsert(n, n3);
            } else if (n < n2 / 2 && this.firstIndex > 0 || this.lastIndex > this.array.length - n3) {
                n4 = this.firstIndex - n3;
                if (n4 < 0) {
                    int n5 = n + this.firstIndex;
                    System.arraycopy(this.array, n5, this.array, n5 - n4, n2 - n);
                    this.lastIndex -= n4;
                    n4 = 0;
                }
                System.arraycopy(this.array, this.firstIndex, this.array, n4, n);
                this.firstIndex = n4;
            } else {
                n4 = n + this.firstIndex;
                System.arraycopy(this.array, n4, this.array, n4 + n3, n2 - n);
                this.lastIndex += n3;
            }
        } else if (n == 0) {
            this.growAtFront(n3);
            this.firstIndex -= n3;
        } else if (n == n2) {
            if (this.lastIndex > this.array.length - n3) {
                this.growAtEnd(n3);
            }
            this.lastIndex += n3;
        }
        if (n3 > 0) {
            Object[] objectArray = new Object[n3];
            collection.toArray(objectArray);
            System.arraycopy(objectArray, 0, this.array, n + this.firstIndex, n3);
            ++this.modCount;
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        Object[] objectArray = collection.toArray();
        if (objectArray.length == 0) {
            return false;
        }
        if (objectArray.length > this.array.length - this.lastIndex) {
            this.growAtEnd(objectArray.length);
        }
        System.arraycopy(objectArray, 0, this.array, this.lastIndex, objectArray.length);
        this.lastIndex += objectArray.length;
        ++this.modCount;
        return true;
    }

    @Override
    public void clear() {
        if (this.firstIndex != this.lastIndex) {
            Arrays.fill(this.array, this.firstIndex, this.lastIndex, null);
            this.lastIndex = 0;
            this.firstIndex = 0;
            ++this.modCount;
        }
    }

    public Object clone() {
        try {
            ArrayList arrayList = (ArrayList)super.clone();
            arrayList.array = (Object[])this.array.clone();
            return arrayList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    @Override
    public boolean contains(Object object) {
        if (object != null) {
            for (int i = this.firstIndex; i < this.lastIndex; ++i) {
                if (!object.equals(this.array[i])) continue;
                return true;
            }
        } else {
            for (int i = this.firstIndex; i < this.lastIndex; ++i) {
                if (this.array[i] != null) continue;
                return true;
            }
        }
        return false;
    }

    public void ensureCapacity(int n) {
        if (this.array.length < n) {
            if (this.firstIndex > 0) {
                this.growAtFront(n - this.array.length);
            } else {
                this.growAtEnd(n - this.array.length);
            }
        }
    }

    @Override
    public E get(int n) {
        if (0 <= n && n < this.lastIndex - this.firstIndex) {
            return this.array[this.firstIndex + n];
        }
        throw new IndexOutOfBoundsException();
    }

    private void growAtEnd(int n) {
        int n2 = this.lastIndex - this.firstIndex;
        if (this.firstIndex >= n - (this.array.length - this.lastIndex)) {
            int n3 = this.lastIndex - this.firstIndex;
            if (n2 > 0) {
                System.arraycopy(this.array, this.firstIndex, this.array, 0, n2);
                int n4 = n3 < this.firstIndex ? this.firstIndex : n3;
                Arrays.fill(this.array, n4, this.array.length, null);
            }
            this.firstIndex = 0;
            this.lastIndex = n3;
        } else {
            int n5 = n2 / 2;
            if (n > n5) {
                n5 = n;
            }
            if (n5 < 12) {
                n5 = 12;
            }
            E[] EArray = this.newElementArray(n2 + n5);
            if (n2 > 0) {
                System.arraycopy(this.array, this.firstIndex, EArray, 0, n2);
                this.firstIndex = 0;
                this.lastIndex = n2;
            }
            this.array = EArray;
        }
    }

    private void growAtFront(int n) {
        int n2 = this.lastIndex - this.firstIndex;
        if (this.array.length - this.lastIndex + this.firstIndex >= n) {
            int n3 = this.array.length - n2;
            if (n2 > 0) {
                System.arraycopy(this.array, this.firstIndex, this.array, n3, n2);
                int n4 = this.firstIndex + n2 > n3 ? n3 : this.firstIndex + n2;
                Arrays.fill(this.array, this.firstIndex, n4, null);
            }
            this.firstIndex = n3;
            this.lastIndex = this.array.length;
        } else {
            int n5 = n2 / 2;
            if (n > n5) {
                n5 = n;
            }
            if (n5 < 12) {
                n5 = 12;
            }
            E[] EArray = this.newElementArray(n2 + n5);
            if (n2 > 0) {
                System.arraycopy(this.array, this.firstIndex, EArray, EArray.length - n2, n2);
            }
            this.firstIndex = EArray.length - n2;
            this.lastIndex = EArray.length;
            this.array = EArray;
        }
    }

    private void growForInsert(int n, int n2) {
        int n3 = this.lastIndex - this.firstIndex;
        int n4 = n3 / 2;
        if (n2 > n4) {
            n4 = n2;
        }
        if (n4 < 12) {
            n4 = 12;
        }
        E[] EArray = this.newElementArray(n3 + n4);
        if (n < n3 / 2) {
            int n5 = EArray.length - (n3 + n2);
            System.arraycopy(this.array, n + this.firstIndex, EArray, n + n4, n3 - n);
            System.arraycopy(this.array, this.firstIndex, EArray, n5, n);
            this.firstIndex = n5;
            this.lastIndex = EArray.length;
        } else {
            System.arraycopy(this.array, this.firstIndex, EArray, 0, n);
            System.arraycopy(this.array, n + this.firstIndex, EArray, n + n2, n3 - n);
            this.firstIndex = 0;
            this.lastIndex = n3 + n2;
        }
        this.array = EArray;
    }

    @Override
    public int indexOf(Object object) {
        if (object != null) {
            for (int i = this.firstIndex; i < this.lastIndex; ++i) {
                if (!object.equals(this.array[i])) continue;
                return i - this.firstIndex;
            }
        } else {
            for (int i = this.firstIndex; i < this.lastIndex; ++i) {
                if (this.array[i] != null) continue;
                return i - this.firstIndex;
            }
        }
        return -1;
    }

    @Override
    public boolean isEmpty() {
        return this.lastIndex == this.firstIndex;
    }

    @Override
    public int lastIndexOf(Object object) {
        if (object != null) {
            for (int i = this.lastIndex - 1; i >= this.firstIndex; --i) {
                if (!object.equals(this.array[i])) continue;
                return i - this.firstIndex;
            }
        } else {
            for (int i = this.lastIndex - 1; i >= this.firstIndex; --i) {
                if (this.array[i] != null) continue;
                return i - this.firstIndex;
            }
        }
        return -1;
    }

    @Override
    public E remove(int n) {
        E e;
        int n2 = this.lastIndex - this.firstIndex;
        if (0 <= n && n < n2) {
            if (n == n2 - 1) {
                e = this.array[--this.lastIndex];
                this.array[this.lastIndex] = null;
            } else if (n == 0) {
                e = this.array[this.firstIndex];
                this.array[this.firstIndex++] = null;
            } else {
                int n3 = this.firstIndex + n;
                e = this.array[n3];
                if (n < n2 / 2) {
                    System.arraycopy(this.array, this.firstIndex, this.array, this.firstIndex + 1, n);
                    this.array[this.firstIndex++] = null;
                } else {
                    System.arraycopy(this.array, n3 + 1, this.array, n3, n2 - n - 1);
                    this.array[--this.lastIndex] = null;
                }
            }
            if (this.firstIndex == this.lastIndex) {
                this.lastIndex = 0;
                this.firstIndex = 0;
            }
        } else {
            throw new IndexOutOfBoundsException();
        }
        ++this.modCount;
        return e;
    }

    @Override
    public boolean remove(Object object) {
        int n = this.indexOf(object);
        if (n >= 0) {
            this.remove(n);
            return true;
        }
        return false;
    }

    @Override
    protected void removeRange(int n, int n2) {
        if (n >= 0 && n <= n2 && n2 <= this.lastIndex - this.firstIndex) {
            if (n == n2) {
                return;
            }
            int n3 = this.lastIndex - this.firstIndex;
            if (n2 == n3) {
                Arrays.fill(this.array, this.firstIndex + n, this.lastIndex, null);
                this.lastIndex = this.firstIndex + n;
            } else if (n == 0) {
                Arrays.fill(this.array, this.firstIndex, this.firstIndex + n2, null);
                this.firstIndex += n2;
            } else {
                System.arraycopy(this.array, this.firstIndex + n2, this.array, this.firstIndex + n, n3 - n2);
                int n4 = this.lastIndex + n - n2;
                Arrays.fill(this.array, n4, this.lastIndex, null);
                this.lastIndex = n4;
            }
            ++this.modCount;
        } else {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public E set(int n, E e) {
        if (0 <= n && n < this.lastIndex - this.firstIndex) {
            E e2 = this.array[this.firstIndex + n];
            this.array[this.firstIndex + n] = e;
            return e2;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int size() {
        return this.lastIndex - this.firstIndex;
    }

    @Override
    public Object[] toArray() {
        int n = this.lastIndex - this.firstIndex;
        Object[] objectArray = new Object[n];
        System.arraycopy(this.array, this.firstIndex, objectArray, 0, n);
        return objectArray;
    }

    @Override
    public <T> T[] toArray(T[] objectArray) {
        int n = this.lastIndex - this.firstIndex;
        if (n > objectArray.length) {
            Class<?> clazz = objectArray.getClass().getComponentType();
            objectArray = (Object[])Array.newInstance(clazz, n);
        }
        System.arraycopy(this.array, this.firstIndex, objectArray, 0, n);
        if (n < objectArray.length) {
            objectArray[n] = null;
        }
        return objectArray;
    }

    public void trimToSize() {
        int n = this.lastIndex - this.firstIndex;
        E[] EArray = this.newElementArray(n);
        System.arraycopy(this.array, this.firstIndex, EArray, 0, n);
        this.array = EArray;
        this.firstIndex = 0;
        this.lastIndex = this.array.length;
        this.modCount = 0;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("size", this.lastIndex - this.firstIndex);
        objectOutputStream.writeFields();
        objectOutputStream.writeInt(this.array.length);
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            objectOutputStream.writeObject(iterator.next());
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        this.lastIndex = getField.get("size", 0);
        this.array = this.newElementArray(objectInputStream.readInt());
        for (int i = 0; i < this.lastIndex; ++i) {
            this.array[i] = objectInputStream.readObject();
        }
    }
}

