/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.axes;

import javax.xml.transform.TransformerException;
import org.apache.xml.dtm.DTMAxisIterator;
import org.apache.xml.dtm.DTMAxisTraverser;
import org.apache.xml.dtm.DTMIterator;
import org.apache.xpath.Expression;
import org.apache.xpath.XPathContext;
import org.apache.xpath.axes.ChildTestIterator;
import org.apache.xpath.axes.WalkerFactory;
import org.apache.xpath.compiler.Compiler;

public class OneStepIterator
extends ChildTestIterator {
    static final long serialVersionUID = 4623710779664998283L;
    protected int m_axis = -1;
    protected DTMAxisIterator m_iterator;

    OneStepIterator(Compiler compiler, int n, int n2) throws TransformerException {
        super(compiler, n, n2);
        int n3 = Compiler.getFirstChildPos(n);
        this.m_axis = WalkerFactory.getAxisFromStep(compiler, n3);
    }

    public OneStepIterator(DTMAxisIterator dTMAxisIterator, int n) throws TransformerException {
        super((DTMAxisTraverser)null);
        this.m_iterator = dTMAxisIterator;
        this.m_axis = n;
        int n2 = -1;
        this.initNodeTest(n2);
    }

    public void setRoot(int n, Object object) {
        super.setRoot(n, object);
        if (this.m_axis > -1) {
            this.m_iterator = this.m_cdtm.getAxisIterator(this.m_axis);
        }
        this.m_iterator.setStartNode(this.m_context);
    }

    public void detach() {
        if (this.m_allowDetach) {
            if (this.m_axis > -1) {
                this.m_iterator = null;
            }
            super.detach();
        }
    }

    protected int getNextNode() {
        this.m_lastFetched = this.m_iterator.next();
        return this.m_lastFetched;
    }

    public Object clone() throws CloneNotSupportedException {
        OneStepIterator oneStepIterator = (OneStepIterator)super.clone();
        if (this.m_iterator != null) {
            oneStepIterator.m_iterator = this.m_iterator.cloneIterator();
        }
        return oneStepIterator;
    }

    public DTMIterator cloneWithReset() throws CloneNotSupportedException {
        OneStepIterator oneStepIterator = (OneStepIterator)super.cloneWithReset();
        oneStepIterator.m_iterator = this.m_iterator;
        return oneStepIterator;
    }

    public boolean isReverseAxes() {
        return this.m_iterator.isReverse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getProximityPosition(int n) {
        if (!this.isReverseAxes()) {
            return super.getProximityPosition(n);
        }
        if (n < 0) {
            return -1;
        }
        if (this.m_proximityPositions[n] <= 0) {
            XPathContext xPathContext = this.getXPathContext();
            try {
                int n2;
                OneStepIterator oneStepIterator = (OneStepIterator)this.clone();
                int n3 = this.getRoot();
                xPathContext.pushCurrentNode(n3);
                oneStepIterator.setRoot(n3, xPathContext);
                oneStepIterator.m_predCount = n;
                int n4 = 1;
                while (-1 != (n2 = oneStepIterator.nextNode())) {
                    ++n4;
                }
                int n5 = n;
                this.m_proximityPositions[n5] = this.m_proximityPositions[n5] + n4;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
            }
            finally {
                xPathContext.popCurrentNode();
            }
        }
        return this.m_proximityPositions[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLength() {
        if (!this.isReverseAxes()) {
            return super.getLength();
        }
        boolean bl = this == this.m_execContext.getSubContextList();
        int n = this.getPredicateCount();
        if (-1 != this.m_length && bl && this.m_predicateIndex < 1) {
            return this.m_length;
        }
        int n2 = 0;
        XPathContext xPathContext = this.getXPathContext();
        try {
            int n3;
            OneStepIterator oneStepIterator = (OneStepIterator)this.cloneWithReset();
            int n4 = this.getRoot();
            xPathContext.pushCurrentNode(n4);
            oneStepIterator.setRoot(n4, xPathContext);
            oneStepIterator.m_predCount = this.m_predicateIndex;
            while (-1 != (n3 = oneStepIterator.nextNode())) {
                ++n2;
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
        }
        finally {
            xPathContext.popCurrentNode();
        }
        if (bl && this.m_predicateIndex < 1) {
            this.m_length = n2;
        }
        return n2;
    }

    protected void countProximityPosition(int n) {
        if (!this.isReverseAxes()) {
            super.countProximityPosition(n);
        } else if (n < this.m_proximityPositions.length) {
            int n2 = n;
            this.m_proximityPositions[n2] = this.m_proximityPositions[n2] - 1;
        }
    }

    public void reset() {
        super.reset();
        if (null != this.m_iterator) {
            this.m_iterator.reset();
        }
    }

    public int getAxis() {
        return this.m_axis;
    }

    public boolean deepEquals(Expression expression) {
        if (!super.deepEquals(expression)) {
            return false;
        }
        return this.m_axis == ((OneStepIterator)expression).m_axis;
    }
}

