/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serializer.dom3;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.xml.serializer.DOM3Serializer;
import org.apache.xml.serializer.Encodings;
import org.apache.xml.serializer.OutputPropertiesFactory;
import org.apache.xml.serializer.Serializer;
import org.apache.xml.serializer.SerializerFactory;
import org.apache.xml.serializer.dom3.DOMErrorImpl;
import org.apache.xml.serializer.dom3.DOMStringListImpl;
import org.apache.xml.serializer.utils.SystemIDResolver;
import org.apache.xml.serializer.utils.Utils;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMErrorHandler;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMStringList;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.ls.LSException;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.w3c.dom.ls.LSSerializerFilter;

public final class LSSerializerImpl
implements DOMConfiguration,
LSSerializer {
    private static final String DEFAULT_END_OF_LINE;
    private Serializer fXMLSerializer = null;
    protected int fFeatures = 0;
    private DOM3Serializer fDOMSerializer = null;
    private LSSerializerFilter fSerializerFilter = null;
    private Node fVisitedNode = null;
    private String fEndOfLine = DEFAULT_END_OF_LINE;
    private DOMErrorHandler fDOMErrorHandler = null;
    private Properties fDOMConfigProperties = null;
    private String fEncoding;
    private static final int CANONICAL = 1;
    private static final int CDATA = 2;
    private static final int CHARNORMALIZE = 4;
    private static final int COMMENTS = 8;
    private static final int DTNORMALIZE = 16;
    private static final int ELEM_CONTENT_WHITESPACE = 32;
    private static final int ENTITIES = 64;
    private static final int INFOSET = 128;
    private static final int NAMESPACES = 256;
    private static final int NAMESPACEDECLS = 512;
    private static final int NORMALIZECHARS = 1024;
    private static final int SPLITCDATA = 2048;
    private static final int VALIDATE = 4096;
    private static final int SCHEMAVALIDATE = 8192;
    private static final int WELLFORMED = 16384;
    private static final int DISCARDDEFAULT = 32768;
    private static final int PRETTY_PRINT = 65536;
    private static final int IGNORE_CHAR_DENORMALIZE = 131072;
    private static final int XMLDECL = 262144;
    private String[] fRecognizedParameters = new String[]{"canonical-form", "cdata-sections", "check-character-normalization", "comments", "datatype-normalization", "element-content-whitespace", "entities", "infoset", "namespaces", "namespace-declarations", "split-cdata-sections", "validate", "validate-if-schema", "well-formed", "discard-default-content", "format-pretty-print", "ignore-unknown-character-denormalizations", "xml-declaration", "error-handler"};
    static /* synthetic */ Class class$java$lang$Throwable;

    public LSSerializerImpl() {
        this.fFeatures |= 2;
        this.fFeatures |= 8;
        this.fFeatures |= 0x20;
        this.fFeatures |= 0x40;
        this.fFeatures |= 0x100;
        this.fFeatures |= 0x200;
        this.fFeatures |= 0x800;
        this.fFeatures |= 0x4000;
        this.fFeatures |= 0x8000;
        this.fFeatures |= 0x40000;
        this.fDOMConfigProperties = new Properties();
        this.initializeSerializerProps();
        Properties properties = OutputPropertiesFactory.getDefaultMethodProperties("xml");
        this.fXMLSerializer = SerializerFactory.getSerializer(properties);
        this.fXMLSerializer.setOutputFormat(this.fDOMConfigProperties);
    }

    public void initializeSerializerProps() {
        this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}canonical-form", "no");
        this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}cdata-sections", "yes");
        this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}check-character-normalization", "no");
        this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}comments", "yes");
        this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}datatype-normalization", "no");
        this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}element-content-whitespace", "yes");
        this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}entities", "yes");
        this.fDOMConfigProperties.setProperty("{http://xml.apache.org/xerces-2j}entities", "yes");
        if ((this.fFeatures & 0x80) != 0) {
            this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}namespaces", "yes");
            this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}namespace-declarations", "yes");
            this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}comments", "yes");
            this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}element-content-whitespace", "yes");
            this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}well-formed", "yes");
            this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}entities", "no");
            this.fDOMConfigProperties.setProperty("{http://xml.apache.org/xerces-2j}entities", "no");
            this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}cdata-sections", "no");
            this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}validate-if-schema", "no");
            this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}datatype-normalization", "no");
        }
        this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}namespaces", "yes");
        this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}namespace-declarations", "yes");
        this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}split-cdata-sections", "yes");
        this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}validate", "no");
        this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}validate-if-schema", "no");
        this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}well-formed", "yes");
        this.fDOMConfigProperties.setProperty("indent", "no");
        this.fDOMConfigProperties.setProperty("{http://xml.apache.org/xalan}indent-amount", Integer.toString(3));
        this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}discard-default-content", "yes");
        this.fDOMConfigProperties.setProperty("omit-xml-declaration", "no");
    }

    public boolean canSetParameter(String string, Object object) {
        if (object instanceof Boolean) {
            if (string.equalsIgnoreCase("cdata-sections") || string.equalsIgnoreCase("comments") || string.equalsIgnoreCase("entities") || string.equalsIgnoreCase("infoset") || string.equalsIgnoreCase("element-content-whitespace") || string.equalsIgnoreCase("namespaces") || string.equalsIgnoreCase("namespace-declarations") || string.equalsIgnoreCase("split-cdata-sections") || string.equalsIgnoreCase("well-formed") || string.equalsIgnoreCase("discard-default-content") || string.equalsIgnoreCase("format-pretty-print") || string.equalsIgnoreCase("xml-declaration")) {
                return true;
            }
            if (string.equalsIgnoreCase("canonical-form") || string.equalsIgnoreCase("check-character-normalization") || string.equalsIgnoreCase("datatype-normalization") || string.equalsIgnoreCase("validate-if-schema") || string.equalsIgnoreCase("validate")) {
                return (Boolean)object == false;
            }
            if (string.equalsIgnoreCase("ignore-unknown-character-denormalizations")) {
                return (Boolean)object;
            }
        } else if (string.equalsIgnoreCase("error-handler") && object == null || object instanceof DOMErrorHandler) {
            return true;
        }
        return false;
    }

    public Object getParameter(String string) throws DOMException {
        if (string.equalsIgnoreCase("comments")) {
            return (this.fFeatures & 8) != 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (string.equalsIgnoreCase("cdata-sections")) {
            return (this.fFeatures & 2) != 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (string.equalsIgnoreCase("entities")) {
            return (this.fFeatures & 0x40) != 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (string.equalsIgnoreCase("namespaces")) {
            return (this.fFeatures & 0x100) != 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (string.equalsIgnoreCase("namespace-declarations")) {
            return (this.fFeatures & 0x200) != 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (string.equalsIgnoreCase("split-cdata-sections")) {
            return (this.fFeatures & 0x800) != 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (string.equalsIgnoreCase("well-formed")) {
            return (this.fFeatures & 0x4000) != 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (string.equalsIgnoreCase("discard-default-content")) {
            return (this.fFeatures & 0x8000) != 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (string.equalsIgnoreCase("format-pretty-print")) {
            return (this.fFeatures & 0x10000) != 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (string.equalsIgnoreCase("xml-declaration")) {
            return (this.fFeatures & 0x40000) != 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (string.equalsIgnoreCase("element-content-whitespace")) {
            return (this.fFeatures & 0x20) != 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (string.equalsIgnoreCase("format-pretty-print")) {
            return (this.fFeatures & 0x10000) != 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (string.equalsIgnoreCase("ignore-unknown-character-denormalizations")) {
            return Boolean.TRUE;
        }
        if (string.equalsIgnoreCase("canonical-form") || string.equalsIgnoreCase("check-character-normalization") || string.equalsIgnoreCase("datatype-normalization") || string.equalsIgnoreCase("validate") || string.equalsIgnoreCase("validate-if-schema")) {
            return Boolean.FALSE;
        }
        if (string.equalsIgnoreCase("infoset")) {
            if ((this.fFeatures & 0x40) == 0 && (this.fFeatures & 2) == 0 && (this.fFeatures & 0x20) != 0 && (this.fFeatures & 0x100) != 0 && (this.fFeatures & 0x200) != 0 && (this.fFeatures & 0x4000) != 0 && (this.fFeatures & 8) != 0) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (string.equalsIgnoreCase("error-handler")) {
            return this.fDOMErrorHandler;
        }
        if (string.equalsIgnoreCase("schema-location") || string.equalsIgnoreCase("schema-type")) {
            return null;
        }
        String string2 = Utils.messages.createMessage("ER_FEATURE_NOT_FOUND", new Object[]{string});
        throw new DOMException(8, string2);
    }

    public DOMStringList getParameterNames() {
        return new DOMStringListImpl(this.fRecognizedParameters);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setParameter(String string, Object object) throws DOMException {
        if (object instanceof Boolean) {
            boolean bl = (Boolean)object;
            if (string.equalsIgnoreCase("comments")) {
                int n = this.fFeatures = bl ? this.fFeatures | 8 : this.fFeatures & 0xFFFFFFF7;
                if (bl) {
                    this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}comments", "yes");
                    return;
                }
                this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}comments", "no");
                return;
            }
            if (string.equalsIgnoreCase("cdata-sections")) {
                int n = this.fFeatures = bl ? this.fFeatures | 2 : this.fFeatures & 0xFFFFFFFD;
                if (bl) {
                    this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}cdata-sections", "yes");
                    return;
                }
                this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}cdata-sections", "no");
                return;
            }
            if (string.equalsIgnoreCase("entities")) {
                int n = this.fFeatures = bl ? this.fFeatures | 0x40 : this.fFeatures & 0xFFFFFFBF;
                if (bl) {
                    this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}entities", "yes");
                    this.fDOMConfigProperties.setProperty("{http://xml.apache.org/xerces-2j}entities", "yes");
                    return;
                }
                this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}entities", "no");
                this.fDOMConfigProperties.setProperty("{http://xml.apache.org/xerces-2j}entities", "no");
                return;
            }
            if (string.equalsIgnoreCase("namespaces")) {
                int n = this.fFeatures = bl ? this.fFeatures | 0x100 : this.fFeatures & 0xFFFFFEFF;
                if (bl) {
                    this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}namespaces", "yes");
                    return;
                }
                this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}namespaces", "no");
                return;
            }
            if (string.equalsIgnoreCase("namespace-declarations")) {
                int n = this.fFeatures = bl ? this.fFeatures | 0x200 : this.fFeatures & 0xFFFFFDFF;
                if (bl) {
                    this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}namespace-declarations", "yes");
                    return;
                }
                this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}namespace-declarations", "no");
                return;
            }
            if (string.equalsIgnoreCase("split-cdata-sections")) {
                int n = this.fFeatures = bl ? this.fFeatures | 0x800 : this.fFeatures & 0xFFFFF7FF;
                if (bl) {
                    this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}split-cdata-sections", "yes");
                    return;
                }
                this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}split-cdata-sections", "no");
                return;
            }
            if (string.equalsIgnoreCase("well-formed")) {
                int n = this.fFeatures = bl ? this.fFeatures | 0x4000 : this.fFeatures & 0xFFFFBFFF;
                if (bl) {
                    this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}well-formed", "yes");
                    return;
                }
                this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}well-formed", "no");
                return;
            }
            if (string.equalsIgnoreCase("discard-default-content")) {
                int n = this.fFeatures = bl ? this.fFeatures | 0x8000 : this.fFeatures & 0xFFFF7FFF;
                if (bl) {
                    this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}discard-default-content", "yes");
                    return;
                }
                this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}discard-default-content", "no");
                return;
            }
            if (string.equalsIgnoreCase("format-pretty-print")) {
                int n = this.fFeatures = bl ? this.fFeatures | 0x10000 : this.fFeatures & 0xFFFEFFFF;
                if (bl) {
                    this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}format-pretty-print", "yes");
                    return;
                }
                this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}format-pretty-print", "no");
                return;
            }
            if (string.equalsIgnoreCase("xml-declaration")) {
                int n = this.fFeatures = bl ? this.fFeatures | 0x40000 : this.fFeatures & 0xFFFBFFFF;
                if (bl) {
                    this.fDOMConfigProperties.setProperty("omit-xml-declaration", "no");
                    return;
                }
                this.fDOMConfigProperties.setProperty("omit-xml-declaration", "yes");
                return;
            }
            if (string.equalsIgnoreCase("element-content-whitespace")) {
                int n = this.fFeatures = bl ? this.fFeatures | 0x20 : this.fFeatures & 0xFFFFFFDF;
                if (bl) {
                    this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}element-content-whitespace", "yes");
                    return;
                }
                this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}element-content-whitespace", "no");
                return;
            }
            if (string.equalsIgnoreCase("ignore-unknown-character-denormalizations")) {
                if (!bl) {
                    String string2 = Utils.messages.createMessage("ER_FEATURE_NOT_SUPPORTED", new Object[]{string});
                    throw new DOMException(9, string2);
                }
                this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}ignore-unknown-character-denormalizations", "yes");
                return;
            }
            if (string.equalsIgnoreCase("canonical-form") || string.equalsIgnoreCase("validate-if-schema") || string.equalsIgnoreCase("validate") || string.equalsIgnoreCase("check-character-normalization") || string.equalsIgnoreCase("datatype-normalization")) {
                if (bl) {
                    String string3 = Utils.messages.createMessage("ER_FEATURE_NOT_SUPPORTED", new Object[]{string});
                    throw new DOMException(9, string3);
                }
                if (string.equalsIgnoreCase("canonical-form")) {
                    this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}canonical-form", "no");
                    return;
                }
                if (string.equalsIgnoreCase("validate-if-schema")) {
                    this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}validate-if-schema", "no");
                    return;
                }
                if (string.equalsIgnoreCase("validate")) {
                    this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}validate", "no");
                    return;
                }
                if (string.equalsIgnoreCase("validate-if-schema")) {
                    this.fDOMConfigProperties.setProperty("check-character-normalizationcheck-character-normalization", "no");
                    return;
                }
                if (!string.equalsIgnoreCase("datatype-normalization")) return;
                this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}datatype-normalization", "no");
                return;
            }
            if (string.equalsIgnoreCase("infoset")) {
                if (!bl) return;
                this.fFeatures &= 0xFFFFFFBF;
                this.fFeatures &= 0xFFFFFFFD;
                this.fFeatures &= 0xFFFFDFFF;
                this.fFeatures &= 0xFFFFFFEF;
                this.fFeatures |= 0x100;
                this.fFeatures |= 0x200;
                this.fFeatures |= 0x4000;
                this.fFeatures |= 0x20;
                this.fFeatures |= 8;
                this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}namespaces", "yes");
                this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}namespace-declarations", "yes");
                this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}comments", "yes");
                this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}element-content-whitespace", "yes");
                this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}well-formed", "yes");
                this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}entities", "no");
                this.fDOMConfigProperties.setProperty("{http://xml.apache.org/xerces-2j}entities", "no");
                this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}cdata-sections", "no");
                this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}validate-if-schema", "no");
                this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}datatype-normalization", "no");
                return;
            }
            if (!(string.equalsIgnoreCase("error-handler") || string.equalsIgnoreCase("schema-location") || string.equalsIgnoreCase("schema-type"))) {
                String string4 = Utils.messages.createMessage("ER_FEATURE_NOT_FOUND", new Object[]{string});
                throw new DOMException(8, string4);
            }
            String string5 = Utils.messages.createMessage("ER_TYPE_MISMATCH_ERR", new Object[]{string});
            throw new DOMException(17, string5);
        }
        if (string.equalsIgnoreCase("error-handler")) {
            if (object != null && !(object instanceof DOMErrorHandler)) {
                String string6 = Utils.messages.createMessage("ER_TYPE_MISMATCH_ERR", new Object[]{string});
                throw new DOMException(17, string6);
            }
            this.fDOMErrorHandler = (DOMErrorHandler)object;
            return;
        }
        if (string.equalsIgnoreCase("schema-location") || string.equalsIgnoreCase("schema-type")) {
            if (object == null) return;
            if (!(object instanceof String)) {
                String string7 = Utils.messages.createMessage("ER_TYPE_MISMATCH_ERR", new Object[]{string});
                throw new DOMException(17, string7);
            }
            String string8 = Utils.messages.createMessage("ER_FEATURE_NOT_SUPPORTED", new Object[]{string});
            throw new DOMException(9, string8);
        }
        if (!(string.equalsIgnoreCase("comments") || string.equalsIgnoreCase("cdata-sections") || string.equalsIgnoreCase("entities") || string.equalsIgnoreCase("namespaces") || string.equalsIgnoreCase("namespace-declarations") || string.equalsIgnoreCase("split-cdata-sections") || string.equalsIgnoreCase("well-formed") || string.equalsIgnoreCase("discard-default-content") || string.equalsIgnoreCase("format-pretty-print") || string.equalsIgnoreCase("xml-declaration") || string.equalsIgnoreCase("element-content-whitespace") || string.equalsIgnoreCase("ignore-unknown-character-denormalizations") || string.equalsIgnoreCase("canonical-form") || string.equalsIgnoreCase("validate-if-schema") || string.equalsIgnoreCase("validate") || string.equalsIgnoreCase("check-character-normalization") || string.equalsIgnoreCase("datatype-normalization") || string.equalsIgnoreCase("infoset"))) {
            String string9 = Utils.messages.createMessage("ER_FEATURE_NOT_FOUND", new Object[]{string});
            throw new DOMException(8, string9);
        }
        String string10 = Utils.messages.createMessage("ER_TYPE_MISMATCH_ERR", new Object[]{string});
        throw new DOMException(17, string10);
    }

    public DOMConfiguration getDomConfig() {
        return this;
    }

    public LSSerializerFilter getFilter() {
        return this.fSerializerFilter;
    }

    public String getNewLine() {
        return this.fEndOfLine;
    }

    public void setFilter(LSSerializerFilter lSSerializerFilter) {
        this.fSerializerFilter = lSSerializerFilter;
    }

    public void setNewLine(String string) {
        this.fEndOfLine = string != null ? string : DEFAULT_END_OF_LINE;
    }

    public boolean write(Node node, LSOutput lSOutput) throws LSException {
        Object object;
        if (lSOutput == null) {
            String string = Utils.messages.createMessage("ER_NO_OUTPUT_SPECIFIED", null);
            if (this.fDOMErrorHandler != null) {
                this.fDOMErrorHandler.handleError(new DOMErrorImpl(3, string, "no-output-specified"));
            }
            throw new LSException(82, string);
        }
        if (node == null) {
            return false;
        }
        Serializer serializer = this.fXMLSerializer;
        serializer.reset();
        if (node != this.fVisitedNode) {
            object = this.getXMLVersion(node);
            this.fEncoding = lSOutput.getEncoding();
            if (this.fEncoding == null) {
                this.fEncoding = this.getInputEncoding(node);
                String string = this.fEncoding != null ? this.fEncoding : (this.fEncoding = this.getXMLEncoding(node) == null ? "UTF-8" : this.getXMLEncoding(node));
            }
            if (!Encodings.isRecognizedEncoding(this.fEncoding)) {
                String string = Utils.messages.createMessage("ER_UNSUPPORTED_ENCODING", null);
                if (this.fDOMErrorHandler != null) {
                    this.fDOMErrorHandler.handleError(new DOMErrorImpl(3, string, "unsupported-encoding"));
                }
                throw new LSException(82, string);
            }
            serializer.getOutputFormat().setProperty("version", (String)object);
            this.fDOMConfigProperties.setProperty("{http://xml.apache.org/xerces-2j}xml-version", (String)object);
            this.fDOMConfigProperties.setProperty("encoding", this.fEncoding);
            if ((node.getNodeType() != 9 || node.getNodeType() != 1 || node.getNodeType() != 6) && (this.fFeatures & 0x40000) != 0) {
                this.fDOMConfigProperties.setProperty("omit-xml-declaration", "no");
            }
            this.fVisitedNode = node;
        }
        this.fXMLSerializer.setOutputFormat(this.fDOMConfigProperties);
        try {
            object = lSOutput.getCharacterStream();
            if (object == null) {
                OutputStream outputStream = lSOutput.getByteStream();
                if (outputStream == null) {
                    String string = lSOutput.getSystemId();
                    if (string == null) {
                        String string2 = Utils.messages.createMessage("ER_NO_OUTPUT_SPECIFIED", null);
                        if (this.fDOMErrorHandler != null) {
                            this.fDOMErrorHandler.handleError(new DOMErrorImpl(3, string2, "no-output-specified"));
                        }
                        throw new LSException(82, string2);
                    }
                    String string3 = SystemIDResolver.getAbsoluteURI(string);
                    URL uRL = new URL(string3);
                    OutputStream outputStream2 = null;
                    String string4 = uRL.getProtocol();
                    String string5 = uRL.getHost();
                    if (string4.equalsIgnoreCase("file") && (string5 == null || string5.length() == 0 || string5.equals("localhost"))) {
                        outputStream2 = new FileOutputStream(LSSerializerImpl.getPathWithoutEscapes(uRL.getPath()));
                    } else {
                        URLConnection uRLConnection = uRL.openConnection();
                        uRLConnection.setDoInput(false);
                        uRLConnection.setDoOutput(true);
                        uRLConnection.setUseCaches(false);
                        uRLConnection.setAllowUserInteraction(false);
                        if (uRLConnection instanceof HttpURLConnection) {
                            HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                            httpURLConnection.setRequestMethod("PUT");
                        }
                        outputStream2 = uRLConnection.getOutputStream();
                    }
                    serializer.setOutputStream(outputStream2);
                } else {
                    serializer.setOutputStream(outputStream);
                }
            } else {
                serializer.setWriter((Writer)object);
            }
            if (this.fDOMSerializer == null) {
                this.fDOMSerializer = (DOM3Serializer)serializer.asDOM3Serializer();
            }
            if (this.fDOMErrorHandler != null) {
                this.fDOMSerializer.setErrorHandler(this.fDOMErrorHandler);
            }
            if (this.fSerializerFilter != null) {
                this.fDOMSerializer.setNodeFilter(this.fSerializerFilter);
            }
            this.fDOMSerializer.setNewLine(this.fEndOfLine.toCharArray());
            this.fDOMSerializer.serializeDOM3(node);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String string = Utils.messages.createMessage("ER_UNSUPPORTED_ENCODING", null);
            if (this.fDOMErrorHandler != null) {
                this.fDOMErrorHandler.handleError(new DOMErrorImpl(3, string, "unsupported-encoding", unsupportedEncodingException));
            }
            throw (LSException)LSSerializerImpl.createLSException((short)82, unsupportedEncodingException).fillInStackTrace();
        }
        catch (LSException lSException) {
            throw lSException;
        }
        catch (RuntimeException runtimeException) {
            throw (LSException)LSSerializerImpl.createLSException((short)82, runtimeException).fillInStackTrace();
        }
        catch (Exception exception) {
            if (this.fDOMErrorHandler != null) {
                this.fDOMErrorHandler.handleError(new DOMErrorImpl(3, exception.getMessage(), null, exception));
            }
            throw (LSException)LSSerializerImpl.createLSException((short)82, exception).fillInStackTrace();
        }
        return true;
    }

    public String writeToString(Node node) throws DOMException, LSException {
        Object object;
        if (node == null) {
            return null;
        }
        Serializer serializer = this.fXMLSerializer;
        serializer.reset();
        if (node != this.fVisitedNode) {
            object = this.getXMLVersion(node);
            serializer.getOutputFormat().setProperty("version", (String)object);
            this.fDOMConfigProperties.setProperty("{http://xml.apache.org/xerces-2j}xml-version", (String)object);
            this.fDOMConfigProperties.setProperty("encoding", "UTF-16");
            if ((node.getNodeType() != 9 || node.getNodeType() != 1 || node.getNodeType() != 6) && (this.fFeatures & 0x40000) != 0) {
                this.fDOMConfigProperties.setProperty("omit-xml-declaration", "no");
            }
            this.fVisitedNode = node;
        }
        this.fXMLSerializer.setOutputFormat(this.fDOMConfigProperties);
        object = new StringWriter();
        try {
            serializer.setWriter((Writer)object);
            if (this.fDOMSerializer == null) {
                this.fDOMSerializer = (DOM3Serializer)serializer.asDOM3Serializer();
            }
            if (this.fDOMErrorHandler != null) {
                this.fDOMSerializer.setErrorHandler(this.fDOMErrorHandler);
            }
            if (this.fSerializerFilter != null) {
                this.fDOMSerializer.setNodeFilter(this.fSerializerFilter);
            }
            this.fDOMSerializer.setNewLine(this.fEndOfLine.toCharArray());
            this.fDOMSerializer.serializeDOM3(node);
        }
        catch (LSException lSException) {
            throw lSException;
        }
        catch (RuntimeException runtimeException) {
            throw (LSException)LSSerializerImpl.createLSException((short)82, runtimeException).fillInStackTrace();
        }
        catch (Exception exception) {
            if (this.fDOMErrorHandler != null) {
                this.fDOMErrorHandler.handleError(new DOMErrorImpl(3, exception.getMessage(), null, exception));
            }
            throw (LSException)LSSerializerImpl.createLSException((short)82, exception).fillInStackTrace();
        }
        return ((StringWriter)object).toString();
    }

    public boolean writeToURI(Node node, String string) throws LSException {
        String string2;
        if (node == null) {
            return false;
        }
        Serializer serializer = this.fXMLSerializer;
        serializer.reset();
        if (node != this.fVisitedNode) {
            string2 = this.getXMLVersion(node);
            this.fEncoding = this.getInputEncoding(node);
            if (this.fEncoding == null) {
                this.fEncoding = this.fEncoding != null ? this.fEncoding : (this.getXMLEncoding(node) == null ? "UTF-8" : this.getXMLEncoding(node));
            }
            serializer.getOutputFormat().setProperty("version", string2);
            this.fDOMConfigProperties.setProperty("{http://xml.apache.org/xerces-2j}xml-version", string2);
            this.fDOMConfigProperties.setProperty("encoding", this.fEncoding);
            if ((node.getNodeType() != 9 || node.getNodeType() != 1 || node.getNodeType() != 6) && (this.fFeatures & 0x40000) != 0) {
                this.fDOMConfigProperties.setProperty("omit-xml-declaration", "no");
            }
            this.fVisitedNode = node;
        }
        this.fXMLSerializer.setOutputFormat(this.fDOMConfigProperties);
        try {
            if (string == null) {
                string2 = Utils.messages.createMessage("ER_NO_OUTPUT_SPECIFIED", null);
                if (this.fDOMErrorHandler != null) {
                    this.fDOMErrorHandler.handleError(new DOMErrorImpl(3, string2, "no-output-specified"));
                }
                throw new LSException(82, string2);
            }
            string2 = SystemIDResolver.getAbsoluteURI(string);
            URL uRL = new URL(string2);
            OutputStream outputStream = null;
            String string3 = uRL.getProtocol();
            String string4 = uRL.getHost();
            if (string3.equalsIgnoreCase("file") && (string4 == null || string4.length() == 0 || string4.equals("localhost"))) {
                outputStream = new FileOutputStream(LSSerializerImpl.getPathWithoutEscapes(uRL.getPath()));
            } else {
                URLConnection uRLConnection = uRL.openConnection();
                uRLConnection.setDoInput(false);
                uRLConnection.setDoOutput(true);
                uRLConnection.setUseCaches(false);
                uRLConnection.setAllowUserInteraction(false);
                if (uRLConnection instanceof HttpURLConnection) {
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                    httpURLConnection.setRequestMethod("PUT");
                }
                outputStream = uRLConnection.getOutputStream();
            }
            serializer.setOutputStream(outputStream);
            if (this.fDOMSerializer == null) {
                this.fDOMSerializer = (DOM3Serializer)serializer.asDOM3Serializer();
            }
            if (this.fDOMErrorHandler != null) {
                this.fDOMSerializer.setErrorHandler(this.fDOMErrorHandler);
            }
            if (this.fSerializerFilter != null) {
                this.fDOMSerializer.setNodeFilter(this.fSerializerFilter);
            }
            this.fDOMSerializer.setNewLine(this.fEndOfLine.toCharArray());
            this.fDOMSerializer.serializeDOM3(node);
        }
        catch (LSException lSException) {
            throw lSException;
        }
        catch (RuntimeException runtimeException) {
            throw (LSException)LSSerializerImpl.createLSException((short)82, runtimeException).fillInStackTrace();
        }
        catch (Exception exception) {
            if (this.fDOMErrorHandler != null) {
                this.fDOMErrorHandler.handleError(new DOMErrorImpl(3, exception.getMessage(), null, exception));
            }
            throw (LSException)LSSerializerImpl.createLSException((short)82, exception).fillInStackTrace();
        }
        return true;
    }

    protected String getXMLVersion(Node node) {
        Document document = null;
        if (node != null && (document = node.getNodeType() == 9 ? (Document)node : node.getOwnerDocument()) != null && document.getImplementation().hasFeature("Core", "3.0")) {
            return document.getXmlVersion();
        }
        return "1.0";
    }

    protected String getXMLEncoding(Node node) {
        Document document = null;
        if (node != null && (document = node.getNodeType() == 9 ? (Document)node : node.getOwnerDocument()) != null && document.getImplementation().hasFeature("Core", "3.0")) {
            return document.getXmlEncoding();
        }
        return "UTF-8";
    }

    protected String getInputEncoding(Node node) {
        Document document = null;
        if (node != null && (document = node.getNodeType() == 9 ? (Document)node : node.getOwnerDocument()) != null && document.getImplementation().hasFeature("Core", "3.0")) {
            return document.getInputEncoding();
        }
        return null;
    }

    public DOMErrorHandler getErrorHandler() {
        return this.fDOMErrorHandler;
    }

    private static String getPathWithoutEscapes(String string) {
        if (string != null && string.length() != 0 && string.indexOf(37) != -1) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "%");
            StringBuffer stringBuffer = new StringBuffer(string.length());
            int n = stringTokenizer.countTokens();
            stringBuffer.append(stringTokenizer.nextToken());
            for (int i = 1; i < n; ++i) {
                String string2 = stringTokenizer.nextToken();
                if (string2.length() >= 2 && LSSerializerImpl.isHexDigit(string2.charAt(0)) && LSSerializerImpl.isHexDigit(string2.charAt(1))) {
                    stringBuffer.append((char)Integer.valueOf(string2.substring(0, 2), 16).intValue());
                    string2 = string2.substring(2);
                }
                stringBuffer.append(string2);
            }
            return stringBuffer.toString();
        }
        return string;
    }

    private static boolean isHexDigit(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    private static LSException createLSException(short s, Throwable throwable) {
        LSException lSException = new LSException(s, throwable != null ? throwable.getMessage() : null);
        if (throwable != null && ThrowableMethods.fgThrowableMethodsAvailable) {
            try {
                ThrowableMethods.fgThrowableInitCauseMethod.invoke((Object)lSException, throwable);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return lSException;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return System.getProperty("line.separator");
                }
                catch (SecurityException securityException) {
                    return null;
                }
            }
        });
        DEFAULT_END_OF_LINE = string != null && (string.equals("\r\n") || string.equals("\r")) ? string : "\n";
    }

    static class ThrowableMethods {
        private static Method fgThrowableInitCauseMethod = null;
        private static boolean fgThrowableMethodsAvailable = false;

        private ThrowableMethods() {
        }

        static {
            try {
                fgThrowableInitCauseMethod = (class$java$lang$Throwable == null ? (class$java$lang$Throwable = LSSerializerImpl.class$("java.lang.Throwable")) : class$java$lang$Throwable).getMethod("initCause", class$java$lang$Throwable == null ? (class$java$lang$Throwable = LSSerializerImpl.class$("java.lang.Throwable")) : class$java$lang$Throwable);
                fgThrowableMethodsAvailable = true;
            }
            catch (Exception exception) {
                fgThrowableInitCauseMethod = null;
                fgThrowableMethodsAvailable = false;
            }
        }
    }
}

