/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serializer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.xml.serializer.WriterChain;
import org.apache.xml.serializer.WriterOptimized;

final class WriterToUTF8Buffered
extends WriterOptimized
implements WriterChain {
    private static final int BYTES_MAX = 16384;
    private static final int CHARS_MAX = 5461;
    private OutputStream m_os;
    private final byte[] m_outputBytes;
    private final char[] m_inputChars;
    private int count;

    public WriterToUTF8Buffered(OutputStream outputStream) {
        this.m_os = outputStream;
        this.m_outputBytes = new byte[16387];
        this.m_inputChars = new char[5463];
        this.count = 0;
    }

    public void write(int n) throws IOException {
        if (this.count >= 16384) {
            this.flushBuffer();
        }
        if (n < 128) {
            this.m_outputBytes[this.count++] = (byte)n;
        } else if (n < 2048) {
            this.m_outputBytes[this.count++] = (byte)(192 + (n >> 6));
            this.m_outputBytes[this.count++] = (byte)(128 + (n & 0x3F));
        } else if (n < 65536) {
            this.m_outputBytes[this.count++] = (byte)(224 + (n >> 12));
            this.m_outputBytes[this.count++] = (byte)(128 + (n >> 6 & 0x3F));
            this.m_outputBytes[this.count++] = (byte)(128 + (n & 0x3F));
        } else {
            this.m_outputBytes[this.count++] = (byte)(240 + (n >> 18));
            this.m_outputBytes[this.count++] = (byte)(128 + (n >> 12 & 0x3F));
            this.m_outputBytes[this.count++] = (byte)(128 + (n >> 6 & 0x3F));
            this.m_outputBytes[this.count++] = (byte)(128 + (n & 0x3F));
        }
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        char c;
        int n3;
        int n4 = 3 * n2;
        if (n4 >= 16384 - this.count) {
            this.flushBuffer();
            if (n4 > 16384) {
                int n5 = this.getNumberOfChunks(n2);
                int n6 = n;
                for (int i = 1; i <= n5; ++i) {
                    int n7 = n6;
                    n6 = this.getEndOfChunk(n, n2, n5, i);
                    char c2 = cArray[n6 - 1];
                    if (c2 >= '\ud800' && c2 <= '\udbff') {
                        n6 = n6 < n + n2 ? ++n6 : --n6;
                    }
                    int n8 = n6 - n7;
                    this.write(cArray, n7, n8);
                }
                return;
            }
        }
        int n9 = n2 + n;
        byte[] byArray = this.m_outputBytes;
        int n10 = this.count;
        for (n3 = n; n3 < n9 && (c = cArray[n3]) < '\u0080'; ++n3) {
            byArray[n10++] = (byte)c;
        }
        while (n3 < n9) {
            c = cArray[n3];
            if (c < '\u0080') {
                byArray[n10++] = (byte)c;
            } else if (c < '\u0800') {
                byArray[n10++] = (byte)(192 + (c >> 6));
                byArray[n10++] = (byte)(128 + (c & 0x3F));
            } else if (c >= '\ud800' && c <= '\udbff') {
                char c3 = c;
                char c4 = cArray[++n3];
                byArray[n10++] = (byte)(0xF0 | c3 + 64 >> 8 & 7);
                byArray[n10++] = (byte)(0x80 | c3 + 64 >> 2 & 0x3F);
                byArray[n10++] = (byte)(0x80 | (c4 >> 6 & 0xF) + (c3 << 4 & 0x30));
                byArray[n10++] = (byte)(0x80 | c4 & 0x3F);
            } else {
                byArray[n10++] = (byte)(224 + (c >> 12));
                byArray[n10++] = (byte)(128 + (c >> 6 & 0x3F));
                byArray[n10++] = (byte)(128 + (c & 0x3F));
            }
            ++n3;
        }
        this.count = n10;
    }

    private int getNumberOfChunks(int n) {
        int n2 = n / 5461;
        int n3 = n % 5461 > 0 ? n2 + 1 : n2;
        return n3;
    }

    public void write(String string) throws IOException {
        char c;
        int n;
        int n2 = string.length();
        int n3 = 3 * n2;
        if (n3 >= 16384 - this.count) {
            this.flushBuffer();
            if (n3 > 16384) {
                int n4 = this.getNumberOfChunks(n2);
                int n5 = 0;
                for (int i = 1; i <= n4; ++i) {
                    int n6 = n5;
                    n5 = this.getEndOfChunk(0, n2, n4, i);
                    string.getChars(n6, n5, this.m_inputChars, 0);
                    int n7 = n5 - n6;
                    char c2 = this.m_inputChars[n7 - 1];
                    if (c2 >= '\ud800' && c2 <= '\udbff') {
                        --n5;
                        --n7;
                        if (i == n4) {
                            // empty if block
                        }
                    }
                    this.write(this.m_inputChars, 0, n7);
                }
                return;
            }
        }
        string.getChars(0, n2, this.m_inputChars, 0);
        char[] cArray = this.m_inputChars;
        int n8 = n2;
        byte[] byArray = this.m_outputBytes;
        int n9 = this.count;
        for (n = 0; n < n8 && (c = cArray[n]) < '\u0080'; ++n) {
            byArray[n9++] = (byte)c;
        }
        while (n < n8) {
            c = cArray[n];
            if (c < '\u0080') {
                byArray[n9++] = (byte)c;
            } else if (c < '\u0800') {
                byArray[n9++] = (byte)(192 + (c >> 6));
                byArray[n9++] = (byte)(128 + (c & 0x3F));
            } else if (c >= '\ud800' && c <= '\udbff') {
                char c3 = c;
                char c4 = cArray[++n];
                byArray[n9++] = (byte)(0xF0 | c3 + 64 >> 8 & 7);
                byArray[n9++] = (byte)(0x80 | c3 + 64 >> 2 & 0x3F);
                byArray[n9++] = (byte)(0x80 | (c4 >> 6 & 0xF) + (c3 << 4 & 0x30));
                byArray[n9++] = (byte)(0x80 | c4 & 0x3F);
            } else {
                byArray[n9++] = (byte)(224 + (c >> 12));
                byArray[n9++] = (byte)(128 + (c >> 6 & 0x3F));
                byArray[n9++] = (byte)(128 + (c & 0x3F));
            }
            ++n;
        }
        this.count = n9;
    }

    public void flushBuffer() throws IOException {
        if (this.count > 0) {
            this.m_os.write(this.m_outputBytes, 0, this.count);
            this.count = 0;
        }
    }

    public void flush() throws IOException {
        this.flushBuffer();
        this.m_os.flush();
    }

    public void close() throws IOException {
        this.flushBuffer();
        this.m_os.close();
    }

    public OutputStream getOutputStream() {
        return this.m_os;
    }

    public Writer getWriter() {
        return null;
    }

    public void writeASCII(char[] cArray, int n, int n2) throws IOException {
        int n3 = 3 * n2;
        if (n3 >= 16384 - this.count) {
            this.flushBuffer();
            if (n3 > 16384) {
                int n4 = this.getNumberOfChunks(n2);
                int n5 = n;
                for (int i = 1; i <= n4; ++i) {
                    int n6 = n5;
                    n5 = this.getEndOfChunk(n, n2, n4, i);
                    int n7 = n5 - n6;
                    this.writeASCII(cArray, n6, n7);
                }
                return;
            }
        }
        int n8 = n2 + n;
        byte[] byArray = this.m_outputBytes;
        int n9 = this.count;
        for (int i = n; i < n8; ++i) {
            byArray[n9++] = (byte)cArray[i];
        }
        this.count = n9;
    }

    private int getEndOfChunk(int n, int n2, int n3, int n4) {
        return n + (int)((long)n2 * (long)n4 / (long)n3);
    }

    public void writeASCII(String string) throws IOException {
        int n = string.length();
        int n2 = 3 * n;
        if (n2 >= 16384 - this.count) {
            this.flushBuffer();
            if (n2 > 16384) {
                int n3 = this.getNumberOfChunks(n);
                int n4 = 0;
                for (int i = 1; i <= n3; ++i) {
                    int n5 = n4;
                    n4 = this.getEndOfChunk(0, n, n3, i);
                    string.getChars(n5, n4, this.m_inputChars, 0);
                    int n6 = n4 - n5;
                    this.writeASCII(this.m_inputChars, 0, n6);
                }
                return;
            }
        }
        string.getChars(0, n, this.m_inputChars, 0);
        char[] cArray = this.m_inputChars;
        int n7 = n;
        byte[] byArray = this.m_outputBytes;
        int n8 = this.count;
        for (int i = 0; i < n7; ++i) {
            byArray[n8++] = (byte)cArray[i];
        }
        this.count = n8;
    }

    public void setOuputStream(OutputStream outputStream) {
        this.m_os = outputStream;
        this.count = 0;
    }

    void writeCharsNoChunking(char[] cArray, int n, int n2) {
    }

    void writeASCIINoChunking(char[] cArray, int n, int n2) {
    }

    void writeBytes(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 3 * n2;
        if (n3 >= 16384 - this.count) {
            this.flushBuffer();
            if (n3 > 16384) {
                int n4 = this.getNumberOfChunks(n2);
                int n5 = n;
                for (int i = 1; i <= n4; ++i) {
                    int n6 = n5;
                    n5 = this.getEndOfChunk(n, n2, n4, i);
                    int n7 = n5 - n6;
                    this.writeBytes(byArray, n6, n7);
                }
                return;
            }
        }
        int n8 = n2 + n;
        byte[] byArray2 = this.m_outputBytes;
        int n9 = this.count;
        for (int i = n; i < n8; ++i) {
            byArray2[n9++] = byArray[i];
        }
        this.count = n9;
    }
}

