/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serializer;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.xml.serializer.EncodingInfo;
import org.apache.xml.serializer.Encodings;
import org.apache.xml.serializer.WriterOptimized;

public class WriterStateless
extends WriterOptimized {
    final EncodingInfo m_ei;
    final EncodingInfo.EncodingImpl m_enc_info;

    public WriterStateless(OutputStream outputStream, EncodingInfo encodingInfo) {
        super(outputStream);
        this.m_ei = encodingInfo;
        this.m_enc_info = new EncodingInfo.EncodingImpl(encodingInfo);
        encodingInfo.m_encoding = this.m_enc_info;
    }

    public void write(int n) throws IOException {
        byte[] byArray;
        if (this.count >= 16384) {
            this.flushBuffer();
        }
        if ((byArray = n < 128 ? this.m_enc_info.getEncodedBytes127(n) : this.m_ei.getEncodedBytes(n)) != null) {
            for (int i = 0; i < byArray.length; ++i) {
                this.m_outputBytes[this.count++] = byArray[i];
            }
        }
    }

    void writeCharsNoChunking(char[] cArray, int n, int n2) {
        char c;
        int n3;
        EncodingInfo.EncodingImpl encodingImpl = this.m_enc_info;
        int n4 = n2 + n;
        byte[] byArray = this.m_outputBytes;
        int n5 = this.count;
        for (n3 = n; n3 < n4 && (c = cArray[n3]) < '\u0080'; ++n3) {
            byte[] byArray2 = encodingImpl.getEncodedBytes127(c);
            if (byArray2 == null) continue;
            for (int i = 0; i < byArray2.length; ++i) {
                byArray[n5++] = byArray2[i];
            }
        }
        while (n3 < n4) {
            c = cArray[n3];
            if (c < '\u0080') {
                byte[] byArray3 = encodingImpl.getEncodedBytes127(c);
                if (byArray3 != null) {
                    for (int i = 0; i < byArray3.length; ++i) {
                        byArray[n5++] = byArray3[i];
                    }
                }
            } else if (Encodings.isHighUTF16Surrogate(c) && n3 < n4 - 1) {
                char c2 = cArray[n3 + 1];
                ++n3;
                byte[] byArray4 = this.m_ei.getEncodedBytes(c, c2);
                if (byArray4 != null) {
                    for (int i = 0; i < byArray4.length; ++i) {
                        byArray[n5++] = byArray4[i];
                    }
                }
            } else {
                byte[] byArray5 = this.m_ei.getEncodedBytes(c);
                if (byArray5 != null) {
                    for (int i = 0; i < byArray5.length; ++i) {
                        byArray[n5++] = byArray5[i];
                    }
                }
            }
            ++n3;
        }
        this.count = n5;
    }

    void writeASCIINoChunking(char[] cArray, int n, int n2) {
        int n3 = n2 + n;
        byte[] byArray = this.m_outputBytes;
        int n4 = this.count;
        EncodingInfo.EncodingImpl encodingImpl = this.m_enc_info;
        for (int i = n; i < n3; ++i) {
            byte[] byArray2 = encodingImpl.getEncodedBytes127(cArray[i]);
            if (byArray2 == null) continue;
            for (int j = 0; j < byArray2.length; ++j) {
                byArray[n4++] = byArray2[j];
            }
        }
        this.count = n4;
    }
}

