/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serializer;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Properties;
import org.apache.xml.serializer.Encodings;
import org.apache.xml.serializer.OutputPropertiesFactory;
import org.apache.xml.serializer.ToStream;
import org.apache.xml.serializer.WriterOptimized;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ToTextStream
extends ToStream {
    public ToTextStream() {
        this.m_OutputPropsDefault = new HashMap();
        this.m_OutputPropsDefault.put("method", "text");
        this.m_mediatype = "text/plain";
        this.m_OutputPropsDefault.put("media-type", "text/plain");
        this.m_wasJustReset = true;
    }

    protected void startDocumentInternal() throws SAXException {
        super.startDocumentInternal();
        this.m_needToCallStartDocument = false;
    }

    public void endDocument() throws SAXException {
        this.flushInternal();
        this.flushWriter();
        if (this.m_tracer != null) {
            super.fireEndDoc();
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.m_tracer != null) {
            super.fireStartElem(string3);
            this.firePseudoAttributes();
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.m_tracer != null) {
            super.fireEndElem(string3);
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.flushInternal();
        try {
            if (this.inTemporaryOutputState()) {
                this.m_writer.write(cArray, n, n2);
                if (0 < n2) {
                    this.m_docIsEmpty = false;
                }
            } else {
                switch (this.m_optLevel) {
                    case 0: {
                        this.writeNormalizedChars0(cArray, n, n2, this.m_lineSepUse);
                        break;
                    }
                    default: {
                        this.writeNormalizedChars(cArray, n, n2, this.m_lineSepUse);
                    }
                }
            }
            if (this.m_tracer != null) {
                super.fireCharEvent(cArray, n, n2);
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void characters(char[] cArray, int n, int n2, int n3) throws SAXException {
        if ((n3 & 1) != 0 && this.m_optLevel == 0) {
            if (this.m_needToCallStartDocument) {
                this.m_docIsEmpty = false;
                this.startDocumentInternal();
                this.m_needToCallStartDocument = false;
            }
            try {
                if (this.m_writerOptimized != null) {
                    if (n2 == 1) {
                        this.m_writerOptimized.write(cArray[n]);
                    } else {
                        this.m_writerOptimized.writeASCII(cArray, n, n2);
                    }
                    return;
                }
                this.m_writer.write(cArray, n, n2);
                return;
            }
            catch (IOException iOException) {
                throw new SAXException(iOException);
            }
        }
        this.characters(cArray, n, n2);
    }

    public void charactersRaw(char[] cArray, int n, int n2) throws SAXException {
        try {
            this.writeNormalizedChars(cArray, n, n2, this.m_lineSepUse);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    void writeNormalizedChars(char[] cArray, int n, int n2, boolean bl) throws IOException, SAXException {
        int n3 = 1;
        int n4 = n;
        int n5 = 0;
        int n6 = n + n2;
        if (this.m_codepoint2String != null && this.m_codepoint2String.hasMappings()) {
            for (int i = n; i < n6; i += n3) {
                int n7;
                int n8 = cArray[i];
                if (Encodings.isHighUTF16Surrogate((char)n8) && i + 1 < n6) {
                    char c = cArray[i + 1];
                    n7 = Encodings.toCodePoint((char)n8, c);
                    n3 = 2;
                } else {
                    n7 = n8;
                    n3 = 1;
                }
                String string = this.m_codepoint2String.getString(n7);
                if (string != null) {
                    if (n5 > 0) {
                        this.uniNormTextThenEscape(cArray, n4, n5, bl);
                        n5 = 0;
                    }
                    n4 = i + n3;
                    this.m_writer.write(string);
                    continue;
                }
                n5 += n3;
            }
        } else {
            n5 = n6 - n4;
        }
        if (n5 > 0) {
            this.uniNormTextThenEscape(cArray, n4, n5, bl);
        }
    }

    void uniNormTextThenEscape(char[] cArray, int n, int n2, boolean bl) throws IOException {
        int n3;
        String string = this.getEncoding();
        if (0 < n2) {
            this.m_docIsEmpty = false;
        }
        int n4 = n2;
        int n5 = n;
        Writer writer = this.m_writer;
        if (this.m_normalizerMode != 1 && !this.m_unicodeNormalizer.alreadyNormalized(cArray, n, n + n2, this.m_normalizerMode)) {
            n3 = n + 3 * n2 + 1;
            if (this.m_normalizedCharsBuff.length < n3) {
                this.m_normalizedCharsBuff = new char[n3];
            }
            n4 = this.m_unicodeNormalizer.normalizeUnicode(cArray, n, n + n2, this.m_normalizedCharsBuff, n, n3, this.m_normalizerMode);
            cArray = this.m_normalizedCharsBuff;
        }
        n3 = n + n4;
        int n6 = 0;
        int n7 = 1;
        int n8 = 0;
        for (int i = n; i < n3; i += n7) {
            String string2;
            int n9;
            n6 = cArray[i];
            if (Encodings.isHighUTF16Surrogate((char)n6) && i + 1 < n3) {
                char c = cArray[i + 1];
                n9 = Encodings.toCodePoint((char)n6, c);
                n7 = 2;
            } else {
                n9 = n6;
                n7 = 1;
            }
            if (this.m_charInfo != null && this.m_charInfo.shouldMapTextChar(n9)) {
                if (n8 > 0) {
                    writer.write(cArray, n5, n8);
                    n8 = 0;
                }
                n5 = i + n7;
                string2 = this.m_charInfo.getOutputStringForChar(n9, this.m_charKey);
                writer.write(string2);
                continue;
            }
            if (10 == n9 && bl) {
                if (n8 > 0) {
                    writer.write(cArray, n5, n8);
                    n8 = 0;
                }
                n5 = i + n7;
                writer.write(this.m_lineSep, 0, this.m_lineSepLen);
                continue;
            }
            if (this.m_encodingInfo.isInEncoding(n9)) {
                n8 += n7;
                continue;
            }
            if (string != null) {
                if (n8 > 0) {
                    writer.write(cArray, n5, n8);
                    n8 = 0;
                }
                n5 = i + n7;
                writer.write(38);
                writer.write(35);
                writer.write(Integer.toString(n9));
                writer.write(59);
                string2 = Integer.toString(n9);
                this.reportWarning("ER_ILLEGAL_CHARACTER", new Object[]{string2, string});
                continue;
            }
            n8 += n7;
        }
        if (n8 > 1) {
            writer.write(cArray, n5, n8);
        } else if (n8 == 1) {
            writer.write(n6);
        }
    }

    public void cdata(char[] cArray, int n, int n2) throws SAXException {
        try {
            this.writeNormalizedChars(cArray, n, n2, this.m_lineSepUse);
            if (this.m_tracer != null) {
                super.fireCDATAEvent(cArray, n, n2);
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        try {
            this.writeNormalizedChars(cArray, n, n2, this.m_lineSepUse);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        this.flushInternal();
        if (this.m_tracer != null) {
            super.fireEscapingEvent(string, string2);
        }
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        this.flushInternal();
        if (this.m_tracer != null) {
            super.fireCommentEvent(cArray, n, n2);
        }
    }

    public void entityReference(String string) throws SAXException {
        if (this.m_tracer != null) {
            super.fireEntityReference(string);
        }
    }

    public void addAttribute(String string, String string2, String string3, String string4, String string5, boolean bl) {
    }

    public void endCDATA() throws SAXException {
    }

    public void endElement(String string) throws SAXException {
        if (this.m_tracer != null) {
            super.fireEndElem(string);
        }
    }

    public void startElement(String string, String string2, String string3) throws SAXException {
        if (this.m_needToCallStartDocument) {
            this.startDocumentInternal();
        }
        if (this.m_tracer != null) {
            super.fireStartElem(string3);
            this.firePseudoAttributes();
        }
    }

    public void addAttribute(String string, String string2) {
    }

    public void addUniqueAttribute(String string, String string2, int n) throws SAXException {
    }

    public boolean startPrefixMapping(String string, String string2, boolean bl) throws SAXException {
        return false;
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
    }

    public void namespaceAfterStartElement(String string, String string2) throws SAXException {
    }

    void flushInternal() throws SAXException {
        if (this.m_needToCallStartDocument) {
            this.startDocumentInternal();
            this.m_needToCallStartDocument = false;
        }
    }

    public void flushPending() throws SAXException {
        this.flushInternal();
        this.flushWriter();
    }

    private void writeNormalizedChars0(char[] cArray, int n, int n2, boolean bl) throws IOException, SAXException {
        int n3;
        String string = null;
        boolean bl2 = false;
        boolean bl3 = true;
        WriterOptimized writerOptimized = this.m_writerOptimized;
        Writer writer = this.m_writer;
        int n4 = n;
        int n5 = n + n2;
        block5: while (n4 < n5) {
            int n6;
            int n7;
            int n8 = cArray[n4];
            if (n8 < 128) {
                switch (n8) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: {
                        ++n4;
                        continue block5;
                    }
                    case 10: {
                        if (!this.m_lineSepUse || this.m_lineSepLen == 1 && this.m_lineSep[0] == '\n') {
                            ++n4;
                            continue block5;
                        }
                        n3 = n4 - n;
                        if (n3 > 0) {
                            if (bl3 && writerOptimized != null) {
                                writerOptimized.writeASCII(cArray, n, n3);
                            } else {
                                writer.write(cArray, n, n3);
                            }
                        }
                        writer.write(this.m_lineSep, 0, this.m_lineSepLen);
                        bl3 = true;
                        n = ++n4;
                        continue block5;
                    }
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 62: 
                    case 63: 
                    case 64: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 76: 
                    case 77: 
                    case 78: 
                    case 79: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 86: 
                    case 87: 
                    case 88: 
                    case 89: 
                    case 90: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: 
                    case 96: 
                    case 97: 
                    case 98: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 104: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 108: 
                    case 109: 
                    case 110: 
                    case 111: 
                    case 112: 
                    case 113: 
                    case 114: 
                    case 115: 
                    case 116: 
                    case 117: 
                    case 118: 
                    case 119: 
                    case 120: 
                    case 121: 
                    case 122: 
                    case 123: 
                    case 124: 
                    case 125: 
                    case 126: 
                    case 127: {
                        ++n4;
                        continue block5;
                    }
                }
                continue;
            }
            if (Encodings.isHighUTF16Surrogate((char)n8) && n4 + 1 < n5) {
                char c = cArray[n4 + 1];
                n7 = Encodings.toCodePoint((char)n8, c);
                n6 = 2;
            } else {
                n7 = n8;
                n6 = 1;
            }
            if (this.m_encodingInfo.isInEncoding(n7)) {
                bl3 = false;
                n4 += n6;
                continue;
            }
            if (!bl2) {
                string = this.getEncoding();
                bl2 = true;
            }
            if (string != null) {
                n3 = n4 - n;
                if (n3 > 0) {
                    if (bl3 && writerOptimized != null) {
                        writerOptimized.writeASCII(cArray, n, n3);
                    } else {
                        writer.write(cArray, n, n3);
                    }
                }
                writer.write(38);
                writer.write(35);
                writer.write(Integer.toString(n7));
                writer.write(59);
                String string2 = Integer.toString(n7);
                this.reportWarning("ER_ILLEGAL_CHARACTER", new Object[]{string2, string});
                bl3 = true;
                n = n4 += n6;
                continue;
            }
            n = n4 += n6;
        }
        n3 = n4 - n;
        if (n3 > 0) {
            if (bl3 && writerOptimized != null) {
                writerOptimized.writeASCII(cArray, n, n3);
            } else {
                writer.write(cArray, n, n3);
            }
        }
    }

    void processAttributes(Writer writer, int n) throws IOException, SAXException {
    }

    public boolean reset() {
        super.reset();
        this.m_wasJustReset = true;
        return true;
    }

    public void setOutputFormat(Properties properties) {
        String string;
        String string2;
        OutputPropertiesFactory.SerializerProps serializerProps;
        super.setOutputFormat(properties);
        if (properties != null && properties instanceof OutputPropertiesFactory.SerializerProps && (serializerProps = (OutputPropertiesFactory.SerializerProps)properties).hasOnlyStandardDefaults() && (string2 = this.getOutputProperty("encoding")) == null && (string = properties.getProperty("encoding")) != null) {
            String string3 = (String)properties.get("encoding");
            if (string3 != null) {
                this.setOutputProperty("encoding", string3);
            } else {
                this.setOutputPropertyDefault("encoding", string);
            }
        }
    }
}

