/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serializer;

import org.apache.xml.serializer.Encodings;

public final class EncodingInfo {
    private final char m_highCharInContiguousGroup;
    final String name;
    final String javaName;
    final boolean isStateless;
    InEncoding m_encoding;
    private static final byte[] s_noBytes = new byte[0];

    public boolean isInEncoding(int n) {
        if (this.m_encoding == null) {
            this.m_encoding = new EncodingImpl(this);
        }
        return this.m_encoding.isInEncoding(n);
    }

    public byte[] getEncodedBytes(int n) {
        if (this.m_encoding == null) {
            this.m_encoding = new EncodingImpl(this);
        }
        return this.m_encoding.getEncodedBytes(n);
    }

    public boolean isInEncoding(char c, char c2) {
        if (this.m_encoding == null) {
            this.m_encoding = new EncodingImpl(this);
        }
        return this.m_encoding.isInEncoding(c, c2);
    }

    public byte[] getEncodedBytes(char c, char c2) {
        if (this.m_encoding == null) {
            this.m_encoding = new EncodingImpl(this);
        }
        return this.m_encoding.getEncodedBytes(c, c2);
    }

    public EncodingInfo(String string, String string2, char c, boolean bl) {
        this.name = string;
        this.javaName = string2;
        this.m_highCharInContiguousGroup = c;
        this.isStateless = bl;
    }

    private static byte[] inEncoding(int n, String string) {
        byte[] byArray;
        try {
            char[] cArray = new char[]{(char)n};
            String string2 = new String(cArray);
            byte[] byArray2 = string2.getBytes(string);
            boolean bl = EncodingInfo.inEncoding(n, byArray2);
            byArray = (byte[])(bl ? byArray2 : null);
        }
        catch (Exception exception) {
            boolean bl = false;
            if (string == null) {
                bl = true;
                byArray = s_noBytes;
            }
            byArray = null;
        }
        return byArray;
    }

    private static byte[] getEncBytes(char c, char c2, String string) {
        try {
            char[] cArray = new char[]{c, c2};
            String string2 = new String(cArray);
            byte[] byArray = string2.getBytes(string);
            boolean bl = EncodingInfo.inEncoding((int)c, byArray);
            if (bl) {
                return byArray;
            }
            return null;
        }
        catch (Exception exception) {
            boolean bl = false;
            return null;
        }
    }

    private static boolean inEncoding(int n, byte[] byArray) {
        boolean bl = byArray == null || byArray.length == 0 ? false : (byArray[0] == 0 ? false : byArray[0] != 63 || n == 63);
        return bl;
    }

    public final char getHighChar() {
        return this.m_highCharInContiguousGroup;
    }

    public final boolean isStatelessEncoding() {
        return this.isStateless;
    }

    static final class EncodingImpl
    implements InEncoding {
        private final EncodingInfo m_encoding;
        private final int m_first;
        private final int m_explFirst;
        private final int m_explLast;
        private final int m_last;
        private EncodingImpl m_before;
        private EncodingImpl m_after;
        private static final int RANGE = 128;
        private final boolean[] m_alreadyKnown = new boolean[128];
        private final byte[][] m_char2Bytes = new byte[128][];

        public boolean isInEncoding(int n) {
            byte[] byArray = this.getEncodedBytes(n);
            return byArray != null;
        }

        public boolean isInEncoding(char c, char c2) {
            byte[] byArray = this.getEncodedBytes(c, c2);
            return byArray != null;
        }

        public final byte[] getEncodedBytes127(int n) {
            return this.m_char2Bytes[n];
        }

        public byte[] getEncodedBytes(int n) {
            byte[] byArray;
            int n2 = n;
            if (n2 < this.m_explFirst) {
                if (this.m_before == null) {
                    this.m_before = new EncodingImpl(this.m_encoding, this.m_first, this.m_explFirst - 1, n2);
                }
                byArray = this.m_before.getEncodedBytes(n);
            } else if (this.m_explLast < n2) {
                if (this.m_after == null) {
                    this.m_after = new EncodingImpl(this.m_encoding, this.m_explLast + 1, this.m_last, n2);
                }
                byArray = this.m_after.getEncodedBytes(n);
            } else {
                int n3 = n2 - this.m_explFirst;
                if (this.m_alreadyKnown[n3]) {
                    byArray = this.m_char2Bytes[n3];
                } else {
                    byArray = EncodingInfo.inEncoding(n, this.m_encoding.javaName);
                    this.m_alreadyKnown[n3] = true;
                    this.m_char2Bytes[n3] = byArray;
                }
            }
            return byArray;
        }

        public byte[] getEncodedBytes(char c, char c2) {
            byte[] byArray;
            int n = Encodings.toCodePoint(c, c2);
            if (n < this.m_explFirst) {
                if (this.m_before == null) {
                    this.m_before = new EncodingImpl(this.m_encoding, this.m_first, this.m_explFirst - 1, n);
                }
                byArray = this.m_before.getEncodedBytes(c, c2);
            } else if (this.m_explLast < n) {
                if (this.m_after == null) {
                    this.m_after = new EncodingImpl(this.m_encoding, this.m_explLast + 1, this.m_last, n);
                }
                byArray = this.m_after.getEncodedBytes(c, c2);
            } else {
                int n2 = n - this.m_explFirst;
                if (this.m_alreadyKnown[n2]) {
                    byArray = this.m_char2Bytes[n2];
                } else {
                    byArray = EncodingInfo.getEncBytes(c, c2, this.m_encoding.javaName);
                    this.m_alreadyKnown[n2] = true;
                    this.m_char2Bytes[n2] = byArray;
                }
            }
            return byArray;
        }

        EncodingImpl(EncodingInfo encodingInfo) {
            this(encodingInfo, 0, Integer.MAX_VALUE, 0);
        }

        private EncodingImpl(EncodingInfo encodingInfo, int n, int n2, int n3) {
            int n4;
            this.m_first = n;
            this.m_last = n2;
            this.m_explFirst = n3;
            this.m_explLast = n3 + 127;
            this.m_encoding = encodingInfo;
            String string = encodingInfo.javaName;
            if (string != null && 0 <= this.m_explFirst && this.m_explFirst <= 127 && encodingInfo.isStatelessEncoding()) {
                int n5;
                if ("UTF8".equals(string) || "UTF-16".equals(string) || "ASCII".equals(string) || "US-ASCII".equals(string) || "Unicode".equals(string) || "UNICODE".equals(string) || string.startsWith("ISO8859")) {
                    for (n4 = 0; n4 < 127; ++n4) {
                        n5 = n4 - this.m_explFirst;
                        if (0 > n5 || n5 >= 128) continue;
                        this.m_alreadyKnown[n5] = true;
                        this.m_char2Bytes[n5] = new byte[]{(byte)n4};
                    }
                } else {
                    for (n4 = 0; n4 < 127; ++n4) {
                        n5 = n4 - this.m_explFirst;
                        if (0 > n5 || n5 >= 128) continue;
                        this.m_char2Bytes[n5] = this.getEncodedBytes(n4);
                    }
                }
            }
            if (string == null) {
                for (n4 = 0; n4 < this.m_alreadyKnown.length; ++n4) {
                    this.m_alreadyKnown[n4] = true;
                    this.m_char2Bytes[n4] = s_noBytes;
                }
            }
        }
    }

    private static interface InEncoding {
        public boolean isInEncoding(int var1);

        public boolean isInEncoding(char var1, char var2);

        public byte[] getEncodedBytes(int var1);

        public byte[] getEncodedBytes(char var1, char var2);
    }
}

