/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xslt;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.xalan.xslt.ObjectFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EnvironmentCheck {
    public static final String ERROR = "ERROR.";
    public static final String WARNING = "WARNING.";
    public static final String ERROR_FOUND = "At least one error was found!";
    public static final String VERSION = "version.";
    public static final String FOUNDCLASSES = "foundclasses.";
    public static final String CLASS_PRESENT = "present-unknown-version";
    public static final String CLASS_NOTPRESENT = "not-present";
    public String[] jarNames = new String[]{"xalan.jar", "xalansamples.jar", "xalanj1compat.jar", "xalanservlet.jar", "serializer.jar", "xerces.jar", "xercesImpl.jar", "b2bxml.jar", "testxsl.jar", "crimson.jar", "lotusxsl.jar", "jaxp.jar", "parser.jar", "dom.jar", "sax.jar", "xml.jar", "xml-apis.jar", "xsltc.jar"};
    private static Hashtable jarVersions = new Hashtable();
    protected PrintWriter outWriter = new PrintWriter(System.out, true);
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$xml$sax$Attributes;

    public static void main(String[] stringArray) {
        PrintWriter printWriter = new PrintWriter(System.out, true);
        for (int i = 0; i < stringArray.length; ++i) {
            if (!"-out".equalsIgnoreCase(stringArray[i])) continue;
            if (++i < stringArray.length) {
                try {
                    printWriter = new PrintWriter(new FileWriter(stringArray[i], true));
                }
                catch (Exception exception) {
                    System.err.println("# WARNING: -out " + stringArray[i] + " threw " + exception.toString());
                }
                continue;
            }
            System.err.println("# WARNING: -out argument should have a filename, output sent to console");
        }
        EnvironmentCheck environmentCheck = new EnvironmentCheck();
        environmentCheck.checkEnvironment(printWriter);
    }

    public boolean checkEnvironment(PrintWriter printWriter) {
        Hashtable hashtable;
        boolean bl;
        if (null != printWriter) {
            this.outWriter = printWriter;
        }
        if (bl = this.writeEnvironmentReport(hashtable = this.getEnvironmentHash())) {
            this.logMsg("# WARNING: Potential problems found in your environment!");
            this.logMsg("#    Check any 'ERROR' items above against the Xalan FAQs");
            this.logMsg("#    to correct potential problems with your classes/jars");
            this.logMsg("#    http://xml.apache.org/xalan-j/faq.html");
            if (null != this.outWriter) {
                this.outWriter.flush();
            }
            return false;
        }
        this.logMsg("# Your environment seems to be OK.");
        if (null != this.outWriter) {
            this.outWriter.flush();
        }
        return true;
    }

    public Hashtable getEnvironmentHash() {
        Hashtable hashtable = new Hashtable();
        this.checkJAXPVersion(hashtable);
        this.checkProcessorVersion(hashtable);
        this.checkParserVersion(hashtable);
        this.checkAntVersion(hashtable);
        this.checkDOMVersion(hashtable);
        this.checkSAXVersion(hashtable);
        this.checkSystemProperties(hashtable);
        return hashtable;
    }

    protected boolean writeEnvironmentReport(Hashtable hashtable) {
        if (null == hashtable) {
            this.logMsg("# ERROR: writeEnvironmentReport called with null Hashtable");
            return false;
        }
        boolean bl = false;
        this.logMsg("#---- BEGIN writeEnvironmentReport(Revision: 1.44): Useful stuff found: ----");
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            String string = (String)k;
            try {
                if (string.startsWith(FOUNDCLASSES)) {
                    Vector vector = (Vector)hashtable.get(string);
                    bl |= this.logFoundJars(vector, string);
                    continue;
                }
                if (string.startsWith(ERROR)) {
                    bl = true;
                }
                this.logMsg(string + "=" + hashtable.get(string));
            }
            catch (Exception exception) {
                this.logMsg("Reading-" + k + "= threw: " + exception.toString());
            }
        }
        this.logMsg("#----- END writeEnvironmentReport: Useful properties found: -----");
        return bl;
    }

    protected boolean logFoundJars(Vector vector, String string) {
        if (null == vector || vector.size() < 1) {
            return false;
        }
        boolean bl = false;
        this.logMsg("#---- BEGIN Listing XML-related jars in: " + string + " ----");
        for (int i = 0; i < vector.size(); ++i) {
            Hashtable hashtable = (Hashtable)vector.elementAt(i);
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                String string2 = (String)k;
                try {
                    if (string2.startsWith(ERROR)) {
                        bl = true;
                    }
                    this.logMsg(string2 + "=" + hashtable.get(string2));
                }
                catch (Exception exception) {
                    bl = true;
                    this.logMsg("Reading-" + k + "= threw: " + exception.toString());
                }
            }
        }
        this.logMsg("#----- END Listing XML-related jars in: " + string + " -----");
        return bl;
    }

    public void appendEnvironmentReport(Node node, Document document, Hashtable hashtable) {
        if (null == node || null == document) {
            return;
        }
        try {
            Element element = document.createElement("EnvironmentCheck");
            element.setAttribute("version", "Revision: 1.44");
            node.appendChild(element);
            if (null == hashtable) {
                Element element2 = document.createElement("status");
                element2.setAttribute("result", "ERROR");
                element2.appendChild(document.createTextNode("appendEnvironmentReport called with null Hashtable!"));
                element.appendChild(element2);
                return;
            }
            boolean bl = false;
            Element element3 = document.createElement("environment");
            element.appendChild(element3);
            Object object = hashtable.keys();
            while (object.hasMoreElements()) {
                Object k = object.nextElement();
                String string = (String)k;
                try {
                    Object object2;
                    if (string.startsWith(FOUNDCLASSES)) {
                        object2 = (Vector)hashtable.get(string);
                        bl |= this.appendFoundJars(element3, document, (Vector)object2, string);
                        continue;
                    }
                    if (string.startsWith(ERROR)) {
                        bl = true;
                    }
                    object2 = document.createElement("item");
                    object2.setAttribute("key", string);
                    object2.appendChild(document.createTextNode((String)hashtable.get(string)));
                    element3.appendChild((Node)object2);
                }
                catch (Exception exception) {
                    bl = true;
                    Element element4 = document.createElement("item");
                    element4.setAttribute("key", string);
                    element4.appendChild(document.createTextNode("ERROR. Reading " + k + " threw: " + exception.toString()));
                    element3.appendChild(element4);
                }
            }
            object = document.createElement("status");
            object.setAttribute("result", bl ? "ERROR" : "OK");
            element.appendChild((Node)object);
        }
        catch (Exception exception) {
            System.err.println("appendEnvironmentReport threw: " + exception.toString());
            exception.printStackTrace();
        }
    }

    protected boolean appendFoundJars(Node node, Document document, Vector vector, String string) {
        if (null == vector || vector.size() < 1) {
            return false;
        }
        boolean bl = false;
        for (int i = 0; i < vector.size(); ++i) {
            Hashtable hashtable = (Hashtable)vector.elementAt(i);
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                Element element;
                Object k = enumeration.nextElement();
                try {
                    String string2 = (String)k;
                    if (string2.startsWith(ERROR)) {
                        bl = true;
                    }
                    element = document.createElement("foundJar");
                    element.setAttribute("name", string2.substring(0, string2.indexOf("-")));
                    element.setAttribute("desc", string2.substring(string2.indexOf("-") + 1));
                    element.appendChild(document.createTextNode((String)hashtable.get(string2)));
                    node.appendChild(element);
                }
                catch (Exception exception) {
                    bl = true;
                    element = document.createElement("foundJar");
                    element.appendChild(document.createTextNode("ERROR. Reading " + k + " threw: " + exception.toString()));
                    node.appendChild(element);
                }
            }
        }
        return bl;
    }

    protected void checkSystemProperties(Hashtable hashtable) {
        String string;
        if (null == hashtable) {
            hashtable = new Hashtable<String, Object>();
        }
        try {
            string = System.getProperty("java.version");
            hashtable.put("java.version", string);
        }
        catch (SecurityException securityException) {
            hashtable.put("java.version", "WARNING: SecurityException thrown accessing system version properties");
        }
        try {
            String string2;
            string = System.getProperty("java.class.path");
            hashtable.put("java.class.path", string);
            Vector vector = this.checkPathForJars(string, this.jarNames);
            if (null != vector) {
                hashtable.put("foundclasses.java.class.path", vector);
            }
            if (null != (string2 = System.getProperty("sun.boot.class.path"))) {
                hashtable.put("sun.boot.class.path", string2);
                vector = this.checkPathForJars(string2, this.jarNames);
                if (null != vector) {
                    hashtable.put("foundclasses.sun.boot.class.path", vector);
                }
            }
            if (null != (string2 = System.getProperty("java.ext.dirs"))) {
                hashtable.put("java.ext.dirs", string2);
                vector = this.checkPathForJars(string2, this.jarNames);
                if (null != vector) {
                    hashtable.put("foundclasses.java.ext.dirs", vector);
                }
            }
        }
        catch (SecurityException securityException) {
            hashtable.put("java.class.path", "WARNING: SecurityException thrown accessing system classpath properties");
        }
    }

    protected Vector checkPathForJars(String string, String[] stringArray) {
        if (null == string || null == stringArray || 0 == string.length() || 0 == stringArray.length) {
            return null;
        }
        Vector vector = new Vector();
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            for (int i = 0; i < stringArray.length; ++i) {
                Hashtable<String, String> hashtable;
                if (string2.indexOf(stringArray[i]) <= -1) continue;
                File file = new File(string2);
                if (file.exists()) {
                    try {
                        hashtable = new Hashtable(2);
                        hashtable.put(stringArray[i] + "-path", file.getAbsolutePath());
                        if (!"xalan.jar".equalsIgnoreCase(stringArray[i])) {
                            hashtable.put(stringArray[i] + "-apparent.version", this.getApparentVersion(stringArray[i], file.length()));
                        }
                        vector.addElement(hashtable);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                hashtable = new Hashtable<String, String>(2);
                hashtable.put(stringArray[i] + "-path", "WARNING. Classpath entry: " + string2 + " does not exist");
                hashtable.put(stringArray[i] + "-apparent.version", CLASS_NOTPRESENT);
                vector.addElement(hashtable);
            }
        }
        return vector;
    }

    protected String getApparentVersion(String string, long l) {
        String string2 = (String)jarVersions.get(new Long(l));
        if (null != string2 && string2.startsWith(string)) {
            return string2;
        }
        if ("xerces.jar".equalsIgnoreCase(string) || "xercesImpl.jar".equalsIgnoreCase(string)) {
            return string + " " + WARNING + CLASS_PRESENT;
        }
        return string + " " + CLASS_PRESENT;
    }

    protected void checkJAXPVersion(Hashtable hashtable) {
        if (null == hashtable) {
            hashtable = new Hashtable<String, String>();
        }
        Class[] classArray = new Class[]{};
        Class clazz = null;
        try {
            clazz = ObjectFactory.findProviderClass("javax.xml.parsers.DocumentBuilder", ObjectFactory.findClassLoader(), true);
            clazz.getMethod("getDOMImplementation", classArray);
            hashtable.put("version.JAXP", "1.1 or higher");
        }
        catch (Exception exception) {
            if (null != clazz) {
                hashtable.put("ERROR.version.JAXP", "1.0.1");
                hashtable.put(ERROR, ERROR_FOUND);
            }
            hashtable.put("ERROR.version.JAXP", CLASS_NOTPRESENT);
            hashtable.put(ERROR, ERROR_FOUND);
        }
    }

    protected void checkProcessorVersion(Hashtable hashtable) {
        if (null == hashtable) {
            hashtable = new Hashtable<String, String>();
        }
        try {
            Class[] classArray = new Class[]{};
            Class clazz = ObjectFactory.findProviderClass("org.apache.xalan.Version", ObjectFactory.findClassLoader(), true);
            Method method = clazz.getMethod("getVersion", classArray);
            Object object = method.invoke(null, new Object[0]);
            hashtable.put("version.xltxe", (String)object);
        }
        catch (Exception exception) {
            hashtable.put("version.xltxe", CLASS_NOTPRESENT);
        }
    }

    protected void checkParserVersion(Hashtable hashtable) {
        Class[] classArray;
        AnnotatedElement annotatedElement;
        Class clazz;
        if (null == hashtable) {
            hashtable = new Hashtable<String, Object>();
        }
        try {
            clazz = ObjectFactory.findProviderClass("org.apache.xerces.framework.Version", ObjectFactory.findClassLoader(), true);
            annotatedElement = clazz.getField("fVersion");
            classArray = (Class[])((Field)annotatedElement).get(null);
            hashtable.put("version.xerces1", classArray);
        }
        catch (Exception exception) {
            hashtable.put("version.xerces1", CLASS_NOTPRESENT);
        }
        try {
            clazz = ObjectFactory.findProviderClass("org.apache.xerces.impl.Version", ObjectFactory.findClassLoader(), true);
            annotatedElement = clazz.getField("fVersion");
            classArray = (String)((Field)annotatedElement).get(null);
            hashtable.put("version.xerces2", classArray);
        }
        catch (Exception exception) {
            hashtable.put("version.xerces2", CLASS_NOTPRESENT);
        }
        try {
            annotatedElement = ObjectFactory.findProviderClass("com.ibm.xml.xlxp.scan.Version", ObjectFactory.findClassLoader(), true);
            classArray = new Class[]{};
            Method method = ((Class)annotatedElement).getMethod("getVersion", classArray);
            Object object = method.invoke(null, new Object[0]);
            hashtable.put("version.xlxp", (String)object);
        }
        catch (Exception exception) {
            hashtable.put("version.xlxp", CLASS_NOTPRESENT);
        }
    }

    protected void checkAntVersion(Hashtable hashtable) {
        if (null == hashtable) {
            hashtable = new Hashtable<String, String>();
        }
        try {
            Class[] classArray = new Class[]{};
            Class clazz = ObjectFactory.findProviderClass("org.apache.tools.ant.Main", ObjectFactory.findClassLoader(), true);
            Method method = clazz.getMethod("getAntVersion", classArray);
            Object object = method.invoke(null, new Object[0]);
            hashtable.put("version.ant", (String)object);
        }
        catch (Exception exception) {
            hashtable.put("version.ant", CLASS_NOTPRESENT);
        }
    }

    protected void checkDOMVersion(Hashtable hashtable) {
        if (null == hashtable) {
            hashtable = new Hashtable<String, String>();
        }
        Class[] classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = EnvironmentCheck.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = EnvironmentCheck.class$("java.lang.String")) : class$java$lang$String};
        try {
            Class clazz = ObjectFactory.findProviderClass("org.w3c.dom.Document", ObjectFactory.findClassLoader(), true);
            clazz.getMethod("createElementNS", classArray);
            hashtable.put("version.DOM", "2.0");
            try {
                clazz = ObjectFactory.findProviderClass("org.w3c.dom.Node", ObjectFactory.findClassLoader(), true);
                clazz.getMethod("supported", classArray);
                hashtable.put("ERROR.version.DOM.draftlevel", "2.0wd");
                hashtable.put(ERROR, ERROR_FOUND);
            }
            catch (Exception exception) {
                try {
                    clazz = ObjectFactory.findProviderClass("org.w3c.dom.Node", ObjectFactory.findClassLoader(), true);
                    clazz.getMethod("isSupported", classArray);
                    hashtable.put("version.DOM.draftlevel", "2.0fd");
                }
                catch (Exception exception2) {
                    hashtable.put("ERROR.version.DOM.draftlevel", "2.0unknown");
                    hashtable.put(ERROR, ERROR_FOUND);
                }
            }
        }
        catch (Exception exception) {
            hashtable.put("ERROR.version.DOM", "ERROR attempting to load DOM level 2 class: " + exception.toString());
            hashtable.put(ERROR, ERROR_FOUND);
        }
    }

    protected void checkSAXVersion(Hashtable hashtable) {
        if (null == hashtable) {
            hashtable = new Hashtable<String, String>();
        }
        Class[] classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = EnvironmentCheck.class$("java.lang.String")) : class$java$lang$String};
        Class[] classArray2 = new Class[]{class$org$xml$sax$Attributes == null ? (class$org$xml$sax$Attributes = EnvironmentCheck.class$("org.xml.sax.Attributes")) : class$org$xml$sax$Attributes};
        try {
            Class clazz = ObjectFactory.findProviderClass("org.xml.sax.helpers.AttributesImpl", ObjectFactory.findClassLoader(), true);
            clazz.getMethod("setAttributes", classArray2);
            hashtable.put("version.SAX", "2.0");
        }
        catch (Exception exception) {
            hashtable.put("ERROR.version.SAX", "ERROR attempting to load SAX version 2 class: " + exception.toString());
            hashtable.put(ERROR, ERROR_FOUND);
            try {
                Class clazz = ObjectFactory.findProviderClass("org.xml.sax.XMLReader", ObjectFactory.findClassLoader(), true);
                clazz.getMethod("parse", classArray);
                hashtable.put("version.SAX-backlevel", "2.0beta2-or-earlier");
            }
            catch (Exception exception2) {
                hashtable.put("ERROR.version.SAX", "ERROR attempting to load SAX version 2 class: " + exception.toString());
                hashtable.put(ERROR, ERROR_FOUND);
                try {
                    Class clazz = ObjectFactory.findProviderClass("org.xml.sax.Parser", ObjectFactory.findClassLoader(), true);
                    Method method = clazz.getMethod("parse", classArray);
                    hashtable.put("version.SAX-backlevel", "1.0");
                }
                catch (Exception exception3) {
                    hashtable.put("ERROR.version.SAX-backlevel", "ERROR attempting to load SAX version 1 class: " + exception3.toString());
                }
            }
        }
    }

    protected void logMsg(String string) {
        this.outWriter.println(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        jarVersions.put(new Long(857192L), "xalan.jar from xalan-j_1_1");
        jarVersions.put(new Long(440237L), "xalan.jar from xalan-j_1_2");
        jarVersions.put(new Long(436094L), "xalan.jar from xalan-j_1_2_1");
        jarVersions.put(new Long(426249L), "xalan.jar from xalan-j_1_2_2");
        jarVersions.put(new Long(702536L), "xalan.jar from xalan-j_2_0_0");
        jarVersions.put(new Long(720930L), "xalan.jar from xalan-j_2_0_1");
        jarVersions.put(new Long(732330L), "xalan.jar from xalan-j_2_1_0");
        jarVersions.put(new Long(872241L), "xalan.jar from xalan-j_2_2_D10");
        jarVersions.put(new Long(882739L), "xalan.jar from xalan-j_2_2_D11");
        jarVersions.put(new Long(923866L), "xalan.jar from xalan-j_2_2_0");
        jarVersions.put(new Long(905872L), "xalan.jar from xalan-j_2_3_D1");
        jarVersions.put(new Long(906122L), "xalan.jar from xalan-j_2_3_0");
        jarVersions.put(new Long(906248L), "xalan.jar from xalan-j_2_3_1");
        jarVersions.put(new Long(983377L), "xalan.jar from xalan-j_2_4_D1");
        jarVersions.put(new Long(997276L), "xalan.jar from xalan-j_2_4_0");
        jarVersions.put(new Long(857171L), "xalan.jar from lotusxsl-j_1_0_1");
        jarVersions.put(new Long(802165L), "xalan.jar from lotusxsl-j_2_0_0");
        jarVersions.put(new Long(857692L), "xalan.jar from lotusxsl-j_2_2");
        jarVersions.put(new Long(906359L), "xalan.jar from lotusxsl-j_2_3_1");
        jarVersions.put(new Long(857692L), "xalan.jar from lotusxsl-j_2_3_2");
        jarVersions.put(new Long(1201514L), "xalan.jar from lotusxsl-j_2_3_3");
        jarVersions.put(new Long(1201599L), "xalan.jar from lotusxsl-j_2_3_4");
        jarVersions.put(new Long(1201641L), "xalan.jar from lotusxsl-j_2_3_5");
        jarVersions.put(new Long(1201693L), "xalan.jar from lotusxsl-j_2_3_6");
        jarVersions.put(new Long(0x148114L), "xalan.jar from lotusxsl-j_2_4_0");
        jarVersions.put(new Long(1345301L), "xalan.jar from lotusxsl-j_2_4_1");
        jarVersions.put(new Long(1345793L), "xalan.jar from lotusxsl-j_2_4_2");
        jarVersions.put(new Long(1352562L), "xalan.jar from lotusxsl-j_2_4_3");
        jarVersions.put(new Long(226589L), "serializer.jar from XSLT4J-2_7_0");
        jarVersions.put(new Long(596540L), "xsltc.jar from xalan-j_2_2_0");
        jarVersions.put(new Long(590247L), "xsltc.jar from xalan-j_2_3_D1");
        jarVersions.put(new Long(589914L), "xsltc.jar from xalan-j_2_3_0");
        jarVersions.put(new Long(589915L), "xsltc.jar from xalan-j_2_3_1");
        jarVersions.put(new Long(1306667L), "xsltc.jar from xalan-j_2_4_D1");
        jarVersions.put(new Long(1328227L), "xsltc.jar from xalan-j_2_4_0");
        jarVersions.put(new Long(1268634L), "xsltc.jar-bundled from xalan-j_2_3_0");
        jarVersions.put(new Long(100196L), "xml-apis.jar from xalan-j_2_2_0 or xalan-j_2_3_D1");
        jarVersions.put(new Long(108484L), "xml-apis.jar from xalan-j_2_3_0, or xalan-j_2_3_1 or xalan-j_2_4_D1 from xml-commons-1.0.b2");
        jarVersions.put(new Long(108017L), "xml-apis.jar from lotusxsl-j_2_3_1");
        jarVersions.put(new Long(109049L), "xml-apis.jar from xalan-j_2_4_0, lotusxsl-j_2_3_2 or lotusxsl-j_2_3_3 from xml-commons RIVERCOURT1");
        jarVersions.put(new Long(113749L), "xml-apis.jar from xalan-j_2_4_1, lotusxsl-j_2_3_4 or lotusxsl-j_2_3_5 from factoryfinder-build of xml-commons RIVERCOURT1");
        jarVersions.put(new Long(113981L), "xml-apis.jar from tck-jaxp-1_2_0 branch of xml-commons");
        jarVersions.put(new Long(124704L), "xml-apis.jar from tck-jaxp-1_2_0 branch of xml-commons");
        jarVersions.put(new Long(124720L), "xml-apis.jar from tck-jaxp-1_2_0 branch of xml-commons");
        jarVersions.put(new Long(124575L), "xml-apis.jar from tck-jaxp-1_2_0 branch of xml-commons");
        jarVersions.put(new Long(124805L), "xml-apis.jar from tck-jaxp-1_2_0 branch of xml-commons");
        jarVersions.put(new Long(124724L), "xml-apis.jar from tck-jaxp-1_2_0 branch of xml-commons, tag = xml-commons-external-1_2_01");
        jarVersions.put(new Long(129319L), "xml-apis.jar from tck-jaxp-1_2_0 branch of xml-commons, tag = xml-commons-external-1_2_02");
        jarVersions.put(new Long(129680L), "xml-apis.jar from tck-jaxp-1_2_0 branch of xml-commons, tag = xml-commons-external-1_2_03");
        jarVersions.put(new Long(129749L), "xml-apis.jar from tck-jaxp-1_2_0 branch of xml-commons, tag = xml-commons-external-1_2_04");
        jarVersions.put(new Long(192444L), "xml-apis.jar from jaxp1.3 release, level jaxp1.3");
        jarVersions.put(new Long(192907L), "xml-apis.jar from jaxp1.3 release, level jaxp1.3.2");
        jarVersions.put(new Long(193605L), "xml-apis.jar from jaxp1.3 release, level jaxp1.3.3");
        jarVersions.put(new Long(193592L), "xml-apis.jar from jaxp1.3 release, level jaxp1.3.4");
        jarVersions.put(new Long(193648L), "xml-apis.jar from jaxp1.3 release, level jaxp1.3.5");
        jarVersions.put(new Long(193719L), "xml-apis.jar from jaxp1.3 release, level jaxp1.3.6");
        jarVersions.put(new Long(215556L), "xml-apis.jar from jaxp1.4 release, level jaxp1.4");
        jarVersions.put(new Long(1720292L), "xercesImpl.jar from xalan-j_2_3_D1");
        jarVersions.put(new Long(1730053L), "xercesImpl.jar from xalan-j_2_3_0 or xalan-j_2_3_1 from xerces-2_0_0");
        jarVersions.put(new Long(1728861L), "xercesImpl.jar from xalan-j_2_4_D1 from xerces-2_0_1");
        jarVersions.put(new Long(972027L), "xercesImpl.jar from xalan-j_2_4_0 from xerces-2_1");
        jarVersions.put(new Long(831587L), "xercesImpl.jar from xalan-j_2_4_1 from xerces-2_2");
        jarVersions.put(new Long(1729063L), "xercesImpl.jar from lotusxsl-j_2_3_1 from XML4J-4_0_0");
        jarVersions.put(new Long(1738551L), "xercesImpl.jar from lotusxsl-j_2_3_2 from XML4J-4_0_2");
        jarVersions.put(new Long(3243826L), "xercesImpl.jar from lotusxsl-j_2_3_3 from XML4J-4_0_5");
        jarVersions.put(new Long(1171789L), "xercesImpl.jar from lotusxsl-j_2_3_4 from XML4J-4_0_6");
        jarVersions.put(new Long(1174955L), "xercesImpl.jar from lotusxsl-j_2_3_5 from XML4J-4_0_8");
        jarVersions.put(new Long(1173922L), "xercesImpl.jar from lotusxsl-j_2_3_6 from XML4J-4_0_9");
        jarVersions.put(new Long(831828L), "xercesImpl.jar from lotusxsl-j_2_4_0 from XML4J-4_1_1");
        jarVersions.put(new Long(1114292L), "xercesImpl.jar from lotusxsl-j_2_4_1, lotusxsl-j_2_4_2 or lotusxsl-j_2_4_3 from XML4J-4_1_3");
        jarVersions.put(new Long(885434L), "xercesImpl.jar from XSLT4J-2_5_0beta from XML4J-4_2_0beta");
        jarVersions.put(new Long(895925L), "xercesImpl.jar from XSLT4J-2_5_0 from XML4J-4_2_0");
        jarVersions.put(new Long(1209585L), "xercesImpl.jar from XML4J-4_2_2");
        jarVersions.put(new Long(1209556L), "xercesImpl.jar from XML4J-4_2_3");
        jarVersions.put(new Long(950131L), "xercesImpl.jar from XML4J-4_3_0beta");
        jarVersions.put(new Long(1010806L), "xercesImpl.jar from XML4J-4_3_0");
        jarVersions.put(new Long(1422751L), "xercesImpl.jar from XML4J-4_3_1");
        jarVersions.put(new Long(1423434L), "xercesImpl.jar from XML4J-4_3_2");
        jarVersions.put(new Long(1423982L), "xercesImpl.jar from XML4J-4_3_3");
        jarVersions.put(new Long(1255171L), "xercesImpl.jar from XML4J-4_4_0");
        jarVersions.put(new Long(1825859L), "xercesImpl.jar from XML4J-4_4_3");
        jarVersions.put(new Long(1827995L), "xercesImpl.jar from XML4J-4_4_4");
        jarVersions.put(new Long(1829599L), "xercesImpl.jar from XML4J-4_4_5");
        jarVersions.put(new Long(1829694L), "xercesImpl.jar from XML4J-4_4_6");
        jarVersions.put(new Long(343458L), "b2bxml.jar from B2BXML4J 1.2.0");
        jarVersions.put(new Long(615993L), "b2bxml.jar from B2BXML4J 1.2.1");
    }
}

