/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.transformer;

import javax.xml.transform.TransformerException;
import org.apache.xalan.serialize.SerializerUtils;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.ref.DTMTreeWalker;
import org.apache.xml.serializer.SerializationHandler;
import org.apache.xpath.XPathContext;
import org.xml.sax.SAXException;

public class TreeWalker2Result
extends DTMTreeWalker {
    TransformerImpl m_transformer;
    SerializationHandler m_handler;
    int m_startNode;

    public TreeWalker2Result(TransformerImpl transformerImpl, SerializationHandler serializationHandler) {
        super(serializationHandler, null);
        this.m_transformer = transformerImpl;
        this.m_handler = serializationHandler;
    }

    public void traverse(int n) throws SAXException {
        this.m_dtm = this.m_transformer.getXPathContext().getDTM(n);
        this.m_startNode = n;
        super.traverse(n);
    }

    protected void endNode(int n) throws SAXException {
        super.endNode(n);
        if (1 == this.m_dtm.getNodeType(n)) {
            this.m_transformer.getXPathContext().popCurrentNode();
        }
    }

    protected void startNode(int n) throws SAXException {
        XPathContext xPathContext = this.m_transformer.getXPathContext();
        try {
            if (1 == this.m_dtm.getNodeType(n)) {
                xPathContext.pushCurrentNode(n);
                if (this.m_startNode != n) {
                    super.startNode(n);
                } else {
                    String string = this.m_dtm.getNodeName(n);
                    String string2 = this.m_dtm.getLocalName(n);
                    String string3 = this.m_dtm.getNamespaceURI(n);
                    this.m_handler.startElement(string3, string2, string);
                    boolean bl = false;
                    DTM dTM = this.m_dtm;
                    int n2 = dTM.getFirstNamespaceNode(n, true);
                    while (-1 != n2) {
                        SerializerUtils.ensureNamespaceDeclDeclared(this.m_handler, dTM, n2);
                        n2 = dTM.getNextNamespaceNode(n, n2, true);
                    }
                    n2 = dTM.getFirstAttribute(n);
                    while (-1 != n2) {
                        SerializerUtils.addAttribute(this.m_handler, n2);
                        n2 = dTM.getNextAttribute(n2);
                    }
                }
            } else {
                xPathContext.pushCurrentNode(n);
                super.startNode(n);
                xPathContext.popCurrentNode();
            }
        }
        catch (TransformerException transformerException) {
            throw new SAXException(transformerException);
        }
    }
}

