/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.lib;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.xpath.objects.XBoolean;
import org.apache.xpath.objects.XNumber;
import org.apache.xpath.objects.XObject;

public class ExsltDatetime {
    static final String dt = "yyyy-MM-dd'T'HH:mm:ss";
    static final String d = "yyyy-MM-dd";
    static final String gym = "yyyy-MM";
    static final String gy = "yyyy";
    static final String gmd = "--MM-dd";
    static final String gm = "--MM--";
    static final String gd = "---dd";
    static final String t = "HH:mm:ss";
    static final String EMPTY_STR = "";

    public static String dateTime() {
        Calendar calendar = Calendar.getInstance();
        Date date = calendar.getTime();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dt);
        StringBuffer stringBuffer = new StringBuffer(simpleDateFormat.format(date));
        int n = calendar.get(15) + calendar.get(16);
        if (n == 0) {
            stringBuffer.append("Z");
        } else {
            int n2 = n / 3600000;
            int n3 = n % 3600000;
            char c = n2 < 0 ? (char)'-' : '+';
            stringBuffer.append(c + ExsltDatetime.formatDigits(n2) + ':' + ExsltDatetime.formatDigits(n3));
        }
        return stringBuffer.toString();
    }

    private static String formatDigits(int n) {
        String string = String.valueOf(Math.abs(n));
        return string.length() == 1 ? '0' + string : string;
    }

    public static String date(String string) throws ParseException {
        String[] stringArray = ExsltDatetime.getEraDatetimeZone(string);
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        String string4 = stringArray[2];
        if (string3 == null || string4 == null) {
            return EMPTY_STR;
        }
        String[] stringArray2 = new String[]{dt, d};
        String string5 = d;
        Date date = ExsltDatetime.testFormats(string3, stringArray2);
        if (date == null) {
            return EMPTY_STR;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string5);
        simpleDateFormat.setLenient(false);
        String string6 = simpleDateFormat.format(date);
        if (string6.length() == 0) {
            return EMPTY_STR;
        }
        return string2 + string6 + string4;
    }

    public static String date() {
        String string = ExsltDatetime.dateTime().toString();
        String string2 = string.substring(0, string.indexOf("T"));
        String string3 = string.substring(ExsltDatetime.getZoneStart(string));
        return string2 + string3;
    }

    public static String time(String string) throws ParseException {
        String[] stringArray = ExsltDatetime.getEraDatetimeZone(string);
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        if (string2 == null || string3 == null) {
            return EMPTY_STR;
        }
        String[] stringArray2 = new String[]{dt, d, t};
        String string4 = t;
        Date date = ExsltDatetime.testFormats(string2, stringArray2);
        if (date == null) {
            return EMPTY_STR;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string4);
        String string5 = simpleDateFormat.format(date);
        return string5 + string3;
    }

    public static String time() {
        String string = ExsltDatetime.dateTime().toString();
        String string2 = string.substring(string.indexOf("T") + 1);
        return string2;
    }

    public static double year(String string) throws ParseException {
        String[] stringArray = ExsltDatetime.getEraDatetimeZone(string);
        boolean bl = stringArray[0].length() == 0;
        String string2 = stringArray[1];
        if (string2 == null) {
            return Double.NaN;
        }
        String[] stringArray2 = new String[]{dt, d, gym, gy};
        double d = ExsltDatetime.getNumber(string2, stringArray2, 1);
        if (bl || d == Double.NaN) {
            return d;
        }
        return -d;
    }

    public static double year() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(1);
    }

    public static double monthInYear(String string) throws ParseException {
        String[] stringArray = ExsltDatetime.getEraDatetimeZone(string);
        String string2 = stringArray[1];
        if (string2 == null) {
            return Double.NaN;
        }
        String[] stringArray2 = new String[]{dt, d, gym, gm, gmd};
        return ExsltDatetime.getNumber(string2, stringArray2, 2) + 1.0;
    }

    public static double monthInYear() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(2) + 1;
    }

    public static double weekInYear(String string) throws ParseException {
        String[] stringArray = ExsltDatetime.getEraDatetimeZone(string);
        String string2 = stringArray[1];
        if (string2 == null) {
            return Double.NaN;
        }
        String[] stringArray2 = new String[]{dt, d};
        return ExsltDatetime.getNumber(string2, stringArray2, 3);
    }

    public static double weekInYear() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(3);
    }

    public static double dayInYear(String string) throws ParseException {
        String[] stringArray = ExsltDatetime.getEraDatetimeZone(string);
        String string2 = stringArray[1];
        if (string2 == null) {
            return Double.NaN;
        }
        String[] stringArray2 = new String[]{dt, d};
        return ExsltDatetime.getNumber(string2, stringArray2, 6);
    }

    public static double dayInYear() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(6);
    }

    public static double dayInMonth(String string) throws ParseException {
        String[] stringArray = ExsltDatetime.getEraDatetimeZone(string);
        String string2 = stringArray[1];
        String[] stringArray2 = new String[]{dt, d, gmd, gd};
        double d = ExsltDatetime.getNumber(string2, stringArray2, 5);
        return d;
    }

    public static double dayInMonth() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(5);
    }

    public static double dayOfWeekInMonth(String string) throws ParseException {
        String[] stringArray = ExsltDatetime.getEraDatetimeZone(string);
        String string2 = stringArray[1];
        if (string2 == null) {
            return Double.NaN;
        }
        String[] stringArray2 = new String[]{dt, d};
        return ExsltDatetime.getNumber(string2, stringArray2, 8);
    }

    public static double dayOfWeekInMonth() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(8);
    }

    public static double dayInWeek(String string) throws ParseException {
        String[] stringArray = ExsltDatetime.getEraDatetimeZone(string);
        String string2 = stringArray[1];
        if (string2 == null) {
            return Double.NaN;
        }
        String[] stringArray2 = new String[]{dt, d};
        return ExsltDatetime.getNumber(string2, stringArray2, 7);
    }

    public static double dayInWeek() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(7);
    }

    public static double hourInDay(String string) throws ParseException {
        String[] stringArray = ExsltDatetime.getEraDatetimeZone(string);
        String string2 = stringArray[1];
        if (string2 == null) {
            return Double.NaN;
        }
        String[] stringArray2 = new String[]{dt, t};
        return ExsltDatetime.getNumber(string2, stringArray2, 11);
    }

    public static double hourInDay() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(11);
    }

    public static double minuteInHour(String string) throws ParseException {
        String[] stringArray = ExsltDatetime.getEraDatetimeZone(string);
        String string2 = stringArray[1];
        if (string2 == null) {
            return Double.NaN;
        }
        String[] stringArray2 = new String[]{dt, t};
        return ExsltDatetime.getNumber(string2, stringArray2, 12);
    }

    public static double minuteInHour() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(12);
    }

    public static double secondInMinute(String string) throws ParseException {
        String[] stringArray = ExsltDatetime.getEraDatetimeZone(string);
        String string2 = stringArray[1];
        if (string2 == null) {
            return Double.NaN;
        }
        String[] stringArray2 = new String[]{dt, t};
        return ExsltDatetime.getNumber(string2, stringArray2, 13);
    }

    public static double secondInMinute() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(13);
    }

    public static XObject leapYear(String string) throws ParseException {
        String[] stringArray = ExsltDatetime.getEraDatetimeZone(string);
        String string2 = stringArray[1];
        if (string2 == null) {
            return new XNumber(Double.NaN);
        }
        String[] stringArray2 = new String[]{dt, d, gym, gy};
        double d = ExsltDatetime.getNumber(string2, stringArray2, 1);
        if (d == Double.NaN) {
            return new XNumber(Double.NaN);
        }
        int n = (int)d;
        return new XBoolean(n % 400 == 0 || n % 100 != 0 && n % 4 == 0);
    }

    public static boolean leapYear() {
        Calendar calendar = Calendar.getInstance();
        int n = calendar.get(1);
        return n % 400 == 0 || n % 100 != 0 && n % 4 == 0;
    }

    public static String monthName(String string) throws ParseException {
        String[] stringArray = ExsltDatetime.getEraDatetimeZone(string);
        String string2 = stringArray[1];
        if (string2 == null) {
            return EMPTY_STR;
        }
        String[] stringArray2 = new String[]{dt, d, gym, gm};
        String string3 = "MMMM";
        return ExsltDatetime.getNameOrAbbrev(string, stringArray2, string3);
    }

    public static String monthName() {
        Calendar calendar = Calendar.getInstance();
        String string = "MMMM";
        return ExsltDatetime.getNameOrAbbrev(string);
    }

    public static String monthAbbreviation(String string) throws ParseException {
        String[] stringArray = ExsltDatetime.getEraDatetimeZone(string);
        String string2 = stringArray[1];
        if (string2 == null) {
            return EMPTY_STR;
        }
        String[] stringArray2 = new String[]{dt, d, gym, gm};
        String string3 = "MMM";
        return ExsltDatetime.getNameOrAbbrev(string, stringArray2, string3);
    }

    public static String monthAbbreviation() {
        String string = "MMM";
        return ExsltDatetime.getNameOrAbbrev(string);
    }

    public static String dayName(String string) throws ParseException {
        String[] stringArray = ExsltDatetime.getEraDatetimeZone(string);
        String string2 = stringArray[1];
        if (string2 == null) {
            return EMPTY_STR;
        }
        String[] stringArray2 = new String[]{dt, d};
        String string3 = "EEEE";
        return ExsltDatetime.getNameOrAbbrev(string, stringArray2, string3);
    }

    public static String dayName() {
        String string = "EEEE";
        return ExsltDatetime.getNameOrAbbrev(string);
    }

    public static String dayAbbreviation(String string) throws ParseException {
        String[] stringArray = ExsltDatetime.getEraDatetimeZone(string);
        String string2 = stringArray[1];
        if (string2 == null) {
            return EMPTY_STR;
        }
        String[] stringArray2 = new String[]{dt, d};
        String string3 = "EEE";
        return ExsltDatetime.getNameOrAbbrev(string, stringArray2, string3);
    }

    public static String dayAbbreviation() {
        String string = "EEE";
        return ExsltDatetime.getNameOrAbbrev(string);
    }

    private static String[] getEraDatetimeZone(String string) {
        int n;
        String string2 = EMPTY_STR;
        String string3 = string;
        String string4 = EMPTY_STR;
        if (string.charAt(0) == '-' && !string.startsWith("--")) {
            string2 = "-";
            string3 = string.substring(1);
        }
        if ((n = ExsltDatetime.getZoneStart(string3)) > 0) {
            string4 = string3.substring(n);
            string3 = string3.substring(0, n);
        } else if (n == -2) {
            string4 = null;
        }
        return new String[]{string2, string3, string4};
    }

    private static int getZoneStart(String string) {
        if (string.indexOf("Z") == string.length() - 1) {
            return string.length() - 1;
        }
        if (string.length() >= 6 && string.charAt(string.length() - 3) == ':' && (string.charAt(string.length() - 6) == '+' || string.charAt(string.length() - 6) == '-')) {
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm");
                simpleDateFormat.setLenient(false);
                Date date = simpleDateFormat.parse(string.substring(string.length() - 5));
                return string.length() - 6;
            }
            catch (ParseException parseException) {
                System.out.println("ParseException " + parseException.getErrorOffset());
                return -2;
            }
        }
        return -1;
    }

    private static Date testFormats(String string, String[] stringArray) throws ParseException {
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(stringArray[i]);
                simpleDateFormat.setLenient(false);
                return simpleDateFormat.parse(string);
            }
            catch (ParseException parseException) {
                continue;
            }
        }
        return null;
    }

    private static double getNumber(String string, String[] stringArray, int n) throws ParseException {
        Calendar calendar = Calendar.getInstance();
        calendar.setLenient(false);
        Date date = ExsltDatetime.testFormats(string, stringArray);
        if (date == null) {
            return Double.NaN;
        }
        calendar.setTime(date);
        return calendar.get(n);
    }

    private static String getNameOrAbbrev(String string, String[] stringArray, String string2) throws ParseException {
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(stringArray[i], Locale.ENGLISH);
                simpleDateFormat.setLenient(false);
                Date date = simpleDateFormat.parse(string);
                simpleDateFormat.applyPattern(string2);
                return simpleDateFormat.format(date);
            }
            catch (ParseException parseException) {
                continue;
            }
        }
        return EMPTY_STR;
    }

    private static String getNameOrAbbrev(String string) {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string, Locale.ENGLISH);
        return simpleDateFormat.format(calendar.getTime());
    }

    public static String formatDate(String string, String string2) {
        String[] stringArray;
        String string3;
        TimeZone timeZone;
        if (string.endsWith("Z") || string.endsWith("z")) {
            timeZone = TimeZone.getTimeZone("GMT");
            string = string.substring(0, string.length() - 1) + "GMT";
            string3 = "z";
        } else if (string.length() >= 6 && string.charAt(string.length() - 3) == ':' && (string.charAt(string.length() - 6) == '+' || string.charAt(string.length() - 6) == '-')) {
            stringArray = string.substring(string.length() - 6);
            timeZone = "+00:00".equals(stringArray) || "-00:00".equals(stringArray) ? TimeZone.getTimeZone("GMT") : TimeZone.getTimeZone("GMT" + (String)stringArray);
            string3 = "z";
            string = string.substring(0, string.length() - 6) + "GMT" + (String)stringArray;
        } else {
            timeZone = TimeZone.getDefault();
            string3 = EMPTY_STR;
        }
        stringArray = new String[]{dt + string3, d, gym, gy};
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(t + string3);
            simpleDateFormat.setLenient(false);
            Date date = simpleDateFormat.parse(string);
            SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat(ExsltDatetime.strip("GyMdDEFwW", string2));
            simpleDateFormat2.setTimeZone(timeZone);
            return simpleDateFormat2.format(date);
        }
        catch (ParseException parseException) {
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat(stringArray[i]);
                    simpleDateFormat.setLenient(false);
                    Date date = simpleDateFormat.parse(string);
                    SimpleDateFormat simpleDateFormat3 = new SimpleDateFormat(string2);
                    simpleDateFormat3.setTimeZone(timeZone);
                    return simpleDateFormat3.format(date);
                }
                catch (ParseException parseException2) {
                    continue;
                }
            }
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(gmd);
                simpleDateFormat.setLenient(false);
                Date date = simpleDateFormat.parse(string);
                SimpleDateFormat simpleDateFormat4 = new SimpleDateFormat(ExsltDatetime.strip("Gy", string2));
                simpleDateFormat4.setTimeZone(timeZone);
                return simpleDateFormat4.format(date);
            }
            catch (ParseException parseException3) {
                try {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat(gm);
                    simpleDateFormat.setLenient(false);
                    Date date = simpleDateFormat.parse(string);
                    SimpleDateFormat simpleDateFormat5 = new SimpleDateFormat(ExsltDatetime.strip("Gy", string2));
                    simpleDateFormat5.setTimeZone(timeZone);
                    return simpleDateFormat5.format(date);
                }
                catch (ParseException parseException4) {
                    try {
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(gd);
                        simpleDateFormat.setLenient(false);
                        Date date = simpleDateFormat.parse(string);
                        SimpleDateFormat simpleDateFormat6 = new SimpleDateFormat(ExsltDatetime.strip("GyM", string2));
                        simpleDateFormat6.setTimeZone(timeZone);
                        return simpleDateFormat6.format(date);
                    }
                    catch (ParseException parseException5) {
                        return EMPTY_STR;
                    }
                }
            }
        }
    }

    private static String strip(String string, String string2) {
        boolean bl = false;
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer(string2.length());
        while (n < string2.length()) {
            char c = string2.charAt(n);
            if (c == '\'') {
                int n2 = string2.indexOf(39, n + 1);
                if (n2 == -1) {
                    n2 = string2.length();
                }
                stringBuffer.append(string2.substring(n, n2));
                n = n2++;
                continue;
            }
            if (string.indexOf(c) > -1) {
                ++n;
                continue;
            }
            stringBuffer.append(c);
            ++n;
        }
        return stringBuffer.toString();
    }
}

